/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.crypto.BASE64;
import com.modnut.framework2.crypto.RSA;
import com.modnut.framework2.database.DBCreator;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.database.DBValPair;
import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.lang.LangPack;
import com.modnut.framework2.resource.ResPack;
import com.modnut.platform2.PlatformConst;
import com.modnut.platform2.PlatformDB;
import com.modnut.platform2.PlatformUrl;
import com.modnut.platform2.PlatformUser;
import com.modnut.platform2.lang.PlatformLang;
import com.modnut.platform2.resource.ResPlatform;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformApp {
    public static final int VERSION = 20301;
    public static final String VERSION_STR = PlatformApp.parseVersion(20301);
    public static final String CODE = "platform";
    public static final String ADMIN = "platform.admin";
    private static final ArrayList<AppObj> appList = new ArrayList();
    private static final HashMap<String, AppObj> appMap = new HashMap();
    private static final ArrayList<UpgradeListener> upgradeListeners = new ArrayList();
    public static final AppObj i = new PlatformAppObj();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUpgradeListener(UpgradeListener listener) {
        ArrayList<UpgradeListener> arrayList = upgradeListeners;
        synchronized (arrayList) {
            upgradeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUpgradeListeners() {
        ArrayList<UpgradeListener> arrayList = upgradeListeners;
        synchronized (arrayList) {
            upgradeListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyUpgradeListeners(String appCode, int form, int to) {
        ArrayList<UpgradeListener> arrayList = upgradeListeners;
        synchronized (arrayList) {
            for (UpgradeListener listener : upgradeListeners) {
                listener.doUpgradeEvent(appCode, form, to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addApp(AppObj app) {
        ResPack res = new ResPack();
        try {
            DBStat stat = res.getDBStat(PlatformDB.NAME);
            if (CODE.equals(app.getAppCode())) {
                DBCreator.doCheckTable((DBStat)stat, (DBCreator.DBTable)PlatformDB.Version.getTable());
            }
            int oldVersion = -1;
            String[] colNames = new String[]{"version_number"};
            String whereStr = "version_app=" + DBHelper.formatSqlStr((DBStat)stat, (String)app.getAppCode());
            DBResult rs = DBHelper.query((DBStat)stat, (String)"platform_version", (String[])colNames, (String)whereStr, null, null);
            try {
                if (rs.next()) {
                    oldVersion = rs.getInt("version_number");
                }
            }
            finally {
                rs.close();
            }
            if (oldVersion == -1) {
                PlatformApp.notifyUpgradeListeners(app.getAppCode(), -1, app.getVersion());
                app.doFirstInit(res, stat);
                DBValPair[] insertValues = new DBValPair[]{new DBValPair("version_app", app.getAppCode()), new DBValPair("version_number", Integer.valueOf(app.getVersion()))};
                DBHelper.insert((DBStat)stat, (String)"platform_version", (DBValPair[])insertValues);
            } else if (oldVersion < app.getVersion()) {
                UpgradeObj[] upgrades = app.getAppUpgrades();
                if (upgrades != null) {
                    for (UpgradeObj upgrade : upgrades) {
                        if (oldVersion >= upgrade.getVersion()) continue;
                        PlatformApp.notifyUpgradeListeners(app.getAppCode(), oldVersion, upgrade.getVersion());
                        upgrade.doUpgrade(res, stat);
                        oldVersion = upgrade.getVersion();
                    }
                }
                DBValPair[] updateValues = new DBValPair[]{new DBValPair("version_number", Integer.valueOf(app.getVersion()))};
                DBHelper.update((DBStat)stat, (String)"platform_version", (DBValPair[])updateValues, (String)whereStr);
            }
        }
        catch (DBException ex) {
            Logger.getLogger(PlatformApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            res.disposeRes();
        }
        Cloneable cloneable = appMap;
        synchronized (cloneable) {
            appMap.put(app.getAppCode(), app);
        }
        cloneable = appList;
        synchronized (cloneable) {
            for (int j = 0; j < appList.size(); ++j) {
                AppObj indexapp = appList.get(j);
                if (indexapp.getAppCode().compareTo(app.getAppCode()) <= 0) continue;
                appList.add(j, app);
                return;
            }
            appList.add(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeApp(AppObj app) {
        Cloneable cloneable = appMap;
        synchronized (cloneable) {
            appMap.remove(app.getAppCode());
        }
        cloneable = appList;
        synchronized (cloneable) {
            appList.remove(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeApp(String appcode) {
        Cloneable cloneable = appMap;
        synchronized (cloneable) {
            appMap.remove(appcode);
        }
        cloneable = appList;
        synchronized (cloneable) {
            for (int j = 0; j < appList.size(); ++j) {
                if (!appList.get(j).getAppCode().equals(appcode)) continue;
                appList.remove(j);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppObj getApp(String appcode) {
        HashMap<String, AppObj> hashMap = appMap;
        synchronized (hashMap) {
            return appMap.get(appcode);
        }
    }

    public static ArrayList<AppObj> getAppList() {
        return appList;
    }

    public static HashMap<String, AppObj> getAppMap() {
        return appMap;
    }

    public static int parseVersion(String versionStr) {
        String[] v = versionStr.split("\\.");
        int[] n = new int[v.length];
        for (int j = 0; j < v.length; ++j) {
            n[j] = Integer.parseInt(v[j]);
        }
        int version = 0;
        for (int j = 0; j < n.length; ++j) {
            version = version * 100 + n[j];
        }
        return version;
    }

    public static String parseVersion(int version) {
        StringBuilder sb = new StringBuilder();
        sb.append(version / 10000).append(".");
        sb.append(version / 100 % 100).append(".");
        sb.append(version % 100);
        return sb.toString();
    }

    public static interface UpgradeListener {
        public void doUpgradeEvent(String var1, int var2, int var3);
    }

    public static abstract class UpgradeObj {
        public abstract int getVersion();

        public abstract void doUpgrade(ResPack var1, DBStat var2) throws DBException;
    }

    public static class AuthSimpleObj
    extends AuthObj {
        private final LangPack langPack;
        protected final String code;
        protected final String name;
        protected final String intro;

        public AuthSimpleObj(String code, String name, String intro) {
            this.langPack = null;
            this.code = code;
            this.name = name;
            this.intro = intro;
        }

        public AuthSimpleObj(LangPack langPack, String code, String nameKey, String introKey) {
            this.langPack = langPack;
            this.code = code;
            this.name = nameKey;
            this.intro = introKey;
        }

        @Override
        public String getAuthCode() {
            return this.code;
        }

        @Override
        public String getAuthName(ResPlatform res) {
            return this.langPack == null ? this.name : res.getLangStr(this.langPack, this.name);
        }

        @Override
        public String getAuthName(Locale locale) {
            return this.langPack == null ? this.name : this.langPack.map(locale).get(this.name);
        }

        @Override
        public String getAuthName(Enumeration<Locale> locales) {
            return this.langPack == null ? this.name : this.langPack.map(locales).get(this.name);
        }

        @Override
        public String getAuthIntro(ResPlatform res) {
            return this.langPack == null ? this.intro : res.getLangStr(this.langPack, this.intro);
        }

        @Override
        public String getAuthIntro(Locale locale) {
            return this.langPack == null ? this.intro : this.langPack.map(locale).get(this.intro);
        }

        @Override
        public String getAuthIntro(Enumeration<Locale> locales) {
            return this.langPack == null ? this.intro : this.langPack.map(locales).get(this.intro);
        }
    }

    public static abstract class AuthObj {
        public abstract String getAuthCode();

        public abstract String getAuthName(ResPlatform var1);

        public abstract String getAuthName(Locale var1);

        public abstract String getAuthName(Enumeration<Locale> var1);

        public abstract String getAuthIntro(ResPlatform var1);

        public abstract String getAuthIntro(Locale var1);

        public abstract String getAuthIntro(Enumeration<Locale> var1);
    }

    public static class AppSimpleObj
    extends AppObj {
        private final LangPack langPack;
        private final String code;
        private final String name;
        private final String url;
        private final String intro;
        private final String auth;
        private final int version;

        public AppSimpleObj(String code, String name, String url, String intro) {
            this.langPack = null;
            this.code = code;
            this.name = name;
            this.url = url;
            this.intro = intro;
            this.auth = null;
            this.version = 0;
        }

        public AppSimpleObj(String code, String name, String url, String intro, String auth) {
            this.langPack = null;
            this.code = code;
            this.name = name;
            this.url = url;
            this.intro = intro;
            this.auth = auth;
            this.version = 0;
        }

        public AppSimpleObj(String code, String name, String url, String intro, String auth, int version) {
            this.langPack = null;
            this.code = code;
            this.name = name;
            this.url = url;
            this.intro = intro;
            this.auth = auth;
            this.version = version;
        }

        public AppSimpleObj(LangPack langPack, String code, String nameKey, String url, String introKey) {
            this.langPack = langPack;
            this.code = code;
            this.name = nameKey;
            this.url = url;
            this.intro = introKey;
            this.auth = null;
            this.version = 0;
        }

        public AppSimpleObj(LangPack langPack, String code, String nameKey, String url, String introKey, String auth) {
            this.langPack = langPack;
            this.code = code;
            this.name = nameKey;
            this.url = url;
            this.intro = introKey;
            this.auth = auth;
            this.version = 0;
        }

        public AppSimpleObj(LangPack langPack, String code, String nameKey, String url, String introKey, String auth, int version) {
            this.langPack = langPack;
            this.code = code;
            this.name = nameKey;
            this.url = url;
            this.intro = introKey;
            this.auth = auth;
            this.version = version;
        }

        @Override
        public String getAppIconUrl() {
            return PlatformUrl.i.getImgAppIcon();
        }

        @Override
        public String getAppNavIconUrl() {
            return PlatformUrl.i.getImgAppNav();
        }

        @Override
        public String getAppUrl() {
            return this.url;
        }

        @Override
        public String getAppCode() {
            return this.code;
        }

        @Override
        public String getAppName(ResPlatform res) {
            return this.langPack == null ? this.name : res.getLangStr(this.langPack, this.name);
        }

        @Override
        public String getAppName(Locale locale) {
            return this.langPack == null ? this.name : this.langPack.map(locale).get(this.name);
        }

        @Override
        public String getAppName(Enumeration<Locale> locales) {
            return this.langPack == null ? this.name : this.langPack.map(locales).get(this.name);
        }

        @Override
        public String getAppIntro(ResPlatform res) {
            return this.langPack == null ? this.intro : res.getLangStr(this.langPack, this.intro);
        }

        @Override
        public String getAppIntro(Locale locale) {
            return this.langPack == null ? this.intro : this.langPack.map(locale).get(this.intro);
        }

        @Override
        public String getAppIntro(Enumeration<Locale> locales) {
            return this.langPack == null ? this.intro : this.langPack.map(locales).get(this.intro);
        }

        @Override
        public boolean hasAuth(ResPlatform res) {
            return this.auth != null ? res.hasAuth(this.auth) : true;
        }

        @Override
        public int getVersion() {
            return this.version;
        }
    }

    public static abstract class AppObj {
        private final ArrayList<AuthObj> auths = new ArrayList();
        public static final int DEFAULT_VERSION = 0;
        public static final int NONE_VERSION = -1;

        public ArrayList<AuthObj> getAuths() {
            return this.auths;
        }

        public void addAuth(AuthObj auth) {
            this.auths.add(auth);
        }

        public int getVersion() {
            return 0;
        }

        public abstract String getAppIconUrl();

        public abstract String getAppNavIconUrl();

        public abstract String getAppUrl();

        public abstract String getAppCode();

        public abstract String getAppName(ResPlatform var1);

        public abstract String getAppName(Locale var1);

        public abstract String getAppName(Enumeration<Locale> var1);

        public abstract String getAppIntro(ResPlatform var1);

        public abstract String getAppIntro(Locale var1);

        public abstract String getAppIntro(Enumeration<Locale> var1);

        public DBCreator.DBTable[] getAppTables() {
            return null;
        }

        public void doFirstInit(ResPack res, DBStat stat) throws DBException {
            DBCreator.DBTable[] tables = this.getAppTables();
            if (tables != null) {
                for (DBCreator.DBTable table : tables) {
                    DBCreator.doCheckTable((DBStat)stat, (DBCreator.DBTable)table);
                }
            }
        }

        public UpgradeObj[] getAppUpgrades() {
            return null;
        }

        public abstract boolean hasAuth(ResPlatform var1);
    }

    public static class AppKey {
        public String sign;
        public byte[] data;

        public AppKey() {
        }

        public AppKey(String sign, byte[] data) {
            this.sign = sign;
            this.data = data;
        }

        public AppKeyContent getContent(String publicKey) {
            try {
                if (this.sign != null && this.data != null && RSA.verifyByPublicKey((byte[])this.data, (String)publicKey, (String)this.sign)) {
                    byte[] decryptBytes = RSA.decryptByPublicKey((byte[])this.data, (String)publicKey);
                    String jsonStr = new String(decryptBytes);
                    return AppKeyContent.fromJson(new JSONArray(jsonStr, true));
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }

        public static AppKey gen(String privateKey, AppKeyContent content) {
            byte[] data = content.toString().getBytes();
            AppKey key = new AppKey();
            key.data = RSA.encryptByPrivateKey((byte[])data, (String)privateKey);
            key.sign = RSA.signByPrivateKey((byte[])key.data, (String)privateKey);
            return key;
        }

        public static AppKeyContent getClientContent(String privateKey, String clientData) {
            try {
                byte[] clientBytes = BASE64.decode((String)clientData);
                byte[] decryptBytes = RSA.decryptByPrivateKey((byte[])clientBytes, (String)privateKey);
                String jsonStr = new String(decryptBytes, ConstFramework.getCharset());
                return AppKeyContent.fromJson(new JSONArray(jsonStr, true));
            }
            catch (Exception ex) {
                return null;
            }
        }

        public static String genClientKey(String publicKey, AppKeyContent keyContent) {
            try {
                String jsonStr = AppKeyContent.toJson(keyContent).toString();
                byte[] encryptBytes = RSA.encryptByPublicKey((byte[])jsonStr.getBytes(ConstFramework.getCharset()), (String)publicKey);
                return BASE64.encode((byte[])encryptBytes);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public static class AppKeyContent {
            public String code;
            public String expiry;
            public String pid;
            public String pin;
            public String sn;
            public String mac;
            public String hardware;
            public int port;
            public String[] params;

            public String toString() {
                return AppKeyContent.toJson(this).toString();
            }

            public String getParam(int index) {
                if (this.params != null && index < this.params.length) {
                    return this.params[index];
                }
                return null;
            }

            public static AppKeyContent fromJson(JSONArray arr) {
                try {
                    AppKeyContent content = new AppKeyContent();
                    content.code = arr.getString(0);
                    content.expiry = arr.getString(1);
                    content.pid = arr.getString(2);
                    content.pin = arr.getString(3);
                    content.sn = arr.getString(4);
                    content.mac = arr.getString(5);
                    content.hardware = arr.getString(6);
                    content.port = arr.getInteger(7);
                    if (arr.length() > 8) {
                        content.params = new String[arr.length() - 8];
                        for (int i = 0; i < content.params.length; ++i) {
                            content.params[i] = arr.getString(i + 8);
                        }
                    }
                    return content;
                }
                catch (JSONException ex) {
                    return null;
                }
            }

            public static JSONArray toJson(AppKeyContent content) {
                JSONArray arr = new JSONArray(true);
                arr.put(content.code);
                arr.put(content.expiry);
                arr.put(content.pid);
                arr.put(content.pin);
                arr.put(content.sn);
                arr.put(content.mac);
                arr.put(content.hardware);
                arr.put(content.port);
                if (content.params != null) {
                    for (String param : content.params) {
                        arr.put(param);
                    }
                }
                return arr;
            }
        }
    }

    private static final class PlatformAppObj
    extends AppSimpleObj {
        private static final DBCreator.DBTable[] TABLES = new DBCreator.DBTable[]{PlatformDB.Group.getTable(), PlatformDB.GroupAuth.getTable(), PlatformDB.GroupUser.getTable(), PlatformDB.Message.getTable(), PlatformDB.Store.getTable(), PlatformDB.Log.getTable(), PlatformDB.User.getTable(), PlatformDB.UserAuth.getTable(), PlatformDB.UserNav.getTable(), PlatformDB.UserRem.getTable()};

        public PlatformAppObj() {
            super(PlatformLang.i, PlatformApp.CODE, "PLANTFORM_NAME", null, "PLANTFORM_INTRO");
            this.addAuth(new AuthSimpleObj(PlatformLang.i, PlatformApp.ADMIN, "ADMIN_NAME", "ADMIN_INTRO"));
        }

        @Override
        public String getAppIconUrl() {
            return PlatformUrl.i.jointBaseImg("platformicon.png");
        }

        @Override
        public String getAppNavIconUrl() {
            return PlatformUrl.i.jointBaseImg("platformnav.png");
        }

        @Override
        public DBCreator.DBTable[] getAppTables() {
            return TABLES;
        }

        @Override
        public void doFirstInit(ResPack res, DBStat stat) throws DBException {
            super.doFirstInit(res, stat);
            String adminAccount = "admin";
            String adminPassword = "admin";
            String adminWhereStr = "user_acc=" + DBHelper.formatSqlStr((DBStat)stat, (String)adminAccount);
            if (DBHelper.count((DBStat)stat, (String)"platform_user", (String)adminWhereStr) == 0L) {
                String adminName = PlatformLang.i.map(PlatformConst.getLocale()).get("ADMIN_NAME");
                DBValPair[] adminValues = new DBValPair[]{new DBValPair("user_acc", adminAccount), new DBValPair("user_name", adminName), new DBValPair("user_passwd", PlatformUser.createPasswordHash(adminPassword)), new DBValPair("user_disabled", Short.valueOf((short)0)), new DBValPair("user_version", Integer.valueOf(0))};
                DBHelper.insert((DBStat)stat, (String)"platform_user", (DBValPair[])adminValues);
                DBValPair[] adminAuthValues = new DBValPair[]{new DBValPair("user_acc", adminAccount), new DBValPair("auth_code", PlatformApp.ADMIN)};
                DBHelper.insert((DBStat)stat, (String)"platform_user_auth", (DBValPair[])adminAuthValues);
            }
        }

        @Override
        public int getVersion() {
            return 20301;
        }
    }
}

