/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.daemon.DaemonPool;
import com.modnut.framework2.data.DataProp;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBPool;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.database.DBValPair;
import com.modnut.framework2.lang.LangPack;
import com.modnut.framework2.memcache.MemConn;
import com.modnut.framework2.memcache.MemPool;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.tool.ToolDate;
import com.modnut.framework2.tool.ToolMail;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformApp;
import com.modnut.platform2.PlatformConst;
import com.modnut.platform2.PlatformDB;
import com.modnut.platform2.PlatformMail;
import com.modnut.platform2.lang.PlatformLang;
import com.modnut.platform2.resource.ResPlatform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class PlatformParam {
    public static final String FILE_CONFIG_NAME = "config.txt";
    public static final String DIR_TEMP_NAME = "temp";
    public static final String EXTRA_INFO = "info.txt";
    public static final String EXTRA_LOGO = "logo.png";
    private static final String PROP_FILE_CHARSET = "file.charset";
    private static final String PROP_DEBUG = "platform.debug";
    private static final String PROP_LOCALE = "platform.locale";
    private static final String PROP_COMPANY = "platform.company";
    private static final String PROP_WEBSITE = "platform.website";
    private static final String PROP_HOST = "platform.host";
    private static final String PROP_DB_URL = "platform.db.url";
    private static final String PROP_DB_USER = "platform.db.user";
    private static final String PROP_DB_PASSWORD = "platform.db.password";
    private static final String PROP_MEM_SESSION = "platform.mem.session";
    private static final String PROP_MEM_CACHE = "platform.mem.cache";
    private static final String PROP_MAIL_USER = "platform.mail.user";
    private static final String PROP_MAIL_PASSWORD = "platform.mail.password";
    private static final String PROP_MAIL_ADDRESS = "platform.mail.address";
    private static final String PROP_MAIL_SERVER = "platform.mail.server";
    private static final String PROP_MAIL_SSL = "platform.mail.ssl";
    private static final String PROP_MAIL_PORT = "platform.mail.port";
    private static final String PROP_MAIL_NAME = "platform.mail.name";
    private static final int STORE_CACHE_TIME = 43200;
    private static final String CHEET_KEY = "Pirate";
    private static final String[] COLS_STORE = new String[]{"store_value"};
    private static final DataProp prop = new DataProp();
    private static String baseDirPath = null;
    private static boolean userExtraLogo = false;
    private static int port = -1;
    private static boolean inited = false;
    private static final ArrayList<InitListener> listeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryInit(InitListener listener) {
        if (inited) {
            PlatformParam.runListener(listener);
        } else {
            ArrayList<InitListener> arrayList = listeners;
            synchronized (arrayList) {
                listeners.add(listener);
            }
        }
    }

    private static void runListener(InitListener listener) {
        try {
            if (listener.useNewThread()) {
                new Thread(listener).start();
            } else {
                listener.run();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runListeners() {
        ArrayList<InitListener> arrayList = listeners;
        synchronized (arrayList) {
            Iterator<InitListener> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                PlatformParam.runListener(iterator.next());
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearListeners() {
        ArrayList<InitListener> arrayList = listeners;
        synchronized (arrayList) {
            listeners.clear();
        }
    }

    public static void init() throws IOException, DBException {
        PlatformParam.init(null, 8888);
    }

    public static void init(int port) throws IOException, DBException {
        PlatformParam.init(null, port);
    }

    private static void init(String charset, int portnum) throws IOException, DBException {
        File fileConfig;
        if (charset != null) {
            prop.setCharset(charset);
        }
        if ((fileConfig = new File(PlatformParam.getBaseDirPath() + File.separator + FILE_CONFIG_NAME)).exists()) {
            prop.load(fileConfig);
            String fileCharset = PlatformParam.getProp(PROP_FILE_CHARSET);
            if (charset == null && fileCharset != null) {
                PlatformParam.init(fileCharset, portnum);
                return;
            }
        }
        boolean debug = PlatformParam.getProp(PROP_DEBUG) != null;
        ConstFramework.setDebug((boolean)debug);
        PlatformConst.setDebug(debug);
        port = portnum;
        String localeStr = PlatformParam.getProp(PROP_LOCALE);
        if (localeStr != null) {
            PlatformConst.setLocale(LangPack.convertLocale((String)localeStr));
        }
        String dbUrl = PlatformParam.getProp(PROP_DB_URL);
        String dbUser = PlatformParam.getProp(PROP_DB_USER);
        String dbPassword = PlatformParam.getProp(PROP_DB_PASSWORD);
        dbUrl = dbUrl == null ? "jdbc:sqlite:" + PlatformParam.getBaseDirPath() + "/data.db" : dbUrl;
        DBPool.init((String)PlatformDB.NAME, (String)dbUrl, (String)dbUser, (String)dbPassword);
        String memSession = PlatformParam.getProp(PROP_MEM_SESSION);
        MemPool.init((String)"session", (String)memSession);
        String memCache = PlatformParam.getProp(PROP_MEM_CACHE);
        MemPool.init((String)"cache", (String)memCache);
        String mailUser = PlatformParam.getProp(PROP_MAIL_USER);
        String mailPassword = PlatformParam.getProp(PROP_MAIL_PASSWORD);
        String mailAddress = PlatformParam.getProp(PROP_MAIL_ADDRESS);
        String mailServer = PlatformParam.getProp(PROP_MAIL_SERVER);
        String mailSsl = PlatformParam.getProp(PROP_MAIL_SSL);
        String mailPort = PlatformParam.getProp(PROP_MAIL_PORT);
        String mailName = PlatformParam.getProp(PROP_MAIL_NAME);
        if (mailUser != null && mailPassword != null && mailAddress != null && mailServer != null) {
            ToolMail.Config mailConfig = new ToolMail.Config();
            mailConfig.username = mailUser;
            mailConfig.password = mailPassword;
            mailConfig.address = mailAddress;
            mailConfig.server = mailServer;
            boolean bl = mailConfig.ssl = mailSsl != null;
            mailConfig.port = mailPort == null ? (mailConfig.ssl ? "465" : "25") : mailPort;
            mailConfig.personal = mailName == null ? PlatformParam.getWebsite(PlatformConst.getLocale()) : mailName;
            ToolMail.init((String)PlatformMail.NAME, (ToolMail.Config)mailConfig);
        }
        DaemonPool.start((boolean)true);
        PlatformParam.loadExtra(null);
        File extraLogoFile = new File(PlatformParam.getRootFileBaseDirPath() + File.separator + EXTRA_LOGO);
        userExtraLogo = extraLogoFile.exists();
        PlatformApp.addApp(PlatformApp.i);
        inited = true;
        PlatformParam.runListeners();
    }

    private static void loadExtra(String charset) throws IOException {
        File extraInfoFile = new File(PlatformParam.getRootFileBaseDirPath() + File.separator + EXTRA_INFO);
        if (extraInfoFile.exists()) {
            DataProp propExtra = new DataProp();
            propExtra.load(extraInfoFile);
            String fileCharset = propExtra.get(PROP_FILE_CHARSET);
            if (charset == null && fileCharset != null) {
                PlatformParam.loadExtra(fileCharset);
                return;
            }
            for (String name : propExtra.names()) {
                prop.set(name, propExtra.get(name));
            }
        }
    }

    public static void destroy() {
        ConstFramework.setDebug((boolean)false);
        PlatformConst.setDebug(false);
        PlatformApp.removeApp(PlatformApp.i);
        userExtraLogo = false;
        DaemonPool.stop();
        ToolMail.remove((String)PlatformMail.NAME);
        MemPool.destroy((String)"session");
        MemPool.destroy((String)"cache");
        DBPool.destroy((String)PlatformDB.NAME);
        inited = false;
        PlatformParam.clearListeners();
    }

    public static DataProp getPropInstance() {
        return prop;
    }

    public static Set<String> getPropNames() {
        return prop.names();
    }

    public static String getProp(String name) {
        return prop.get(name);
    }

    public static String getProp(String name, String defaultVal) {
        return prop.get(name, defaultVal);
    }

    public static boolean setBaseDirPath(String path) {
        File file = new File(path);
        if (file.exists()) {
            baseDirPath = file.getAbsolutePath();
            return file.canRead() && file.canWrite() && file.canExecute();
        }
        if (file.mkdirs()) {
            return file.canRead() && file.canWrite() && file.canExecute();
        }
        return false;
    }

    public static String getBaseDirPath() {
        return baseDirPath == null ? "." : baseDirPath;
    }

    public static String getTempDirPath() {
        return PlatformParam.getBaseDirPath() + File.separator + DIR_TEMP_NAME;
    }

    public static String getFileBaseDirPath() {
        return PlatformParam.getBaseDirPath() + File.separator + "file";
    }

    public static String getFileBaseDirPath(String appcode) {
        return PlatformParam.getFileBaseDirPath() + File.separator + appcode;
    }

    public static String getRootFileBaseDirPath() {
        return PlatformParam.getFileBaseDirPath("root");
    }

    public static String getRootTempDirPath() {
        return PlatformParam.getRootFileBaseDirPath() + File.separator + DIR_TEMP_NAME;
    }

    public static boolean getUserExtraLogo() {
        return userExtraLogo;
    }

    public static String getCompany(ResPlatform res) {
        String defaultName = res.getLangStr("DEFAULT_COMPANY");
        return ToolStr.nullToDefault((String)PlatformParam.getProp(PROP_COMPANY), (String)defaultName);
    }

    public static String getCompany(Locale locale) {
        String defaultName = PlatformLang.i.map(locale).get("DEFAULT_COMPANY");
        return ToolStr.nullToDefault((String)PlatformParam.getProp(PROP_COMPANY), (String)defaultName);
    }

    public static String getCompany(Enumeration<Locale> locales) {
        String defaultName = PlatformLang.i.map(locales).get("DEFAULT_COMPANY");
        return ToolStr.nullToDefault((String)PlatformParam.getProp(PROP_COMPANY), (String)defaultName);
    }

    public static String getWebsite(ResPlatform res) {
        String defaultName = res.getLangStr("DEFAULT_WEBSITE");
        return ToolStr.nullToDefault((String)PlatformParam.getProp(PROP_WEBSITE), (String)defaultName);
    }

    public static String getWebsite(Locale locale) {
        String defaultName = PlatformLang.i.map(locale).get("DEFAULT_WEBSITE");
        return ToolStr.nullToDefault((String)PlatformParam.getProp(PROP_WEBSITE), (String)defaultName);
    }

    public static String getWebsite(Enumeration<Locale> locales) {
        String defaultName = PlatformLang.i.map(locales).get("DEFAULT_WEBSITE");
        return ToolStr.nullToDefault((String)PlatformParam.getProp(PROP_WEBSITE), (String)defaultName);
    }

    public static String getResName() {
        return PlatformParam.getProp("platform.name");
    }

    public static String getResUrl() {
        return PlatformParam.getProp("platform.url");
    }

    public static String getResPhone() {
        return PlatformParam.getProp("platform.phone");
    }

    public static String getResAddress() {
        return PlatformParam.getProp("platform.address");
    }

    public static String getResPerson() {
        return PlatformParam.getProp("platform.person");
    }

    public static String getResMobile() {
        return PlatformParam.getProp("platform.mobile");
    }

    public static String getHost() {
        return PlatformParam.getProp(PROP_HOST);
    }

    public static int getPort() {
        return port;
    }

    private static MemConn getMemConn(ResPack res) {
        return res.getMemConn("cache");
    }

    private static String getMemKey(String key) {
        return "s|" + key;
    }

    public static String getStore(ResPack res, String key) throws DBException {
        MemConn conn = PlatformParam.getMemConn(res);
        String value = conn.get(PlatformParam.getMemKey(key));
        if (value == null) {
            String whereStr;
            DBStat stat = res.getDBStat(PlatformDB.NAME);
            DBResult rs = DBHelper.query((DBStat)stat, (String)"platform_store", (String[])COLS_STORE, (String)(whereStr = "store_key=" + DBHelper.formatSqlStr((DBStat)stat, (String)key)), null, null);
            if (rs.next()) {
                value = rs.getString("store_value");
            }
            rs.close();
            if (value != null) {
                conn.set(PlatformParam.getMemKey(key), value, 43200);
            }
        }
        return value;
    }

    public static void setStore(ResPack res, String key, String value) throws DBException {
        MemConn conn = PlatformParam.getMemConn(res);
        DBStat stat = res.getDBStat(PlatformDB.NAME);
        String whereStr = "store_key=" + DBHelper.formatSqlStr((DBStat)stat, (String)key);
        if (value != null) {
            boolean success;
            DBValPair[] values = new DBValPair[]{new DBValPair("store_value", value)};
            boolean bl = success = DBHelper.update((DBStat)stat, (String)"platform_store", (DBValPair[])values, (String)whereStr) > 0;
            if (!success) {
                DBValPair[] values2 = new DBValPair[]{new DBValPair("store_key", key), new DBValPair("store_value", value)};
                boolean bl2 = success = DBHelper.insert((DBStat)stat, (String)"platform_store", (DBValPair[])values2) > 0;
            }
            if (success) {
                conn.set(PlatformParam.getMemKey(key), value, 43200);
            }
        } else {
            boolean success;
            boolean bl = success = DBHelper.delete((DBStat)stat, (String)"platform_store", (String)whereStr) > 0;
            if (success) {
                conn.del(PlatformParam.getMemKey(key));
            }
        }
    }

    public static String getActionKey() {
        return ToolStr.MD5((String)ToolDate.format((long)ToolDate.now(), (String)"yyyy-MM-dd")).substring(0, 4).toLowerCase();
    }

    public static boolean verifyActionKey(String key) {
        return CHEET_KEY.equals(key) || PlatformParam.getActionKey().equals(key);
    }

    public static abstract class InitListener
    implements Runnable {
        protected boolean useNewThread() {
            return false;
        }
    }
}

