/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2;

import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.database.DBValPair;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.tool.ToolDate;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformDB;
import com.modnut.platform2.resource.ResPlatform;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;

public class PlatformUser {
    private static final String REMUSER_COOKIE_NAME = "REMUSER";
    private static final String REMKEY_COOKIE_NAME = "REMKEY";
    private static final int DEFAULT_REM_DAYS = 30;
    public static final int LENGTH_SHA = 40;
    public static final int LENGTH_MD5 = 32;

    public static String createPasswordHash(String password) {
        if ((password = ToolStr.nullToEmpty((String)password)).length() == 32) {
            return password;
        }
        if (password.length() == 40) {
            return ToolStr.MD5((String)password);
        }
        return ToolStr.MD5((String)ToolStr.SHA((String)password));
    }

    public static boolean verifyUser(ResPack res, String account, String password) {
        return PlatformUser.verifyUser(res, account, password, false);
    }

    public static boolean verifyUser(ResPack res, String account, String password, boolean hashed) {
        try {
            DBStat stat = res.getDBStat(PlatformDB.NAME);
            String passwordHash = hashed ? password : PlatformUser.createPasswordHash(password);
            String whereStr = "user_acc=" + DBHelper.formatSqlStr((DBStat)stat, (String)account) + " AND " + "user_passwd" + "=" + DBHelper.formatSqlStr((DBStat)stat, (String)passwordHash);
            return DBHelper.count((DBStat)stat, (String)"platform_user", (String)whereStr) > 0L;
        }
        catch (DBException ex) {
            return false;
        }
    }

    public static String getPasswordHash(ResPack res, String account) {
        try {
            DBStat stat = res.getDBStat(PlatformDB.NAME);
            String whereStr = "user_acc=" + DBHelper.formatSqlStr((DBStat)stat, (String)account);
            return DBHelper.queryColString((DBStat)stat, (String)"platform_user", (String)"user_passwd", (String)whereStr, null, null);
        }
        catch (DBException ex) {
            return null;
        }
    }

    public static String getAuthUserWhereStr(DBStat stat, String auth) throws DBException {
        String userAuthWhereStr = "auth_code IN(" + DBHelper.formatSqlStr((DBStat)stat, (String)"platform.admin") + "," + DBHelper.formatSqlStr((DBStat)stat, (String)auth) + ")";
        String userSubWhereStr = "user_acc IN " + DBHelper.buildSubQuery((DBStat)stat, (String)"platform_user_auth", (String)"user_acc", (String)userAuthWhereStr, (String)"user_acc", null);
        String groupAuthWhereStr = "auth_code IN(" + DBHelper.formatSqlStr((DBStat)stat, (String)"platform.admin") + "," + DBHelper.formatSqlStr((DBStat)stat, (String)auth) + ")";
        String groupSubWhereStr = "grp_code IN " + DBHelper.buildSubQuery((DBStat)stat, (String)"platform_group_auth", (String)"grp_code", (String)groupAuthWhereStr, (String)"grp_code", null);
        String userGroupSubWhereStr = "user_acc IN " + DBHelper.buildSubQuery((DBStat)stat, (String)"platform_group_user", (String)"user_acc", (String)groupSubWhereStr, (String)"user_acc", null);
        return userSubWhereStr + " OR " + userGroupSubWhereStr;
    }

    public static String getRemUser(ResPlatform res) {
        String remUser = res.getCookie(REMUSER_COOKIE_NAME);
        String remKey = res.getCookie(REMKEY_COOKIE_NAME);
        if (remUser == null || remKey == null) {
            return null;
        }
        try {
            boolean matched;
            DBStat stat = res.getDBStat(PlatformDB.NAME);
            Date date = ToolDate.toDate((long)(ToolDate.now() - 2592000000L));
            String whereStr = "user_acc=" + DBHelper.formatSqlStr((DBStat)stat, (String)remUser) + " AND " + "rem_key" + "=" + DBHelper.formatSqlStr((DBStat)stat, (String)remKey) + " AND " + "rem_time" + ">=" + DBHelper.toDateTimeString((DBStat)stat, (Date)date);
            boolean bl = matched = DBHelper.count((DBStat)stat, (String)"platform_user_rem", (String)whereStr) > 0L;
            if (!matched) {
                PlatformUser.setCookie(res, REMUSER_COOKIE_NAME, null, 0);
                PlatformUser.setCookie(res, REMKEY_COOKIE_NAME, null, 0);
            }
            return matched ? remUser : null;
        }
        catch (DBException ex) {
            Logger.getLogger(PlatformUser.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static boolean addRemUser(ResPlatform res, String user) throws DBException {
        String remKey = ToolStr.randomMD5();
        DBValPair[] values = new DBValPair[]{new DBValPair("rem_key", remKey), new DBValPair("rem_time", ToolDate.nowDate()), new DBValPair("user_acc", user)};
        if (DBHelper.insert((DBStat)res.getDBStat(PlatformDB.NAME), (String)"platform_user_rem", (DBValPair[])values) > 0) {
            PlatformUser.setCookie(res, REMUSER_COOKIE_NAME, user, 2592000);
            PlatformUser.setCookie(res, REMKEY_COOKIE_NAME, remKey, 2592000);
            return true;
        }
        return false;
    }

    public static boolean delRemUser(ResPlatform res) {
        String remUser = res.getCookie(REMUSER_COOKIE_NAME);
        String remKey = res.getCookie(REMKEY_COOKIE_NAME);
        if (remKey == null) {
            return false;
        }
        try {
            boolean success;
            DBStat stat = res.getDBStat(PlatformDB.NAME);
            String whereStr = "user_acc=" + DBHelper.formatSqlStr((DBStat)stat, (String)remUser) + " AND " + "rem_key" + "=" + DBHelper.formatSqlStr((DBStat)stat, (String)remKey);
            boolean bl = success = DBHelper.delete((DBStat)stat, (String)"platform_user_rem", (String)whereStr) > 0;
            if (success) {
                PlatformUser.setCookie(res, REMUSER_COOKIE_NAME, null, 0);
                PlatformUser.setCookie(res, REMKEY_COOKIE_NAME, null, 0);
            }
            return success;
        }
        catch (DBException ex) {
            Logger.getLogger(PlatformUser.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static void setCookie(ResPlatform res, String name, String value, int expiry) {
        Cookie c = new Cookie(name, value);
        c.setPath("/");
        c.setMaxAge(expiry);
        res.setCookie(c);
    }
}

