/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.cache;

import com.modnut.framework2.cache.CacheMemBase;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBResult;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.json.JSONArray;
import com.modnut.framework2.resource.ResPack;
import com.modnut.platform2.PlatformDB;
import com.modnut.platform2.PlatformUrl;

public class CacheUser
extends CacheMemBase<UserObj> {
    public static final CacheUser i = new CacheUser();
    private static final String[] COLS_CACHE = new String[]{"user_acc", "user_name", "user_phone", "user_mail", "user_avatar20", "user_avatar50", "user_avatar200", "user_version", "user_disabled"};

    protected String getMemName() {
        return "cache";
    }

    protected UserObj str2obj(String str) throws Exception {
        JSONArray arr = new JSONArray(str);
        UserObj obj = new UserObj();
        int index = 0;
        obj.account = arr.getString(index++);
        obj.name = arr.getString(index++);
        obj.phone = arr.getString(index++);
        obj.mail = arr.getString(index++);
        obj.avatar20 = arr.getString(index++);
        obj.avatar50 = arr.getString(index++);
        obj.avatar200 = arr.getString(index++);
        obj.version = arr.getLong(index++);
        obj.disabled = arr.getInteger(index++) > 0;
        return obj;
    }

    protected String obj2str(UserObj obj) throws Exception {
        JSONArray arr = new JSONArray();
        arr.put(obj.account);
        arr.put(obj.name);
        arr.put(obj.phone);
        arr.put(obj.mail);
        arr.put(obj.avatar20);
        arr.put(obj.avatar50);
        arr.put(obj.avatar200);
        arr.put(obj.version);
        arr.put(obj.disabled ? 1 : 0);
        return arr.toJsonString();
    }

    protected int getCacheTime() {
        return 86400;
    }

    protected UserObj getNone() {
        return new UserObj();
    }

    protected String getCacheKey(String key) {
        return "u|" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserObj fromDB(ResPack res, String key) throws Exception {
        DBStat stat = res.getDBStat(PlatformDB.NAME);
        String whereStr = "user_acc=" + DBHelper.formatSqlStr((DBStat)stat, (String)key);
        DBResult rs = DBHelper.query((DBStat)stat, (String)"platform_user", (String[])COLS_CACHE, (String)whereStr, null, null);
        try {
            if (rs.next()) {
                UserObj obj = new UserObj();
                obj.account = rs.getString("user_acc");
                obj.name = rs.getString("user_name");
                obj.phone = rs.getString("user_phone");
                obj.mail = rs.getString("user_mail");
                obj.avatar20 = rs.getString("user_avatar20");
                obj.avatar50 = rs.getString("user_avatar50");
                obj.avatar200 = rs.getString("user_avatar200");
                obj.version = rs.getLong("user_version");
                obj.disabled = rs.getBoolean("user_disabled");
                UserObj userObj = obj;
                return userObj;
            }
            UserObj userObj = null;
            return userObj;
        }
        finally {
            rs.close();
        }
    }

    public static class UserObj {
        public String account;
        public String name;
        public String phone;
        public String mail;
        public String avatar20;
        public String avatar50;
        public String avatar200;
        public long version;
        public boolean disabled;

        public String getAvatar20Url() {
            String avatar = this.avatar20 == null ? null : this.avatar20 + "?" + this.version;
            return PlatformUrl.i.convert(avatar, PlatformUrl.i.getImgAvatar20());
        }

        public String getAvatar50Url() {
            String avatar = this.avatar50 == null ? null : this.avatar50 + "?" + this.version;
            return PlatformUrl.i.convert(avatar, PlatformUrl.i.getImgAvatar50());
        }

        public String getAvatar200Url() {
            String avatar = this.avatar200 == null ? null : this.avatar200 + "?" + this.version;
            return PlatformUrl.i.convert(avatar, PlatformUrl.i.getImgAvatar200());
        }
    }
}

