/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.daemon;

import com.modnut.framework2.crypto.BASE64;
import com.modnut.framework2.crypto.TokenET99;
import com.modnut.framework2.daemon.DaemonBase;
import com.modnut.framework2.extend.HardwareInfo;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.tool.ToolDate;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformApp;
import com.modnut.platform2.PlatformConst;
import com.modnut.platform2.PlatformParam;
import com.modnut.platform2.lang.PlatformLang;
import com.modnut.platform2.resource.ResPlatform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DaemonCheckBase
extends DaemonBase {
    public static final int CODE_OK = 0;
    public static final int CODE_NOT_INITED = 1;
    public static final int CODE_KEY_NULL = 2;
    public static final int CODE_CONTENT_NULL = 3;
    public static final int CODE_CODE_NOT_MATCH = 4;
    public static final int CODE_TIME_EXPIRY = 5;
    public static final int CODE_TOKEN_MISSING = 6;
    public static final int CODE_SN_NOT_MATCH = 7;
    public static final int CODE_PIN_NOT_MATCH = 8;
    public static final int CODE_MAC_NOT_MATCH = 9;
    public static final int CODE_HARDWARE_NOT_MATCH = 10;
    public static final int CODE_PORT_NOT_MATCH = 11;
    public static final int CODE_PARAM_UNVERIFY = 12;
    private final AtomicInteger code = new AtomicInteger(1);
    private final AtomicBoolean lock = new AtomicBoolean(false);

    public DaemonCheckBase() {
    }

    public DaemonCheckBase(String schedule) {
        super(schedule);
    }

    protected void doTask() {
        this.refreshResult();
    }

    public String getResult(ResPlatform res) {
        int value = this.code.get();
        if (value != 0) {
            value = this.refreshResult();
        }
        switch (value) {
            case 0: {
                return null;
            }
            case 1: {
                return res.getLangStr("TOKEN_NOT_INITED");
            }
            case 2: {
                return res.getLangStr("TOKEN_KEY_NULL");
            }
            case 3: {
                return res.getLangStr("TOKEN_CONTENT_NULL");
            }
            case 4: {
                return res.getLangStr("TOKEN_CODE_NOT_MATCH");
            }
            case 5: {
                return res.getLangStr("TOKEN_TIME_EXPIRY");
            }
            case 6: {
                return res.getLangStr("TOKEN_TOKEN_MISSING");
            }
            case 7: {
                return res.getLangStr("TOKEN_SN_NOT_MATCH");
            }
            case 8: {
                return res.getLangStr("TOKEN_PIN_NOT_MATCH");
            }
            case 9: {
                return res.getLangStr("TOKEN_MAC_NOT_MATCH");
            }
            case 10: {
                return res.getLangStr("TOKEN_HARDWARE_NOT_MATCH");
            }
            case 11: {
                return res.getLangStr("TOKEN_PORT_NOT_MATCH");
            }
            case 12: {
                return res.getLangStr("TOKEN_PARAM_UNVERIFY");
            }
        }
        return res.getLangStr("TOKEN_UNKNOW_ERROR");
    }

    public String getResult(Locale locale) {
        int value = this.code.get();
        if (value != 0) {
            value = this.refreshResult();
        }
        switch (value) {
            case 0: {
                return null;
            }
            case 1: {
                return PlatformLang.i.map(locale).get("TOKEN_NOT_INITED");
            }
            case 2: {
                return PlatformLang.i.map(locale).get("TOKEN_KEY_NULL");
            }
            case 3: {
                return PlatformLang.i.map(locale).get("TOKEN_CONTENT_NULL");
            }
            case 4: {
                return PlatformLang.i.map(locale).get("TOKEN_CODE_NOT_MATCH");
            }
            case 5: {
                return PlatformLang.i.map(locale).get("TOKEN_TIME_EXPIRY");
            }
            case 6: {
                return PlatformLang.i.map(locale).get("TOKEN_TOKEN_MISSING");
            }
            case 7: {
                return PlatformLang.i.map(locale).get("TOKEN_SN_NOT_MATCH");
            }
            case 8: {
                return PlatformLang.i.map(locale).get("TOKEN_PIN_NOT_MATCH");
            }
            case 9: {
                return PlatformLang.i.map(locale).get("TOKEN_MAC_NOT_MATCH");
            }
            case 10: {
                return PlatformLang.i.map(locale).get("TOKEN_HARDWARE_NOT_MATCH");
            }
            case 11: {
                return PlatformLang.i.map(locale).get("TOKEN_PORT_NOT_MATCH");
            }
            case 12: {
                return PlatformLang.i.map(locale).get("TOKEN_PARAM_UNVERIFY");
            }
        }
        return PlatformLang.i.map(locale).get("TOKEN_UNKNOW_ERROR");
    }

    public String getResult(Enumeration<Locale> locales) {
        int value = this.code.get();
        if (value != 0) {
            value = this.refreshResult();
        }
        switch (value) {
            case 0: {
                return null;
            }
            case 1: {
                return PlatformLang.i.map(locales).get("TOKEN_NOT_INITED");
            }
            case 2: {
                return PlatformLang.i.map(locales).get("TOKEN_KEY_NULL");
            }
            case 3: {
                return PlatformLang.i.map(locales).get("TOKEN_CONTENT_NULL");
            }
            case 4: {
                return PlatformLang.i.map(locales).get("TOKEN_CODE_NOT_MATCH");
            }
            case 5: {
                return PlatformLang.i.map(locales).get("TOKEN_TIME_EXPIRY");
            }
            case 6: {
                return PlatformLang.i.map(locales).get("TOKEN_TOKEN_MISSING");
            }
            case 7: {
                return PlatformLang.i.map(locales).get("TOKEN_SN_NOT_MATCH");
            }
            case 8: {
                return PlatformLang.i.map(locales).get("TOKEN_PIN_NOT_MATCH");
            }
            case 9: {
                return PlatformLang.i.map(locales).get("TOKEN_MAC_NOT_MATCH");
            }
            case 10: {
                return PlatformLang.i.map(locales).get("TOKEN_HARDWARE_NOT_MATCH");
            }
            case 11: {
                return PlatformLang.i.map(locales).get("TOKEN_PORT_NOT_MATCH");
            }
            case 12: {
                return PlatformLang.i.map(locales).get("TOKEN_PARAM_UNVERIFY");
            }
        }
        return PlatformLang.i.map(locales).get("TOKEN_UNKNOW_ERROR");
    }

    public int refreshResult() {
        DaemonCheckBase.echoLog("start to verify application " + this.getAppCode());
        if (this.lock.compareAndSet(false, true)) {
            this.code.set(this.verifyAppKey());
            this.lock.set(false);
        }
        return this.code.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int verifyAppKey() {
        PlatformApp.AppKey appKey = this.getAppKey();
        if (appKey == null) {
            return 2;
        }
        PlatformApp.AppKey.AppKeyContent content = appKey.getContent(this.getPublicKey());
        if (content == null) {
            return 3;
        }
        DaemonCheckBase.echoLog("verify code=" + content.code + ",expiry=" + content.expiry + ",PID=" + content.pid + ",SN=" + content.sn + ",PIN=" + content.pin + ",MAC=" + content.mac + ",HARDWARE=" + content.hardware + ",PORT=" + content.port);
        if (!this.getAppCode().equals(content.code)) {
            return 4;
        }
        if (content.expiry != null && ToolDate.parseParam((String)content.expiry, (boolean)true) < ToolDate.now()) {
            return 5;
        }
        if (content.mac != null) {
            String mac = content.mac.toUpperCase();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length(); ++i) {
                char ch = mac.charAt(i);
                if ((ch < '0' || ch > '9') && (ch < 'A' || ch > 'F')) continue;
                sb.append(ch);
            }
            mac = sb.toString();
            if (!DaemonCheckBase.getTestMac(mac)) {
                return 9;
            }
        }
        if (content.hardware != null && !content.hardware.equals(HardwareInfo.getSerial())) {
            return 10;
        }
        if (content.port != 0 && content.port != PlatformParam.getPort()) {
            return 11;
        }
        ResPack res = new ResPack();
        try {
            if (!this.checkParams(res, content.params)) {
                int n = 12;
                return n;
            }
        }
        finally {
            res.disposeRes();
        }
        return DaemonCheckBase.verifyToken(content);
    }

    protected boolean checkParams(ResPack res, String[] params) {
        return true;
    }

    private static boolean getTestMac(String mac) {
        try {
            for (String mac2 : HardwareInfo.getMacAddress()) {
                if (!ToolStr.equals((String)mac, (String)mac2, (boolean)false)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static synchronized int verifyToken(PlatformApp.AppKey.AppKeyContent content) {
        if (content.pid != null) {
            TokenET99 et99 = new TokenET99(content.pid, content.pin, false);
            if (et99.tokenCount() == 0) {
                return 6;
            }
            if (content.sn != null && content.pin != null && et99.tokenOpen(1)) {
                try {
                    if (content.sn != null && !ToolStr.equals((String)content.sn, (String)et99.tokenSN(), (boolean)false)) {
                        int n = 7;
                        return n;
                    }
                    if (content.pin != null && !et99.tokenVerify()) {
                        int n = 8;
                        return n;
                    }
                }
                finally {
                    et99.tokenClose();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlatformApp.AppKey getAppKey() {
        PlatformApp.AppKey key = null;
        String path = PlatformParam.getBaseDirPath() + File.separator + "key" + File.separator + this.getAppCode() + ".key";
        File file = new File(path);
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(path));
                try {
                    String line1 = reader.readLine();
                    String line2 = reader.readLine();
                    if (line1 != null && line2 != null) {
                        PlatformApp.AppKey newKey = new PlatformApp.AppKey();
                        newKey.sign = line1.trim();
                        newKey.data = BASE64.decode((String)line2.trim());
                        key = newKey;
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PlatformApp.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return key;
    }

    protected abstract String getAppCode();

    protected abstract String getPublicKey();

    protected static String getParam(String[] params, int index) {
        if (params != null && index < params.length) {
            return params[index];
        }
        return null;
    }

    protected static boolean getParam(String[] params, int index, boolean defaultVal) {
        return ToolStr.parseBoolean((String)DaemonCheckBase.getParam(params, index), (boolean)defaultVal);
    }

    protected static short getParam(String[] params, int index, short defaultVal) {
        return ToolStr.parseShort((String)DaemonCheckBase.getParam(params, index), (short)defaultVal);
    }

    protected static int getParam(String[] params, int index, int defaultVal) {
        return ToolStr.parseInt((String)DaemonCheckBase.getParam(params, index), (int)defaultVal);
    }

    protected static long getParam(String[] params, int index, long defaultVal) {
        return ToolStr.parseLong((String)DaemonCheckBase.getParam(params, index), (long)defaultVal);
    }

    protected static float getParam(String[] params, int index, float defaultVal) {
        return ToolStr.parseFloat((String)DaemonCheckBase.getParam(params, index), (float)defaultVal);
    }

    protected static double getParam(String[] params, int index, double defaultVal) {
        return ToolStr.parseDouble((String)DaemonCheckBase.getParam(params, index), (double)defaultVal);
    }

    private static String echoLog(String message) {
        if (PlatformConst.getDebug()) {
            String dateTimeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            System.out.println("[" + dateTimeStr + " DAEMON CHECK]" + message);
        }
        return message;
    }
}

