/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.dom;

import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.dom.DomHelper;

public class DomForm {
    private final String action;
    private String id;
    private String addClass;
    private String title;
    private Boolean methodGet;
    private StringBuilder inputsBuilder;
    private StringBuilder buttonsBuilder;

    public DomForm() {
        this.action = null;
    }

    public DomForm(String action) {
        this.action = action;
    }

    public DomForm(String action, boolean methodGet) {
        this.action = action;
        this.methodGet = methodGet ? Boolean.TRUE : Boolean.FALSE;
    }

    public DomForm(String id, String addClass) {
        this.action = null;
        this.id = id;
        this.addClass = addClass;
    }

    public DomForm(String action, String id, String addClass) {
        this.action = action;
        this.id = id;
        this.addClass = addClass;
    }

    public DomForm(String action, String id, String addClass, boolean methodGet) {
        this.action = action;
        this.id = id;
        this.addClass = addClass;
        this.methodGet = methodGet ? Boolean.TRUE : Boolean.FALSE;
    }

    public StringBuilder getInputsBuilder() {
        if (this.inputsBuilder == null) {
            this.inputsBuilder = new StringBuilder();
        }
        return this.inputsBuilder;
    }

    public StringBuilder getButtonsBuilder() {
        if (this.buttonsBuilder == null) {
            this.buttonsBuilder = new StringBuilder();
        }
        return this.buttonsBuilder;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addDom(String dom) {
        this.getInputsBuilder().append(dom);
    }

    public void addLine(String dom) {
        this.addLine(dom, null);
    }

    public void addLine(String dom, String addClass) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">").append(dom).append("</div>");
    }

    public void addField(String label, String dom) {
        this.addField(label, dom, null);
    }

    public void addField(String label, String dom, String addClass) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        sb.append("<span class=\"form-field");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">");
        sb.append(dom);
        sb.append("</span>");
        sb.append("</div>");
    }

    public void addInput(String label, String name) {
        this.addInput(label, name, null, null, null);
    }

    public void addInput(String label, String name, String value) {
        this.addInput(label, name, value, null, null);
    }

    public void addInput(String label, String name, String value, String addClass) {
        this.addInput(label, name, value, addClass, null);
    }

    public void addInput(String label, String name, String value, String addClass, String placeholder) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        sb.append(DomHelper.input(name, value, addClass, placeholder));
        sb.append("</div>");
    }

    public void addPassword(String label, String name) {
        this.addPassword(label, name, null, null, null);
    }

    public void addPassword(String label, String name, String value) {
        this.addPassword(label, name, value, null, null);
    }

    public void addPassword(String label, String name, String value, String addClass) {
        this.addPassword(label, name, value, addClass, null);
    }

    public void addPassword(String label, String name, String value, String addClass, String placeholder) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        sb.append(DomHelper.password(name, value, addClass, placeholder));
        sb.append("</div>");
    }

    public void addInputHidden(String name) {
        this.addInputHidden(name, null, null);
    }

    public void addInputHidden(String name, String value) {
        this.addInputHidden(name, value, null);
    }

    public void addInputHidden(String name, String value, String addClass) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"hide form-name-").append(name).append("\">");
        sb.append(DomHelper.inputHidden(name, value, addClass));
        sb.append("</div>");
    }

    public void addTextarea(String label, String name) {
        this.addTextarea(label, name, null, null);
    }

    public void addTextarea(String label, String name, String value) {
        this.addTextarea(label, name, value, null);
    }

    public void addTextarea(String label, String name, String value, String addClass) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        sb.append(DomHelper.textarea(name, value, addClass));
        sb.append("</div>");
    }

    public void addSelect(String label, String name, String option) {
        this.addSelect(label, name, option, null);
    }

    public void addSelect(String label, String name, String option, String addClass) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        sb.append(DomHelper.select(name, option, addClass));
        sb.append("</div>");
    }

    public void addCaptcha(String label, String name, String captchaUrl) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        sb.append(DomHelper.input(name, null, "input-captcha")).append(DomHelper.captcha(captchaUrl));
        sb.append("</div>");
    }

    public void addRadio(String label, String name, String[] texts, String[] values, String checkedValue) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        for (int i = 0; i < texts.length && i < values.length; ++i) {
            boolean checked = values[i].equals(checkedValue);
            sb.append("<label class=\"checklabel\">");
            sb.append(DomHelper.radio(name, values[i], checked));
            sb.append(texts[i]).append("</label>");
        }
        sb.append("</div>");
    }

    public void addCheckbox(String label, String name, String[] texts, String[] values, String[] checkedValues) {
        StringBuilder sb = this.getInputsBuilder();
        sb.append("<div class=\"form-line form-name-").append(name).append("\">");
        sb.append("<label class=\"label\">").append(label).append("</label>");
        for (int i = 0; i < texts.length && i < values.length; ++i) {
            boolean checked = false;
            if (checkedValues != null) {
                for (int j = 0; j < checkedValues.length; ++j) {
                    if (!values[i].equals(checkedValues[j])) continue;
                    checked = true;
                    break;
                }
            }
            sb.append("<label class=\"checklabel\">");
            sb.append(DomHelper.checkbox(name, values[i], checked));
            sb.append(texts[i]).append("</label>");
        }
        sb.append("</div>");
    }

    public void addButton(String dom) {
        this.addButton(dom, null);
    }

    public void addButton(String dom, String addClass) {
        this.getButtonsBuilder().append(DomHelper.button(dom, addClass));
    }

    public void addSubmit(String name) {
        this.addSubmit(name, null, null);
    }

    public void addSubmit(String name, String value) {
        this.addSubmit(name, value, null);
    }

    public void addSubmit(String name, String value, String addClass) {
        this.getButtonsBuilder().append(DomHelper.submit(name, value, addClass));
    }

    public String getDom() {
        return this.getDom(null, null);
    }

    public String getDom(String prefix) {
        return this.getDom(prefix, null);
    }

    public String getDom(String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        String tagName = this.action == null ? "div" : "form";
        sb.append("<").append(tagName);
        if (this.action != null) {
            sb.append(" action=\"").append(ToolStr.toHtml((String)this.action)).append("\" method=\"");
            sb.append(this.methodGet != null && this.methodGet != false ? "get" : "post");
            sb.append("\"");
        }
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(" class=\"form");
        if (this.addClass != null) {
            sb.append(" ").append(this.addClass);
        }
        sb.append("\">");
        if (prefix != null) {
            sb.append(prefix);
        }
        if (this.title != null) {
            sb.append("<div class=\"form-title\">").append(this.title).append("</div>");
        }
        sb.append("<div class=\"form-inputs\">").append(this.getInputsBuilder().toString()).append("</div>");
        sb.append("<div class=\"form-buttons\">").append(this.getButtonsBuilder().toString()).append("</div>");
        if (suffix != null) {
            sb.append(suffix);
        }
        sb.append("</").append(tagName).append(">");
        return sb.toString();
    }

    public String toString() {
        return this.getDom();
    }
}

