/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.dom;

import com.modnut.framework2.tool.ToolStr;

public class DomHelper {
    public static final String NONE_DISPLAY_STYLE = "style=\"display:none;\"";
    public static final String SPACE = "&nbsp;";
    public static final String D_QUOTE = "&quot;";
    public static final String S_QUOTE = "&#039;";
    public static final String GT = "&gt;";
    public static final String LT = "&lt;";
    public static final String AMP = "&amp;";
    public static final String BR = "<br />";

    public static String div(String innerDom, String className) {
        return DomHelper.div(innerDom, className, null);
    }

    public static String div(String innerDom, String className, String id) {
        StringBuilder sb = new StringBuilder("<div");
        if (className != null) {
            sb.append(" class=\"").append(className).append("\"");
        }
        if (id != null) {
            sb.append(" id=\"").append(className).append("\"");
        }
        sb.append(">").append(innerDom).append("</div>");
        return sb.toString();
    }

    public static String span(String innerDom, String className) {
        return DomHelper.span(innerDom, className, null);
    }

    public static String span(String innerDom, String className, String id) {
        StringBuilder sb = new StringBuilder("<span");
        if (className != null) {
            sb.append(" class=\"").append(className).append("\"");
        }
        if (id != null) {
            sb.append(" id=\"").append(className).append("\"");
        }
        sb.append(">").append(innerDom).append("</span>");
        return sb.toString();
    }

    public static String captcha(String captchaUrl) {
        return "<img class=\"captcha\" src=\"" + ToolStr.toHtml((String)captchaUrl) + "?" + System.currentTimeMillis() + "\" onclick=\"this.src='" + ToolStr.toHtml((String)captchaUrl) + "?'+(new Date()).getTime();\" />";
    }

    public static String line(String innerDom) {
        return DomHelper.line(innerDom, null, null);
    }

    public static String line(String innerDom, String addClass) {
        return DomHelper.line(innerDom, addClass, null);
    }

    public static String line(String innerDom, String addClass, String id) {
        StringBuilder sb = new StringBuilder("<div class=\"line");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (id != null) {
            sb.append(" id=\"").append(addClass).append("\"");
        }
        sb.append(">").append(innerDom).append("</div>");
        return sb.toString();
    }

    public static String input(String name) {
        return DomHelper.input(name, null, null, null, false);
    }

    public static String input(String name, String value) {
        return DomHelper.input(name, value, null, null, false);
    }

    public static String input(String name, String value, String addClass) {
        return DomHelper.input(name, value, addClass, null, false);
    }

    public static String input(String name, String value, String addClass, String placeholder) {
        return DomHelper.input(name, value, addClass, placeholder, false);
    }

    public static String input(String name, String value, String addClass, String placeholder, boolean noautocomplete) {
        StringBuilder sb = new StringBuilder("<input class=\"input");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (placeholder != null) {
            sb.append(" placeholder=\"").append(ToolStr.toHtml((String)placeholder)).append("\"");
        }
        if (noautocomplete) {
            sb.append(" autocomplete=\"off\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String inputDl(String name, String value, String placeholder, String iconName, String addClass, String addDom) {
        StringBuilder sb = new StringBuilder("<dl class=\"inputdl");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">");
        sb.append("<dt");
        if (iconName != null) {
            sb.append(" class=\"icon-").append(iconName).append("\"");
        }
        sb.append(">").append(placeholder).append(" :</dt>");
        sb.append("<dd>");
        sb.append("<input");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (placeholder != null) {
            sb.append(" placeholder=\"").append(ToolStr.toHtml((String)placeholder)).append("\"");
        }
        sb.append(" autocomplete=\"off\"");
        sb.append("/>");
        if (addDom != null) {
            sb.append(addDom);
        }
        sb.append("</dd>");
        sb.append("</dl>");
        return sb.toString();
    }

    public static String password(String name) {
        return DomHelper.password(name, null, null, null);
    }

    public static String password(String name, String value) {
        return DomHelper.password(name, value, null, null);
    }

    public static String password(String name, String value, String addClass) {
        return DomHelper.password(name, value, addClass, null);
    }

    public static String password(String name, String value, String addClass, String placeholder) {
        StringBuilder sb = new StringBuilder("<input type=\"password\" class=\"input");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (placeholder != null) {
            sb.append(" placeholder=\"").append(ToolStr.toHtml((String)placeholder)).append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String passwordDl(String name, String value, String placeholder, String iconName, String addClass, String addDom) {
        StringBuilder sb = new StringBuilder("<dl class=\"inputdl");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">");
        sb.append("<dt");
        if (iconName != null) {
            sb.append(" class=\"icon-").append(iconName).append("\"");
        }
        sb.append(">").append(placeholder).append(" :</dt>");
        sb.append("<dd>");
        sb.append("<input type=\"password\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (placeholder != null) {
            sb.append(" placeholder=\"").append(ToolStr.toHtml((String)placeholder)).append("\"");
        }
        sb.append("/>");
        if (addDom != null) {
            sb.append(addDom);
        }
        sb.append("</dd>");
        sb.append("</dl>");
        return sb.toString();
    }

    public static String inputHidden(String name) {
        return DomHelper.inputHidden(name, null, null);
    }

    public static String inputHidden(String name, String value) {
        return DomHelper.inputHidden(name, value, null);
    }

    public static String inputHidden(String name, String value, String addClass) {
        StringBuilder sb = new StringBuilder("<input type=\"hidden\" class=\"input-hidden");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String textarea(String name) {
        return DomHelper.textarea(name, null, null);
    }

    public static String textarea(String name, String value) {
        return DomHelper.textarea(name, value, null);
    }

    public static String textarea(String name, String value, String addClass) {
        StringBuilder sb = new StringBuilder("<textarea class=\"textarea");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        sb.append(">");
        sb.append(ToolStr.toHtml((String)value, (boolean)false, (boolean)false));
        sb.append("</textarea>");
        return sb.toString();
    }

    public static String select(String name) {
        return DomHelper.select(name, null, null);
    }

    public static String select(String name, String option) {
        return DomHelper.select(name, option, null);
    }

    public static String select(String name, String option, String addClass) {
        StringBuilder sb = new StringBuilder("<select class=\"select");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        sb.append(">").append(option).append("</select>");
        return sb.toString();
    }

    public static String option(String text, String value, boolean selected) {
        StringBuilder sb = new StringBuilder("<option");
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (selected) {
            sb.append(" selected=\"selected\"");
        }
        sb.append(">").append(ToolStr.toHtml((String)text)).append("</option>");
        return sb.toString();
    }

    public static String checkbox(String name, String value, boolean checked) {
        return DomHelper.checkbox(name, value, null, checked);
    }

    public static String checkbox(String name, String value, String addClass, boolean checked) {
        StringBuilder sb = new StringBuilder("<input type=\"checkbox\" class=\"checkbox");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (checked) {
            sb.append(" checked=\"checked\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String radio(String name, String value, boolean checked) {
        return DomHelper.radio(name, value, null, checked);
    }

    public static String radio(String name, String value, String addClass, boolean checked) {
        StringBuilder sb = new StringBuilder("<input type=\"radio\" class=\"radio");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        if (checked) {
            sb.append(" checked=\"checked\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String submit() {
        return DomHelper.submit(null, null, null);
    }

    public static String submit(String name) {
        return DomHelper.submit(name, null, null);
    }

    public static String submit(String name, String value) {
        return DomHelper.submit(name, value, null);
    }

    public static String submit(String name, String value, String addClass) {
        StringBuilder sb = new StringBuilder("<input type=\"submit\" class=\"button");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (value != null) {
            sb.append(" value=\"").append(ToolStr.toHtml((String)value)).append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String button(String dom) {
        return DomHelper.button(dom, null);
    }

    public static String button(String dom, String addClass) {
        StringBuilder sb = new StringBuilder("<button class=\"button");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">").append(dom).append("</button>");
        return sb.toString();
    }

    public static String link(String href, String dom) {
        return DomHelper.link(href, dom, null, false);
    }

    public static String link(String href, String dom, String className) {
        return DomHelper.link(href, dom, className, false);
    }

    public static String link(String href, String dom, String className, boolean newWindow) {
        StringBuilder sb = new StringBuilder("<a");
        if (href != null) {
            sb.append(" href=\"").append(href).append("\"");
        }
        if (className != null) {
            sb.append(" class=\"").append(className).append("\"");
        }
        if (newWindow) {
            sb.append(" target=\"_blank\"");
        }
        sb.append(">").append(dom).append("</a>");
        return sb.toString();
    }

    public static String label(String dom) {
        return DomHelper.label(dom, null);
    }

    public static String label(String dom, String addClass) {
        StringBuilder sb = new StringBuilder("<label class=\"label");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">").append(dom).append("</label>");
        return sb.toString();
    }

    public static String conCenter(String dom) {
        return DomHelper.conCenter(dom, null);
    }

    public static String conCenter(String dom, String addClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"concenter");
        if (addClass != null) {
            sb.append(" ").append(addClass);
        }
        sb.append("\">").append(dom).append("</div>");
        return sb.toString();
    }

    public static String conPage(String inner) {
        return "<div class=\"container conpage\">" + inner + "</div>";
    }

    public static String divider() {
        return DomHelper.divider(null);
    }

    public static String divider(String addClass) {
        if (addClass == null) {
            return "<div class=\"divider\"></div>";
        }
        return "<div class=\"divider " + addClass + "\"></div>";
    }
}

