/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.dom;

public class DomTable {
    private StringBuilder builder = new StringBuilder();
    private int curRowNum = 0;
    private int curColNum = 0;
    private int totalColNum = 0;
    private boolean finished = false;
    private String rowID;
    private String cellID;
    private String rowClass;

    public DomTable(String[] header) {
        this.totalColNum = header.length;
        this.print("<table class=\"table\"><thead>");
        this.printHeader(header);
        this.print("</thead><tbody>");
    }

    public DomTable(HeadCell[] header) {
        this.totalColNum = header.length;
        this.print("<table class=\"table\"><thead>");
        this.printHeader(header);
        this.print("</thead><tbody>");
    }

    public DomTable(int colNum) {
        this.totalColNum = colNum;
        this.finished = false;
        this.print("<table class=\"table\"><tbody>");
    }

    public DomTable(String[] header, String addClass) {
        String addClassStr = addClass == null ? "" : " " + addClass;
        this.totalColNum = header.length;
        this.print("<table class=\"table" + addClassStr + "\"><thead>");
        this.printHeader(header);
        this.print("</thead><tbody>");
    }

    public DomTable(HeadCell[] header, String addClass) {
        String addClassStr = addClass == null ? "" : " " + addClass;
        this.totalColNum = header.length;
        this.print("<table class=\"table" + addClassStr + "\"><thead>");
        this.printHeader(header);
        this.print("</thead><tbody>");
    }

    public DomTable(int colNum, String addClass) {
        String addClassStr = addClass == null ? "" : " " + addClass;
        this.totalColNum = colNum;
        this.finished = false;
        this.print("<table class=\"table" + addClassStr + "\"><tbody>");
    }

    private void print(String domStr) {
        this.builder.append(domStr);
    }

    private void printHeader(String[] header) {
        for (int i = 0; i < header.length; ++i) {
            this.print("<th>");
            this.print(header[i]);
            this.print("</th>");
        }
    }

    private void printHeader(HeadCell[] header) {
        for (int i = 0; i < header.length; ++i) {
            this.print("<th");
            if (header[i].className != null) {
                this.print(" class=\"" + header[i].className + "\"");
            }
            this.print(">");
            this.print(header[i].innerDom);
            this.print("</th>");
        }
    }

    public String finish() {
        if (!this.finished) {
            while (this.curColNum != 0) {
                int echoCnt = this.totalColNum - this.curColNum;
                for (int i = 0; i < echoCnt; ++i) {
                    this.print("<td></td>");
                }
                ++this.curRowNum;
                this.curColNum = 0;
            }
            this.print("</tr></tbody></table>");
            this.finished = true;
        }
        return this.builder.toString();
    }

    public DomTable setRowID(String id) {
        this.rowID = id;
        return this;
    }

    public DomTable setCellID(String id) {
        this.cellID = id;
        return this;
    }

    public DomTable setRowClass(String cssClass) {
        this.rowClass = cssClass;
        return this;
    }

    public DomTable addCell(String innerDom) {
        return this.addCell(innerDom, null);
    }

    public DomTable addCell(String innerDom, String className) {
        if (this.finished) {
            return this;
        }
        if (this.curColNum == 0) {
            StringBuilder sb = new StringBuilder();
            if (this.curRowNum != 0) {
                sb.append("</tr>");
            }
            sb.append("<tr");
            if (this.rowID != null) {
                sb.append(" id=\"").append(this.rowID).append("\"");
                this.rowID = null;
            }
            if (this.rowClass != null) {
                sb.append(" class=\"").append(this.rowClass).append("\"");
                this.rowClass = null;
            }
            sb.append(">");
            this.print(sb.toString());
        }
        this.print("<td");
        if (this.cellID != null) {
            this.print(" id=\"");
            this.print(this.cellID);
            this.print("\"");
            this.cellID = null;
        }
        if (className != null) {
            this.print(" class=\"");
            this.print(className);
            this.print("\"");
        }
        this.print(">");
        this.print(innerDom);
        this.print("</td>");
        if (this.curColNum + 1 >= this.totalColNum) {
            ++this.curRowNum;
            this.curColNum = 0;
        } else {
            ++this.curColNum;
        }
        return this;
    }

    public static class HeadCell {
        private String innerDom;
        private String className;

        public HeadCell(String innerDom, String className) {
            this.innerDom = innerDom;
            this.className = className;
        }
    }
}

