/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.logic;

import com.modnut.framework2.database.DBCreator;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBHelper;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.database.DBValPair;
import com.modnut.framework2.json.JSONObject;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.framework2.tool.ToolArr;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformApp;
import com.modnut.platform2.ajax.AjaxCmdUserBase;
import com.modnut.platform2.ajax.AjaxCmdUserException;
import com.modnut.platform2.logic.LogicCommon;
import com.modnut.platform2.resource.ResPlatform;
import java.util.ArrayList;

public class LogicEdit {
    public static final String PARAM_DEL = "del";
    public static final String RTN_PACK_DATA = "data";

    public static abstract class EditSolver {
        protected final EditCore core;

        public EditSolver(EditCore core) {
            this.core = core;
        }

        public EditSolver(DBCreator.DBTable table, String[] colNames, String[] colParams) {
            this.core = new EditCore(table, colNames, colParams);
        }

        public EditSolver(String tbName, String[] colNames, String[] colParams) {
            this.core = EditCore.get(tbName, colNames, colParams);
        }

        public EditSolver(PlatformApp.AppObj app, String tbName, String[] colNames, String[] colParams) {
            this.core = EditCore.get(app, tbName, colNames, colParams);
        }

        public void process(AjaxCmdUserBase ajax, DBStat stat) throws DBException, AjaxCmdUserException {
            this.process(ajax, stat, null);
        }

        public void process(AjaxCmdUserBase ajax, DBStat stat, String name) throws DBException, AjaxCmdUserException {
            ResServlet res = ajax.getRes();
            if (this.core == null) {
                throw new AjaxCmdUserException(-1, this.getFailedText((ResPlatform)res, null));
            }
            String pkValue = ToolStr.emptyToNull((String)res.getParam(this.core.pkParam), (boolean)true);
            if (res.hasParam(LogicEdit.PARAM_DEL)) {
                this.doPreCheck((ResPlatform)res, stat, EditType.DEL);
                String delWhereStr = this.core.pkColumn + "=" + DBHelper.formatSqlStr((DBStat)stat, (String)pkValue) + DBHelper.andWhereStr((DBStat)stat, (String)this.getWhereStr((ResPlatform)res, stat, EditType.DEL));
                if (DBHelper.delete((DBStat)stat, (String)this.core.tbName, (String)delWhereStr) <= 0) {
                    throw new AjaxCmdUserException(-1, this.getFailedText((ResPlatform)res, EditType.DEL));
                }
            } else if (pkValue == null) {
                this.doPreCheck((ResPlatform)res, stat, EditType.ADD);
                ArrayList<DBValPair> addValues = new ArrayList<DBValPair>();
                this.addInitValues((ResPlatform)res, stat, EditType.ADD, addValues);
                addValues.add(new DBValPair(this.core.pkColumn, this.getNewPk(ajax, stat)));
                this.addParamValues((ResPlatform)res, addValues, EditType.ADD);
                if (DBHelper.insert((DBStat)stat, (String)this.core.tbName, (DBValPair[])addValues.toArray(new DBValPair[addValues.size()])) <= 0) {
                    throw new AjaxCmdUserException(-1, this.getFailedText((ResPlatform)res, EditType.ADD));
                }
                this.putRtnData(ajax, addValues, name, EditType.ADD);
            } else {
                this.doPreCheck((ResPlatform)res, stat, EditType.EDIT);
                ArrayList<DBValPair> editValues = new ArrayList<DBValPair>();
                this.addInitValues((ResPlatform)res, stat, EditType.EDIT, editValues);
                this.addParamValues((ResPlatform)res, editValues, EditType.EDIT);
                String editWhereStr = this.core.pkColumn + "=" + DBHelper.formatSqlStr((DBStat)stat, (String)pkValue) + DBHelper.andWhereStr((DBStat)stat, (String)this.getWhereStr((ResPlatform)res, stat, EditType.EDIT));
                if (DBHelper.update((DBStat)stat, (String)this.core.tbName, (DBValPair[])editValues.toArray(new DBValPair[editValues.size()]), (String)editWhereStr) <= 0) {
                    throw new AjaxCmdUserException(-1, this.getFailedText((ResPlatform)res, EditType.EDIT));
                }
                this.putRtnData(ajax, editValues, name, EditType.EDIT);
            }
        }

        protected String getNewPk(AjaxCmdUserBase ajax, DBStat stat) throws DBException, AjaxCmdUserException {
            return ToolStr.timeUUID();
        }

        private void addParamValues(ResPlatform res, ArrayList<DBValPair> values, EditType type) {
            Object[] limitParams = null;
            if (type == EditType.ADD) {
                limitParams = this.getAddParams();
            } else if (type == EditType.EDIT) {
                limitParams = this.getEditParams();
            }
            for (int i = 0; i < this.core.params.length; ++i) {
                String param = this.core.params[i];
                if (param == null || param.equals(this.core.pkParam) || limitParams != null && !ToolArr.contain((Object[])limitParams, (Object)param)) continue;
                DBCreator.DBColumn column = this.core.columns[i];
                values.add(new DBValPair(column.name, LogicCommon.getPairValue(res, param, column)));
            }
        }

        private void putRtnData(AjaxCmdUserBase ajax, ArrayList<DBValPair> values, String name, EditType type) {
            JSONObject data = new JSONObject();
            for (DBValPair value : values) {
                String param = this.core.getParamByColName(value.getColName());
                if (param == null) continue;
                data.put(param, LogicCommon.getAjaxValue(value));
            }
            this.putMoreData(ajax, (ResPlatform)ajax.getRes(), data, type);
            ajax.put(name == null ? LogicEdit.RTN_PACK_DATA : name, data);
        }

        protected void putMoreData(AjaxCmdUserBase ajax, ResPlatform res, JSONObject data, EditType type) {
        }

        protected void doPreCheck(ResPlatform res, DBStat stat, EditType type) throws DBException, AjaxCmdUserException {
        }

        protected void addInitValues(ResPlatform res, DBStat stat, EditType type, ArrayList<DBValPair> values) throws DBException, AjaxCmdUserException {
        }

        protected String getWhereStr(ResPlatform res, DBStat stat, EditType type) throws DBException, AjaxCmdUserException {
            return null;
        }

        protected String[] getAddParams() {
            return null;
        }

        protected String[] getEditParams() {
            return null;
        }

        protected String getFailedText(ResPlatform res, EditType type) throws DBException, AjaxCmdUserException {
            if (type != null) {
                switch (type) {
                    case ADD: {
                        return res.getLangStr("LOGIC_ADD_FAILED");
                    }
                    case EDIT: {
                        return res.getLangStr("LOGIC_EDIT_FAILED");
                    }
                    case DEL: {
                        return res.getLangStr("LOGIC_DEL_FAILED");
                    }
                }
            }
            return res.getLangStr("LOGIC_ERROR");
        }
    }

    public static class EditCore {
        protected final String tbName;
        protected final DBCreator.DBColumn[] columns;
        protected final String pkColumn;
        protected String[] params;
        protected String pkParam;

        public EditCore(DBCreator.DBTable table, String[] colNames, String[] colParams) {
            this.tbName = table.name;
            this.columns = table.columns.toArray(new DBCreator.DBColumn[table.columns.size()]);
            this.pkColumn = table.pkColNames != null && !table.pkColNames.isEmpty() ? (String)table.pkColNames.get(0) : null;
            ArrayList<String> paramList = new ArrayList<String>();
            for (DBCreator.DBColumn column : table.columns) {
                String colParam = null;
                for (int i = 0; i < colNames.length && i < colParams.length; ++i) {
                    if (ToolStr.equals((String)column.name, (String)colNames[i])) {
                        colParam = colParams[i];
                    }
                    if (this.pkParam != null || this.pkColumn == null || !ToolStr.equals((String)column.name, (String)this.pkColumn)) continue;
                    this.pkParam = colParams[i];
                }
                paramList.add(colParam);
            }
            this.params = paramList.toArray(new String[paramList.size()]);
        }

        public DBCreator.DBColumn getColumnByParam(String param) {
            if (param != null) {
                for (int i = 0; i < this.params.length; ++i) {
                    if (!param.equals(this.params[i])) continue;
                    return this.columns[i];
                }
            }
            return null;
        }

        public String getParamByColName(String colName) {
            if (colName != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    if (!colName.equals(this.columns[i].name)) continue;
                    return this.params[i];
                }
            }
            return null;
        }

        public static EditCore get(String tbName, String[] colNames, String[] colParams) {
            ArrayList<PlatformApp.AppObj> apps = PlatformApp.getAppList();
            for (PlatformApp.AppObj app : apps) {
                EditCore core = EditCore.get(app, tbName, colNames, colParams);
                if (core == null) continue;
                return core;
            }
            return null;
        }

        public static EditCore get(PlatformApp.AppObj app, String tbName, String[] colNames, String[] colParams) {
            DBCreator.DBTable[] tables = app.getAppTables();
            if (tables != null) {
                for (DBCreator.DBTable table : tables) {
                    if (!ToolStr.equals((String)tbName, (String)table.name)) continue;
                    return new EditCore(table, colNames, colParams);
                }
            }
            return null;
        }
    }

    public static enum EditType {
        ADD,
        EDIT,
        DEL;

    }
}

