/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.logic;

import com.modnut.framework2.constant.ConstFramework;
import com.modnut.framework2.json.JSONException;
import com.modnut.framework2.json.JSONObject;
import com.modnut.framework2.tool.ToolDate;
import com.modnut.framework2.tool.ToolHttp;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformUser;
import java.nio.charset.Charset;
import java.util.HashMap;

public class LogicRemote {
    public static final String PARAM_RACCOUNT = "raccount";
    public static final String PARAM_RPASSWORD = "rpassword";
    public static final String PARAM_RTIMESTAMP = "rtimestamp";
    public static final String PARAM_RSIGN = "rsign";
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_FAILED = -1;
    public static final long RANGE_MS = 300000L;

    public static JSONObject call(String urlStr, HashMap<String, String> paramMap, String account, String password) throws RemoteException {
        return LogicRemote.call(urlStr, paramMap, account, password, ConstFramework.getCharset(), 0);
    }

    public static JSONObject call(String urlStr, HashMap<String, String> paramMap, String account, String password, Charset charset) throws RemoteException {
        return LogicRemote.call(urlStr, paramMap, account, password, charset, 0);
    }

    public static JSONObject call(String urlStr, HashMap<String, String> paramMap, String account, String password, int timeout) throws RemoteException {
        return LogicRemote.call(urlStr, paramMap, account, password, ConstFramework.getCharset(), timeout);
    }

    public static JSONObject call(String urlStr, HashMap<String, String> paramMap, String account, String password, Charset charset, int timeout) throws RemoteException {
        if (paramMap == null) {
            paramMap = new HashMap();
        }
        long timestamp = ToolDate.now();
        paramMap.put(PARAM_RACCOUNT, account);
        paramMap.put(PARAM_RTIMESTAMP, Long.toString(timestamp));
        paramMap.put(PARAM_RSIGN, LogicRemote.genSign(account, password, timestamp));
        ToolHttp.HttpResponse response = ToolHttp.post((String)urlStr, paramMap, (Charset)charset, (int)timeout);
        if (response.code == 200) {
            try {
                JSONObject json = new JSONObject(response.text, true);
                int code = json.getInteger("code");
                if (code == 0) {
                    return json;
                }
                throw new RemoteException(code, json.getString("msg"), json);
            }
            catch (JSONException ex) {
                throw new RemoteException(-1, ex.getMessage(), null);
            }
        }
        if (response.code == -1) {
            throw new RemoteException(-1, response.ex.getMessage(), null);
        }
        throw new RemoteException(-1, "http error : " + response.code, null);
    }

    public static JSONObject call(String server, String app, String ajax, HashMap<String, String> paramMap, String account, String password) throws RemoteException {
        String urlStr = server;
        if (!urlStr.toLowerCase().startsWith("http://")) {
            urlStr = "http://" + server;
        }
        if (!urlStr.endsWith("/")) {
            urlStr = urlStr + "/";
        }
        if (app != null) {
            urlStr = urlStr + app.replace('.', '/') + "/";
        }
        if (ajax != null) {
            urlStr = urlStr + "cmd/" + ajax;
        }
        return LogicRemote.call(urlStr, paramMap, account, password);
    }

    public static boolean allowTimestamp(long timestamp) {
        long now = ToolDate.now();
        return now - 300000L <= timestamp && timestamp <= now + 300000L;
    }

    public static String genSign(String account, String password, long timestamp) {
        return ToolStr.MD5((String)(account + "\n" + PlatformUser.createPasswordHash(password) + "\n" + timestamp));
    }

    public static class RemoteException
    extends Exception {
        public int code;
        public String msg;
        public JSONObject json;

        public RemoteException(int code, String msg, JSONObject json) {
            this.code = code;
            this.msg = msg;
            this.json = json;
        }
    }
}

