/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.page;

import com.modnut.framework2.constant.ConstUrlBase;
import com.modnut.framework2.tool.ToolFile;
import com.modnut.framework2.tool.ToolStr;
import com.modnut.platform2.PlatformApp;
import com.modnut.platform2.PlatformParam;
import com.modnut.platform2.dom.DomInfo;
import com.modnut.platform2.page.PageUserBase;
import com.modnut.platform2.resource.ResPlatform;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PageAppBase
extends PageUserBase {
    private final PlatformApp.AppObj app;
    private final ConstUrlBase url;
    private final String prefixCode;
    private final ArrayList<String> cssFiles;
    private final ArrayList<String> jsFiles;

    public PageAppBase(PlatformApp.AppObj app, ConstUrlBase url) {
        this(app, url, null, false);
    }

    public PageAppBase(PlatformApp.AppObj app, ConstUrlBase url, boolean langJs) {
        this(app, url, null, langJs);
    }

    public PageAppBase(PlatformApp.AppObj app, ConstUrlBase url, String[] resources) {
        this(app, url, resources, false);
    }

    public PageAppBase(PlatformApp.AppObj app, ConstUrlBase url, String[] resources, boolean langJs) {
        this.app = app;
        this.url = url;
        String appCode = app.getAppCode();
        int lastIndex = appCode.lastIndexOf(46);
        this.prefixCode = lastIndex >= 0 ? appCode.substring(lastIndex + 1) : appCode;
        this.cssFiles = new ArrayList();
        this.jsFiles = new ArrayList();
        if (resources != null) {
            for (String resource : resources) {
                if (resource == null) continue;
                String fileExt = ToolStr.nullToEmpty((String)ToolFile.getFileExt((String)resource)).toLowerCase();
                if ("css".equals(fileExt)) {
                    this.cssFiles.add(resource);
                }
                if (!"js".equals(fileExt)) continue;
                this.jsFiles.add(resource);
            }
        }
        if (langJs) {
            this.jsFiles.add("lang.js");
        }
        this.cssFiles.add(this.prefixCode + ".css");
        this.jsFiles.add(this.prefixCode + ".js");
    }

    @Override
    public void doInit() {
        super.doInit();
        this.addMoreCss(this.cssFiles);
        this.addMoreJs(this.jsFiles);
        for (String cssFile : this.cssFiles) {
            if (PageAppBase.isRelative(cssFile)) {
                this.addCssFile(this.url, cssFile);
                continue;
            }
            this.addCssFile(cssFile);
        }
        for (String jsFile : this.jsFiles) {
            if (PageAppBase.isRelative(jsFile)) {
                this.addJsFile(this.url, jsFile);
                continue;
            }
            this.addJsFile(jsFile);
        }
    }

    private static boolean isRelative(String resPath) {
        if (resPath != null) {
            if (resPath.toLowerCase().startsWith("http://")) {
                return false;
            }
            if (resPath.startsWith("/")) {
                return false;
            }
        }
        return true;
    }

    public String getPageTitle() {
        return this.app.getAppName((ResPlatform)this.getRes()) + " - " + PlatformParam.getWebsite((ResPlatform)this.getRes());
    }

    @Override
    protected void printMain(PrintWriter out) {
        out.print("<div class=\"" + this.prefixCode + "-wrap\"></div>");
        DomInfo.userAppContext(this.url, out);
        DomInfo.userAppAuth((ResPlatform)this.getRes(), this.app, out);
    }

    public PlatformApp.AppObj getApp() {
        return this.app;
    }

    public ConstUrlBase getUrl() {
        return this.url;
    }

    public String getPrefixCode() {
        return this.prefixCode;
    }

    protected void addMoreCss(ArrayList<String> cssFiles) {
    }

    protected void addMoreJs(ArrayList<String> jsFiles) {
    }
}

