/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.resource;

import com.modnut.framework2.database.DBConn;
import com.modnut.framework2.database.DBException;
import com.modnut.framework2.database.DBStat;
import com.modnut.framework2.lang.LangMap;
import com.modnut.framework2.resource.ResPack;
import com.modnut.framework2.resource.ResServlet;
import com.modnut.platform2.PlatformDB;
import com.modnut.platform2.PlatformUser;
import com.modnut.platform2.cache.CacheUser;
import com.modnut.platform2.cache.CacheUserAuth;
import com.modnut.platform2.lang.PlatformLang;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResPlatform
extends ResServlet {
    public static final String SESSION_USER = "user";
    public static final String SESSION_CAPTCHA = "captcha";
    private String user;
    private CacheUser.UserObj userObj;
    private ArrayList<String> userAuth;
    private Boolean userAdmin;
    private LangMap platformLangMap = null;

    public ResPlatform(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public LangMap getLangMap() {
        if (this.platformLangMap == null) {
            this.platformLangMap = PlatformLang.i.map(this.getLocales());
        }
        return this.platformLangMap;
    }

    public String getLangStr(String key) {
        return this.getLangMap().get(key);
    }

    protected String getSessionMemName() {
        return "session";
    }

    public String getCaptcha() {
        return this.getSession(SESSION_CAPTCHA);
    }

    protected String getMemcacheSessionCookiePath() {
        return "/";
    }

    public boolean matchCaptcha(String captcha) {
        String serverCaptcha = this.getCaptcha();
        this.removeSession(SESSION_CAPTCHA);
        if (serverCaptcha == null || captcha == null) {
            return false;
        }
        return serverCaptcha.toLowerCase().equals(captcha.toLowerCase());
    }

    public void setUser(String loginUser) {
        this.user = loginUser;
    }

    public String getUser() {
        if (this.user == null) {
            this.user = this.getSession(SESSION_USER);
            if (this.user == null) {
                this.user = PlatformUser.getRemUser(this);
                if (this.user != null) {
                    this.setSession(SESSION_USER, this.user);
                }
            }
        }
        return this.user;
    }

    public CacheUser.UserObj getUserObj() {
        if (this.userObj == null) {
            this.userObj = (CacheUser.UserObj)CacheUser.i.get((ResPack)this, this.getUser());
        }
        return this.userObj;
    }

    public ArrayList<String> getUserAuth() {
        if (this.userAuth == null) {
            this.userAuth = (ArrayList)CacheUserAuth.i.get((ResPack)this, this.getUser());
        }
        return this.userAuth;
    }

    public boolean getUserAdmin() {
        if (this.userAdmin == null) {
            this.userAdmin = this.getUserAuth().contains("platform.admin");
        }
        return this.userAdmin;
    }

    public boolean hasAuth(String auth) {
        return this.getUserAdmin() || this.getUserAuth().contains(auth);
    }

    public boolean hasLogined() {
        return this.getUser() != null;
    }

    public DBStat getDBStat() throws DBException {
        return this.getDBStat(PlatformDB.NAME);
    }

    public DBConn getDBConn() throws DBException {
        return this.getDBConn(PlatformDB.NAME);
    }
}

