/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.servlet;

import com.modnut.framework2.page.PageBase;
import com.modnut.framework2.servlet.ServletBase;
import com.modnut.framework2.servlet.ServletPageSolver;
import com.modnut.framework2.servlet.ServletSolver;
import com.modnut.platform2.PlatformParam;
import com.modnut.platform2.PlatformUrl;
import com.modnut.platform2.dom.DomHelper;
import com.modnut.platform2.resource.ResPlatform;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletErrorBase
extends ServletBase<ResPlatform> {
    public static final String DEFAULT_URL = "/error";
    public static final String URL_PATTERN = "/*";
    public static final String PATTERN_403 = "/403";
    public static final String PATTERN_404 = "/404";
    public static final String PATTERN_500 = "/500";

    protected String getErrorTitle(ResPlatform res, String pathInfo) {
        return null;
    }

    protected String getErrorContent(ResPlatform res, String pathInfo) {
        return null;
    }

    protected ResPlatform createRes(HttpServletRequest request, HttpServletResponse response) {
        return new ResPlatform(request, response);
    }

    protected ServletSolver getSolver(ResPlatform res) {
        return new ServletPageSolver<ResPlatform>(res){

            protected PageBase getPage() {
                String pathInfo = ((ResPlatform)this.getRes()).getPathInfo();
                String errorTitle = ServletErrorBase.this.getErrorTitle((ResPlatform)this.getRes(), pathInfo);
                String errorContent = ServletErrorBase.this.getErrorContent((ResPlatform)this.getRes(), pathInfo);
                if (errorTitle != null || errorContent != null) {
                    return new PageError(errorTitle, errorContent);
                }
                if (ServletErrorBase.PATTERN_403.equals(pathInfo)) {
                    String title403 = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_403_TITLE");
                    String content403 = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_403_CONTENT");
                    return new PageError(title403, content403);
                }
                if (ServletErrorBase.PATTERN_404.equals(pathInfo)) {
                    String title404 = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_404_TITLE");
                    String content404 = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_404_CONTENT");
                    return new PageError(title404, content404);
                }
                if (ServletErrorBase.PATTERN_500.equals(pathInfo)) {
                    String title500 = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_500_TITLE");
                    String content500 = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_500_CONTENT");
                    return new PageError(title500, content500);
                }
                String titleError = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_OTHER_TITLE");
                String contentError = ((ResPlatform)this.getRes()).getLangStr("PAGE_ERROR_OTHER_CONTENT");
                return new PageError(titleError, contentError);
            }
        };
    }

    public static class PageError
    extends PageBase<ResPlatform> {
        String title;
        String content;

        public PageError(String title, String content) {
            this.title = title;
            this.content = content;
        }

        protected boolean setViewPort() {
            return true;
        }

        public String getPageTitle() {
            String titleStr = this.title == null ? "" : this.title + " - ";
            return titleStr + PlatformParam.getWebsite((ResPlatform)this.getRes());
        }

        public void doInit() {
            super.doInit();
            this.addCssFile(PlatformUrl.i.getCssMain());
            this.addJsFile(PlatformUrl.i.getJsLibrary());
            this.addJsFile(PlatformUrl.i.getJsPlatform());
        }

        public void printPageBody(PrintWriter out) {
            out.print("<div class=\"container conpage\">");
            out.print("<div class=\"concenter\">");
            if (this.title != null) {
                out.print("<h2>" + this.title + "</h2>");
            }
            if (this.content != null) {
                out.print("<p>" + this.content + "</p>");
            }
            String textBackHome = ((ResPlatform)this.getRes()).getLangStr("BACK_HOME");
            out.print("<p>" + DomHelper.link(PlatformUrl.i.getBaseUrl(), textBackHome) + "</p>");
            out.print("</div>");
            out.print("</div>");
        }
    }
}

