/*
 * Decompiled with CFR 0.152.
 */
package com.modnut.platform2.servlet;

import com.modnut.framework2.constant.ConstUrlBase;
import com.modnut.framework2.page.PageBase;
import com.modnut.framework2.servlet.ServletBase;
import com.modnut.framework2.servlet.ServletPageSolver;
import com.modnut.platform2.PlatformApp;
import com.modnut.platform2.PlatformUrl;
import com.modnut.platform2.daemon.DaemonCheckBase;
import com.modnut.platform2.page.PageAppBase;
import com.modnut.platform2.resource.ResPlatform;
import com.modnut.platform2.servlet.ServletErrorBase;
import java.io.PrintWriter;
import javax.servlet.ServletException;

public abstract class ServletUserResBase<RC extends ResPlatform>
extends ServletBase<RC> {

    protected static class ServletPageAppSolver<RC extends ResPlatform>
    extends ServletPageUserSolver<RC> {
        private final PlatformApp.AppObj app;
        private final ConstUrlBase url;
        private final String[] resources;
        private final boolean langJs;

        public ServletPageAppSolver(RC res, PlatformApp.AppObj app, ConstUrlBase url, String[] resources, boolean langJs) {
            super(res);
            this.app = app;
            this.url = url;
            this.resources = resources;
            this.langJs = langJs;
        }

        public ServletPageAppSolver(RC res, PlatformApp.AppObj app, ConstUrlBase url, String[] resources, boolean langJs, String needAuth, DaemonCheckBase daemonCheck) {
            super(res, needAuth, daemonCheck);
            this.app = app;
            this.url = url;
            this.resources = resources;
            this.langJs = langJs;
        }

        @Override
        protected PageBase getUserPage() throws ServletPageUserSolver.ServletUserException {
            return new PageAppBase(this.app, this.url, this.resources, this.langJs){

                @Override
                public void doInit() {
                    super.doInit();
                    ServletPageAppSolver.this.doPageInit(this);
                }

                public void doDispose() {
                    super.doDispose();
                    ServletPageAppSolver.this.doPageDispose(this);
                }

                @Override
                protected void printAddonHeadDom(PrintWriter out) {
                    super.printAddonHeadDom(out);
                    ServletPageAppSolver.this.printPageAddonHeadDom(out);
                }

                protected void printAddonBodyDom(PrintWriter out) {
                    super.printAddonBodyDom(out);
                    ServletPageAppSolver.this.printPageAddonBodyDom(out);
                }
            };
        }

        protected void doPageInit(PageBase page) {
        }

        protected void doPageDispose(PageBase page) {
        }

        protected void printPageAddonHeadDom(PrintWriter out) {
        }

        protected void printPageAddonBodyDom(PrintWriter out) {
        }
    }

    protected static abstract class ServletPageUserSolver<RC extends ResPlatform>
    extends ServletPageSolver<RC> {
        private final String innerNeedAuth;
        private final DaemonCheckBase innerDaemonCheck;

        public ServletPageUserSolver(RC res) {
            super(res);
            this.innerNeedAuth = null;
            this.innerDaemonCheck = null;
        }

        public ServletPageUserSolver(RC res, String needAuth, DaemonCheckBase daemonCheck) {
            super(res);
            this.innerNeedAuth = needAuth;
            this.innerDaemonCheck = daemonCheck;
        }

        public void doInit() throws ServletException {
            super.doInit();
            if (this.getNeedLogin() && !((ResPlatform)this.getRes()).hasLogined()) {
                throw new ServletNotLoginedException();
            }
        }

        public void doException(ServletException ex) throws ServletException {
            if (ex instanceof ServletNotLoginedException) {
                String reffer = ((ResPlatform)this.getRes()).getRequest().getRequestURL().toString();
                ((ResPlatform)this.getRes()).sendRedirect(PlatformUrl.i.getLoginUrl(reffer));
            } else {
                super.doException(ex);
            }
        }

        protected PageBase getPage() {
            try {
                this.doCheck();
                return this.getUserPage();
            }
            catch (ServletUserException ex) {
                return new ServletErrorBase.PageError(ex.title, ex.content);
            }
        }

        protected abstract PageBase getUserPage() throws ServletUserException;

        protected boolean getNeedLogin() {
            return true;
        }

        protected String getNeedAuth() {
            return this.innerNeedAuth;
        }

        protected DaemonCheckBase getDaemonCheck() {
            return this.innerDaemonCheck;
        }

        protected void doCheck() throws ServletUserException {
            String error;
            String needAuth = this.getNeedAuth();
            if (needAuth != null && !((ResPlatform)this.getRes()).hasAuth(needAuth)) {
                String textNoAuth = ((ResPlatform)this.getRes()).getLangStr("TEXT_NO_AUTH");
                String textNoAuthAddon = ((ResPlatform)this.getRes()).getLangStr("TEXT_NO_AUTH_ADDON");
                throw new ServletUserException(textNoAuth, textNoAuth + textNoAuthAddon);
            }
            DaemonCheckBase daemonCheck = this.getDaemonCheck();
            if (daemonCheck != null && (error = daemonCheck.getResult((ResPlatform)this.getRes())) != null) {
                String textProgramLock = ((ResPlatform)this.getRes()).getLangStr("TEXT_PROGRAM_LOCK");
                throw new ServletUserException(textProgramLock, textProgramLock + ((ResPlatform)this.getRes()).getLangStr("COMMON_COMMA") + error);
            }
        }

        protected static final class ServletUserException
        extends ServletException {
            public String title;
            public String content;

            public ServletUserException(String title, String content) {
                this.title = title;
                this.content = content;
            }
        }

        protected static final class ServletNotLoginedException
        extends ServletException {
            protected ServletNotLoginedException() {
            }
        }
    }
}

