/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserException;
import com.teamdev.jxbrowser.chromium.BrowserKeyEvent;
import com.teamdev.jxbrowser.chromium.BrowserMouseEvent;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.CacheStorage;
import com.teamdev.jxbrowser.chromium.Callback;
import com.teamdev.jxbrowser.chromium.ContextMenu;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.ContextMenuParams;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DownloadHandler;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.FullScreenHandler;
import com.teamdev.jxbrowser.chromium.JSContext;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.LoadDataParams;
import com.teamdev.jxbrowser.chromium.LoadHTMLParams;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadParams;
import com.teamdev.jxbrowser.chromium.LoadURLParams;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MediaStreamDevice;
import com.teamdev.jxbrowser.chromium.MediaStreamDeviceManager;
import com.teamdev.jxbrowser.chromium.MediaStreamDeviceRequest;
import com.teamdev.jxbrowser.chromium.MediaStreamType;
import com.teamdev.jxbrowser.chromium.MediaType;
import com.teamdev.jxbrowser.chromium.NavigationEntry;
import com.teamdev.jxbrowser.chromium.PermissionHandler;
import com.teamdev.jxbrowser.chromium.PermissionType;
import com.teamdev.jxbrowser.chromium.PluginFilter;
import com.teamdev.jxbrowser.chromium.PluginInfo;
import com.teamdev.jxbrowser.chromium.PluginManager;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.PrintHandler;
import com.teamdev.jxbrowser.chromium.PrintJob;
import com.teamdev.jxbrowser.chromium.RenderProcessInfo;
import com.teamdev.jxbrowser.chromium.SavePageType;
import com.teamdev.jxbrowser.chromium.SearchParams;
import com.teamdev.jxbrowser.chromium.SearchResult;
import com.teamdev.jxbrowser.chromium.SpellCheckCompletedParams;
import com.teamdev.jxbrowser.chromium.SpellCheckResult;
import com.teamdev.jxbrowser.chromium.StopFindAction;
import com.teamdev.jxbrowser.chromium.StorageType;
import com.teamdev.jxbrowser.chromium.TerminationStatus;
import com.teamdev.jxbrowser.chromium.WebRTCIPHandlingPolicy;
import com.teamdev.jxbrowser.chromium.WebStorage;
import com.teamdev.jxbrowser.chromium.aa;
import com.teamdev.jxbrowser.chromium.ab;
import com.teamdev.jxbrowser.chromium.ac;
import com.teamdev.jxbrowser.chromium.ad;
import com.teamdev.jxbrowser.chromium.ae;
import com.teamdev.jxbrowser.chromium.af;
import com.teamdev.jxbrowser.chromium.ag;
import com.teamdev.jxbrowser.chromium.ah;
import com.teamdev.jxbrowser.chromium.ai;
import com.teamdev.jxbrowser.chromium.aj;
import com.teamdev.jxbrowser.chromium.al;
import com.teamdev.jxbrowser.chromium.ao;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMFactory;
import com.teamdev.jxbrowser.chromium.dom.internal.Document;
import com.teamdev.jxbrowser.chromium.events.ConsoleEvent;
import com.teamdev.jxbrowser.chromium.events.ConsoleListener;
import com.teamdev.jxbrowser.chromium.events.DisposeEvent;
import com.teamdev.jxbrowser.chromium.events.DisposeListener;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.events.PrintJobEvent;
import com.teamdev.jxbrowser.chromium.events.PrintJobListener;
import com.teamdev.jxbrowser.chromium.events.ProvisionalLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.RenderEvent;
import com.teamdev.jxbrowser.chromium.events.RenderListener;
import com.teamdev.jxbrowser.chromium.events.ScriptContextEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextListener;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.StatusEvent;
import com.teamdev.jxbrowser.chromium.events.StatusListener;
import com.teamdev.jxbrowser.chromium.events.TitleEvent;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import com.teamdev.jxbrowser.chromium.f;
import com.teamdev.jxbrowser.chromium.g;
import com.teamdev.jxbrowser.chromium.h;
import com.teamdev.jxbrowser.chromium.i;
import com.teamdev.jxbrowser.chromium.internal.CacheStorageDelegate;
import com.teamdev.jxbrowser.chromium.internal.ChannelCacheStorage;
import com.teamdev.jxbrowser.chromium.internal.ChannelCookieStorage;
import com.teamdev.jxbrowser.chromium.internal.ChannelWebStorage;
import com.teamdev.jxbrowser.chromium.internal.ChromiumProfileLock;
import com.teamdev.jxbrowser.chromium.internal.DialogHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.EventQueue;
import com.teamdev.jxbrowser.chromium.internal.MediaStreamDeviceParser;
import com.teamdev.jxbrowser.chromium.internal.MutableDownloadItem;
import com.teamdev.jxbrowser.chromium.internal.PluginInfoParser;
import com.teamdev.jxbrowser.chromium.internal.PluginManagerImpl;
import com.teamdev.jxbrowser.chromium.internal.ProxyParams;
import com.teamdev.jxbrowser.chromium.internal.SearchCompleteCallback;
import com.teamdev.jxbrowser.chromium.internal.SearchRequestIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.WebStorageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.AddWordToDictionaryMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.AllowCertificateErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.BeforeDisposeBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoToOffsetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ClearWebCacheMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CreateBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DisposeBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteCommandMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteJavaScriptMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FindTextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardKeyboardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseWheelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FrameSetBoundsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetCurrentEntryIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetDocumentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetEntryCountMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetEntryMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetFramesIdsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetHTMLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeAtPointMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetRemoteDebuggingURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetRenderProcessInfoMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetSelectedHTMLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetSelectedTextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetTitleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetWebPreferencesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoToIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoToOffsetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsAudioMutedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsAudioPlayingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsCommandEnabledMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsFrameExistsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsLoadingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadDataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAddNewContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAllowCertificateErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeDownloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnConsoleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidCommitProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidCreateScriptContextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailProvisionalLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFinishLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidRemoveScriptContextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidStartProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentAvailableInMainFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentLoadedInFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetCSSMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetDefaultMediaStreamDeviceMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHandleLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPrintingDoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderResponsiveMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewCreatedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewGoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPermissionMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPluginStateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPrintSettingsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunFileChooserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunJavaScriptDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSearchCompleteMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSelectClientCertificateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldCreateWebContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowColorDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowContextMenuMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSpellCheckCompletedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStatusChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTitleChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnToggleFullscreenModeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnWindowCloseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PageZoom;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PrintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadIgnoringCacheMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.RemoveEntryAtIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReplaceMisspelledWordMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SaveWebPageMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetAudioMutedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetBoundsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopFindingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.TestSandboxMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UpdateWebPreferencesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ZoomModeMessage;
import com.teamdev.jxbrowser.chromium.j;
import com.teamdev.jxbrowser.chromium.k;
import com.teamdev.jxbrowser.chromium.l;
import com.teamdev.jxbrowser.chromium.n;
import com.teamdev.jxbrowser.chromium.o;
import com.teamdev.jxbrowser.chromium.p;
import com.teamdev.jxbrowser.chromium.q;
import com.teamdev.jxbrowser.chromium.r;
import com.teamdev.jxbrowser.chromium.s;
import com.teamdev.jxbrowser.chromium.t;
import com.teamdev.jxbrowser.chromium.u;
import com.teamdev.jxbrowser.chromium.v;
import com.teamdev.jxbrowser.chromium.w;
import com.teamdev.jxbrowser.chromium.x;
import com.teamdev.jxbrowser.chromium.y;
import com.teamdev.jxbrowser.chromium.z;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public class Browser {
    public static final int MAIN_FRAME_ID = -1;
    public static final int FOCUSED_FRAME_ID = -2;
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final EventQueue b;
    private final Channel c;
    private final BrowserType d;
    private final CookieStorage e;
    private final BrowserContext f;
    private final PluginManagerImpl g;
    private final ChannelCacheStorage h;
    private final List<LoadListener> i;
    private final List<TitleListener> j;
    private final List<RenderListener> k;
    private final List<StatusListener> l;
    private final al m;
    private final List<ConsoleListener> n;
    private final DialogHandlerDelegate o;
    private final MediaStreamDeviceManager p;
    private final List<DisposeListener<Browser>> q;
    private final List<ScriptContextListener> r;
    private final Map<Integer, PrintJob> s;
    private final Map<Integer, SearchCompleteCallback> t;
    private final ChannelListener u;
    private final ChannelListener v;
    private final ChannelListener w;
    private final IPCChannelListener x;
    private int y;
    private Channel z;
    private String A;
    private Set<Long> B;
    private ChromiumProfileLock C;
    private LoadHandler D;
    private PopupHandler E;
    private PrintHandler F;
    private DownloadHandler G;
    private PermissionHandler H;
    private FullScreenHandler I;
    private PopupContainer J;
    private ContextMenuHandler K;

    public Browser() {
        this(BrowserContext.defaultContext());
    }

    /*
     * WARNING - void declaration
     */
    public Browser(BrowserContext browserContext) {
        this(BrowserType.getDefault(), (BrowserContext)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Browser(BrowserType browserType) {
        this((BrowserType)var1_1, BrowserContext.defaultContext());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Browser(BrowserType browserType, BrowserContext browserContext) {
        this((BrowserType)var1_1, (BrowserContext)var2_2, null, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Browser(BrowserType type, BrowserContext context, Channel channel, int renderProcessId) {
        void var2_2;
        void var3_3;
        String string;
        boolean bl;
        if (context == null) {
            throw new IllegalArgumentException("The browserContext cannot be null.");
        }
        this.d = type;
        this.f = context;
        this.B = new HashSet<Long>();
        this.v = new a(this, 0);
        this.A = "";
        this.y = renderProcessId;
        boolean bl2 = Boolean.getBoolean("jxbrowser.ipc.external");
        boolean bl3 = bl = type == BrowserType.HEAVYWEIGHT;
        if (Environment.isMac() && bl2 && bl) {
            throw new IllegalArgumentException("The 'jxbrowser.ipc.external' VM parameter is used. The HEAVYWEIGHT browser type isn't compatible with the VM parameter on Mac OS X. Use the LIGHTWEIGHT browser type instead.");
        }
        if (this.f.getStorageType() == StorageType.DISK) {
            long l2 = SharedMemoryLibrary.getInstance().getCurrentProcessId();
            this.C = new ChromiumProfileLock(context.getDataDir(), context.getIdentifier(), l2);
            if (this.C.isLocked()) {
                string = "The Chromium profile directory is already used/locked by another BrowserContext instance or process.";
                a.log(Level.SEVERE, string);
                throw new BrowserException(string);
            }
            this.f.c();
            this.C.lock();
        }
        context.a().start();
        context.d();
        context.a().getMainChannel().addChannelListener(this.v);
        boolean bl4 = channel == null;
        this.c = bl4 ? Browser.a(context, (BrowserType)((Object)string)) : var3_3;
        IPC.addBrowser(this);
        this.w = new e(this, 0);
        Channel channel2 = this.z = !bl4 ? context.a().findRenderChannel(this.c) : null;
        if (this.z != null) {
            this.z.addChannelListener(this.w);
        }
        this.s = new HashMap<Integer, PrintJob>();
        this.t = new HashMap<Integer, SearchCompleteCallback>();
        this.m = new al();
        this.b = EventQueue.createFixedEventQueue("Browser Events Thread");
        this.j = new CopyOnWriteArrayList<TitleListener>();
        this.i = new CopyOnWriteArrayList<LoadListener>();
        this.k = new CopyOnWriteArrayList<RenderListener>();
        this.q = new CopyOnWriteArrayList<DisposeListener<Browser>>();
        this.n = new CopyOnWriteArrayList<ConsoleListener>();
        this.l = new CopyOnWriteArrayList<StatusListener>();
        this.r = new CopyOnWriteArrayList<ScriptContextListener>();
        this.o = new DialogHandlerDelegate();
        this.p = new MediaStreamDeviceManager(this.c);
        this.e = new ChannelCookieStorage(this.c);
        this.h = new ChannelCacheStorage(this.c, this.b, new b(this, 0));
        this.g = new PluginManagerImpl(this.c);
        this.u = new c(this, 0);
        this.c.addChannelListener(this.u);
        this.x = new d(this, 0);
        var2_2.a().addIPCChannelListener(this.x);
        if (bl4) {
            this.d();
        }
    }

    private static Channel a(BrowserContext object, BrowserType browserType) {
        ProxyParams proxyParams = ProxyParams.from(((BrowserContext)object).getProxyConfig());
        int n2 = ChannelIDGenerator.generate();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        com.teamdev.jxbrowser.chromium.b b2 = new com.teamdev.jxbrowser.chromium.b(n2, countDownLatch);
        IPC iPC = ((BrowserContext)object).a();
        iPC.addIPCChannelListener(b2);
        CreateBrowserMessage createBrowserMessage = new CreateBrowserMessage();
        new CreateBrowserMessage().channelId = n2;
        createBrowserMessage.contextId = ((BrowserContext)object).getIdentifier();
        createBrowserMessage.cacheDir = ((BrowserContext)object).getCacheDir();
        createBrowserMessage.memoryDir = ((BrowserContext)object).getMemoryDir();
        createBrowserMessage.dataDir = ((BrowserContext)object).getDataDir();
        createBrowserMessage.currentLocale = ((BrowserContext)object).getAcceptLanguage();
        createBrowserMessage.proxyType = proxyParams.getProxyType();
        createBrowserMessage.proxyRules = proxyParams.getProxyRules();
        createBrowserMessage.proxyBypassRules = proxyParams.getProxyBypassRules();
        createBrowserMessage.proxyAutoConfigURL = proxyParams.getProxyAutoConfigURL();
        createBrowserMessage.defaultZoomLevel = ((BrowserContext)object).getZoomService().getDefaultZoomLevel();
        createBrowserMessage.isOffScreenMode = browserType == BrowserType.LIGHTWEIGHT;
        createBrowserMessage.storageType = ((BrowserContext)object).getStorageType().a();
        iPC.send(createBrowserMessage);
        try {
            if (Environment.isMac() && Environment.isJavaFX() && Platform.isFxApplicationThread()) {
                while (countDownLatch.getCount() != 0L) {
                    SharedMemoryLibrary.getInstance().runPendingTasks();
                }
            }
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser browserChannel " + n2));
        }
        finally {
            iPC.removeIPCChannelListener(b2);
        }
        object = iPC.getChannel(n2, ChannelType.Browser);
        if (object == null) {
            throw new IPCException("Failed to get Browser browserChannel " + n2);
        }
        return object;
    }

    private static void a(Channel channel) {
        if (channel != null) {
            channel.blockWriteMessages();
            channel.waitForPendingPostRequests();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void invokeAndWaitFinishLoadingMainFrame(Browser browser, Callback<Browser> task) {
        void var1_1;
        Browser.invokeAndWaitFinishLoadingMainFrame(browser, (Callback<Browser>)var1_1, 45);
    }

    /*
     * WARNING - void declaration
     */
    public static void invokeAndWaitFinishLoadingMainFrame(Browser browser, Callback<Browser> task, int timeoutInSeconds) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        o o2 = new o(countDownLatch);
        browser.addLoadListener(o2);
        try {
            void var1_1;
            var1_1.invoke(browser);
            try {
                void var2_3;
                if (!countDownLatch.await((long)var2_3, TimeUnit.SECONDS)) {
                    throw new RuntimeException(new TimeoutException());
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            browser.removeLoadListener(o2);
            return;
        }
        catch (Throwable throwable) {
            Browser browser2;
            browser2.removeLoadListener(o2);
            throw throwable;
        }
    }

    final int a() {
        return this.y;
    }

    final Set<Long> b() {
        return new HashSet<Long>(this.B);
    }

    public BrowserType getType() {
        return this.d;
    }

    private Channel getChannel() {
        return this.c;
    }

    private IPC getIPC() {
        return this.f.a();
    }

    private void a(Message message) {
        this.c.send(message);
    }

    private <M extends Message> M b(M m2) {
        return this.c.post(m2);
    }

    /*
     * WARNING - void declaration
     */
    public void setSize(int width, int height) {
        DataMessage dataMessage;
        if (width < 0) {
            throw new IllegalArgumentException("Width cannot be negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height cannot be negative");
        }
        if (this.d == BrowserType.LIGHTWEIGHT) {
            dataMessage = new SetBoundsMessage();
            new SetBoundsMessage().bounds = new Rectangle(width, height);
            this.a(dataMessage);
        }
        if (this.d == BrowserType.HEAVYWEIGHT) {
            void var2_2;
            void var1_1;
            dataMessage = new FrameSetBoundsMessage();
            new FrameSetBoundsMessage().width = var1_1;
            ((FrameSetBoundsMessage)dataMessage).height = var2_2;
            this.a(dataMessage);
        }
    }

    private void d() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        z z2 = new z(this, countDownLatch);
        this.addLoadListener(z2);
        this.loadURL("about:blank");
        try {
            if (Environment.isMac() && Environment.isJavaFX() && Platform.isFxApplicationThread()) {
                while (countDownLatch.getCount() != 0L) {
                    SharedMemoryLibrary.getInstance().runPendingTasks();
                }
            }
            LatchUtil.await(countDownLatch, new BrowserException("Failed to load 'about:blank' web page within " + LatchUtil.getWaitInSeconds() + " seconds."));
            return;
        }
        finally {
            this.removeLoadListener(z2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTitleListener(TitleListener listener) {
        if (!this.j.contains(listener)) {
            void var1_1;
            this.j.add((TitleListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTitleListener(TitleListener listener) {
        void var1_1;
        this.j.remove(var1_1);
    }

    public List<TitleListener> getTitleListeners() {
        return new ArrayList<TitleListener>(this.j);
    }

    /*
     * WARNING - void declaration
     */
    public void addStatusListener(StatusListener listener) {
        if (!this.l.contains(listener)) {
            void var1_1;
            this.l.add((StatusListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeStatusListener(StatusListener listener) {
        void var1_1;
        this.l.remove(var1_1);
    }

    public List<StatusListener> getStatusListeners() {
        return new ArrayList<StatusListener>(this.l);
    }

    /*
     * WARNING - void declaration
     */
    public void addLoadListener(LoadListener listener) {
        if (!this.i.contains(listener)) {
            void var1_1;
            this.i.add((LoadListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeLoadListener(LoadListener listener) {
        void var1_1;
        this.i.remove(var1_1);
    }

    public List<LoadListener> getLoadListeners() {
        return new ArrayList<LoadListener>(this.i);
    }

    /*
     * WARNING - void declaration
     */
    public void addScriptContextListener(ScriptContextListener listener) {
        if (!this.r.contains(listener)) {
            void var1_1;
            this.r.add((ScriptContextListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeScriptContextListener(ScriptContextListener listener) {
        void var1_1;
        this.r.remove(var1_1);
    }

    public List<ScriptContextListener> getScriptContextListeners() {
        return new ArrayList<ScriptContextListener>(this.r);
    }

    /*
     * WARNING - void declaration
     */
    public void addRenderListener(RenderListener listener) {
        if (!this.k.contains(listener)) {
            void var1_1;
            this.k.add((RenderListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeRenderListener(RenderListener listener) {
        void var1_1;
        this.k.remove(var1_1);
    }

    public List<RenderListener> getRenderListeners() {
        return new ArrayList<RenderListener>(this.k);
    }

    /*
     * WARNING - void declaration
     */
    public void addConsoleListener(ConsoleListener listener) {
        if (!this.n.contains(listener)) {
            void var1_1;
            this.n.add((ConsoleListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeConsoleListener(ConsoleListener listener) {
        void var1_1;
        this.n.remove(var1_1);
    }

    public List<ConsoleListener> getConsoleListeners() {
        return new ArrayList<ConsoleListener>(this.n);
    }

    public FullScreenHandler getFullScreenHandler() {
        return this.I;
    }

    /*
     * WARNING - void declaration
     */
    public void setFullScreenHandler(FullScreenHandler handler) {
        void var1_1;
        this.I = var1_1;
    }

    public PopupHandler getPopupHandler() {
        return this.E;
    }

    /*
     * WARNING - void declaration
     */
    public void setPopupHandler(PopupHandler handle) {
        void var1_1;
        this.E = var1_1;
    }

    public ContextMenuHandler getContextMenuHandler() {
        return this.K;
    }

    /*
     * WARNING - void declaration
     */
    public void setContextMenuHandler(ContextMenuHandler handler) {
        void var1_1;
        this.K = var1_1;
    }

    public DownloadHandler getDownloadHandler() {
        return this.G;
    }

    /*
     * WARNING - void declaration
     */
    public void setDownloadHandler(DownloadHandler handler) {
        void var1_1;
        this.G = var1_1;
    }

    public PermissionHandler getPermissionHandler() {
        return this.H;
    }

    /*
     * WARNING - void declaration
     */
    public void setPermissionHandler(PermissionHandler handler) {
        void var1_1;
        this.H = var1_1;
    }

    public DialogHandler getDialogHandler() {
        return this.o.getDialogHandler();
    }

    /*
     * WARNING - void declaration
     */
    public void setDialogHandler(DialogHandler handler) {
        void var1_1;
        this.o.setDialogHandler((DialogHandler)var1_1);
    }

    public CookieStorage getCookieStorage() {
        return this.e;
    }

    public CacheStorage getCacheStorage() {
        return this.h;
    }

    public synchronized boolean isCommandEnabled(EditorCommand command) {
        if (command == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        if (this.z != null) {
            IsCommandEnabledMessage isCommandEnabledMessage;
            IsCommandEnabledMessage isCommandEnabledMessage2 = new IsCommandEnabledMessage();
            new IsCommandEnabledMessage().command = ((EditorCommand)((Object)isCommandEnabledMessage)).getCommandText();
            isCommandEnabledMessage = this.z.post(isCommandEnabledMessage2);
            return isCommandEnabledMessage.result;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean executeCommand(EditorCommand command) {
        void var1_1;
        return this.executeCommand(-2L, (EditorCommand)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean executeCommand(long frameId, EditorCommand command) {
        void var3_2;
        void var1_1;
        return this.executeCommand((long)var1_1, (EditorCommand)var3_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean executeCommand(EditorCommand command, String value) {
        void var2_2;
        void var1_1;
        return this.executeCommand(-2L, (EditorCommand)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean executeCommand(long frameId, EditorCommand command, String value) {
        if (command == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        this.a(frameId);
        if (this.z != null) {
            void var3_3;
            void var1_1;
            ExecuteCommandMessage executeCommandMessage = new ExecuteCommandMessage();
            new ExecuteCommandMessage().frameId = var1_1;
            executeCommandMessage.command = var3_3.getCommandText();
            executeCommandMessage.commandValue = value;
            ExecuteCommandMessage executeCommandMessage2 = this.z.post(executeCommandMessage);
            return executeCommandMessage2.result;
        }
        return false;
    }

    public LoadHandler getLoadHandler() {
        return this.D;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadHandler(LoadHandler handler) {
        void var1_1;
        this.D = var1_1;
    }

    public synchronized String getRemoteDebuggingURL() {
        GetRemoteDebuggingURLMessage getRemoteDebuggingURLMessage = this.b(new GetRemoteDebuggingURLMessage());
        return getRemoteDebuggingURLMessage.remoteDebuggingUrl;
    }

    public synchronized List<Long> getFramesIds() {
        return this.getFramesIds(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized List<Long> getFramesIds(long frameId) {
        if (this.z != null) {
            void var1_1;
            Object object = new GetFramesIdsMessage();
            new GetFramesIdsMessage().frameId = var1_1;
            Object object2 = this.z.post(object);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            object2 = new StringTokenizer(((GetFramesIdsMessage)object2).ids, "|");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                arrayList.add(Long.parseLong((String)object));
            }
            return arrayList;
        }
        return new ArrayList<Long>();
    }

    public synchronized SearchResult findText(SearchParams params) {
        AtomicReference atomicReference;
        if (params == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        int n2 = SearchRequestIDGenerator.generate();
        FindTextMessage findTextMessage = new FindTextMessage();
        new FindTextMessage().requestId = n2;
        findTextMessage.searchText = params.getSearchText();
        findTextMessage.forward = params.isForward();
        findTextMessage.matchCase = ((SearchParams)((Object)atomicReference)).isMatchCase();
        findTextMessage.findNext = false;
        atomicReference = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ae ae2 = new ae(this, atomicReference, countDownLatch);
        this.t.put(n2, ae2);
        this.a(findTextMessage);
        LatchUtil.await(countDownLatch, new IPCException("Response was not received."));
        return (SearchResult)atomicReference.get();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void stopFindingText(StopFindAction action) {
        void var1_1;
        if (action == null) {
            throw new IllegalArgumentException("The action parameter cannot be null.");
        }
        StopFindingMessage stopFindingMessage = new StopFindingMessage();
        new StopFindingMessage().action = var1_1.getValue();
        this.a(stopFindingMessage);
    }

    public synchronized String getSelectedText() {
        return this.getSelectedText(-2L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String getSelectedText(long frameId) {
        this.a(frameId);
        if (this.z != null) {
            void var1_1;
            GetSelectedTextMessage getSelectedTextMessage = new GetSelectedTextMessage();
            new GetSelectedTextMessage().frameId = var1_1;
            GetSelectedTextMessage getSelectedTextMessage2 = this.z.post(getSelectedTextMessage);
            return getSelectedTextMessage2.selectedText;
        }
        return "";
    }

    public synchronized String getSelectedHTML() {
        return this.getSelectedHTML(-2L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String getSelectedHTML(long frameId) {
        this.a(frameId);
        if (this.z != null) {
            void var1_1;
            GetSelectedHTMLMessage getSelectedHTMLMessage = new GetSelectedHTMLMessage();
            new GetSelectedHTMLMessage().frameId = var1_1;
            GetSelectedHTMLMessage getSelectedHTMLMessage2 = this.z.post(getSelectedHTMLMessage);
            return getSelectedHTMLMessage2.selectedHTML;
        }
        return "";
    }

    public PluginManager getPluginManager() {
        return this.g;
    }

    public MediaStreamDeviceManager getMediaStreamDeviceManager() {
        return this.p;
    }

    public PrintHandler getPrintHandler() {
        return this.F;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrintHandler(PrintHandler handler) {
        void var1_1;
        this.F = var1_1;
    }

    public synchronized void print() {
        this.print(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void print(long frameId) {
        void var1_1;
        this.a(frameId);
        PrintMessage printMessage = new PrintMessage();
        new PrintMessage().frameId = var1_1;
        this.a(printMessage);
    }

    public synchronized BrowserPreferences getPreferences() {
        GetWebPreferencesMessage getWebPreferencesMessage = this.b(new GetWebPreferencesMessage());
        BrowserPreferences browserPreferences = new BrowserPreferences();
        browserPreferences.setDefaultEncoding(getWebPreferencesMessage.defaultEncoding);
        browserPreferences.setJavaScriptEnabled(getWebPreferencesMessage.javascriptEnabled);
        browserPreferences.setJavaScriptCanOpenWindowsAutomatically(getWebPreferencesMessage.javascriptCanOpenWindowsAutomatically);
        browserPreferences.setLoadsImagesAutomatically(getWebPreferencesMessage.loadsImagesAutomatically);
        browserPreferences.setImagesEnabled(getWebPreferencesMessage.imagesEnabled);
        browserPreferences.setPluginsEnabled(getWebPreferencesMessage.pluginsEnabled);
        browserPreferences.setAllowScriptsToCloseWindows(getWebPreferencesMessage.allowScriptsToCloseWindows);
        browserPreferences.setJavaScriptCanAccessClipboard(getWebPreferencesMessage.javascriptCanAccessClipboard);
        browserPreferences.setLocalStorageEnabled(getWebPreferencesMessage.localStorageEnabled);
        browserPreferences.setDatabasesEnabled(getWebPreferencesMessage.databasesEnabled);
        browserPreferences.setApplicationCacheEnabled(getWebPreferencesMessage.applicationCacheEnabled);
        browserPreferences.setAllowRunningInsecureContent(getWebPreferencesMessage.allowRunningInsecureContent);
        browserPreferences.setTransparentBackground(getWebPreferencesMessage.transparentBackground);
        browserPreferences.setWebRTCIPHandlingPolicy(WebRTCIPHandlingPolicy.valueOf(getWebPreferencesMessage.webRTCIPHandlingPolicyFlag));
        return browserPreferences;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setPreferences(BrowserPreferences preferences) {
        void var1_1;
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences cannot be null.");
        }
        UpdateWebPreferencesMessage updateWebPreferencesMessage = new UpdateWebPreferencesMessage();
        new UpdateWebPreferencesMessage().defaultEncoding = preferences.getDefaultEncoding();
        updateWebPreferencesMessage.javaScriptEnabled = preferences.isJavaScriptEnabled();
        updateWebPreferencesMessage.javaScriptCanOpenWindowsAutomatically = preferences.isJavaScriptCanOpenWindowsAutomatically();
        updateWebPreferencesMessage.loadsImagesAutomatically = preferences.isLoadsImagesAutomatically();
        updateWebPreferencesMessage.imagesEnabled = preferences.isImagesEnabled();
        updateWebPreferencesMessage.pluginsEnabled = preferences.isPluginsEnabled();
        updateWebPreferencesMessage.allowScriptsToCloseWindows = preferences.isAllowScriptsToCloseWindows();
        updateWebPreferencesMessage.javaScriptCanAccessClipboard = preferences.isJavaScriptCanAccessClipboard();
        updateWebPreferencesMessage.localStorageEnabled = preferences.isLocalStorageEnabled();
        updateWebPreferencesMessage.databasesEnabled = preferences.isDatabasesEnabled();
        updateWebPreferencesMessage.applicationCacheEnabled = preferences.isApplicationCacheEnabled();
        updateWebPreferencesMessage.allowRunningInsecureContent = preferences.isAllowRunningInsecureContent();
        updateWebPreferencesMessage.transparentBackground = preferences.isTransparentBackground();
        updateWebPreferencesMessage.webRTCIPHandlingPolicyFlag = var1_1.getWebRTCIPHandlingPolicy().ordinal();
        this.a(updateWebPreferencesMessage);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean saveWebPage(String filePath, String dirPath, SavePageType saveType) {
        void var3_3;
        void var2_2;
        SaveWebPageMessage saveWebPageMessage;
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("The filePath parameter cannot be empty or null.");
        }
        if (dirPath == null || dirPath.isEmpty()) {
            throw new IllegalArgumentException("The dirPath parameter cannot be empty or null.");
        }
        if (saveType == null) {
            throw new IllegalArgumentException("The saveType parameter cannot be null.");
        }
        SaveWebPageMessage saveWebPageMessage2 = new SaveWebPageMessage();
        new SaveWebPageMessage().filePath = saveWebPageMessage;
        saveWebPageMessage2.dirPath = var2_2;
        saveWebPageMessage2.saveType = var3_3.getValue();
        saveWebPageMessage = this.b(saveWebPageMessage2);
        return saveWebPageMessage.result;
    }

    public BrowserContext getContext() {
        return this.f;
    }

    public synchronized DOMDocument getDocument() {
        return this.getDocument(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized DOMDocument getDocument(long frameId) {
        this.a(frameId);
        if (this.z != null) {
            void var1_1;
            GetDocumentMessage getDocumentMessage = new GetDocumentMessage();
            new GetDocumentMessage().frameId = var1_1;
            Object object = this.z.post(getDocumentMessage);
            long l2 = ((GetDocumentMessage)object).documentPtr;
            if (l2 != 0L) {
                object = new DOMContext(this.z);
                DOMFactory dOMFactory = new DOMFactory((DOMContext)object);
                return new Document(l2, dOMFactory, (DOMContext)object);
            }
        }
        return null;
    }

    public synchronized boolean isSandboxEnabled() {
        if (this.z != null) {
            TestSandboxMessage testSandboxMessage = new TestSandboxMessage();
            testSandboxMessage = this.z.post(testSandboxMessage);
            return testSandboxMessage.isSandboxEnabled;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized DOMNodeAtPoint getNodeAtPoint(int x2, int y2) {
        if (this.z != null) {
            void var2_3;
            void var1_1;
            GetNodeAtPointMessage getNodeAtPointMessage = new GetNodeAtPointMessage();
            new GetNodeAtPointMessage().x = var1_1;
            getNodeAtPointMessage.y = var2_3;
            GetNodeAtPointMessage getNodeAtPointMessage2 = this.z.post(getNodeAtPointMessage);
            Object object = new DOMContext(this.z);
            object = new DOMFactory((DOMContext)object);
            return ((DOMFactory)object).createNodeAtPoint(getNodeAtPointMessage2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized DOMNodeAtPoint getNodeAtPoint(Point point) {
        void var1_1;
        if (point == null) {
            throw new IllegalArgumentException("The point parameter cannot be null.");
        }
        return this.getNodeAtPoint(point.x, var1_1.y);
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            DisposeEvent<Browser> disposeEvent = new CountDownLatch(1);
            af af2 = new af(this, (CountDownLatch)((Object)disposeEvent));
            IPC iPC = this.getIPC();
            iPC.addIPCChannelListener(af2);
            try {
                this.stopFindingText(StopFindAction.CLEAR_SELECTION);
                Browser.a(this.z);
                this.b(new BeforeDisposeBrowserMessage());
                this.a(new DisposeBrowserMessage());
                Browser.a(this.c);
                if (Environment.isMac() && Environment.isJavaFX() && Platform.isFxApplicationThread()) {
                    while (((CountDownLatch)((Object)disposeEvent)).getCount() != 0L) {
                        SharedMemoryLibrary.getInstance().runPendingTasks();
                    }
                }
                LatchUtil.await((CountDownLatch)((Object)disposeEvent), new IPCException("Failed to execute WebEngine dispose post message."));
                for (JSContext object : this.m.a()) {
                    this.m.b(object);
                    object.a();
                }
                this.h.dispose();
                this.c.removeChannelListener(this.u);
                if (this.z != null) {
                    this.z.removeChannelListener(this.w);
                    this.z = null;
                }
            }
            finally {
                iPC.getMainChannel().removeChannelListener(this.v);
                iPC.removeIPCChannelListener(this.x);
                iPC.removeIPCChannelListener(af2);
                iPC.stop();
            }
            disposeEvent = new DisposeEvent<Browser>(this);
            for (DisposeListener<Browser> disposeListener : this.getDisposeListeners()) {
                this.b.invokeLater(new ag(this, disposeListener, disposeEvent));
            }
            this.b.dispose();
            IPC.removeBrowser(this);
            this.f.e();
            if (!this.f.b()) {
                this.f.f();
                if (this.C != null) {
                    this.C.unlock();
                }
            }
        }
    }

    public synchronized boolean isDisposed() {
        try {
            PingMessage pingMessage = this.b(new PingMessage());
            return !pingMessage.alive;
        }
        catch (Exception exception) {
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addDisposeListener(DisposeListener<Browser> listener) {
        if (!this.q.contains(listener)) {
            void var1_1;
            this.q.add((DisposeListener<Browser>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeDisposeListener(DisposeListener<Browser> listener) {
        void var1_1;
        this.q.remove(var1_1);
    }

    public List<DisposeListener<Browser>> getDisposeListeners() {
        return new ArrayList<DisposeListener<Browser>>(this.q);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadURL(String url) {
        void var1_1;
        this.loadURL(-1L, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadURL(long frameId, String url) {
        void var1_1;
        void var3_2;
        if (url == null) {
            throw new IllegalArgumentException("The url parameter cannot be null.");
        }
        this.a(frameId);
        LoadURLMessage loadURLMessage = new LoadURLMessage();
        new LoadURLMessage().url = var3_2;
        loadURLMessage.frameId = var1_1;
        this.a(loadURLMessage);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadURL(LoadURLParams params) {
        void var1_1;
        if (params == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        LoadURLMessage loadURLMessage = new LoadURLMessage();
        new LoadURLMessage().url = params.getURL();
        loadURLMessage.frameId = -1L;
        loadURLMessage.extraHeaders = params.getExtraHeaders();
        loadURLMessage.postData = var1_1.getPostData().getBytes(Charset.forName("UTF-8"));
        this.a(loadURLMessage);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadHTML(String html) {
        void var1_1;
        this.loadHTML(-1L, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadHTML(long frameId, String html) {
        void var3_2;
        void var1_1;
        if (html == null || html.isEmpty()) {
            throw new IllegalArgumentException("The html parameter cannot be null or empty.");
        }
        this.a(frameId);
        this.loadHTML((long)var1_1, new LoadHTMLParams((String)var3_2, "UTF-8", "about:blank"));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadHTML(LoadHTMLParams params) {
        void var1_1;
        this.loadHTML(-1L, (LoadHTMLParams)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadHTML(long frameId, LoadHTMLParams params) {
        void var3_2;
        void var1_1;
        if (params == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.loadData((long)var1_1, new LoadDataParams(params.getHTML(), "text/html", params.getTextEncoding(), var3_2.getBaseURL()));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadData(LoadDataParams params) {
        void var1_1;
        this.loadData(-1L, (LoadDataParams)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void loadData(long frameId, LoadDataParams params) {
        void var1_1;
        void var3_2;
        if (params == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.a(frameId);
        if (this.z == null || this.z.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        LoadDataMessage loadDataMessage = new LoadDataMessage();
        new LoadDataMessage().data = params.getData();
        loadDataMessage.mimeType = params.getMimeType();
        loadDataMessage.textEncoding = params.getTextEncoding();
        loadDataMessage.baseURL = var3_2.getBaseURL();
        loadDataMessage.frameId = var1_1;
        this.z.send(loadDataMessage);
    }

    public synchronized String getHTML() {
        return this.getHTML(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String getHTML(long frameId) {
        void var1_1;
        this.a(frameId);
        if (this.z == null || this.z.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        GetHTMLMessage getHTMLMessage = new GetHTMLMessage();
        new GetHTMLMessage().frameId = var1_1;
        GetHTMLMessage getHTMLMessage2 = this.z.post(getHTMLMessage);
        return getHTMLMessage2.html;
    }

    public synchronized String getURL() {
        GetURLMessage getURLMessage = this.b(new GetURLMessage());
        return getURLMessage.url;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void executeJavaScript(String javaScript) {
        void var1_1;
        this.executeJavaScript(-1L, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSValue executeJavaScriptAndReturnValue(String javaScript) {
        void var1_1;
        return this.executeJavaScriptAndReturnValue(-1L, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void executeJavaScript(long frameId, String javaScript) {
        void var3_2;
        void var1_1;
        if (javaScript == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        this.a(frameId);
        if (this.z == null || this.z.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        ExecuteJavaScriptMessage executeJavaScriptMessage = new ExecuteJavaScriptMessage();
        new ExecuteJavaScriptMessage().frameId = var1_1;
        executeJavaScriptMessage.worldId = 0;
        executeJavaScriptMessage.javaScript = var3_2;
        this.z.send(executeJavaScriptMessage);
    }

    /*
     * WARNING - void declaration
     */
    public JSValue executeJavaScriptAndReturnValue(long frameId, String javaScript) {
        void var1_1;
        Object object;
        if (javaScript == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        this.a(frameId);
        if (this.z == null || this.z.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        ExecuteJavaScriptMessage executeJavaScriptMessage = new ExecuteJavaScriptMessage();
        new ExecuteJavaScriptMessage().frameId = frameId;
        executeJavaScriptMessage.worldId = 0;
        executeJavaScriptMessage.javaScript = object;
        executeJavaScriptMessage.hasReturnValue = true;
        object = this.z.post(executeJavaScriptMessage);
        object = ao.b(((ExecuteJavaScriptMessage)object).returnValue);
        return al.a((ao)object, this.getJSContext((long)var1_1));
    }

    public JSContext getJSContext() {
        return this.getJSContext(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public JSContext getJSContext(long frameId) {
        void var1_1;
        return this.m.a((long)var1_1, 0L);
    }

    public synchronized String getTitle() {
        GetTitleMessage getTitleMessage = this.b(new GetTitleMessage());
        return getTitleMessage.title;
    }

    public synchronized double getZoomLevel() {
        GetZoomLevelMessage getZoomLevelMessage = this.b(new GetZoomLevelMessage());
        return getZoomLevelMessage.zoomLevel;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setZoomLevel(double zoomLevel) {
        void var1_1;
        SetZoomLevelMessage setZoomLevelMessage = new SetZoomLevelMessage();
        new SetZoomLevelMessage().zoomLevel = var1_1;
        this.a(setZoomLevelMessage);
    }

    public synchronized void zoomIn() {
        SetZoomMessage setZoomMessage = new SetZoomMessage();
        new SetZoomMessage().zoomFlag = PageZoom.PAGE_ZOOM_IN.getValue();
        this.a(setZoomMessage);
    }

    public synchronized void zoomOut() {
        SetZoomMessage setZoomMessage = new SetZoomMessage();
        new SetZoomMessage().zoomFlag = PageZoom.PAGE_ZOOM_OUT.getValue();
        this.a(setZoomMessage);
    }

    public synchronized void zoomReset() {
        SetZoomMessage setZoomMessage = new SetZoomMessage();
        new SetZoomMessage().zoomFlag = PageZoom.PAGE_ZOOM_RESET.getValue();
        this.a(setZoomMessage);
    }

    public synchronized boolean isZoomEnabled() {
        ZoomModeMessage zoomModeMessage = new ZoomModeMessage();
        new ZoomModeMessage().isGet = true;
        zoomModeMessage = this.b(zoomModeMessage);
        return zoomModeMessage.zoomEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setZoomEnabled(boolean enabled) {
        void var1_1;
        ZoomModeMessage zoomModeMessage = new ZoomModeMessage();
        new ZoomModeMessage().zoomEnabled = var1_1;
        this.a(zoomModeMessage);
    }

    public synchronized boolean isLoading() {
        IsLoadingMessage isLoadingMessage = this.b(new IsLoadingMessage());
        return isLoadingMessage.loading;
    }

    public synchronized void stop() {
        this.a(new StopMessage());
    }

    public synchronized void goBack() {
        this.a(new GoBackMessage());
    }

    public synchronized boolean canGoBack() {
        CanGoBackMessage canGoBackMessage = this.b(new CanGoBackMessage());
        return canGoBackMessage.goBack;
    }

    public synchronized void goForward() {
        this.a(new GoForwardMessage());
    }

    public synchronized boolean canGoForward() {
        CanGoForwardMessage canGoForwardMessage = this.b(new CanGoForwardMessage());
        return canGoForwardMessage.goForward;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean canGoToOffset(int offset) {
        void var1_1;
        CanGoToOffsetMessage canGoToOffsetMessage = new CanGoToOffsetMessage();
        new CanGoToOffsetMessage().offset = var1_1;
        CanGoToOffsetMessage canGoToOffsetMessage2 = this.b(canGoToOffsetMessage);
        return canGoToOffsetMessage2.goToOffset;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void goToOffset(int offset) {
        void var1_1;
        GoToOffsetMessage goToOffsetMessage = new GoToOffsetMessage();
        new GoToOffsetMessage().offset = var1_1;
        this.a(goToOffsetMessage);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void goToIndex(int index) {
        void var1_1;
        GoToIndexMessage goToIndexMessage = new GoToIndexMessage();
        new GoToIndexMessage().index = var1_1;
        this.a(goToIndexMessage);
    }

    public synchronized int getNavigationEntryCount() {
        GetEntryCountMessage getEntryCountMessage = this.b(new GetEntryCountMessage());
        return getEntryCountMessage.entryCount;
    }

    public synchronized int getCurrentNavigationEntryIndex() {
        GetCurrentEntryIndexMessage getCurrentEntryIndexMessage = this.b(new GetCurrentEntryIndexMessage());
        return getCurrentEntryIndexMessage.index;
    }

    public synchronized NavigationEntry getCurrentNavigationEntry() {
        return this.a(0, -1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized NavigationEntry getNavigationEntryAtIndex(int index) {
        void var1_1;
        return this.a(1, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized NavigationEntry getNavigationEntryAtOffset(int offset) {
        void var1_1;
        return this.a(2, (int)var1_1);
    }

    private NavigationEntry a(int n2, int n3) {
        Object object = new GetEntryMessage();
        new GetEntryMessage().flag = n2;
        ((GetEntryMessage)object).indexOffset = n3;
        Object object2 = this.b(object);
        if (((GetEntryMessage)object2).success) {
            String string = ((GetEntryMessage)object2).url;
            object = ((GetEntryMessage)object2).title;
            long l2 = ((GetEntryMessage)object2).timestamp;
            NavigationEntry.PageType pageType = NavigationEntry.PageType.valueOf(((GetEntryMessage)object2).pageType);
            int n4 = ((GetEntryMessage)object2).httpStatusCode;
            object2 = ((GetEntryMessage)object2).originalRequestURL;
            return new NavigationEntry(string, (String)object, l2, pageType, n4, (String)object2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean removeNavigationEntryAtIndex(int index) {
        void var1_1;
        RemoveEntryAtIndexMessage removeEntryAtIndexMessage = new RemoveEntryAtIndexMessage();
        new RemoveEntryAtIndexMessage().index = var1_1;
        RemoveEntryAtIndexMessage removeEntryAtIndexMessage2 = this.b(removeEntryAtIndexMessage);
        return removeEntryAtIndexMessage2.success;
    }

    public synchronized void reload() {
        this.reload(false);
    }

    public synchronized void reloadIgnoringCache() {
        this.reloadIgnoringCache(false);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void reload(boolean checkForRepost) {
        void var1_1;
        ReloadMessage reloadMessage = new ReloadMessage();
        new ReloadMessage().checkForRepost = var1_1;
        this.a(reloadMessage);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void reloadIgnoringCache(boolean checkForRepost) {
        void var1_1;
        ReloadIgnoringCacheMessage reloadIgnoringCacheMessage = new ReloadIgnoringCacheMessage();
        new ReloadIgnoringCacheMessage().checkForRepost = var1_1;
        this.a(reloadIgnoringCacheMessage);
    }

    public WebStorage getLocalWebStorage() {
        return this.getLocalWebStorage(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized WebStorage getLocalWebStorage(long frameId) {
        void var1_1;
        return this.a((long)var1_1, WebStorageType.LOCAL);
    }

    public WebStorage getSessionWebStorage() {
        return this.getSessionWebStorage(-1L);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized WebStorage getSessionWebStorage(long frameId) {
        void var1_1;
        return this.a((long)var1_1, WebStorageType.SESSION);
    }

    private synchronized WebStorage a(long l2, WebStorageType webStorageType) {
        this.a(l2);
        if (this.z != null) {
            return new ChannelWebStorage(this.z, l2, webStorageType);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void replaceMisspelledWord(String word) {
        void var1_1;
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("The word parameter cannot be null or empty.");
        }
        ReplaceMisspelledWordMessage replaceMisspelledWordMessage = new ReplaceMisspelledWordMessage();
        new ReplaceMisspelledWordMessage().word = var1_1;
        this.a(replaceMisspelledWordMessage);
    }

    public boolean addWordToSpellCheckerDictionary(String word) {
        AddWordToDictionaryMessage addWordToDictionaryMessage;
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("The word parameter cannot be null or empty.");
        }
        AddWordToDictionaryMessage addWordToDictionaryMessage2 = new AddWordToDictionaryMessage();
        new AddWordToDictionaryMessage().word = addWordToDictionaryMessage;
        addWordToDictionaryMessage = this.b(addWordToDictionaryMessage2);
        return addWordToDictionaryMessage.success;
    }

    public boolean isAudioMuted() {
        IsAudioMutedMessage isAudioMutedMessage = this.b(new IsAudioMutedMessage());
        return isAudioMutedMessage.audioMuted;
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioMuted(boolean muted) {
        void var1_1;
        SetAudioMutedMessage setAudioMutedMessage = new SetAudioMutedMessage();
        new SetAudioMutedMessage().audioMuted = var1_1;
        this.a(setAudioMutedMessage);
    }

    public boolean isAudioPlaying() {
        IsAudioPlayingMessage isAudioPlayingMessage = this.b(new IsAudioPlayingMessage());
        return isAudioPlayingMessage.playing;
    }

    /*
     * WARNING - void declaration
     */
    public void forwardKeyEvent(BrowserKeyEvent event) {
        void var1_1;
        if (event == null) {
            throw new IllegalArgumentException("The event parameter cannot be null.");
        }
        ForwardKeyboardMessage forwardKeyboardMessage = new ForwardKeyboardMessage();
        new ForwardKeyboardMessage().eventType = event.getEventType().getValue();
        forwardKeyboardMessage.systemKey = event.getKeyCode() == BrowserKeyEvent.KeyCode.VK_RETURN;
        forwardKeyboardMessage.keyChar = event.getKeyChar();
        forwardKeyboardMessage.windowsKeyCode = event.getKeyCode().getCode();
        forwardKeyboardMessage.modifiers = var1_1.getModifiers().a();
        this.getChannel().send(forwardKeyboardMessage);
    }

    /*
     * WARNING - void declaration
     */
    public void forwardMouseEvent(BrowserMouseEvent event) {
        void var1_1;
        if (event == null) {
            throw new IllegalArgumentException("The event parameter cannot be null.");
        }
        Object object = event.getEventType();
        int n2 = object != null ? object.getValue() : -1;
        int n3 = event.getButtonType() != null ? event.getButtonType().getValue() : BrowserMouseEvent.MouseButtonType.NO_BUTTON.getValue();
        int n4 = event.getModifiers().a();
        int n5 = event.getX();
        int n6 = event.getY();
        int n7 = event.getWindowX();
        int n8 = event.getWindowY();
        int n9 = event.getGlobalX();
        int n10 = event.getGlobalY();
        if (object == BrowserMouseEvent.MouseEventType.MOUSE_WHEEL) {
            int n11 = event.getUnitsToScroll();
            ForwardMouseWheelMessage forwardMouseWheelMessage = new ForwardMouseWheelMessage();
            new ForwardMouseWheelMessage().x = n5;
            forwardMouseWheelMessage.y = n6;
            forwardMouseWheelMessage.globalX = n9;
            forwardMouseWheelMessage.globalY = n10;
            forwardMouseWheelMessage.windowX = n7;
            forwardMouseWheelMessage.windowY = n8;
            forwardMouseWheelMessage.scrollType = event.getScrollType().getValue();
            forwardMouseWheelMessage.unitsToScroll = n11;
            forwardMouseWheelMessage.modifiers = n4;
            forwardMouseWheelMessage.horizontalScroll = event.isHorizontalScroll();
            forwardMouseWheelMessage.scrollbarPixelsPerLine = event.getScrollBarPixelsPerLine();
            this.getChannel().send(forwardMouseWheelMessage);
            return;
        }
        object = new ForwardMouseMessage();
        new ForwardMouseMessage().eventType = n2;
        ((ForwardMouseMessage)object).x = n5;
        ((ForwardMouseMessage)object).y = n6;
        ((ForwardMouseMessage)object).globalX = n9;
        ((ForwardMouseMessage)object).globalY = n10;
        ((ForwardMouseMessage)object).windowX = n7;
        ((ForwardMouseMessage)object).globalY = n10;
        ((ForwardMouseMessage)object).button = n3;
        ((ForwardMouseMessage)object).clickCount = var1_1.getClickCount();
        ((ForwardMouseMessage)object).modifiers = n4;
        this.getChannel().send((Message)object);
    }

    public RenderProcessInfo getRenderProcessInfo() {
        if (this.z != null) {
            GetRenderProcessInfoMessage getRenderProcessInfoMessage = this.z.post(new GetRenderProcessInfoMessage());
            return new RenderProcessInfo((int)getRenderProcessInfoMessage.pid);
        }
        return null;
    }

    public String getCustomStyleSheet() {
        return this.A;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomStyleSheet(String customStyleSheet) {
        void var1_1;
        if (customStyleSheet == null) {
            throw new IllegalArgumentException("The customStyleSheet parameter cannot be null.");
        }
        this.A = var1_1;
    }

    private void a(long l2) {
        boolean bl;
        boolean bl2 = l2 == -1L;
        boolean bl3 = bl = l2 == -2L;
        if (bl2 || bl) {
            return;
        }
        if (this.z == null || this.z.isClosed()) {
            throw new IllegalStateException("HTML document isn't available.");
        }
        IsFrameExistsMessage isFrameExistsMessage = new IsFrameExistsMessage();
        new IsFrameExistsMessage().frameId = l2;
        isFrameExistsMessage = this.z.post(isFrameExistsMessage);
        if (!isFrameExistsMessage.result) {
            throw new IllegalArgumentException("The '" + l2 + "' frame ID doesn't exist.");
        }
    }

    static /* synthetic */ Channel a(Browser browser) {
        return browser.getChannel();
    }

    static /* synthetic */ FullScreenHandler b(Browser browser) {
        return browser.I;
    }

    static /* synthetic */ PrintHandler c(Browser browser) {
        return browser.F;
    }

    static /* synthetic */ EventQueue d(Browser browser) {
        return browser.b;
    }

    static /* synthetic */ Map e(Browser browser) {
        return browser.s;
    }

    static /* synthetic */ void a(Browser browser, Message message) {
        browser.a(message);
    }

    static /* synthetic */ DownloadHandler f(Browser browser) {
        return browser.G;
    }

    static /* synthetic */ ContextMenuHandler g(Browser browser) {
        return browser.K;
    }

    static /* synthetic */ PermissionHandler h(Browser browser) {
        return browser.H;
    }

    static /* synthetic */ void a(Browser browser, OnRenderViewCreatedMessage object) {
        v0.y = ((OnRenderViewCreatedMessage)object).renderProcessId;
        browser.B.clear();
        object = new RenderEvent(browser);
        for (RenderListener renderListener : browser.getRenderListeners()) {
            browser.b.invokeLater(new t(browser, renderListener, (RenderEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnRenderViewGoneMessage object) {
        object = new RenderEvent(browser, ((OnRenderViewGoneMessage)object).errorCode, TerminationStatus.valueOf(((OnRenderViewGoneMessage)object).terminationStatus));
        for (RenderListener renderListener : browser.getRenderListeners()) {
            browser.b.invokeLater(new ab(browser, renderListener, (RenderEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnRenderResponsiveMessage onRenderResponsiveMessage) {
        boolean bl = onRenderResponsiveMessage.responsive;
        RenderEvent renderEvent = new RenderEvent(browser);
        for (RenderListener renderListener : browser.getRenderListeners()) {
            browser.b.invokeLater(new ac(browser, bl, renderListener, renderEvent));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidStartProvisionalLoadForFrameMessage object) {
        browser.B.add(((OnDidStartProvisionalLoadForFrameMessage)object).frameId);
        object = new StartLoadingEvent(browser, ((OnDidStartProvisionalLoadForFrameMessage)object).frameId, ((OnDidStartProvisionalLoadForFrameMessage)object).parentFrameId, ((OnDidStartProvisionalLoadForFrameMessage)object).isMainFrame, ((OnDidStartProvisionalLoadForFrameMessage)object).validatedURL, ((OnDidStartProvisionalLoadForFrameMessage)object).isErrorPage);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new aa(browser, loadListener, (StartLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidCommitProvisionalLoadForFrameMessage object) {
        object = new ProvisionalLoadingEvent(browser, ((OnDidCommitProvisionalLoadForFrameMessage)object).frameId, ((OnDidCommitProvisionalLoadForFrameMessage)object).isMainFrame, ((OnDidCommitProvisionalLoadForFrameMessage)object).url);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new y(browser, loadListener, (ProvisionalLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidFinishLoadMessage object) {
        object = new FinishLoadingEvent(browser, ((OnDidFinishLoadMessage)object).frameId, ((OnDidFinishLoadMessage)object).isMainFrame, ((OnDidFinishLoadMessage)object).validatedURL);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new x(browser, loadListener, (FinishLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidFailProvisionalLoadMessage object) {
        object = new FailLoadingEvent(browser, ((OnDidFailProvisionalLoadMessage)object).frameId, ((OnDidFailProvisionalLoadMessage)object).isMainFrame, ((OnDidFailProvisionalLoadMessage)object).validatedURL, NetError.valueOf(((OnDidFailProvisionalLoadMessage)object).errorCode), ((OnDidFailProvisionalLoadMessage)object).errorDescription);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new w(browser, loadListener, (FailLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDidFailLoadMessage object) {
        object = new FailLoadingEvent(browser, ((OnDidFailLoadMessage)object).frameId, ((OnDidFailLoadMessage)object).isMainFrame, ((OnDidFailLoadMessage)object).validatedURL, NetError.valueOf(((OnDidFailLoadMessage)object).errorCode), ((OnDidFailLoadMessage)object).errorDescription);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new r(browser, loadListener, (FailLoadingEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDocumentAvailableInMainFrameMessage object) {
        object = new LoadEvent(browser);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new v(browser, loadListener, (LoadEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnDocumentLoadedInFrameMessage object) {
        object = new FrameLoadEvent(browser, ((OnDocumentLoadedInFrameMessage)object).frameId, ((OnDocumentLoadedInFrameMessage)object).isMainFrame);
        for (LoadListener loadListener : browser.getLoadListeners()) {
            browser.b.invokeLater(new u(browser, loadListener, (FrameLoadEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnTitleChangeMessage object) {
        object = new TitleEvent(browser, ((OnTitleChangeMessage)object).title);
        for (TitleListener titleListener : browser.getTitleListeners()) {
            browser.b.invokeLater(new s(browser, titleListener, (TitleEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnShouldCreateWebContentsMessage onShouldCreateWebContentsMessage) {
        Object object = onShouldCreateWebContentsMessage.frameName;
        String string = onShouldCreateWebContentsMessage.targetURL;
        if (browser.E != null) {
            object = new PopupParams(browser, (String)object, string);
            browser.J = browser.E.handlePopup((PopupParams)object);
            onShouldCreateWebContentsMessage.shouldCreate = browser.J != null;
        }
    }

    static /* synthetic */ void a(Browser browser, OnAddNewContentsMessage object) {
        Object object2;
        int n2 = ((OnAddNewContentsMessage)object).channelId;
        IPC iPC = browser.getIPC();
        if (!iPC.hasChannel(n2, ChannelType.Browser)) {
            iPC.waitChannel(n2, ChannelType.Browser);
        }
        if ((object2 = iPC.getChannel(n2, ChannelType.Browser)) != null) {
            object2 = new Browser(browser.d, browser.getContext(), (Channel)object2, browser.y);
            object = ((OnAddNewContentsMessage)object).initialBounds;
            if (browser.J != null) {
                browser.J.insertBrowser((Browser)object2, (Rectangle)object);
                browser.J = null;
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnShowContextMenuMessage object) {
        if (browser.K != null) {
            MediaType mediaType = MediaType.valueOf(((OnShowContextMenuMessage)object).mediaType);
            ContextMenu contextMenu = new ContextMenu(al.a(((OnShowContextMenuMessage)object).menuItems), browser.c);
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(((OnShowContextMenuMessage)object).dictionarySuggestions, "|");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            object = new ContextMenuParams(browser, mediaType, ((OnShowContextMenuMessage)object).x, ((OnShowContextMenuMessage)object).y, ((OnShowContextMenuMessage)object).linkURL, ((OnShowContextMenuMessage)object).linkText, ((OnShowContextMenuMessage)object).srcURL, ((OnShowContextMenuMessage)object).isImageBlocked, ((OnShowContextMenuMessage)object).pageURL, ((OnShowContextMenuMessage)object).frameURL, ((OnShowContextMenuMessage)object).frameId, ((OnShowContextMenuMessage)object).selectionText, ((OnShowContextMenuMessage)object).misspelledWord, ((OnShowContextMenuMessage)object).frameCharset, contextMenu, arrayList);
            browser.b.invokeLater(new q(browser, (ContextMenuParams)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnBeforeDownloadMessage onBeforeDownloadMessage) {
        File file = new File(onBeforeDownloadMessage.destinationFile);
        int n2 = onBeforeDownloadMessage.percentComplete;
        long l2 = onBeforeDownloadMessage.receivedBytes;
        long l3 = onBeforeDownloadMessage.totalBytes;
        long l4 = onBeforeDownloadMessage.currentSpeed;
        boolean bl = onBeforeDownloadMessage.isPaused;
        boolean bl2 = onBeforeDownloadMessage.isCanceled;
        boolean bl3 = onBeforeDownloadMessage.isCompleted;
        String string = onBeforeDownloadMessage.mimeType;
        String string2 = onBeforeDownloadMessage.url;
        int n3 = onBeforeDownloadMessage.id;
        MutableDownloadItem mutableDownloadItem = new MutableDownloadItem(browser, browser.getIPC().getMainChannel(), browser.c, file, n2, l2, l3, l4, bl, bl2, bl3, string, string2, n3);
        browser.b.invokeLater(new p(browser, mutableDownloadItem));
    }

    static /* synthetic */ void a(Browser object, OnWindowCloseMessage onWindowCloseMessage) {
        object = new Thread((Runnable)new l((Browser)object), "Window Closing Thread");
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    static /* synthetic */ void a(Browser browser, OnConsoleMessage object) {
        object = new ConsoleEvent(browser, ConsoleEvent.Level.valueOf(((OnConsoleMessage)object).level), ((OnConsoleMessage)object).lineNumber, ((OnConsoleMessage)object).message, ((OnConsoleMessage)object).sourceId);
        for (ConsoleListener consoleListener : browser.getConsoleListeners()) {
            browser.b.invokeLater(new i(browser, consoleListener, (ConsoleEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnStatusChangeMessage object) {
        object = new StatusEvent(browser, ((OnStatusChangeMessage)object).url);
        for (StatusListener statusListener : browser.getStatusListeners()) {
            browser.b.invokeLater(new h(browser, statusListener, (StatusEvent)object));
        }
    }

    static /* synthetic */ void a(Browser browser, OnAllowCertificateErrorMessage dataMessage) {
        int n2 = dataMessage.callbackId;
        LoadHandler loadHandler = browser.getLoadHandler();
        if (loadHandler == null) {
            dataMessage = new AllowCertificateErrorMessage();
            new AllowCertificateErrorMessage().callbackId = n2;
            ((AllowCertificateErrorMessage)dataMessage).result = 0;
            browser.a(dataMessage);
            return;
        }
        browser.b.invokeLater(new f(browser, n2, (OnAllowCertificateErrorMessage)dataMessage, loadHandler));
    }

    static /* synthetic */ void a(Browser object, OnSearchCompleteMessage onSearchCompleteMessage) {
        int n2 = onSearchCompleteMessage.requestId;
        object = ((Browser)object).t.remove(n2);
        if (object != null) {
            n2 = onSearchCompleteMessage.currentMatch;
            int n3 = onSearchCompleteMessage.numberOfMatches;
            SearchResult searchResult = new SearchResult(n2, n3);
            object.searchComplete(searchResult);
        }
    }

    static /* synthetic */ void a(Browser browser, OnPrintingDoneMessage object) {
        int n2 = ((OnPrintingDoneMessage)object).requestId;
        Object object2 = browser.s.remove(n2);
        if (object2 != null) {
            object = new PrintJobEvent(browser, ((OnPrintingDoneMessage)object).success);
            object2 = ((PrintJob)object2).getPrintJobListeners();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                PrintJobListener printJobListener = object2.next();
                browser.b.invokeLater(new aj(browser, printJobListener, (PrintJobEvent)object));
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnToggleFullscreenModeMessage onToggleFullscreenModeMessage) {
        if (onToggleFullscreenModeMessage.fullScreenEnabled) {
            browser.b.invokeLater(new ah(browser));
            return;
        }
        browser.b.invokeLater(new ai(browser));
    }

    static /* synthetic */ void a(Browser object, OnGetDefaultMediaStreamDeviceMessage onGetDefaultMediaStreamDeviceMessage) {
        block5: {
            try {
                int n2 = onGetDefaultMediaStreamDeviceMessage.deviceIndex;
                List<MediaStreamDevice> list = MediaStreamDeviceParser.parse(onGetDefaultMediaStreamDeviceMessage.devices);
                MediaStreamType mediaStreamType = MediaStreamDeviceParser.toMediaStreamType(onGetDefaultMediaStreamDeviceMessage.mediaType);
                MediaStreamDeviceRequest mediaStreamDeviceRequest = new MediaStreamDeviceRequest(mediaStreamType, list, n2);
                object = ((Browser)object).p.getMediaStreamDeviceProvider();
                if (object != null) {
                    try {
                        object.onRequestDefaultDevice(mediaStreamDeviceRequest);
                        object = mediaStreamDeviceRequest.getDefaultMediaStreamDevice();
                        onGetDefaultMediaStreamDeviceMessage.deviceIndex = list.indexOf(object);
                        break block5;
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "The MediaStreamDeviceProvider.onRequestDefaultDevice() method has thrown exception: ", exception);
                    }
                }
                return;
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "Failed to process OnGetDefaultMediaStreamDevice message", exception);
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnRequestPermissionMessage onRequestPermissionMessage) {
        ArrayList<PermissionType> arrayList = new ArrayList<PermissionType>();
        StringTokenizer object2 = new StringTokenizer(onRequestPermissionMessage.permissionTypes, " ");
        while (object2.hasMoreTokens()) {
            String string = object2.nextToken();
            arrayList.add(PermissionType.a(Integer.valueOf(string)));
        }
        for (PermissionType permissionType : arrayList) {
            browser.b.invokeLater(new ad(browser, onRequestPermissionMessage, arrayList, permissionType));
        }
    }

    static /* synthetic */ void a(Browser browser, OnRequestPluginStateMessage onRequestPluginStateMessage) {
        if (browser.y == onRequestPluginStateMessage.renderProcessId) {
            for (Long exception : browser.B) {
                PluginManager pluginManager;
                PluginFilter pluginFilter;
                if (exception != (long)onRequestPluginStateMessage.renderFrameId || (pluginFilter = (pluginManager = browser.getPluginManager()).getPluginFilter()) == null) continue;
                PluginInfo pluginInfo = PluginInfoParser.parsePluginInfo(onRequestPluginStateMessage.plugin);
                try {
                    if (pluginInfo == null) continue;
                    onRequestPluginStateMessage.isDisabled = !pluginFilter.isPluginAllowed(pluginInfo);
                }
                catch (Exception exception2) {
                    a.log(Level.SEVERE, "The PluginFilter.isPluginAllowed() method has thrown exception: ", exception2);
                }
            }
        }
    }

    static /* synthetic */ void a(Browser browser, OnGetCSSMessage onGetCSSMessage) {
        if (browser.y == onGetCSSMessage.renderProcessId) {
            for (Long l2 : browser.B) {
                if (l2 != (long)onGetCSSMessage.renderFrameId) continue;
                onGetCSSMessage.css = browser.getCustomStyleSheet();
            }
        }
    }

    final class a
    extends ChannelAdapter {
        private /* synthetic */ Browser a;

        private a(Browser browser) {
            this.a = browser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onMessageReceived(Message message) {
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnRequestPluginState) {
                Browser.a(this.a, (OnRequestPluginStateMessage)message);
                return;
            }
            if (messageType == MessageType.OnGetCSS) {
                void var1_1;
                Browser.a(this.a, (OnGetCSSMessage)var1_1);
            }
        }

        /* synthetic */ a(Browser browser, byte by) {
            this(browser);
        }
    }

    final class b
    implements CacheStorageDelegate {
        private /* synthetic */ Browser a;

        private b(Browser browser) {
            this.a = browser;
        }

        @Override
        public final void onClearCache() {
            if (this.a.z != null && !this.a.z.isClosed()) {
                this.a.z.send(new ClearWebCacheMessage());
            }
        }

        /* synthetic */ b(Browser browser, byte by) {
            this(browser);
        }
    }

    final class c
    implements ChannelListener {
        private /* synthetic */ Browser a;

        private c(Browser browser) {
            this.a = browser;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onMessageReceived(Message message) {
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnRenderViewCreated) {
                Browser.a(this.a, (OnRenderViewCreatedMessage)message);
                return;
            }
            if (messageType == MessageType.OnRenderViewGone) {
                Browser.a(this.a, (OnRenderViewGoneMessage)message);
                return;
            }
            if (messageType == MessageType.OnRenderResponsive) {
                Browser.a(this.a, (OnRenderResponsiveMessage)message);
                return;
            }
            if (messageType == MessageType.OnDidStartProvisionalLoadForFrame) {
                Browser.a(this.a, (OnDidStartProvisionalLoadForFrameMessage)message);
                return;
            }
            if (messageType == MessageType.OnDidCommitProvisionalLoadForFrame) {
                Browser.a(this.a, (OnDidCommitProvisionalLoadForFrameMessage)message);
                return;
            }
            if (messageType == MessageType.OnDidFinishLoad) {
                Browser.a(this.a, (OnDidFinishLoadMessage)message);
                return;
            }
            if (messageType == MessageType.OnDidFailProvisionalLoad) {
                Browser.a(this.a, (OnDidFailProvisionalLoadMessage)message);
                return;
            }
            if (messageType == MessageType.OnDidFailLoad) {
                Browser.a(this.a, (OnDidFailLoadMessage)message);
                return;
            }
            if (messageType == MessageType.OnDocumentAvailableInMainFrame) {
                Browser.a(this.a, (OnDocumentAvailableInMainFrameMessage)message);
                return;
            }
            if (messageType == MessageType.OnDocumentLoadedInFrame) {
                Browser.a(this.a, (OnDocumentLoadedInFrameMessage)message);
                return;
            }
            if (messageType == MessageType.OnTitleChange) {
                Browser.a(this.a, (OnTitleChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnShouldCreateWebContents) {
                Browser.a(this.a, (OnShouldCreateWebContentsMessage)message);
                return;
            }
            if (messageType == MessageType.OnAddNewContents) {
                Browser.a(this.a, (OnAddNewContentsMessage)message);
                return;
            }
            if (messageType == MessageType.OnShowContextMenu) {
                Browser.a(this.a, (OnShowContextMenuMessage)message);
                return;
            }
            if (messageType == MessageType.OnBeforeDownload) {
                Browser.a(this.a, (OnBeforeDownloadMessage)message);
                return;
            }
            if (messageType == MessageType.OnRunJavaScriptDialog) {
                this.a.o.handle(this.a, this.a.b, (OnRunJavaScriptDialogMessage)message, (Callback<Message>)new n(this.a));
                return;
            }
            if (messageType == MessageType.OnWindowClose) {
                Browser.a(this.a, (OnWindowCloseMessage)message);
                return;
            }
            if (messageType == MessageType.OnRunFileChooser) {
                this.a.o.handle(this.a, this.a.b, (OnRunFileChooserMessage)message, (Callback<Message>)new j(this.a));
                return;
            }
            if (messageType == MessageType.OnConsole) {
                Browser.a(this.a, (OnConsoleMessage)message);
                return;
            }
            if (messageType == MessageType.OnStatusChange) {
                Browser.a(this.a, (OnStatusChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnSelectClientCertificate) {
                this.a.o.handle(this.a, this.a.b, (OnSelectClientCertificateMessage)message, (Callback<Message>)new g(this.a));
                return;
            }
            if (messageType == MessageType.OnAllowCertificateError) {
                Browser.a(this.a, (OnAllowCertificateErrorMessage)message);
                return;
            }
            if (messageType == MessageType.OnSearchComplete) {
                Browser.a(this.a, (OnSearchCompleteMessage)message);
                return;
            }
            if (messageType == MessageType.OnFormRepostWarningShow) {
                this.a.o.handleReloadPostData(this.a, this.a.b, new com.teamdev.jxbrowser.chromium.e(this.a));
                return;
            }
            if (message.getType() == MessageType.OnRequestPrintSettings) {
                this.a.b.invokeLater(new com.teamdev.jxbrowser.chromium.c(this.a, (OnRequestPrintSettingsMessage)message));
                return;
            }
            if (message.getType() == MessageType.OnPrintingDone) {
                Browser.a(this.a, (OnPrintingDoneMessage)message);
                return;
            }
            if (messageType == MessageType.OnToggleFullscreen) {
                Browser.a(this.a, (OnToggleFullscreenModeMessage)message);
                return;
            }
            if (messageType == MessageType.OnShowColorDialog) {
                this.a.o.handle(this.a, this.a.b, (OnShowColorDialogMessage)message, (Callback<Message>)new k(this.a));
                return;
            }
            if (messageType == MessageType.OnGetDefaultMediaStreamDevice) {
                Browser.a(this.a, (OnGetDefaultMediaStreamDeviceMessage)message);
                return;
            }
            if (messageType == MessageType.OnRequestPermission) {
                void var1_1;
                Browser.a(this.a, (OnRequestPermissionMessage)var1_1);
            }
        }

        /* synthetic */ c(Browser browser, byte by) {
            this(browser);
        }
    }

    final class d
    extends IPCChannelAdapter {
        private /* synthetic */ Browser a;

        private d(Browser browser) {
            this.a = browser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public final void onChannelAdded(Channel channel) {
            boolean bl;
            boolean bl2 = channel.getType() == ChannelType.Render;
            boolean bl3 = bl = channel.getBrowserId() == this.a.c.getBrowserId();
            if (bl2 && bl) {
                Browser browser = this.a;
                synchronized (browser) {
                    void var1_1;
                    if (this.a.z != null) {
                        this.a.z.removeChannelListener(this.a.w);
                    }
                    this.a.z = (Channel)var1_1;
                    this.a.z.addChannelListener(this.a.w);
                    return;
                }
            }
        }

        /* synthetic */ d(Browser browser, byte by) {
            this(browser);
        }
    }

    final class e
    implements ChannelListener {
        private /* synthetic */ Browser a;

        private e(Browser browser) {
            this.a = browser;
        }

        @Override
        public final void onMessageReceived(Message message) {
            block11: {
                Object object = message.getType();
                if (object == MessageType.OnHandleLoad) {
                    object = (OnHandleLoadMessage)message;
                    message = this;
                    LoadHandler loadHandler = ((e)message).a.getLoadHandler();
                    if (loadHandler != null) {
                        String string = ((OnHandleLoadMessage)object).url;
                        LoadParams.LoadType loadType = LoadParams.LoadType.valueOf(((OnHandleLoadMessage)object).loadType);
                        LoadParams.LoadPolicy loadPolicy = LoadParams.LoadPolicy.valueOf(((OnHandleLoadMessage)object).loadPolicy);
                        try {
                            if (!((OnHandleLoadMessage)object).isBackForward) {
                                ((OnHandleLoadMessage)object).cancel = loadHandler.onLoad(new LoadParams(string, loadType, loadPolicy, ((OnHandleLoadMessage)object).isRedirect));
                            }
                            break block11;
                        }
                        catch (Exception exception) {
                            a.log(Level.SEVERE, "The LoadHandler.onLoad() method has thrown exception: ", exception);
                        }
                    }
                    return;
                }
                if (object == MessageType.OnDidCreateScriptContext) {
                    object = (OnDidCreateScriptContextMessage)message;
                    message = this;
                    long l2 = ((OnDidCreateScriptContextMessage)object).frameId;
                    long l3 = ((OnDidCreateScriptContextMessage)object).worldId;
                    JSContext jSContext = ((e)message).a.m.a(l2, l3);
                    if (jSContext != null) {
                        ((e)message).a.m.b(jSContext);
                        jSContext.a();
                    }
                    jSContext = new JSContext(((e)message).a.z, l2, l3, ((OnDidCreateScriptContextMessage)object).contextPtr);
                    ((e)message).a.m.a(jSContext);
                    super.b(jSContext);
                    return;
                }
                if (object == MessageType.OnDidRemoveScriptContext) {
                    object = (OnDidRemoveScriptContextMessage)message;
                    message = this;
                    long l4 = ((OnDidRemoveScriptContextMessage)object).frameId;
                    long l5 = ((OnDidRemoveScriptContextMessage)object).worldId;
                    JSContext jSContext = ((e)message).a.m.a(l4, l5);
                    if (jSContext != null) {
                        ((OnDidRemoveScriptContextMessage)object).contextPtr = jSContext.b();
                        ((e)message).a.m.b(jSContext);
                        jSContext.a();
                        super.a(jSContext);
                    }
                    return;
                }
                if (object == MessageType.OnSpellCheckCompleted) {
                    e e2;
                    object = (OnSpellCheckCompletedMessage)((Object)e2);
                    e2 = this;
                    String string = ((OnSpellCheckCompletedMessage)object).text;
                    String string2 = ((OnSpellCheckCompletedMessage)object).result;
                    String[] stringArray = string2.isEmpty() ? new String[]{} : string2.split(";");
                    ArrayList<SpellCheckResult> arrayList = new ArrayList<SpellCheckResult>();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object = Integer.parseInt(stringArray[n2++]);
                        Integer n3 = Integer.parseInt(stringArray[n2++]);
                        arrayList.add(new SpellCheckResult((Integer)object, n3));
                    }
                    SpellCheckCompletedParams spellCheckCompletedParams = new SpellCheckCompletedParams(string, arrayList);
                    e2.a.getContext().getSpellCheckerService().a(spellCheckCompletedParams);
                }
            }
        }

        private void a(JSContext object) {
            object = new ScriptContextEvent(this.a, (JSContext)object);
            for (ScriptContextListener scriptContextListener : this.a.getScriptContextListeners()) {
                try {
                    scriptContextListener.onScriptContextDestroyed((ScriptContextEvent)object);
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The ScriptContextListener.onScriptContextDestroyed() method has thrown exception: ", exception);
                }
            }
        }

        private void b(JSContext object) {
            object = new ScriptContextEvent(this.a, (JSContext)object);
            for (ScriptContextListener scriptContextListener : this.a.getScriptContextListeners()) {
                try {
                    scriptContextListener.onScriptContextCreated((ScriptContextEvent)object);
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The ScriptContextListener.onScriptContextCreated() method has thrown exception: ", exception);
                }
            }
        }

        /* synthetic */ e(Browser browser, byte by) {
            this(browser);
        }
    }
}

