/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BrowserContextParams;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.NetworkService;
import com.teamdev.jxbrowser.chromium.NotificationService;
import com.teamdev.jxbrowser.chromium.ProtocolService;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.SpellCheckerService;
import com.teamdev.jxbrowser.chromium.StorageType;
import com.teamdev.jxbrowser.chromium.ZoomService;
import com.teamdev.jxbrowser.chromium.internal.BrowserContextIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import java.util.concurrent.atomic.AtomicInteger;

public final class BrowserContext {
    private static final BrowserContext a = new BrowserContext(new BrowserContextParams(BrowserPreferences.getDefaultDataDir()), -1);
    private final int b;
    private final IPC c;
    private final String d;
    private final String e;
    private final String f;
    private final String g;
    private final StorageType h;
    private final ProxyConfig i;
    private final ZoomService j;
    private final NotificationService k;
    private final NetworkService l;
    private final SpellCheckerService m;
    private final ProtocolService n;
    private final AtomicInteger o;

    /*
     * WARNING - void declaration
     */
    public BrowserContext(BrowserContextParams params) {
        this((BrowserContextParams)var1_1, BrowserContextIDGenerator.generate());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private BrowserContext(BrowserContextParams params, int id) {
        this((BrowserContextParams)var1_1, (int)var2_2, IPC.getDefault());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private BrowserContext(BrowserContextParams params, int id, IPC ipc) {
        void var3_3;
        void var2_2;
        BrowserContext browserContext;
        if (params == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.b = id;
        this.c = ipc;
        this.o = new AtomicInteger();
        this.d = params.getDataDir();
        this.e = params.getCacheDir();
        this.f = params.getMemoryDir();
        this.g = params.getAcceptLanguage();
        this.h = params.getStorageType();
        this.i = ((BrowserContextParams)((Object)browserContext)).getProxyConfig();
        this.j = new ZoomService(id, ipc);
        this.l = new NetworkService(id, ipc);
        this.m = new SpellCheckerService(id, ipc);
        this.k = new NotificationService(id, ipc);
        this.n = new ProtocolService((int)var2_2, (IPC)var3_3);
        browserContext = this;
        if (browserContext.getStorageType() == StorageType.DISK) {
            FileUtil.createDirs(browserContext.d);
            FileUtil.createDirs(browserContext.e);
        }
        if (!Environment.isWindows()) {
            FileUtil.createDirs(browserContext.f);
        }
    }

    public static BrowserContext defaultContext() {
        return a;
    }

    public final String getDataDir() {
        return this.d;
    }

    public final String getCacheDir() {
        return this.e;
    }

    public final String getMemoryDir() {
        return this.f;
    }

    public final String getAcceptLanguage() {
        return this.g;
    }

    public final StorageType getStorageType() {
        return this.h;
    }

    public final ProxyConfig getProxyConfig() {
        return this.i;
    }

    public final NetworkService getNetworkService() {
        return this.l;
    }

    public final ZoomService getZoomService() {
        return this.j;
    }

    public final SpellCheckerService getSpellCheckerService() {
        return this.m;
    }

    public final ProtocolService getProtocolService() {
        return this.n;
    }

    public final int getIdentifier() {
        return this.b;
    }

    public final NotificationService getNotificationService() {
        return this.k;
    }

    final IPC a() {
        return this.c;
    }

    final boolean b() {
        return this.o.intValue() > 0;
    }

    final void c() {
        this.o.incrementAndGet();
    }

    final void d() {
        if (!this.l.a().isInitialized()) {
            this.l.a().initialize();
        }
        if (!this.j.a().isInitialized()) {
            this.j.a().initialize();
        }
        if (!this.k.a().isInitialized()) {
            this.k.a().initialize();
        }
    }

    final void e() {
        this.o.decrementAndGet();
    }

    final void f() {
        if (this.l.a().isInitialized()) {
            this.l.a().uninitialize();
        }
        if (this.j.a().isInitialized()) {
            this.j.a().uninitialize();
        }
        if (this.k.a().isInitialized()) {
            this.k.a().uninitialize();
        }
    }
}

