/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFile;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFiles;
import java.io.File;
import java.util.logging.Logger;

public class ChromiumVerifier {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public boolean verify(File chromiumDir, ChromiumFiles chromiumFiles) {
        for (ChromiumFile chromiumFile : chromiumFiles.getFiles()) {
            String string = chromiumFile.getFileName();
            File file = new File(chromiumDir, string);
            a.fine("Verifying " + file.getAbsolutePath() + "...");
            long l2 = chromiumFile.getFileSizeInBytes();
            if (l2 != 0L) {
                long l3 = file.length();
                a.fine("Expected size: " + l2 + " bytes, actual size: " + l3 + " bytes");
                if (l2 != l3) {
                    String string2 = "Chromium binaries verification has been failed: incorrect size of " + string + ". Expected size: " + l2 + " bytes. Actual size: " + l3 + " bytes";
                    a.info(string2);
                    return false;
                }
                a.fine("Verifying " + file.getAbsolutePath() + "... [OK]");
                continue;
            }
            a.fine("Skipping file verification because of missing expected size...");
        }
        return true;
    }
}

