/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ReflectionUtil {
    public static <R, T> R invokeMethod(T instance, String methodName) {
        try {
            T t2;
            Method method;
            method = ReflectionUtil.getMethod(instance.getClass(), (String)((Object)method));
            method.setAccessible(true);
            return (R)method.invoke(t2, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public static Method getMethod(Class<?> instance, String methodName) {
        while (true) {
            if (instance == null) {
                throw new NoSuchMethodException(methodName);
            }
            try {
                return instance.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                instance = instance.getSuperclass();
                continue;
            }
            break;
        }
    }

    public static Field findPublicFieldByName(Class<?> cls, String propName) {
        while (cls != null) {
            Field[] fieldArray = cls.getDeclaredFields();
            Field[] fieldArray2 = fieldArray;
            fieldArray2 = fieldArray;
            int n2 = fieldArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = fieldArray2[i2];
                if (!propName.equals(field.getName()) || !Modifier.isPublic(field.getModifiers())) continue;
                return field;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Field findFieldByName(Class<?> cls, String propName) {
        while (cls != null) {
            Field[] fieldArray = cls.getDeclaredFields();
            Field[] fieldArray2 = fieldArray;
            fieldArray2 = fieldArray;
            int n2 = fieldArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = fieldArray2[i2];
                if (!propName.equals(field.getName())) continue;
                return field;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Method findPublicMethodByName(Class<?> cls, String name) {
        while (cls != null) {
            Method[] methodArray = cls.getDeclaredMethods();
            Method[] methodArray2 = methodArray;
            methodArray2 = methodArray;
            int n2 = methodArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method = methodArray2[i2];
                if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers())) continue;
                return method;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }
}

