/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessLinux32;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessLinux64;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessMac;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessWin32;
import com.teamdev.jxbrowser.chromium.internal.ipc.InternalChromiumProcess;

public final class ChromiumProcessFactory {
    public static ChromiumProcess create(String chromiumDir) {
        if (Environment.isWindows()) {
            return new ExternalChromiumProcessWin32(chromiumDir);
        }
        if (Environment.isMac()) {
            if (Boolean.getBoolean("jxbrowser.ipc.external")) {
                return new ExternalChromiumProcessMac(chromiumDir);
            }
            return new InternalChromiumProcess(chromiumDir);
        }
        if (Environment.isLinux()) {
            if (Environment.is32Bit()) {
                return new ExternalChromiumProcessLinux32(chromiumDir);
            }
            if (Environment.is64Bit()) {
                String string;
                return new ExternalChromiumProcessLinux64(string);
            }
        }
        throw new IllegalStateException("Unsupported operating system.");
    }
}

