/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.ConnectionFunc;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.PyExtendedCursor;
import com.ziclix.python.sql.PyStatement;
import com.ziclix.python.sql.zxJDBC;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.python.core.ClassDictInit;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.util.Generic;

public class PyConnection
extends PyObject
implements ClassDictInit,
ContextManager {
    protected boolean closed = false;
    protected boolean supportsTransactions;
    protected boolean supportsMultipleResultSets;
    protected Connection connection;
    private Set<PyCursor> cursors = Collections.synchronizedSet(this.cursors);
    private Set<PyStatement> statements;
    protected static PyList __members__;
    protected static PyList __methods__;

    public PyConnection(Connection connection) throws SQLException {
        this.connection = connection;
        this.statements = Generic.newSetFromMap(new WeakHashMap());
        this.statements = Collections.synchronizedSet(this.statements);
        this.supportsTransactions = this.connection.getMetaData().supportsTransactions();
        this.supportsMultipleResultSets = this.connection.getMetaData().supportsMultipleResultSets();
        if (this.supportsTransactions) {
            this.connection.setAutoCommit(false);
        }
    }

    public String toString() {
        try {
            return String.format("<PyConnection object at %s user='%s', url='%s'>", Py.idstr(this), this.connection.getMetaData().getUserName(), this.connection.getMetaData().getURL());
        }
        catch (SQLException e) {
            return String.format("<PyConnection object at %s", Py.idstr(this));
        }
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__version__", (PyObject)Py.newString("7290"));
        dict.__setitem__("autocommit", (PyObject)new PyInteger(0));
        dict.__setitem__("close", (PyObject)new ConnectionFunc("close", 0, 0, 0, zxJDBC.getString("close")));
        dict.__setitem__("commit", (PyObject)new ConnectionFunc("commit", 1, 0, 0, zxJDBC.getString("commit")));
        dict.__setitem__("cursor", (PyObject)new ConnectionFunc("cursor", 2, 0, 4, zxJDBC.getString("cursor")));
        dict.__setitem__("rollback", (PyObject)new ConnectionFunc("rollback", 3, 0, 0, zxJDBC.getString("rollback")));
        dict.__setitem__("nativesql", (PyObject)new ConnectionFunc("nativesql", 4, 1, 1, zxJDBC.getString("nativesql")));
        dict.__setitem__("__enter__", (PyObject)new ConnectionFunc("__enter__", 5, 0, 0, "__enter__"));
        dict.__setitem__("__exit__", (PyObject)new ConnectionFunc("__exit__", 6, 3, 3, "__exit__"));
        dict.__setitem__("initModule", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("setConnection", null);
        dict.__setitem__("getPyClass", null);
        dict.__setitem__("connection", null);
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("cursors", null);
    }

    public void __setattr__(String name, PyObject value) {
        if ("autocommit".equals(name)) {
            try {
                if (this.supportsTransactions) {
                    this.connection.setAutoCommit(value.__nonzero__());
                }
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
            return;
        }
        super.__setattr__(name, value);
    }

    public PyObject __findattr_ex__(String name) {
        if ("autocommit".equals(name)) {
            try {
                return this.connection.getAutoCommit() ? Py.One : Py.Zero;
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        if ("dbname".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDatabaseProductName());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        if ("dbversion".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDatabaseProductVersion());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        if ("drivername".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDriverName());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        if ("driverversion".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDriverVersion());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        if ("url".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getURL());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        if ("__connection__".equals(name)) {
            return Py.java2py(this.connection);
        }
        if ("__cursors__".equals(name)) {
            return Py.java2py(Collections.unmodifiableSet(this.cursors));
        }
        if ("__statements__".equals(name)) {
            return Py.java2py(Collections.unmodifiableSet(this.statements));
        }
        if ("__methods__".equals(name)) {
            return __methods__;
        }
        if ("__members__".equals(name)) {
            return __members__;
        }
        if ("closed".equals(name)) {
            return Py.newBoolean(this.closed);
        }
        return super.__findattr_ex__(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        this.closed = true;
        Set<PyObject> set = this.cursors;
        synchronized (set) {
            for (PyCursor cursor : this.cursors) {
                cursor.close();
            }
            this.cursors.clear();
        }
        set = this.statements;
        synchronized (set) {
            for (PyStatement statement : this.statements) {
                statement.close();
            }
            this.statements.clear();
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(e);
        }
    }

    public void commit() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        if (!this.supportsTransactions) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(e);
        }
    }

    public void rollback() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        if (!this.supportsTransactions) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(e);
        }
    }

    public PyObject nativesql(PyObject nativeSQL) {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        if (nativeSQL == Py.None) {
            return Py.None;
        }
        try {
            if (nativeSQL instanceof PyUnicode) {
                return Py.newUnicode(this.connection.nativeSQL(nativeSQL.toString()));
            }
            return Py.newString(this.connection.nativeSQL(nativeSQL.__str__().toString()));
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(e);
        }
    }

    public PyCursor cursor() {
        return this.cursor(false);
    }

    public PyCursor cursor(boolean dynamicFetch) {
        return this.cursor(dynamicFetch, Py.None, Py.None);
    }

    public PyCursor cursor(boolean dynamicFetch, PyObject rsType, PyObject rsConcur) {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        PyExtendedCursor cursor = new PyExtendedCursor(this, dynamicFetch, rsType, rsConcur);
        this.cursors.add(cursor);
        return cursor;
    }

    void remove(PyCursor cursor) {
        if (this.closed) {
            return;
        }
        this.cursors.remove(cursor);
    }

    void add(PyStatement statement) {
        if (this.closed) {
            return;
        }
        this.statements.add(statement);
    }

    boolean contains(PyStatement statement) {
        if (this.closed) {
            return false;
        }
        return this.statements.contains(statement);
    }

    public PyObject __enter__(ThreadState ts) {
        return this;
    }

    public PyObject __enter__() {
        return this;
    }

    public boolean __exit__(ThreadState ts, PyException exception) {
        if (exception == null) {
            this.commit();
        } else {
            this.rollback();
        }
        return false;
    }

    public boolean __exit__(PyObject type, PyObject value, PyObject traceback2) {
        if (type == null || type == Py.None) {
            this.commit();
        } else {
            this.rollback();
        }
        return false;
    }

    static {
        PyObject[] m = new PyObject[]{new PyString("close"), new PyString("commit"), new PyString("cursor"), new PyString("rollback"), new PyString("nativesql")};
        __methods__ = new PyList(m);
        m = new PyObject[]{new PyString("autocommit"), new PyString("dbname"), new PyString("dbversion"), new PyString("drivername"), new PyString("driverversion"), new PyString("url"), new PyString("__connection__"), new PyString("__cursors__"), new PyString("__statements__"), new PyString("closed")};
        __members__ = new PyList(m);
    }
}

