/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.gradle.eclipse.GradleImport;
import com.android.tools.gradle.eclipse.ImportSummary;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;

abstract class ImportModule
implements Comparable<ImportModule> {
    private static final String LATEST = "+";
    private static final String APPCOMPAT_DEP = "com.android.support:appcompat-v7:+";
    private static final String GRID_LAYOUT_DEP = "com.android.support:gridlayout-v7:+";
    private static final String SUPPORT_LIB_DEP = "com.android.support:support-v4:+";
    private static final String SHERLOCK_DEP = "com.actionbarsherlock:actionbarsherlock:4.4.0@aar";
    private static final String PLAY_SERVICES_DEP = "com.google.android.gms:play-services:+";
    protected final GradleImport mImporter;
    protected final List<GradleCoordinate> mDependencies = Lists.newArrayList();
    protected final List<GradleCoordinate> mTestDependencies = Lists.newArrayList();
    protected final List<File> mJarDependencies = Lists.newArrayList();
    protected final List<File> mTestJarDependencies = Lists.newArrayList();
    protected List<GradleCoordinate> mReplaceWithDependencies;
    private String mModuleName;

    public ImportModule(@NonNull GradleImport importer) {
        this.mImporter = importer;
    }

    protected abstract boolean isLibrary();

    protected abstract boolean isApp();

    protected abstract boolean isAndroidLibrary();

    protected abstract boolean isAndroidProject();

    protected abstract boolean isJavaLibrary();

    protected abstract boolean isNdkProject();

    protected abstract int getCompileSdkVersion();

    protected abstract int getMinSdkVersion();

    protected abstract int getTargetSdkVersion();

    @NonNull
    protected abstract String getOriginalName();

    @NonNull
    protected abstract List<File> getSourcePaths();

    @NonNull
    protected abstract List<File> getJarPaths();

    @NonNull
    protected abstract List<File> getTestJarPaths();

    @NonNull
    protected abstract List<File> getNativeLibs();

    @NonNull
    protected abstract File resolveFile(@NonNull File var1);

    @NonNull
    protected abstract File getCanonicalModuleDir();

    @NonNull
    protected abstract List<File> getLocalProguardFiles();

    @NonNull
    protected abstract List<File> getSdkProguardFiles();

    @NonNull
    protected abstract String getLanguageLevel();

    @NonNull
    protected abstract List<ImportModule> getDirectDependencies();

    @NonNull
    protected abstract List<ImportModule> getAllDependencies();

    @Nullable
    protected abstract String getPackage();

    @Nullable
    protected abstract File getLintXml();

    @Nullable
    protected abstract File getOutputDir();

    @Nullable
    protected abstract File getManifestFile();

    @Nullable
    protected abstract File getResourceDir();

    @Nullable
    protected abstract File getAssetsDir();

    @Nullable
    protected abstract File getNativeSources();

    @Nullable
    protected abstract String getNativeModuleName();

    @Nullable
    protected abstract File getInstrumentationDir();

    public void initialize() {
        this.initDependencies();
        this.initReplaceWithDependency();
    }

    protected void initDependencies() {
    }

    @Nullable
    GradleCoordinate guessDependency(@NonNull File jar) {
        String name = jar.getName().toLowerCase(Locale.US);
        if (name.equals("android-support-v4.jar")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)SUPPORT_LIB_DEP);
        }
        if (name.equals("android-support-v7-gridlayout.jar")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)GRID_LAYOUT_DEP);
        }
        if (name.equals("android-support-v7-appcompat.jar")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)APPCOMPAT_DEP);
        }
        if (name.equals("com_actionbarsherlock.jar") || name.equalsIgnoreCase("actionbarsherlock.jar")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)SHERLOCK_DEP);
        }
        if (name.equals("guava.jar") || name.startsWith("guava-")) {
            this.mImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "guava-", name, "15.0");
            if (version.startsWith("r")) {
                version = "15.0";
            }
            return GradleCoordinate.parseCoordinateString((String)("com.google.guava:guava:" + version));
        }
        if (name.startsWith("joda-time")) {
            this.mImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "joda-time-", name, "2.3");
            return GradleCoordinate.parseCoordinateString((String)("joda-time:joda-time:" + version));
        }
        if (name.startsWith("robotium-solo-")) {
            this.mImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "robotium-solo-", name, "4.3.1");
            return GradleCoordinate.parseCoordinateString((String)("com.jayway.android.robotium:robotium-solo:" + version));
        }
        if (name.startsWith("protobuf-java-")) {
            this.mImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "protobuf-java-", name, "2.5");
            return GradleCoordinate.parseCoordinateString((String)("com.google.protobuf:protobuf-java:" + version));
        }
        if (name.startsWith("gson-")) {
            this.mImporter.markJarHandled(jar);
            String version = this.getVersion(jar, "gson-", name, "2.2.4");
            return GradleCoordinate.parseCoordinateString((String)("com.google.code.gson:gson:" + version));
        }
        if (name.startsWith("google-http-client-gson-")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)"com.google.http-client:google-http-client-gson:1.17.0-rc");
        }
        if (name.startsWith("svg-android")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)"com.github.japgolly.android:svg-android:2.0.5");
        }
        if (name.equals("gcm.jar")) {
            this.mImporter.markJarHandled(jar);
            return GradleCoordinate.parseCoordinateString((String)PLAY_SERVICES_DEP);
        }
        return null;
    }

    private String getVersion(File jar, String prefix, String jarName, String defaultVersion) {
        if (jarName.matches(prefix + "([\\d\\.]+)\\.jar")) {
            String version = jarName.substring(prefix.length(), jarName.length() - 4);
            if (!defaultVersion.equals(version)) {
                this.mImporter.getSummary().reportGuessedVersion(jar);
            }
            return version;
        }
        return defaultVersion;
    }

    private void initReplaceWithDependency() {
        String pkg;
        if (this.isLibrary() && this.mImporter.isReplaceLibs() && (pkg = this.getPackage()) != null) {
            if (pkg.equals("com.actionbarsherlock")) {
                this.mReplaceWithDependencies = Arrays.asList(GradleCoordinate.parseCoordinateString((String)SHERLOCK_DEP), GradleCoordinate.parseCoordinateString((String)SUPPORT_LIB_DEP));
            } else if (pkg.equals("android.support.v7.gridlayout")) {
                this.mReplaceWithDependencies = Collections.singletonList(GradleCoordinate.parseCoordinateString((String)GRID_LAYOUT_DEP));
            } else if (pkg.equals("com.google.android.gms")) {
                this.mReplaceWithDependencies = Collections.singletonList(GradleCoordinate.parseCoordinateString((String)PLAY_SERVICES_DEP));
            } else if (pkg.equals("android.support.v7.appcompat")) {
                this.mReplaceWithDependencies = Collections.singletonList(GradleCoordinate.parseCoordinateString((String)APPCOMPAT_DEP));
            } else if (pkg.equals("android.support.v7.mediarouter")) {
                this.mReplaceWithDependencies = Collections.singletonList(GradleCoordinate.parseCoordinateString((String)"com.android.support:support-v7-mediarouter:+"));
            }
            if (this.mReplaceWithDependencies != null) {
                this.mImporter.getSummary().reportReplacedLib(this.getOriginalName(), this.mReplaceWithDependencies);
            }
        }
    }

    public boolean isReplacedWithDependency() {
        return this.mReplaceWithDependencies != null && !this.mReplaceWithDependencies.isEmpty();
    }

    public List<GradleCoordinate> getReplaceWithDependencies() {
        return this.mReplaceWithDependencies;
    }

    public String getModuleName() {
        if (this.mModuleName == null) {
            if (this.mImporter.isGradleNameStyle() && this.mImporter.getModuleCount() == 1) {
                this.mModuleName = "app";
                return this.mModuleName;
            }
            String string = this.getOriginalName();
            StringBuilder sb = new StringBuilder(string.length());
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) continue;
                sb.append(c);
            }
            String moduleName = sb.toString();
            if (!moduleName.isEmpty() && !Character.isJavaIdentifierStart(moduleName.charAt(0))) {
                moduleName = '_' + moduleName;
            }
            if (this.mImporter.isGradleNameStyle() && !moduleName.isEmpty()) {
                moduleName = Character.toLowerCase(moduleName.charAt(0)) + moduleName.substring(1);
            }
            this.mModuleName = moduleName;
        }
        return this.mModuleName;
    }

    public String getModuleReference() {
        return ':' + this.getModuleName();
    }

    protected File getJarOutputRelativePath(File jar) {
        if (jar.isAbsolute()) {
            File relative;
            try {
                relative = GradleImport.computeRelativePath(this.getCanonicalModuleDir(), jar);
            }
            catch (IOException ioe) {
                relative = null;
            }
            jar = relative != null ? relative : new File("libs", jar.getName());
        }
        return jar;
    }

    protected static File getTestJarOutputRelativePath(File jar) {
        return new File("libs", jar.getName());
    }

    public void copyInto(@NonNull File destDir) throws IOException {
        File instrumentation;
        ImportSummary summary = this.mImporter.getSummary();
        HashSet copied = Sets.newHashSet();
        final File main = new File(destDir, "src" + File.separator + "main");
        this.mImporter.mkdirs(main);
        if (this.isAndroidProject()) {
            File lintXml;
            File srcAssets;
            File srcRes;
            File srcManifest = this.getManifestFile();
            if (srcManifest != null && srcManifest.exists()) {
                File destManifest = new File(main, "AndroidManifest.xml");
                Files.copy((File)srcManifest, (File)destManifest);
                summary.reportMoved(this, srcManifest, destManifest);
                ImportModule.recordCopiedFile(copied, srcManifest);
            }
            if ((srcRes = this.getResourceDir()) != null && srcRes.exists()) {
                File destRes = new File(main, "res");
                this.mImporter.mkdirs(destRes);
                this.mImporter.copyDir(srcRes, destRes, null);
                summary.reportMoved(this, srcRes, destRes);
                ImportModule.recordCopiedFile(copied, srcRes);
            }
            if ((srcAssets = this.getAssetsDir()) != null && srcAssets.exists()) {
                File destAssets = new File(main, "assets");
                this.mImporter.mkdirs(destAssets);
                this.mImporter.copyDir(srcAssets, destAssets, null);
                summary.reportMoved(this, srcAssets, destAssets);
                ImportModule.recordCopiedFile(copied, srcAssets);
            }
            if ((lintXml = this.getLintXml()) != null) {
                File destLintXml = new File(destDir, lintXml.getName());
                Files.copy((File)lintXml, (File)destLintXml);
                summary.reportMoved(this, lintXml, destLintXml);
                ImportModule.recordCopiedFile(copied, lintXml);
            }
        }
        for (File src : this.getSourcePaths()) {
            final File srcJava = this.resolveFile(src);
            File destJava = new File(main, "java");
            if (srcJava.isDirectory()) {
                this.mImporter.mkdirs(destJava);
            } else {
                destJava = new File(main, srcJava.getName());
            }
            this.mImporter.copyDir(srcJava, destJava, new GradleImport.CopyHandler(){

                @Override
                public boolean handle(@NonNull File source, @NonNull File dest) throws IOException {
                    String sourcePath = source.getPath();
                    if (sourcePath.endsWith(".aidl")) {
                        File aidlDir = new File(main, "aidl");
                        File relative = GradleImport.computeRelativePath(srcJava, source);
                        if (relative == null) {
                            relative = GradleImport.computeRelativePath(srcJava.getCanonicalFile(), source);
                        }
                        if (relative != null) {
                            File destAidl = new File(aidlDir, relative.getPath());
                            ImportModule.this.mImporter.mkdirs(destAidl.getParentFile());
                            Files.copy((File)source, (File)destAidl);
                            ImportModule.this.mImporter.getSummary().reportMoved(ImportModule.this, source, destAidl);
                            return true;
                        }
                    } else if (sourcePath.endsWith(".rs") || sourcePath.endsWith(".rsh") || sourcePath.endsWith(".fs")) {
                        File destRs = new File(main, "rs" + File.separator + source.getName());
                        ImportModule.this.mImporter.mkdirs(destRs.getParentFile());
                        Files.copy((File)source, (File)destRs);
                        ImportModule.this.mImporter.getSummary().reportMoved(ImportModule.this, source, destRs);
                        return true;
                    }
                    return false;
                }
            });
            summary.reportMoved(this, srcJava, destJava);
            ImportModule.recordCopiedFile(copied, srcJava);
        }
        for (File jar : this.getJarPaths()) {
            File srcJar = this.resolveFile(jar);
            File destJar = new File(destDir, this.getJarOutputRelativePath(jar).getPath());
            if (destJar.getParentFile() != null) {
                this.mImporter.mkdirs(destJar.getParentFile());
            }
            Files.copy((File)srcJar, (File)destJar);
            summary.reportMoved(this, srcJar, destJar);
            ImportModule.recordCopiedFile(copied, srcJar);
        }
        for (File lib : this.getNativeLibs()) {
            File srcLib = this.resolveFile(lib);
            String abi = lib.getParentFile().getName();
            File destLib = new File(destDir, "src" + File.separator + "main" + File.separator + "jniLibs" + File.separator + abi + File.separator + lib.getName());
            if (destLib.getParentFile() != null) {
                this.mImporter.mkdirs(destLib.getParentFile());
            }
            Files.copy((File)srcLib, (File)destLib);
            summary.reportMoved(this, srcLib, destLib);
            ImportModule.recordCopiedFile(copied, srcLib);
        }
        File jni = this.getNativeSources();
        if (jni != null) {
            File srcJni = this.resolveFile(jni);
            File destJni = new File(destDir, "src" + File.separator + "main" + File.separator + "jni");
            this.mImporter.copyDir(srcJni, destJni, null);
            summary.reportMoved(this, srcJni, destJni);
            ImportModule.recordCopiedFile(copied, srcJni);
        }
        if ((instrumentation = this.getInstrumentationDir()) != null) {
            File srcJava;
            File test = new File(destDir, "src" + File.separator + "instrumentTest");
            this.mImporter.mkdirs(test);
            ImportModule.recordCopiedFile(copied, new File(instrumentation, "AndroidManifest.xml"));
            File srcRes = new File(instrumentation, "res");
            if (srcRes.isDirectory()) {
                File destRes = new File(test, "res");
                this.mImporter.mkdirs(destRes);
                this.mImporter.copyDir(srcRes, destRes, null);
                summary.reportMoved(this, srcRes, destRes);
                ImportModule.recordCopiedFile(copied, srcRes);
            }
            if ((srcJava = new File(instrumentation, "src")).isDirectory()) {
                File destRes = new File(test, "java");
                this.mImporter.mkdirs(destRes);
                this.mImporter.copyDir(srcJava, destRes, null);
                summary.reportMoved(this, srcJava, destRes);
                ImportModule.recordCopiedFile(copied, srcJava);
            }
            for (File jar : this.getTestJarPaths()) {
                File srcJar = this.resolveFile(jar);
                File destJar = new File(destDir, ImportModule.getTestJarOutputRelativePath(jar).getPath());
                if (destJar.exists()) continue;
                if (destJar.getParentFile() != null) {
                    this.mImporter.mkdirs(destJar.getParentFile());
                }
                Files.copy((File)srcJar, (File)destJar);
                summary.reportMoved(this, srcJar, destJar);
                ImportModule.recordCopiedFile(copied, srcJar);
            }
        }
        if (this.isAndroidProject()) {
            for (File srcProguard : this.getLocalProguardFiles()) {
                File destProguard = new File(destDir, srcProguard.getName());
                if (!destProguard.exists()) {
                    Files.copy((File)srcProguard, (File)destProguard);
                    summary.reportMoved(this, srcProguard, destProguard);
                    ImportModule.recordCopiedFile(copied, srcProguard);
                    continue;
                }
                this.mImporter.reportWarning(this, destProguard, "Local proguard config file name is not unique");
            }
        }
        this.reportIgnored(copied);
    }

    private static void recordCopiedFile(@NonNull Set<File> copied, @NonNull File file) throws IOException {
        copied.add(file);
        copied.add(file.getCanonicalFile());
    }

    private void reportIgnored(Set<File> copied) throws IOException {
        File canonicalDir = this.getCanonicalModuleDir();
        File outputDir = this.getOutputDir();
        if (outputDir != null) {
            copied.add(this.resolveFile(outputDir).getCanonicalFile());
        }
        copied.add(new File(canonicalDir, "bin"));
        copied.add(new File(canonicalDir, "gen"));
        copied.add(new File(canonicalDir, ".classpath"));
        copied.add(new File(canonicalDir, ".project"));
        copied.add(new File(canonicalDir, "project.properties"));
        copied.add(new File(canonicalDir, "project.properties"));
        copied.add(new File(canonicalDir, "local.properties"));
        copied.add(new File(canonicalDir, "libs"));
        copied.add(new File(canonicalDir, ".settings"));
        copied.add(new File(canonicalDir, ".cproject"));
        if (this.isNdkProject()) {
            copied.add(new File(canonicalDir, "obj"));
        }
        this.reportIgnored(canonicalDir, copied, 0);
    }

    private boolean reportIgnored(@NonNull File file, @NonNull Set<File> copied, int depth) throws IOException {
        if (depth > 0 && copied.contains(file)) {
            return true;
        }
        boolean ignore = true;
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            if (depth == 1 && GradleImport.isIgnoredFile(file)) {
                return false;
            }
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    ignore &= this.reportIgnored(child, copied, depth + 1);
                }
            }
        } else {
            ignore = false;
        }
        if (depth > 0 && !ignore) {
            File relative = GradleImport.computeRelativePath(this.getCanonicalModuleDir(), file);
            if (relative == null) {
                relative = file;
            }
            String path = relative.getPath();
            if (isDirectory) {
                path = path + File.separator;
            }
            this.mImporter.getSummary().reportIgnored(this.getOriginalName(), path);
        }
        return ignore;
    }

    public List<File> getJarDependencies() {
        return this.mJarDependencies;
    }

    public List<GradleCoordinate> getDependencies() {
        return this.mDependencies;
    }

    public List<File> getTestJarDependencies() {
        return this.mTestJarDependencies;
    }

    public List<GradleCoordinate> getTestDependencies() {
        return this.mTestDependencies;
    }

    @Nullable
    public File computeProjectRelativePath(@NonNull File file) throws IOException {
        return GradleImport.computeRelativePath(this.getCanonicalModuleDir(), file);
    }

    protected abstract boolean dependsOn(@NonNull ImportModule var1);

    protected abstract boolean dependsOnLibrary(@NonNull String var1);

    void removeJarDependencies() {
        ListIterator<File> iterator = this.getJarPaths().listIterator();
        while (iterator.hasNext()) {
            File jar = iterator.next();
            if (this.mImporter.isJarHandled(jar)) {
                iterator.remove();
                continue;
            }
            String pkg = jar.getName();
            if (pkg.endsWith(".jar")) {
                pkg = pkg.substring(0, pkg.length() - ".jar".length());
            }
            if (!this.dependsOnLibrary(pkg = pkg.replace('-', '.'))) continue;
            iterator.remove();
        }
    }

    @Override
    public int compareTo(@NonNull ImportModule other) {
        if (this.dependsOn(other)) {
            return 1;
        }
        if (other.dependsOn(this)) {
            return -1;
        }
        return this.getOriginalName().compareTo(other.getOriginalName());
    }
}

