/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ide.eclipse.ddms.IClientAction;
import com.android.ide.eclipse.gltrace.CollectTraceAction;
import com.android.ide.eclipse.gltrace.GLTraceOptionsDialog;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import com.android.ide.eclipse.gltrace.TraceOptions;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeviceViewAction
implements IClientAction {
    private static final StartTraceAction sAction = new StartTraceAction();

    public Action getAction() {
        return sAction;
    }

    public void selectedClientChanged(Client client) {
        sAction.setClient(client);
    }

    private static final class StartTraceAction
    extends Action {
        private static final int LOCAL_FORWARDED_PORT = 6049;
        private Client mClient;

        public StartTraceAction() {
            super("Start OpenGL Trace");
            this.setImageDescriptor(GlTracePlugin.getImageDescriptor("/icons/connect.png"));
            this.setClient(null);
        }

        public void setClient(Client client) {
            this.mClient = client;
            this.clientChanged();
        }

        private void clientChanged() {
            if (this.mClient == null) {
                this.setEnabled(false);
                return;
            }
            ClientData clientData = this.mClient.getClientData();
            if (clientData.hasFeature("opengl-tracing")) {
                this.setEnabled(true);
                this.setToolTipText("Trace OpenGL calls");
            } else {
                this.setEnabled(false);
                this.setToolTipText("Selected VM does not support tracing OpenGL calls");
            }
        }

        public void run() {
            if (this.mClient == null) {
                return;
            }
            Shell shell = Display.getDefault().getActiveShell();
            GLTraceOptionsDialog gLTraceOptionsDialog = new GLTraceOptionsDialog(shell, false, this.mClient.getClientData().getClientDescription());
            if (gLTraceOptionsDialog.open() != 0) {
                return;
            }
            this.mClient.startOpenGlTracing();
            try {
                CollectTraceAction.setupForwarding(this.mClient.getDevice(), 6049);
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)shell, (String)"Setup GL Trace", (String)("Error while setting up port forwarding: " + exception.getMessage()));
                return;
            }
            try {
                new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        Thread.sleep(3000L);
                    }
                });
            }
            catch (Exception exception) {}
            TraceOptions traceOptions = gLTraceOptionsDialog.getTraceOptions();
            CollectTraceAction.startTracing(shell, traceOptions, 6049);
            this.mClient.stopOpenGlTracing();
            CollectTraceAction.disablePortForwarding(this.mClient.getDevice(), 6049);
            CollectTraceAction.openInEditor(shell, traceOptions.traceDestination);
        }
    }
}

