/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFileSystem;
import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.ReadOnlyException;
import de.waldheinz.fs.fat.AbstractDirectory;
import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.ClusterChain;
import de.waldheinz.fs.fat.ClusterChainDirectory;
import de.waldheinz.fs.fat.Fat;
import de.waldheinz.fs.fat.Fat16BootSector;
import de.waldheinz.fs.fat.Fat16RootDirectory;
import de.waldheinz.fs.fat.Fat32BootSector;
import de.waldheinz.fs.fat.FatLfnDirectory;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.FatUtils;
import de.waldheinz.fs.fat.FsInfoSector;
import java.io.IOException;

public final class FatFileSystem
extends AbstractFileSystem {
    private final Fat fat;
    private final FsInfoSector fsiSector;
    private final BootSector bs;
    private final FatLfnDirectory rootDir;
    private final AbstractDirectory rootDirStore;
    private final FatType fatType;
    private final long filesOffset;

    FatFileSystem(BlockDevice api, boolean readOnly) throws IOException {
        this(api, readOnly, false);
    }

    private FatFileSystem(BlockDevice device, boolean readOnly, boolean ignoreFatDifferences) throws IOException {
        super(readOnly);
        this.bs = BootSector.read(device);
        if (this.bs.getNrFats() <= 0) {
            throw new IOException("boot sector says there are no FATs");
        }
        this.filesOffset = FatUtils.getFilesOffset(this.bs);
        this.fatType = this.bs.getFatType();
        this.fat = Fat.read(this.bs, 0);
        if (!ignoreFatDifferences) {
            for (int i = 1; i < this.bs.getNrFats(); ++i) {
                Fat tmpFat = Fat.read(this.bs, i);
                if (this.fat.equals(tmpFat)) continue;
                throw new IOException("FAT " + i + " differs from FAT 0");
            }
        }
        if (this.fatType == FatType.FAT32) {
            Fat32BootSector f32bs = (Fat32BootSector)this.bs;
            ClusterChain rootDirFile = new ClusterChain(this.fat, f32bs.getRootDirFirstCluster(), this.isReadOnly());
            this.rootDirStore = ClusterChainDirectory.readRoot(rootDirFile);
            this.fsiSector = FsInfoSector.read(f32bs);
            if (this.fsiSector.getFreeClusterCount() != (long)this.fat.getFreeClusterCount()) {
                throw new IOException("free cluster count mismatch - fat: " + this.fat.getFreeClusterCount() + " - fsinfo: " + this.fsiSector.getFreeClusterCount());
            }
        } else {
            this.rootDirStore = Fat16RootDirectory.read((Fat16BootSector)this.bs, readOnly);
            this.fsiSector = null;
        }
        this.rootDir = new FatLfnDirectory(this.rootDirStore, this.fat, this.isReadOnly());
    }

    public static FatFileSystem read(BlockDevice device, boolean readOnly) throws IOException {
        return new FatFileSystem(device, readOnly);
    }

    long getFilesOffset() {
        this.checkClosed();
        return this.filesOffset;
    }

    public FatType getFatType() {
        this.checkClosed();
        return this.fatType;
    }

    public String getVolumeLabel() {
        this.checkClosed();
        String fromDir = this.rootDirStore.getLabel();
        if (fromDir == null && this.fatType != FatType.FAT32) {
            return ((Fat16BootSector)this.bs).getVolumeLabel();
        }
        return fromDir;
    }

    public void setVolumeLabel(String label) throws ReadOnlyException, IOException {
        this.checkClosed();
        this.checkReadOnly();
        this.rootDirStore.setLabel(label);
        if (this.fatType != FatType.FAT32) {
            ((Fat16BootSector)this.bs).setVolumeLabel(label);
        }
    }

    AbstractDirectory getRootDirStore() {
        this.checkClosed();
        return this.rootDirStore;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        if (this.bs.isDirty()) {
            this.bs.write();
        }
        for (int i = 0; i < this.bs.getNrFats(); ++i) {
            this.fat.writeCopy(FatUtils.getFatOffset(this.bs, i));
        }
        this.rootDir.flush();
        if (this.fsiSector != null) {
            this.fsiSector.setFreeClusterCount(this.fat.getFreeClusterCount());
            this.fsiSector.setLastAllocatedCluster(this.fat.getLastAllocatedCluster());
            this.fsiSector.write();
        }
    }

    @Override
    public FatLfnDirectory getRoot() {
        this.checkClosed();
        return this.rootDir;
    }

    public Fat getFat() {
        return this.fat;
    }

    public BootSector getBootSector() {
        this.checkClosed();
        return this.bs;
    }

    @Override
    public long getFreeSpace() {
        return this.fat.getFreeClusterCount() * this.bs.getBytesPerCluster();
    }

    @Override
    public long getTotalSpace() {
        return this.bs.getDataClusterCount() * (long)this.bs.getBytesPerCluster();
    }

    @Override
    public long getUsableSpace() {
        return -1L;
    }
}

