/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import com.android.sdklib.util.GrabProcessOutput;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AvdManager {
    private static final Pattern INI_LINE_PATTERN = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final String AVD_INI_ENCODING = "avd.ini.encoding";
    public static final String AVD_INFO_ABS_PATH = "path";
    public static final String AVD_INFO_REL_PATH = "path.rel";
    public static final String AVD_INFO_TARGET = "target";
    public static final String AVD_INI_TAG_ID = "tag.id";
    public static final String AVD_INI_TAG_DISPLAY = "tag.display";
    public static final String AVD_INI_ABI_TYPE = "abi.type";
    public static final String AVD_INI_CPU_ARCH = "hw.cpu.arch";
    public static final String AVD_INI_CPU_MODEL = "hw.cpu.model";
    public static final String AVD_INI_DEVICE_MANUFACTURER = "hw.device.manufacturer";
    public static final String AVD_INI_DEVICE_NAME = "hw.device.name";
    public static final String AVD_INI_SKIN_PATH = "skin.path";
    public static final String AVD_INI_SKIN_NAME = "skin.name";
    public static final String AVD_INI_SKIN_DYNAMIC = "skin.dynamic";
    public static final String AVD_INI_SDCARD_PATH = "sdcard.path";
    public static final String AVD_INI_SDCARD_SIZE = "sdcard.size";
    public static final String AVD_INI_IMAGES_1 = "image.sysdir.1";
    public static final String AVD_INI_IMAGES_2 = "image.sysdir.2";
    public static final String AVD_INI_SNAPSHOT_PRESENT = "snapshot.present";
    public static final String AVD_INI_GPU_EMULATION = "hw.gpu.enabled";
    public static final String AVD_INI_CAMERA_FRONT = "hw.camera.front";
    public static final String AVD_INI_CAMERA_BACK = "hw.camera.back";
    public static final String AVD_INI_RAM_SIZE = "hw.ramSize";
    public static final String AVD_INI_VM_HEAP_SIZE = "vm.heapSize";
    public static final String AVD_INI_DATA_PARTITION_SIZE = "disk.dataPartition.size";
    public static final String AVD_INI_DEVICE_HASH_V1 = "hw.device.hash";
    public static final String AVD_INI_DEVICE_HASH_V2 = "hw.device.hash2";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    private static final String USERDATA_IMG = "userdata.img";
    private static final String BOOT_PROP = "boot.prop";
    static final String CONFIG_INI = "config.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    private static final String SNAPSHOTS_IMG = "snapshots.img";
    static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    private static final Pattern SDCARD_SIZE_PATTERN = Pattern.compile("(\\d+)([KMG])");
    public static final long SDCARD_MIN_BYTE_SIZE = 0x900000L;
    public static final long SDCARD_MAX_BYTE_SIZE = 0xFFC0000000L;
    public static final int SDCARD_SIZE_NOT_IN_RANGE = 0;
    public static final int SDCARD_SIZE_INVALID = -1;
    public static final int SDCARD_NOT_SIZE_PATTERN = -2;
    public static final Pattern RE_AVD_NAME = Pattern.compile("[a-zA-Z0-9._-]+");
    public static final String CHARS_AVD_NAME = "a-z A-Z 0-9 . _ -";
    public static final String HARDWARE_INI = "hardware.ini";
    private static final Map<String, AvdManager> mManagers = Collections.synchronizedMap(new WeakHashMap());
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private AvdInfo[] mValidAvdList;
    private AvdInfo[] mBrokenAvdList;
    private final SdkManager mSdkManager;

    protected AvdManager(SdkManager sdkManager, ILogger log) throws AndroidLocation.AndroidLocationException {
        this.mSdkManager = sdkManager;
        this.buildAvdList(this.mAllAvdList, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvdManager getInstance(SdkManager sdkManager, ILogger log) throws AndroidLocation.AndroidLocationException {
        Map<String, AvdManager> map = mManagers;
        synchronized (map) {
            AvdManager manager = mManagers.get(sdkManager.getLocation());
            if (manager != null) {
                return manager;
            }
            manager = new AvdManager(sdkManager, log);
            mManagers.put(sdkManager.getLocation(), manager);
            return manager;
        }
    }

    public String getBaseAvdFolder() throws AndroidLocation.AndroidLocationException {
        assert (AndroidLocation.getFolder().endsWith(File.separator));
        return AndroidLocation.getFolder() + "avd";
    }

    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    public static long parseSdcardSize(String sdcard, String[] parsedStrings) {
        Matcher m;
        if (parsedStrings != null) {
            assert (parsedStrings.length == 2);
            parsedStrings[0] = null;
            parsedStrings[1] = null;
        }
        if ((m = SDCARD_SIZE_PATTERN.matcher(sdcard)).matches()) {
            if (parsedStrings != null) {
                assert (parsedStrings.length == 2);
                parsedStrings[0] = m.group(1);
                parsedStrings[1] = m.group(2);
            }
            try {
                long sdcardSize = Long.parseLong(m.group(1));
                String sdcardSizeModifier = m.group(2);
                if ("K".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 10;
                } else if ("M".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 20;
                } else if ("G".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 30;
                }
                if (sdcardSize < 0x900000L || sdcardSize > 0xFFC0000000L) {
                    return 0L;
                }
                return sdcardSize;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[this.mAllAvdList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() != AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mValidAvdList = list.toArray(new AvdInfo[list.size()]);
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getBrokenAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mBrokenAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() == AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mBrokenAvdList = list.toArray(new AvdInfo[list.size()]);
            }
            return this.mBrokenAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String name, boolean validAvdOnly) {
        boolean ignoreCase;
        boolean bl = ignoreCase = SdkConstants.currentPlatform() == 2;
        if (validAvdOnly) {
            for (AvdInfo info : this.getValidAvds()) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                return info;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo info : this.mAllAvdList) {
                    String name2 = info.getName();
                    if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                    return info;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<AvdConflict, String> isAvdNameConflicting(String name) {
        boolean ignoreCase = SdkConstants.currentPlatform() == 2;
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            for (AvdInfo info : this.mAllAvdList) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                if (info.getStatus() == AvdInfo.AvdStatus.OK) {
                    return Pair.of((Object)((Object)AvdConflict.CONFLICT_EXISTING_AVD), (Object)name2);
                }
                return Pair.of((Object)((Object)AvdConflict.CONFLICT_INVALID_AVD), (Object)name2);
            }
        }
        try {
            File file = AvdInfo.getDefaultIniFile(this, name);
            if (file.exists()) {
                return Pair.of((Object)((Object)AvdConflict.CONFLICT_EXISTING_PATH), (Object)file.getPath());
            }
            file = AvdInfo.getDefaultAvdFolder(this, name);
            if (file.exists()) {
                return Pair.of((Object)((Object)AvdConflict.CONFLICT_EXISTING_PATH), (Object)file.getPath());
            }
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            // empty catch block
        }
        return Pair.of((Object)((Object)AvdConflict.NO_CONFLICT), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAvds(ILogger log) throws AndroidLocation.AndroidLocationException {
        ArrayList<AvdInfo> allList = new ArrayList<AvdInfo>();
        this.buildAvdList(allList, log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(allList);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * Exception decompiling
     */
    public AvdInfo createAvd(File avdFolder, String avdName, IAndroidTarget target, IdDisplay tag, String abiType, File skinFolder, String skinName, String sdcard, @Nullable Map<String, String> hardwareConfig, @Nullable Map<String, String> bootProps, boolean createSnapshot, boolean removePrevious, boolean editExisting, ILogger log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyImageFile(File source, File destination) throws FileNotFoundException, IOException {
        int count;
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(destination);
        byte[] buffer = new byte[4096];
        while ((count = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, count);
        }
        fos.close();
        fis.close();
    }

    private String getImageRelativePath(IAndroidTarget target, IdDisplay tag, String abiType) throws InvalidTargetPathException {
        String[] list;
        String sdkLocation;
        ISystemImage systemImage = target.getSystemImage(tag, abiType);
        if (systemImage == null) {
            return null;
        }
        File folder = systemImage.getLocation();
        String imageFullPath = folder.getAbsolutePath();
        if (!imageFullPath.startsWith(sdkLocation = this.mSdkManager.getLocation())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        if (folder.isDirectory() && (list = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return IMAGE_NAME_PATTERN.matcher(name).matches();
            }
        })).length > 0) {
            if ((imageFullPath = imageFullPath.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
                imageFullPath = imageFullPath.substring(1);
            }
            if (!imageFullPath.endsWith(File.separator)) {
                imageFullPath = imageFullPath + File.separator;
            }
            return imageFullPath;
        }
        return null;
    }

    private String getSkinRelativePath(String skinName, IAndroidTarget target, ILogger log) {
        String sdkLocation;
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        File skin = this.getSkinFolder(skinName, target);
        if (!skin.exists()) {
            log.error(null, "Skin '%1$s' does not exist.", new Object[]{skinName});
            return null;
        }
        String path = skin.getAbsolutePath();
        if (!path.startsWith(sdkLocation = this.mSdkManager.getLocation())) {
            log.error(null, "Target location is not inside the SDK.", new Object[0]);
            assert (false);
            return null;
        }
        if ((path = path.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
            path = path.substring(1);
        }
        return path;
    }

    private File getSkinFolder(String skinName, IAndroidTarget target) {
        String path = target.getPath(5);
        File skin = new File(path, skinName);
        if (!skin.exists() && !target.isPlatform()) {
            target = target.getParent();
            path = target.getPath(5);
            skin = new File(path, skinName);
        }
        return skin;
    }

    private File createAvdIniFile(String name, File avdFolder, IAndroidTarget target, boolean removePrevious) throws AndroidLocation.AndroidLocationException, IOException {
        File iniFile = AvdInfo.getDefaultIniFile(this, name);
        if (removePrevious) {
            if (iniFile.isFile()) {
                iniFile.delete();
            } else if (iniFile.isDirectory()) {
                this.deleteContentOf(iniFile);
                iniFile.delete();
            }
        }
        String absPath = avdFolder.getAbsolutePath();
        String relPath = null;
        String androidPath = AndroidLocation.getFolder();
        if (absPath.startsWith(androidPath)) {
            assert (androidPath.endsWith(File.separator));
            relPath = absPath.substring(androidPath.length());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (relPath != null) {
            values.put(AVD_INFO_REL_PATH, relPath);
        }
        values.put(AVD_INFO_ABS_PATH, absPath);
        values.put(AVD_INFO_TARGET, target.hashString());
        AvdManager.writeIniFile(iniFile, values, true);
        return iniFile;
    }

    private File createAvdIniFile(AvdInfo info) throws AndroidLocation.AndroidLocationException, IOException {
        return this.createAvdIniFile(info.getName(), new File(info.getDataFolderPath()), info.getTarget(), false);
    }

    public boolean deleteAvd(AvdInfo avdInfo, ILogger log) {
        try {
            String path;
            boolean error = false;
            File f = avdInfo.getIniFile();
            if (f != null && f.exists()) {
                log.info("Deleting file %1$s\n", new Object[]{f.getCanonicalPath()});
                if (!f.delete()) {
                    log.error(null, "Failed to delete %1$s\n", new Object[]{f.getCanonicalPath()});
                    error = true;
                }
            }
            if ((path = avdInfo.getDataFolderPath()) != null && (f = new File(path)).exists()) {
                log.info("Deleting folder %1$s\n", new Object[]{f.getCanonicalPath()});
                if (!this.deleteContentOf(f) || !f.delete()) {
                    log.error(null, "Failed to delete %1$s\n", new Object[]{f.getCanonicalPath()});
                    error = true;
                }
            }
            this.removeAvd(avdInfo);
            if (!error) {
                log.info("\nAVD '%1$s' deleted.\n", new Object[]{avdInfo.getName()});
                return true;
            }
            log.info("\nAVD '%1$s' deleted with errors. See errors above.\n", new Object[]{avdInfo.getName()});
        }
        catch (IOException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        catch (SecurityException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        return false;
    }

    public boolean moveAvd(AvdInfo avdInfo, String newName, String paramFolderPath, ILogger log) {
        try {
            if (paramFolderPath != null) {
                File f = new File(avdInfo.getDataFolderPath());
                log.warning("Moving '%1$s' to '%2$s'.", new Object[]{avdInfo.getDataFolderPath(), paramFolderPath});
                if (!f.renameTo(new File(paramFolderPath))) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.", new Object[]{avdInfo.getDataFolderPath(), paramFolderPath});
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getName(), avdInfo.getIniFile(), paramFolderPath, avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getTag(), avdInfo.getAbiType(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
                this.createAvdIniFile(info);
            }
            if (newName != null) {
                File oldIniFile = avdInfo.getIniFile();
                File newIniFile = AvdInfo.getDefaultIniFile(this, newName);
                log.warning("Moving '%1$s' to '%2$s'.", new Object[]{oldIniFile.getPath(), newIniFile.getPath()});
                if (!oldIniFile.renameTo(newIniFile)) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.", new Object[]{oldIniFile.getPath(), newIniFile.getPath()});
                    return false;
                }
                AvdInfo info = new AvdInfo(newName, avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getTag(), avdInfo.getAbiType(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
            }
            log.info("AVD '%1$s' moved.\n", new Object[]{avdInfo.getName()});
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        return true;
    }

    private boolean deleteContentOf(File folder) throws SecurityException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory() && !this.deleteContentOf(f)) {
                    return false;
                }
                if (f.delete()) continue;
                return false;
            }
        }
        return true;
    }

    private File[] buildAvdFilesList() throws AndroidLocation.AndroidLocationException {
        File folder = new File(this.getBaseAvdFolder());
        if (folder.isFile()) {
            throw new AndroidLocation.AndroidLocationException(String.format("%1$s is not a valid folder.", folder.getAbsolutePath()));
        }
        if (!folder.exists()) {
            folder.mkdirs();
            return null;
        }
        File[] avds = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File parent, String name) {
                if (INI_NAME_PATTERN.matcher(name).matches()) {
                    boolean isFile = new File(parent, name).isFile();
                    return isFile;
                }
                return false;
            }
        });
        return avds;
    }

    private void buildAvdList(ArrayList<AvdInfo> allList, ILogger log) throws AndroidLocation.AndroidLocationException {
        File[] avds = this.buildAvdFilesList();
        if (avds != null) {
            for (File avd : avds) {
                AvdInfo info = this.parseAvdInfo(avd, log);
                if (info == null || allList.contains(info)) continue;
                allList.add(info);
            }
        }
    }

    private AvdInfo parseAvdInfo(File iniPath, ILogger log) {
        String imageSysDir;
        String abiType;
        String tagId;
        String relPath;
        Map<String, String> map = AvdManager.parseIniFile((IAbstractFile)new FileWrapper(iniPath), log);
        String avdPath = map.get(AVD_INFO_ABS_PATH);
        String targetHash = map.get(AVD_INFO_TARGET);
        if (!new File(avdPath).isDirectory() && (relPath = map.get(AVD_INFO_REL_PATH)) != null) {
            try {
                String androidPath = AndroidLocation.getFolder();
                File f = new File(androidPath, relPath);
                if (f.isDirectory()) {
                    avdPath = f.getAbsolutePath();
                }
            }
            catch (AndroidLocation.AndroidLocationException ignore) {
                // empty catch block
            }
        }
        IAndroidTarget target = null;
        FileWrapper configIniFile = null;
        Map<String, String> properties = null;
        if (targetHash != null) {
            target = this.mSdkManager.getTargetFromHashString(targetHash);
        }
        if (avdPath != null) {
            configIniFile = new FileWrapper(avdPath, CONFIG_INI);
        }
        if (configIniFile != null) {
            if (!configIniFile.isFile()) {
                log.warning("Missing file '%1$s'.", new Object[]{configIniFile.getPath()});
            } else {
                properties = AvdManager.parseIniFile((IAbstractFile)configIniFile, log);
            }
        }
        String name = iniPath.getName();
        Matcher matcher = INI_NAME_PATTERN.matcher(iniPath.getName());
        if (matcher.matches()) {
            name = matcher.group(1);
        }
        IdDisplay tag = SystemImage.DEFAULT_TAG;
        String string = tagId = properties == null ? null : properties.get(AVD_INI_TAG_ID);
        if (tagId != null) {
            String tagDisp;
            String string2 = tagDisp = properties == null ? null : properties.get(AVD_INI_TAG_DISPLAY);
            if (tagDisp == null || tagDisp.isEmpty()) {
                tagDisp = LocalSysImgPkgInfo.tagIdToDisplay(tagId);
            }
            tag = new IdDisplay(tagId, tagDisp);
        }
        String string3 = abiType = properties == null ? null : properties.get(AVD_INI_ABI_TYPE);
        if (abiType == null) {
            abiType = "armeabi";
        }
        boolean validImageSysdir = true;
        if (properties != null && (imageSysDir = properties.get(AVD_INI_IMAGES_1)) != null) {
            File f = new File(this.mSdkManager.getLocation() + File.separator + imageSysDir);
            if (!f.isDirectory()) {
                validImageSysdir = false;
            } else {
                imageSysDir = properties.get(AVD_INI_IMAGES_2);
                if (imageSysDir != null && !(f = new File(this.mSdkManager.getLocation() + File.separator + imageSysDir)).isDirectory()) {
                    validImageSysdir = false;
                }
            }
        }
        DeviceManager.DeviceStatus deviceStatus = null;
        boolean updateHashV2 = false;
        if (properties != null) {
            String deviceName = properties.get(AVD_INI_DEVICE_NAME);
            String deviceMfctr = properties.get(AVD_INI_DEVICE_MANUFACTURER);
            Device d = null;
            if (deviceName != null && deviceMfctr != null) {
                String hashV1;
                DeviceManager devMan = DeviceManager.createInstance(this.mSdkManager.getLocation(), log);
                d = devMan.getDevice(deviceName, deviceMfctr);
                deviceStatus = d == null ? DeviceManager.DeviceStatus.MISSING : DeviceManager.DeviceStatus.EXISTS;
                updateHashV2 = true;
                String hashV2 = properties.get(AVD_INI_DEVICE_HASH_V2);
                if (hashV2 != null) {
                    String newHashV2 = DeviceManager.hasHardwarePropHashChanged(d, hashV2);
                    if (newHashV2 == null) {
                        updateHashV2 = false;
                    } else {
                        properties.put(AVD_INI_DEVICE_HASH_V2, newHashV2);
                    }
                }
                if ((hashV1 = properties.get(AVD_INI_DEVICE_HASH_V1)) != null) {
                    properties.remove(AVD_INI_DEVICE_HASH_V1);
                }
            }
        }
        AvdInfo.AvdStatus status = avdPath == null ? AvdInfo.AvdStatus.ERROR_PATH : (configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (targetHash == null ? AvdInfo.AvdStatus.ERROR_TARGET_HASH : (target == null ? AvdInfo.AvdStatus.ERROR_TARGET : (properties == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (!validImageSysdir ? AvdInfo.AvdStatus.ERROR_IMAGE_DIR : (deviceStatus == DeviceManager.DeviceStatus.CHANGED ? AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED : (deviceStatus == DeviceManager.DeviceStatus.MISSING ? AvdInfo.AvdStatus.ERROR_DEVICE_MISSING : AvdInfo.AvdStatus.OK)))))));
        AvdInfo info = new AvdInfo(name, iniPath, avdPath, targetHash, target, tag, abiType, properties, status);
        if (updateHashV2) {
            try {
                return this.updateDeviceChanged(info, log);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return info;
    }

    private static void writeIniFile(File iniFile, Map<String, String> values, boolean addEncoding) throws IOException {
        Charset charset = Charsets.ISO_8859_1;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(iniFile), charset);
        if (addEncoding) {
            writer.write(String.format("%1$s=%2$s\n", AVD_INI_ENCODING, charset.name()));
        }
        ArrayList<String> keys = new ArrayList<String>(values.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = values.get(key);
            writer.write(String.format("%1$s=%2$s\n", key, value));
        }
        writer.close();
    }

    private static Map<String, String> parseIniFile(@NonNull IAbstractFile propFile, @Nullable ILogger log) {
        return AvdManager.parseIniFileImpl(propFile, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseIniFileImpl(@NonNull IAbstractFile propFile, @Nullable ILogger log, @Nullable Charset charset) {
        BufferedReader reader = null;
        try {
            boolean canChangeCharset = false;
            if (charset == null) {
                canChangeCharset = false;
                charset = Charsets.ISO_8859_1;
            }
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), charset));
            String line = null;
            HashMap<String, String> map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                Matcher m = INI_LINE_PATTERN.matcher(line);
                if (m.matches()) {
                    String key = m.group(1);
                    String value = m.group(2);
                    if (canChangeCharset && AVD_INI_ENCODING.equals(key) && !charset.name().equals(value) && Charset.isSupported(value)) {
                        charset = Charset.forName(value);
                        Map<String, String> map2 = AvdManager.parseIniFileImpl(propFile, log, charset);
                        Closeables.closeQuietly((Closeable)reader);
                        return map2;
                    }
                    map.put(key, value);
                    continue;
                }
                if (log != null) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propFile.getOsLocation(), line});
                }
                Map<String, String> map3 = null;
                Closeables.closeQuietly((Closeable)reader);
                return map3;
            }
            HashMap<String, String> hashMap = map;
            Closeables.closeQuietly((Closeable)reader);
            return hashMap;
        }
        catch (FileNotFoundException e) {
            Closeables.closeQuietly(reader);
            return null;
        }
        catch (IOException e) {
            if (log == null) return null;
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (StreamException e2) {
                if (log == null) return null;
                log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e2.getMessage()});
                return null;
            }
        }
        finally {
            Closeables.closeQuietly(reader);
        }
    }

    private boolean createSdCard(String toolLocation, String size, String location, ILogger log) {
        try {
            String[] command = new String[]{toolLocation, size, location};
            Process process = Runtime.getRuntime().exec(command);
            final ArrayList errorOutput = new ArrayList();
            final ArrayList stdOutput = new ArrayList();
            int status = GrabProcessOutput.grabProcessOutput(process, GrabProcessOutput.Wait.WAIT_FOR_READERS, new GrabProcessOutput.IProcessOutput(){

                @Override
                public void out(@Nullable String line) {
                    if (line != null) {
                        stdOutput.add(line);
                    }
                }

                @Override
                public void err(@Nullable String line) {
                    if (line != null) {
                        errorOutput.add(line);
                    }
                }
            });
            if (status == 0) {
                return true;
            }
            for (String error : errorOutput) {
                log.error(null, error, new Object[0]);
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        log.error(null, "Failed to create the SD card.", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mBrokenAvdList = null;
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvd(String name, ILogger log) throws IOException {
        AvdInfo avd = null;
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            for (AvdInfo info : this.mAllAvdList) {
                if (!info.getName().equals(name)) continue;
                avd = info;
                break;
            }
        }
        if (avd == null) {
            log.error(null, "There is no Android Virtual Device named '%s'.", new Object[]{name});
            return;
        }
        this.updateAvd(avd, log);
    }

    public AvdInfo updateAvd(AvdInfo avd, ILogger log) throws IOException {
        AvdInfo.AvdStatus status;
        Map<String, String> oldProperties = avd.getProperties();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (oldProperties != null) {
            properties.putAll(oldProperties);
        }
        if (this.setImagePathProperties(avd.getTarget(), avd.getTag(), avd.getAbiType(), properties, log)) {
            if (properties.containsKey(AVD_INI_IMAGES_1)) {
                log.info("Updated '%1$s' with value '%2$s'\n", new Object[]{AVD_INI_IMAGES_1, properties.get(AVD_INI_IMAGES_1)});
            }
            if (properties.containsKey(AVD_INI_IMAGES_2)) {
                log.info("Updated '%1$s' with value '%2$s'\n", new Object[]{AVD_INI_IMAGES_2, properties.get(AVD_INI_IMAGES_2)});
            }
            status = AvdInfo.AvdStatus.OK;
        } else {
            log.error(null, "Unable to find non empty system images folders for %1$s", new Object[]{avd.getName()});
            status = AvdInfo.AvdStatus.ERROR_IMAGE_DIR;
        }
        return this.updateAvd(avd, properties, status, log);
    }

    public AvdInfo updateAvd(AvdInfo avd, Map<String, String> newProperties, AvdInfo.AvdStatus status, ILogger log) throws IOException {
        File configIniFile = new File(avd.getDataFolderPath(), CONFIG_INI);
        AvdManager.writeIniFile(configIniFile, newProperties, true);
        AvdInfo newAvd = new AvdInfo(avd.getName(), avd.getIniFile(), avd.getDataFolderPath(), avd.getTargetHash(), avd.getTarget(), avd.getTag(), avd.getAbiType(), newProperties);
        this.replaceAvd(avd, newAvd);
        return newAvd;
    }

    public AvdInfo updateDeviceChanged(AvdInfo avd, ILogger log) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(avd.getProperties());
        DeviceManager devMan = DeviceManager.createInstance(this.mSdkManager.getLocation(), log);
        List<Device> devices = devMan.getDevices(DeviceManager.ALL_DEVICES);
        String name = (String)properties.get(AVD_INI_DEVICE_NAME);
        String manufacturer = (String)properties.get(AVD_INI_DEVICE_MANUFACTURER);
        if (properties != null && devices != null && name != null && manufacturer != null) {
            for (Device d : devices) {
                if (!d.getId().equals(name) || !d.getManufacturer().equals(manufacturer)) continue;
                properties.putAll(DeviceManager.getHardwareProperties(d));
                try {
                    return this.updateAvd(avd, properties, AvdInfo.AvdStatus.OK, log);
                }
                catch (IOException e) {
                    log.error((Throwable)e, null, new Object[0]);
                }
            }
        } else {
            log.error(null, "Base device information incomplete or missing.", new Object[0]);
        }
        return null;
    }

    private boolean setImagePathProperties(IAndroidTarget target, IdDisplay tag, String abiType, Map<String, String> properties, ILogger log) {
        properties.remove(AVD_INI_IMAGES_1);
        properties.remove(AVD_INI_IMAGES_2);
        try {
            IAndroidTarget parent;
            String property = AVD_INI_IMAGES_1;
            String imagePath = this.getImageRelativePath(target, tag, abiType);
            if (imagePath != null) {
                properties.put(property, imagePath);
                property = AVD_INI_IMAGES_2;
            }
            if ((parent = target.getParent()) != null && (imagePath = this.getImageRelativePath(parent, tag, abiType)) != null) {
                properties.put(property, imagePath);
            }
            return properties.containsKey(AVD_INI_IMAGES_1);
        }
        catch (InvalidTargetPathException e) {
            log.error((Throwable)e, e.getMessage(), new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(oldAvd);
            this.mAllAvdList.add(newAvd);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    public static enum AvdConflict {
        NO_CONFLICT,
        CONFLICT_EXISTING_AVD,
        CONFLICT_INVALID_AVD,
        CONFLICT_EXISTING_PATH;

    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String message) {
            super(message);
        }
    }
}

