/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import java.io.File;
import java.util.Properties;

public abstract class LocalPkgInfo
implements IListDescription,
Comparable<LocalPkgInfo> {
    private final LocalSdk mLocalSdk;
    private final File mLocalDir;
    private final Properties mSourceProperties;
    private Package mPackage;
    private String mLoadError;
    private RemotePkgInfo mUpdate;

    protected LocalPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps) {
        this.mLocalSdk = localSdk;
        this.mLocalDir = localDir;
        this.mSourceProperties = sourceProps;
    }

    @NonNull
    public LocalSdk getLocalSdk() {
        return this.mLocalSdk;
    }

    @NonNull
    public File getLocalDir() {
        return this.mLocalDir;
    }

    @NonNull
    public Properties getSourceProperties() {
        return this.mSourceProperties;
    }

    @Nullable
    public String getLoadError() {
        return this.mLoadError;
    }

    public boolean hasUpdate() {
        return this.mUpdate != null;
    }

    @Nullable
    public RemotePkgInfo getUpdate() {
        return this.mUpdate;
    }

    void setUpdate(@Nullable RemotePkgInfo update) {
        this.mUpdate = update;
    }

    @NonNull
    public abstract IPkgDesc getDesc();

    @Override
    public int compareTo(@NonNull LocalPkgInfo o) {
        return this.getDesc().compareTo(o.getDesc());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(this.getClass().getSimpleName()).append(' ');
        builder.append(this.getDesc().toString());
        if (this.mUpdate != null) {
            builder.append(" Updated by: ");
            builder.append(this.mUpdate.toString());
        }
        builder.append('>');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDesc() == null ? 0 : this.getDesc().hashCode());
        result = 31 * result + (this.mLocalDir == null ? 0 : this.mLocalDir.hashCode());
        result = 31 * result + (this.mSourceProperties == null ? 0 : this.mSourceProperties.hashCode());
        result = 31 * result + (this.mUpdate == null ? 0 : this.mUpdate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalPkgInfo)) {
            return false;
        }
        LocalPkgInfo other = (LocalPkgInfo)obj;
        if (!this.getDesc().equals(other.getDesc())) {
            return false;
        }
        if (this.mLocalDir == null ? other.mLocalDir != null : !this.mLocalDir.equals(other.mLocalDir)) {
            return false;
        }
        if (this.mSourceProperties == null ? other.mSourceProperties != null : !this.mSourceProperties.equals(other.mSourceProperties)) {
            return false;
        }
        return !(this.mUpdate == null ? other.mUpdate != null : !this.mUpdate.equals(other.mUpdate));
    }

    public boolean hasLoadError() {
        return this.mLoadError != null;
    }

    void appendLoadError(@NonNull String format, Object ... params) {
        String loadError = String.format(format, params);
        this.mLoadError = this.mLoadError == null ? loadError : this.mLoadError + '\n' + loadError;
    }

    void setPackage(@Nullable Package pkg) {
        this.mPackage = pkg;
    }

    @Nullable
    public Package getPackage() {
        return this.mPackage;
    }

    @Override
    @NonNull
    public String getListDescription() {
        Package pkg = this.getPackage();
        return pkg == null ? "" : pkg.getListDescription();
    }
}

