/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.TreeSet;

public class Update {
    public static Result computeUpdates(@NonNull LocalPkgInfo[] localPkgs, @NonNull Multimap<PkgType, RemotePkgInfo> remotePkgs) {
        Result result = new Result();
        TreeSet updates = Sets.newTreeSet();
        for (LocalPkgInfo local : localPkgs) {
            RemotePkgInfo update = Update.findUpdate(local, remotePkgs, result);
            if (update == null) continue;
            updates.add(update);
        }
        block1: for (RemotePkgInfo remote : remotePkgs.values()) {
            if (updates.contains(remote)) continue;
            IPkgDesc remoteDesc = remote.getDesc();
            for (LocalPkgInfo local : localPkgs) {
                IPkgDesc localDesc = local.getDesc();
                if (remoteDesc.compareTo(localDesc) == 0 || remoteDesc.isUpdateFor(localDesc)) continue block1;
            }
            result.mNewPkgs.add(remote);
        }
        return result;
    }

    private static RemotePkgInfo findUpdate(@NonNull LocalPkgInfo local, @NonNull Multimap<PkgType, RemotePkgInfo> remotePkgs, @NonNull Result result) {
        RemotePkgInfo currUpdatePkg = null;
        IPkgDesc currUpdateDesc = null;
        IPkgDesc localDesc = local.getDesc();
        for (RemotePkgInfo remote : remotePkgs.get((Object)localDesc.getType())) {
            IPkgDesc remoteDesc = remote.getDesc();
            if ((currUpdateDesc != null || !remoteDesc.isUpdateFor(localDesc)) && (currUpdateDesc == null || !remoteDesc.isUpdateFor(currUpdateDesc))) continue;
            currUpdatePkg = remote;
            currUpdateDesc = remoteDesc;
        }
        local.setUpdate(currUpdatePkg);
        if (currUpdatePkg != null) {
            result.mUpdatedPkgs.add(local);
        }
        return currUpdatePkg;
    }

    public static class Result {
        final Set<LocalPkgInfo> mUpdatedPkgs = Sets.newTreeSet();
        final Set<RemotePkgInfo> mNewPkgs = Sets.newTreeSet();

        public Set<LocalPkgInfo> getUpdatedPkgs() {
            return this.mUpdatedPkgs;
        }

        public Set<RemotePkgInfo> getNewPkgs() {
            return this.mNewPkgs;
        }
    }
}

