/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class CompletionFieldFilter
extends CompatibilityFieldFilter {
    static final int COMPLETED = 2;
    static final int NOT_COMPLETED = 1;
    private static int ALL_SELECTED = 3;
    private int completion = ALL_SELECTED;
    private static String COMPLETION_ATTRIBUTE = "completion";

    public void loadSettings(IMemento memento) {
        Integer completionValue = memento.getInteger(COMPLETION_ATTRIBUTE);
        if (completionValue == null) {
            return;
        }
        this.completion = completionValue;
    }

    void loadLegacySettings(IMemento memento, MarkerContentGenerator generator) {
        String setting = memento.getString("done");
        if (setting != null) {
            this.completion = Boolean.valueOf(setting) != false ? 2 : 1;
        }
    }

    public void initialize(ProblemFilter problemFilter) {
    }

    public void saveSettings(IMemento memento) {
        memento.putInteger(COMPLETION_ATTRIBUTE, this.completion);
    }

    public boolean select(MarkerItem item) {
        if (this.completion == ALL_SELECTED) {
            return true;
        }
        if (item.getAttributeValue("userEditable", true)) {
            if (item.getAttributeValue("done", false)) {
                return (this.completion & 2) > 0;
            }
            return (this.completion & 1) > 0;
        }
        return false;
    }

    int getCompletion() {
        return this.completion;
    }

    void setCompletion(int completion) {
        this.completion = completion;
    }

    public void populateWorkingCopy(MarkerFieldFilter copy) {
        super.populateWorkingCopy(copy);
        ((CompletionFieldFilter)copy).setCompletion(this.getCompletion());
    }
}

