/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.core;

import com.android.sdkuilib.internal.tasks.ILogUiProvider;
import com.android.utils.ILogger;

public final class SdkLogAdapter
implements ILogUiProvider {
    private ILogger mSdkLog;
    private String mLastLogMsg;

    public SdkLogAdapter(ILogger sdkLog) {
        this.mSdkLog = sdkLog;
    }

    @Override
    public void setDescription(String description) {
        if (this.acceptLog(description)) {
            this.mSdkLog.info("%1$s", new Object[]{description});
        }
    }

    @Override
    public void log(String log) {
        if (this.acceptLog(log)) {
            this.mSdkLog.info("  %1$s", new Object[]{log});
        }
    }

    @Override
    public void logError(String log) {
        if (this.acceptLog(log)) {
            this.mSdkLog.error(null, "  %1$s", new Object[]{log});
        }
    }

    @Override
    public void logVerbose(String log) {
        if (this.acceptLog(log)) {
            this.mSdkLog.verbose("    %1$s", new Object[]{log});
        }
    }

    private boolean acceptLog(String msg) {
        if (msg == null) {
            return false;
        }
        if ((msg = msg.trim()).indexOf(37) != -1) {
            return false;
        }
        if (msg.equals(this.mLastLogMsg)) {
            return false;
        }
        this.mLastLogMsg = msg;
        return true;
    }
}

