/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository.icons;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdkuilib.internal.repository.core.PkgContentProvider;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageFactory {
    private final Display mDisplay;
    private final Map<String, Image> mImages = new HashMap<String, Image>();

    public ImageFactory(Display display) {
        this.mDisplay = display;
    }

    public Image getImageByName(String imageName) {
        Image image = this.mImages.get(imageName);
        if (image != null) {
            return image;
        }
        InputStream stream = this.getClass().getResourceAsStream(imageName);
        if (stream != null) {
            try {
                image = new Image((Device)this.mDisplay, stream);
            }
            catch (SWTException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.mImages.put(imageName, image);
        return image;
    }

    public Image getImageForObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Image) {
            return (Image)object;
        }
        String clz = object.getClass().getSimpleName();
        if (clz.endsWith(Package.class.getSimpleName())) {
            String name = clz.replaceFirst(Package.class.getSimpleName(), "").replace("SystemImage", "sysimg").toLowerCase(Locale.US);
            name = name + "_pkg_16.png";
            return this.getImageByName(name);
        }
        if (object instanceof SdkSourceCategory) {
            return this.getImageByName("source_cat_icon_16.png");
        }
        if (object instanceof SdkSource) {
            return this.getImageByName("source_icon_16.png");
        }
        if (object instanceof PkgContentProvider.RepoSourceError) {
            return this.getImageByName("error_icon_16.png");
        }
        if (object instanceof PkgContentProvider.RepoSourceNotification) {
            return this.getImageByName("nopkg_icon_16.png");
        }
        if (object instanceof Archive) {
            if (((Archive)object).isCompatible()) {
                return this.getImageByName("archive_icon16.png");
            }
            return this.getImageByName("incompat_icon16.png");
        }
        if (object instanceof String) {
            return this.getImageByName((String)object);
        }
        if (object != null) {
            // empty if block
        }
        return null;
    }

    public void dispose() {
        Iterator<Image> it = this.mImages.values().iterator();
        while (it.hasNext()) {
            Image img = it.next();
            if (img != null && !img.isDisposed()) {
                img.dispose();
            }
            it.remove();
        }
    }
}

