/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.SdkConstants;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.internal.widgets.HardwarePropertyChooser;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.ui.GridDialog;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

final class LegacyAvdEditDialog
extends GridDialog {
    private static final String ABI_SYS_IMG_DATA_KEY = "systemImagesData";
    private final AvdManager mAvdManager;
    private final TreeMap<String, IAndroidTarget> mCurrentTargets = new TreeMap();
    private final Map<String, HardwareProperties.HardwareProperty> mHardwareMap;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final ArrayList<String> mEditedProperties = new ArrayList();
    private final ImageFactory mImageFactory;
    private final ILogger mSdkLog;
    private final AvdInfo mEditAvdInfo;
    private Text mAvdName;
    private Combo mTargetCombo;
    private Combo mTagAbiCombo;
    private String mAbiType;
    private Button mSdCardSizeRadio;
    private Text mSdCardSize;
    private Combo mSdCardSizeCombo;
    private Text mSdCardFile;
    private Button mBrowseSdCard;
    private Button mSdCardFileRadio;
    private Button mSnapshotCheck;
    private Button mSkinListRadio;
    private Combo mSkinCombo;
    private Button mSkinSizeRadio;
    private Text mSkinSizeWidth;
    private Text mSkinSizeHeight;
    private TableViewer mHardwareViewer;
    private Button mDeleteHardwareProp;
    private Button mForceCreation;
    private Button mOkButton;
    private Label mStatusIcon;
    private Label mStatusLabel;
    private Composite mStatusComposite;
    private final VerifyListener mDigitVerifier = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            int count = event.text.length();
            for (int i = 0; i < count; ++i) {
                char c = event.text.charAt(i);
                if (c >= '0' && c <= '9') continue;
                event.doit = false;
                return;
            }
        }
    };

    protected LegacyAvdEditDialog(Shell parentShell, AvdManager avdManager, ImageFactory imageFactory, ILogger log, AvdInfo editAvdInfo) {
        super(parentShell, 2, false);
        String sdkPath;
        this.mAvdManager = avdManager;
        this.mImageFactory = imageFactory;
        this.mSdkLog = log;
        this.mEditAvdInfo = editAvdInfo;
        File hardwareDefs = null;
        SdkManager sdkMan = avdManager.getSdkManager();
        if (sdkMan != null && (sdkPath = sdkMan.getLocation()) != null) {
            hardwareDefs = new File(sdkPath + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER, "hardware-properties.ini");
        }
        if (hardwareDefs == null) {
            log.error(null, "Failed to load file %s from SDK", new Object[]{"hardware-properties.ini"});
            this.mHardwareMap = new HashMap<String, HardwareProperties.HardwareProperty>();
        } else {
            this.mHardwareMap = HardwareProperties.parseHardwareDefinitions(hardwareDefs, null);
        }
    }

    @Override
    public void create() {
        super.create();
        Point p = this.getShell().getSize();
        if (p.x < 400) {
            p.x = 400;
        }
        this.getShell().setSize(p);
    }

    @Override
    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText(this.mEditAvdInfo == null ? "Create new Android Virtual Device (AVD)" : "Edit Android Virtual Device (AVD)");
        this.mOkButton = this.getButton(0);
        this.fillExistingAvdInfo();
        this.validatePage();
        return control;
    }

    @Override
    public void createDialogContent(final Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Name:");
        String tooltip = "Name of the new Android Virtual Device";
        label.setToolTipText(tooltip);
        this.mAvdName = new Text(parent, 2048);
        this.mAvdName.setLayoutData((Object)new GridData(768));
        this.mAvdName.addModifyListener((ModifyListener)new CreateNameModifyListener());
        this.mAvdName.setToolTipText(tooltip);
        label = new Label(parent, 0);
        label.setText("Target:");
        tooltip = "The version of Android to use in the virtual device";
        label.setToolTipText(tooltip);
        this.mTargetCombo = new Combo(parent, 12);
        this.mTargetCombo.setLayoutData((Object)new GridData(768));
        this.mTargetCombo.setToolTipText(tooltip);
        this.mTargetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LegacyAvdEditDialog.this.reloadSkinCombo();
                LegacyAvdEditDialog.this.reloadTagAbiCombo();
                LegacyAvdEditDialog.this.validatePage();
            }
        });
        label = new Label(parent, 0);
        label.setText("CPU/ABI:");
        tooltip = "The CPU/ABI to use in the virtual device";
        label.setToolTipText(tooltip);
        this.mTagAbiCombo = new Combo(parent, 12);
        this.mTagAbiCombo.setLayoutData((Object)new GridData(768));
        this.mTagAbiCombo.setToolTipText(tooltip);
        this.mTagAbiCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LegacyAvdEditDialog.this.validatePage();
            }
        });
        this.mTagAbiCombo.setEnabled(false);
        label = new Label(parent, 0);
        label.setText("SD Card:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group sdCardGroup = new Group(parent, 0);
        sdCardGroup.setLayoutData((Object)new GridData(768));
        sdCardGroup.setLayout((Layout)new GridLayout(3, false));
        this.mSdCardSizeRadio = new Button((Composite)sdCardGroup, 16);
        this.mSdCardSizeRadio.setText("Size:");
        this.mSdCardSizeRadio.setToolTipText("Create a new SD Card file");
        this.mSdCardSizeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean sizeMode = LegacyAvdEditDialog.this.mSdCardSizeRadio.getSelection();
                LegacyAvdEditDialog.this.enableSdCardWidgets(sizeMode);
                LegacyAvdEditDialog.this.validatePage();
            }
        });
        ValidateListener validateListener = new ValidateListener();
        this.mSdCardSize = new Text((Composite)sdCardGroup, 2048);
        this.mSdCardSize.setLayoutData((Object)new GridData(768));
        this.mSdCardSize.addVerifyListener(this.mDigitVerifier);
        this.mSdCardSize.addModifyListener((ModifyListener)validateListener);
        this.mSdCardSize.setToolTipText("Size of the new SD Card file (must be at least 9 MiB)");
        this.mSdCardSizeCombo = new Combo((Composite)sdCardGroup, 12);
        this.mSdCardSizeCombo.add("KiB");
        this.mSdCardSizeCombo.add("MiB");
        this.mSdCardSizeCombo.add("GiB");
        this.mSdCardSizeCombo.select(1);
        this.mSdCardSizeCombo.addSelectionListener((SelectionListener)validateListener);
        this.mSdCardFileRadio = new Button((Composite)sdCardGroup, 16);
        this.mSdCardFileRadio.setText("File:");
        this.mSdCardFileRadio.setToolTipText("Use an existing file for the SD Card");
        this.mSdCardFile = new Text((Composite)sdCardGroup, 2048);
        this.mSdCardFile.setLayoutData((Object)new GridData(768));
        this.mSdCardFile.addModifyListener((ModifyListener)validateListener);
        this.mSdCardFile.setToolTipText("File to use for the SD Card");
        this.mBrowseSdCard = new Button((Composite)sdCardGroup, 8);
        this.mBrowseSdCard.setText("Browse...");
        this.mBrowseSdCard.setToolTipText("Select the file to use for the SD Card");
        this.mBrowseSdCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LegacyAvdEditDialog.this.onBrowseSdCard();
                LegacyAvdEditDialog.this.validatePage();
            }
        });
        this.mSdCardSizeRadio.setSelection(true);
        this.enableSdCardWidgets(true);
        label = new Label(parent, 0);
        label.setText("Snapshot:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group snapshotGroup = new Group(parent, 0);
        snapshotGroup.setLayoutData((Object)new GridData(768));
        snapshotGroup.setLayout((Layout)new GridLayout(3, false));
        this.mSnapshotCheck = new Button((Composite)snapshotGroup, 32);
        this.mSnapshotCheck.setText("Enabled");
        this.mSnapshotCheck.setToolTipText("Emulator's state will be persisted between emulator executions");
        label = new Label(parent, 0);
        label.setText("Skin:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group skinGroup = new Group(parent, 0);
        skinGroup.setLayoutData((Object)new GridData(768));
        skinGroup.setLayout((Layout)new GridLayout(4, false));
        this.mSkinListRadio = new Button((Composite)skinGroup, 16);
        this.mSkinListRadio.setText("Built-in:");
        this.mSkinListRadio.setToolTipText("Select an emulated screen size provided by the current Android target");
        this.mSkinListRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean listMode = LegacyAvdEditDialog.this.mSkinListRadio.getSelection();
                LegacyAvdEditDialog.this.enableSkinWidgets(listMode);
                LegacyAvdEditDialog.this.validatePage();
            }
        });
        this.mSkinCombo = new Combo((Composite)skinGroup, 12);
        GridData gd = new GridData(768);
        this.mSkinCombo.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        this.mSkinCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LegacyAvdEditDialog.this.loadSkin();
            }
        });
        this.mSkinSizeRadio = new Button((Composite)skinGroup, 16);
        this.mSkinSizeRadio.setText("Resolution:");
        this.mSkinSizeRadio.setToolTipText("Select a custom emulated screen size");
        this.mSkinSizeWidth = new Text((Composite)skinGroup, 2048);
        this.mSkinSizeWidth.setLayoutData((Object)new GridData(768));
        this.mSkinSizeWidth.addVerifyListener(this.mDigitVerifier);
        this.mSkinSizeWidth.addModifyListener((ModifyListener)validateListener);
        this.mSkinSizeWidth.setToolTipText("Width in pixels of the emulated screen size");
        new Label((Composite)skinGroup, 0).setText("x");
        this.mSkinSizeHeight = new Text((Composite)skinGroup, 2048);
        this.mSkinSizeHeight.setLayoutData((Object)new GridData(768));
        this.mSkinSizeHeight.addVerifyListener(this.mDigitVerifier);
        this.mSkinSizeHeight.addModifyListener((ModifyListener)validateListener);
        this.mSkinSizeHeight.setToolTipText("Height in pixels of the emulated screen size");
        this.mSkinListRadio.setSelection(true);
        this.enableSkinWidgets(true);
        label = new Label(parent, 0);
        label.setText("Hardware:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Group hwGroup = new Group(parent, 0);
        hwGroup.setLayoutData((Object)new GridData(768));
        hwGroup.setLayout((Layout)new GridLayout(2, false));
        this.createHardwareTable((Composite)hwGroup);
        Composite hwButtons = new Composite((Composite)hwGroup, 0);
        hwButtons.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout(1, false);
        hwButtons.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Button b = new Button(hwButtons, 0x800008);
        b.setText("New...");
        b.setToolTipText("Add a new hardware property");
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HardwareProperties.HardwareProperty choice;
                HardwarePropertyChooser dialog = new HardwarePropertyChooser(parent.getShell(), LegacyAvdEditDialog.this.mHardwareMap, LegacyAvdEditDialog.this.mProperties.keySet());
                if (dialog.open() == 0 && (choice = dialog.getProperty()) != null) {
                    LegacyAvdEditDialog.this.mProperties.put(choice.getName(), choice.getDefault());
                    LegacyAvdEditDialog.this.mHardwareViewer.refresh();
                }
            }
        });
        this.mDeleteHardwareProp = new Button(hwButtons, 0x800008);
        this.mDeleteHardwareProp.setText("Delete");
        this.mDeleteHardwareProp.setToolTipText("Delete the selected hardware property");
        this.mDeleteHardwareProp.setLayoutData((Object)new GridData(768));
        this.mDeleteHardwareProp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ISelection selection = LegacyAvdEditDialog.this.mHardwareViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    String hwName = (String)((IStructuredSelection)selection).getFirstElement();
                    LegacyAvdEditDialog.this.mProperties.remove(hwName);
                    LegacyAvdEditDialog.this.mHardwareViewer.refresh();
                }
            }
        });
        this.mDeleteHardwareProp.setEnabled(false);
        this.mForceCreation = new Button(parent, 32);
        this.mForceCreation.setText("Override the existing AVD with the same name");
        this.mForceCreation.setToolTipText("There's already an AVD with the same name. Check this to delete it and replace it by the new AVD.");
        this.mForceCreation.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.mForceCreation.setEnabled(false);
        this.mForceCreation.addSelectionListener((SelectionListener)validateListener);
        label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        this.mStatusComposite = new Composite(parent, 0);
        this.mStatusComposite.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        gl = new GridLayout(2, false);
        this.mStatusComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mStatusIcon = new Label(this.mStatusComposite, 0);
        this.mStatusIcon.setLayoutData((Object)new GridData(1, 1, false, false));
        this.mStatusLabel = new Label(this.mStatusComposite, 0);
        this.mStatusLabel.setLayoutData((Object)new GridData(768));
        this.mStatusLabel.setText(" \n ");
        this.reloadTargetCombo();
    }

    private void createHardwareTable(Composite parent) {
        final Table hardwareTable = new Table(parent, 65540);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 100;
        hardwareTable.setLayoutData((Object)gd);
        hardwareTable.setHeaderVisible(true);
        hardwareTable.setLinesVisible(true);
        this.mHardwareViewer = new TableViewer(hardwareTable);
        this.mHardwareViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                LegacyAvdEditDialog.this.mDeleteHardwareProp.setEnabled(hardwareTable.getSelectionIndex() != -1);
            }
        });
        this.mHardwareViewer.setContentProvider(new IStructuredContentProvider(){

            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            @Override
            public Object[] getElements(Object arg0) {
                return LegacyAvdEditDialog.this.mProperties.keySet().toArray();
            }

            @Override
            public void dispose() {
            }
        });
        TableColumn col1 = new TableColumn(hardwareTable, 16384);
        col1.setText("Property");
        col1.setWidth(150);
        TableViewerColumn tvc1 = new TableViewerColumn(this.mHardwareViewer, col1);
        tvc1.setLabelProvider(new CellLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                String name = cell.getElement().toString();
                HardwareProperties.HardwareProperty prop = (HardwareProperties.HardwareProperty)LegacyAvdEditDialog.this.mHardwareMap.get(name);
                if (prop != null) {
                    cell.setText(prop.getAbstract());
                } else {
                    cell.setText(String.format("%1$s (Unknown)", name));
                }
            }
        });
        TableColumn col2 = new TableColumn(hardwareTable, 16384);
        col2.setText("Value");
        col2.setWidth(50);
        TableViewerColumn tvc2 = new TableViewerColumn(this.mHardwareViewer, col2);
        tvc2.setLabelProvider(new CellLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                String value = (String)LegacyAvdEditDialog.this.mProperties.get(cell.getElement());
                cell.setText(value != null ? value : "");
            }
        });
        tvc2.setEditingSupport(new EditingSupport(this.mHardwareViewer){

            @Override
            protected void setValue(Object element, Object value) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)LegacyAvdEditDialog.this.mHardwareMap.get(hardwareName);
                switch (property.getType()) {
                    case INTEGER: {
                        LegacyAvdEditDialog.this.mProperties.put((String)element, (String)value);
                        break;
                    }
                    case DISKSIZE: {
                        if (!HardwareProperties.DISKSIZE_PATTERN.matcher((String)value).matches()) break;
                        LegacyAvdEditDialog.this.mProperties.put((String)element, (String)value);
                        break;
                    }
                    case BOOLEAN: {
                        int index = (Integer)value;
                        LegacyAvdEditDialog.this.mProperties.put((String)element, HardwareProperties.BOOLEAN_VALUES[index]);
                        break;
                    }
                    case STRING_ENUM: 
                    case INTEGER_ENUM: {
                        int index = (Integer)value;
                        String[] values = property.getEnum();
                        if (values == null || values.length <= index) break;
                        LegacyAvdEditDialog.this.mProperties.put((String)element, values[index]);
                    }
                }
                LegacyAvdEditDialog.this.mHardwareViewer.refresh(element);
            }

            @Override
            protected Object getValue(Object element) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)LegacyAvdEditDialog.this.mHardwareMap.get(hardwareName);
                String value = (String)LegacyAvdEditDialog.this.mProperties.get(hardwareName);
                switch (property.getType()) {
                    case INTEGER: 
                    case DISKSIZE: {
                        return value;
                    }
                    case BOOLEAN: {
                        return HardwareProperties.getBooleanValueIndex(value);
                    }
                    case STRING_ENUM: 
                    case INTEGER_ENUM: {
                        String[] values = property.getEnum();
                        if (values == null) break;
                        for (int i = 0; i < values.length; ++i) {
                            if (!values[i].equals(value)) continue;
                            return i;
                        }
                        break;
                    }
                }
                return null;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)LegacyAvdEditDialog.this.mHardwareMap.get(hardwareName);
                switch (property.getType()) {
                    case INTEGER: 
                    case DISKSIZE: {
                        return new TextCellEditor((Composite)hardwareTable);
                    }
                    case BOOLEAN: {
                        return new ComboBoxCellEditor((Composite)hardwareTable, HardwareProperties.BOOLEAN_VALUES, 12);
                    }
                    case STRING_ENUM: 
                    case INTEGER_ENUM: {
                        String[] values = property.getEnum();
                        if (values == null || values.length <= 0) break;
                        return new ComboBoxCellEditor((Composite)hardwareTable, values, 12);
                    }
                }
                return null;
            }

            @Override
            protected boolean canEdit(Object element) {
                String hardwareName = (String)element;
                HardwareProperties.HardwareProperty property = (HardwareProperties.HardwareProperty)LegacyAvdEditDialog.this.mHardwareMap.get(hardwareName);
                return property != null;
            }
        });
        this.mHardwareViewer.setInput(this.mProperties);
    }

    public void fillExistingAvdInfo() {
        if (this.mEditAvdInfo == null) {
            return;
        }
        this.mAvdName.setText(this.mEditAvdInfo.getName());
        Map<String, String> props = this.mEditAvdInfo.getProperties();
        IAndroidTarget target = this.mEditAvdInfo.getTarget();
        if (target != null && !this.mCurrentTargets.isEmpty()) {
            int n = this.mTargetCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!target.equals(this.mCurrentTargets.get(this.mTargetCombo.getItem(i)))) continue;
                this.mTargetCombo.select(i);
                this.reloadTagAbiCombo();
                this.reloadSkinCombo();
                break;
            }
        }
        ISystemImage[] systemImages = this.getSystemImages(target);
        if (target != null && systemImages.length > 0) {
            this.mTagAbiCombo.setEnabled(systemImages.length > 1);
            String abiType = AvdInfo.getPrettyAbiType(this.mEditAvdInfo);
            int n = this.mTagAbiCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                if (!abiType.equals(this.mTagAbiCombo.getItem(i))) continue;
                this.mTagAbiCombo.select(i);
                this.reloadSkinCombo();
                break;
            }
        }
        if (props != null) {
            String snapshots;
            String[] values;
            long sdcardSize;
            String sdcard;
            block2: for (int s = 0; s < 2; ++s) {
                String skin = props.get(s == 0 ? "skin.name" : "skin.path");
                if (skin == null || skin.length() <= 0) continue;
                Matcher m = AvdManager.NUMERIC_SKIN_SIZE.matcher(skin);
                if (m.matches() && m.groupCount() == 2) {
                    this.enableSkinWidgets(false);
                    this.mSkinListRadio.setSelection(false);
                    this.mSkinSizeRadio.setSelection(true);
                    this.mSkinSizeWidth.setText(m.group(1));
                    this.mSkinSizeHeight.setText(m.group(2));
                    break;
                }
                this.enableSkinWidgets(true);
                this.mSkinSizeRadio.setSelection(false);
                this.mSkinListRadio.setSelection(true);
                int n = this.mSkinCombo.getItemCount();
                for (int i = 0; i < n; ++i) {
                    if (!skin.equals(this.mSkinCombo.getItem(i))) continue;
                    this.mSkinCombo.select(i);
                    break block2;
                }
            }
            if ((sdcard = props.get("sdcard.path")) != null && sdcard.length() > 0) {
                this.enableSdCardWidgets(false);
                this.mSdCardSizeRadio.setSelection(false);
                this.mSdCardFileRadio.setSelection(true);
                this.mSdCardFile.setText(sdcard);
            }
            if ((sdcard = props.get("sdcard.size")) != null && sdcard.length() > 0 && (sdcardSize = AvdManager.parseSdcardSize(sdcard, values = new String[2])) != -2L) {
                this.enableSdCardWidgets(true);
                this.mSdCardFileRadio.setSelection(false);
                this.mSdCardSizeRadio.setSelection(true);
                this.mSdCardSize.setText(values[0]);
                String suffix = values[1];
                int n = this.mSdCardSizeCombo.getItemCount();
                for (int i = 0; i < n; ++i) {
                    if (!this.mSdCardSizeCombo.getItem(i).startsWith(suffix)) continue;
                    this.mSdCardSizeCombo.select(i);
                }
            }
            if ((snapshots = props.get("snapshot.present")) != null && snapshots.length() > 0) {
                this.mSnapshotCheck.setSelection(snapshots.equals("true"));
            }
        }
        this.mProperties.clear();
        if (props != null) {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                HardwareProperties.HardwareProperty prop = this.mHardwareMap.get(entry.getKey());
                if (prop == null || !prop.isValidForUi()) continue;
                this.mProperties.put(entry.getKey(), entry.getValue());
            }
        }
        this.mProperties.remove("abi.type");
        this.mProperties.remove("hw.cpu.arch");
        this.mProperties.remove("skin.path");
        this.mProperties.remove("skin.name");
        this.mProperties.remove("sdcard.size");
        this.mProperties.remove("sdcard.path");
        this.mProperties.remove("snapshot.present");
        this.mProperties.remove("image.sysdir.1");
        this.mProperties.remove("image.sysdir.2");
        this.mHardwareViewer.refresh();
    }

    @Override
    protected void okPressed() {
        if (this.createAvd()) {
            super.okPressed();
        }
    }

    private void enableSdCardWidgets(boolean sizeMode) {
        this.mSdCardSize.setEnabled(sizeMode);
        this.mSdCardSizeCombo.setEnabled(sizeMode);
        this.mSdCardFile.setEnabled(!sizeMode);
        this.mBrowseSdCard.setEnabled(!sizeMode);
    }

    private void enableSkinWidgets(boolean listMode) {
        this.mSkinCombo.setEnabled(listMode);
        this.mSkinSizeWidth.setEnabled(!listMode);
        this.mSkinSizeHeight.setEnabled(!listMode);
    }

    private void onBrowseSdCard() {
        FileDialog dlg = new FileDialog(this.getContents().getShell(), 4096);
        dlg.setText("Choose SD Card image file.");
        String fileName = dlg.open();
        if (fileName != null) {
            this.mSdCardFile.setText(fileName);
        }
    }

    private void reloadTargetCombo() {
        String selected = null;
        int index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            selected = this.mTargetCombo.getItem(index);
        }
        this.mCurrentTargets.clear();
        this.mTargetCombo.removeAll();
        boolean found = false;
        index = -1;
        SdkManager sdkManager = this.mAvdManager.getSdkManager();
        if (sdkManager != null) {
            for (IAndroidTarget target : sdkManager.getTargets()) {
                String name = target.isPlatform() ? String.format("%s - API Level %s", target.getName(), target.getVersion().getApiString()) : String.format("%s (%s) - API Level %s", target.getName(), target.getVendor(), target.getVersion().getApiString());
                this.mCurrentTargets.put(name, target);
                this.mTargetCombo.add(name);
                if (found) continue;
                ++index;
                found = name.equals(selected);
            }
        }
        this.mTargetCombo.setEnabled(this.mCurrentTargets.size() > 0);
        if (found) {
            this.mTargetCombo.select(index);
        }
        this.reloadSkinCombo();
    }

    private void reloadSkinCombo() {
        String selected = null;
        int index = this.mSkinCombo.getSelectionIndex();
        if (index >= 0) {
            selected = this.mSkinCombo.getItem(index);
        }
        this.mSkinCombo.removeAll();
        this.mSkinCombo.setEnabled(false);
        index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            String targetName = this.mTargetCombo.getItem(index);
            boolean found = false;
            IAndroidTarget target = this.mCurrentTargets.get(targetName);
            if (target != null) {
                this.mSkinCombo.add(String.format("Default (%s)", target.getDefaultSkin()));
                index = -1;
                for (File skin : target.getSkins()) {
                    this.mSkinCombo.add(skin.getName());
                    if (found) continue;
                    ++index;
                    found = skin.equals(selected);
                }
                this.mSkinCombo.setEnabled(true);
                if (found) {
                    this.mSkinCombo.select(index);
                } else {
                    this.mSkinCombo.select(0);
                    this.loadSkin();
                }
            }
        }
    }

    private void reloadTagAbiCombo() {
        String selected = null;
        boolean found = false;
        int index = this.mTargetCombo.getSelectionIndex();
        if (index >= 0) {
            String targetName = this.mTargetCombo.getItem(index);
            IAndroidTarget target = this.mCurrentTargets.get(targetName);
            ISystemImage[] systemImages = this.getSystemImages(target);
            this.mTagAbiCombo.setData(ABI_SYS_IMG_DATA_KEY, (Object)systemImages);
            this.mTagAbiCombo.setEnabled(systemImages.length > 1);
            index = this.mTagAbiCombo.getSelectionIndex();
            if (index >= 0 && this.mTagAbiCombo.getItemCount() > 1) {
                selected = this.mTagAbiCombo.getItem(index);
            }
            this.mTagAbiCombo.removeAll();
            for (int i = 0; i < systemImages.length; ++i) {
                String prettyAbiType = AvdInfo.getPrettyAbiType(systemImages[i]);
                this.mTagAbiCombo.add(prettyAbiType);
                if (found || !(found = prettyAbiType.equals(selected))) continue;
                this.mTagAbiCombo.select(i);
            }
            if (systemImages.length == 1) {
                this.mTagAbiCombo.select(0);
            }
        }
    }

    private void validatePage() {
        boolean can_create;
        int index;
        String targetName;
        IAndroidTarget target;
        ISystemImage[] systemImages;
        boolean isCreate;
        String error = null;
        String warning = null;
        String avdName = this.mAvdName.getText().trim();
        boolean hasAvdName = avdName.length() > 0;
        boolean bl = isCreate = this.mEditAvdInfo == null || !avdName.equals(this.mEditAvdInfo.getName());
        if (hasAvdName && !AvdManager.RE_AVD_NAME.matcher(avdName).matches()) {
            error = String.format("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, "a-z A-Z 0-9 . _ -");
        }
        if (hasAvdName && error == null && this.mTargetCombo.getSelectionIndex() < 0) {
            error = "A target must be selected in order to create an AVD.";
        }
        if (hasAvdName && error == null && this.mTargetCombo.getSelectionIndex() > 0 && (systemImages = this.getSystemImages(target = this.mCurrentTargets.get(targetName = this.mTargetCombo.getItem(index = this.mTargetCombo.getSelectionIndex())))).length > 1 && this.mTagAbiCombo.getSelectionIndex() < 0) {
            error = "An ABI type must be selected in order to create an AVD.";
        }
        if (error == null) {
            boolean sdcardFileMode = this.mSdCardFileRadio.getSelection();
            if (sdcardFileMode) {
                String sdName = this.mSdCardFile.getText().trim();
                if (sdName.length() > 0 && !new File(sdName).isFile()) {
                    error = "SD Card path isn't valid.";
                }
            } else {
                String valueString = this.mSdCardSize.getText();
                if (valueString.length() > 0) {
                    long originalSize;
                    String original;
                    Map<String, String> props;
                    long value = 0L;
                    try {
                        value = Long.parseLong(valueString);
                        int sizeIndex = this.mSdCardSizeCombo.getSelectionIndex();
                        if (sizeIndex >= 0) {
                            value <<= 10 * (1 + sizeIndex);
                        }
                        if (value < 0x900000L || value > 0xFFC0000000L) {
                            value = 0L;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (value <= 0L) {
                        error = "SD Card size is invalid. Range is 9 MiB..1023 GiB.";
                    } else if (this.mEditAvdInfo != null && (props = this.mEditAvdInfo.getProperties()) != null && (original = this.mEditAvdInfo.getProperties().get("sdcard.size")) != null && original.length() > 0 && (originalSize = AvdManager.parseSdcardSize(original, null)) > 0L && value != originalSize) {
                        warning = "A new SD Card file will be created.\nThe current SD Card file will be lost.";
                    }
                }
            }
        }
        if (error == null && this.mSkinSizeRadio.getSelection()) {
            String width = this.mSkinSizeWidth.getText();
            String height = this.mSkinSizeHeight.getText();
            if (width.length() == 0 || height.length() == 0) {
                error = "Skin size is incorrect.\nBoth dimensions must be > 0.";
            }
        }
        if (isCreate && hasAvdName && error == null && !this.mForceCreation.getSelection()) {
            Pair<AvdManager.AvdConflict, String> conflict = this.mAvdManager.isAvdNameConflicting(avdName);
            assert (conflict != null);
            switch ((AvdManager.AvdConflict)((Object)conflict.getFirst())) {
                case NO_CONFLICT: {
                    break;
                }
                case CONFLICT_EXISTING_AVD: 
                case CONFLICT_INVALID_AVD: {
                    error = String.format("The AVD name '%s' is already used.\nCheck \"Override the existing AVD\" to delete the existing one.", avdName);
                    break;
                }
                case CONFLICT_EXISTING_PATH: {
                    error = String.format("Conflict with %s\nCheck \"Override the existing AVD\" to delete the existing one.", conflict.getSecond());
                    break;
                }
                default: {
                    error = String.format("Conflict %s with %s.\nCheck \"Override the existing AVD\" to delete the existing one.", ((AvdManager.AvdConflict)((Object)conflict.getFirst())).toString(), conflict.getSecond());
                    assert (false);
                    break;
                }
            }
        }
        if (error == null && this.mEditAvdInfo != null && isCreate) {
            warning = String.format("The AVD '%1$s' will be duplicated into '%2$s'.", this.mEditAvdInfo.getName(), avdName);
        }
        boolean bl2 = can_create = hasAvdName && error == null;
        if (can_create) {
            can_create &= this.mTargetCombo.getSelectionIndex() >= 0;
        }
        this.mOkButton.setEnabled(can_create);
        if (isCreate) {
            this.mOkButton.setText("Create AVD");
        } else {
            this.mOkButton.setText("Edit AVD");
        }
        if (error != null) {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("reject_icon16.png"));
            this.mStatusLabel.setText(error);
        } else if (warning != null) {
            this.mStatusIcon.setImage(this.mImageFactory.getImageByName("warning_icon16.png"));
            this.mStatusLabel.setText(warning);
        } else {
            this.mStatusIcon.setImage(null);
            this.mStatusLabel.setText(" \n ");
        }
        this.mStatusComposite.pack(true);
    }

    private void loadSkin() {
        Map<String, String> skinHardwareConfig;
        FileWrapper skinHardwareFile;
        Map<String, String> targetHardwareConfig;
        FileWrapper targetHardwareFile;
        int targetIndex = this.mTargetCombo.getSelectionIndex();
        if (targetIndex < 0) {
            return;
        }
        String targetName = this.mTargetCombo.getItem(targetIndex);
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return;
        }
        String skinName = null;
        int skinIndex = this.mSkinCombo.getSelectionIndex();
        if (skinIndex < 0) {
            return;
        }
        if (skinIndex == 0) {
            File skin = target.getDefaultSkin();
            if (skin != null) {
                skinName = skin.getName();
            }
        } else {
            skinName = this.mSkinCombo.getItem(skinIndex);
        }
        String path = target.getPath(5);
        File skin = new File(path, skinName);
        if (!skin.isDirectory() && !target.isPlatform()) {
            path = target.getParent().getPath(5);
            skin = new File(path, skinName);
        }
        if (!skin.isDirectory()) {
            return;
        }
        HashMap<String, String> hardwareValues = new HashMap<String, String>();
        if (!target.isPlatform() && (targetHardwareFile = new FileWrapper(target.getLocation(), "hardware.ini")).isFile() && (targetHardwareConfig = ProjectProperties.parsePropertyFile((IAbstractFile)targetHardwareFile, null)) != null) {
            hardwareValues.putAll(targetHardwareConfig);
        }
        if ((skinHardwareFile = new FileWrapper(skin, "hardware.ini")).isFile() && (skinHardwareConfig = ProjectProperties.parsePropertyFile((IAbstractFile)skinHardwareFile, null)) != null) {
            hardwareValues.putAll(skinHardwareConfig);
        }
        for (Map.Entry entry : hardwareValues.entrySet()) {
            if (this.mEditedProperties.contains(entry.getKey())) continue;
            this.mProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.mHardwareViewer.refresh();
    }

    private boolean createAvd() {
        String avdName = this.mAvdName.getText().trim();
        int index = this.mTargetCombo.getSelectionIndex();
        if (avdName.length() == 0 || index < 0) {
            return false;
        }
        String targetName = this.mTargetCombo.getItem(index);
        IAndroidTarget target = this.mCurrentTargets.get(targetName);
        if (target == null) {
            return false;
        }
        IdDisplay tag = SystemImage.DEFAULT_TAG;
        this.mAbiType = "armeabi";
        Object appData = this.mTagAbiCombo.getData(ABI_SYS_IMG_DATA_KEY);
        if (appData instanceof ISystemImage[]) {
            int abiIndex = this.mTagAbiCombo.getSelectionIndex();
            ISystemImage[] systemImages = (ISystemImage[])appData;
            if (abiIndex >= 0 && abiIndex < systemImages.length) {
                ISystemImage systemImage = systemImages[abiIndex];
                tag = systemImage.getTag();
                this.mAbiType = systemImage.getAbiType();
            }
        }
        String sdName = null;
        if (this.mSdCardSizeRadio.getSelection()) {
            String value = this.mSdCardSize.getText().trim();
            if (value.length() > 0) {
                sdName = value;
                switch (this.mSdCardSizeCombo.getSelectionIndex()) {
                    case 0: {
                        sdName = sdName + "K";
                        break;
                    }
                    case 1: {
                        sdName = sdName + "M";
                        break;
                    }
                    case 2: {
                        sdName = sdName + "G";
                        break;
                    }
                    default: {
                        assert (false);
                        {
                            break;
                        }
                    }
                }
            }
        } else {
            sdName = this.mSdCardFile.getText().trim();
        }
        String skinName = null;
        if (this.mSkinListRadio.getSelection()) {
            int skinIndex = this.mSkinCombo.getSelectionIndex();
            if (skinIndex > 0) {
                skinName = this.mSkinCombo.getItem(skinIndex);
            }
        } else {
            skinName = this.mSkinSizeWidth.getText() + "x" + this.mSkinSizeHeight.getText();
        }
        ILogger log = this.mSdkLog;
        if (log == null || log instanceof MessageBoxLog) {
            log = new MessageBoxLog(String.format("Result of creating AVD '%s':", avdName), this.getContents().getDisplay(), false);
        }
        File avdFolder = null;
        try {
            avdFolder = AvdInfo.getDefaultAvdFolder(this.mAvdManager, avdName);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            return false;
        }
        boolean force = this.mForceCreation.getSelection();
        boolean snapshot = this.mSnapshotCheck.getSelection();
        boolean success = false;
        AvdInfo avdInfo = this.mAvdManager.createAvd(avdFolder, avdName, target, tag, this.mAbiType, null, skinName, sdName, this.mProperties, null, snapshot, force, this.mEditAvdInfo != null, log);
        boolean bl = success = avdInfo != null;
        if (log instanceof MessageBoxLog) {
            ((MessageBoxLog)log).displayResult(success);
        }
        return success;
    }

    private ISystemImage[] getSystemImages(IAndroidTarget target) {
        if (target != null) {
            ISystemImage[] images = target.getSystemImages();
            if (!(images != null && images.length != 0 || target.isPlatform())) {
                images = target.getParent().getSystemImages();
            }
            if (images != null) {
                return images;
            }
        }
        return new ISystemImage[0];
    }

    private class ValidateListener
    extends SelectionAdapter
    implements ModifyListener {
        private ValidateListener() {
        }

        public void modifyText(ModifyEvent e) {
            LegacyAvdEditDialog.this.validatePage();
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            LegacyAvdEditDialog.this.validatePage();
        }
    }

    private class CreateNameModifyListener
    implements ModifyListener {
        private CreateNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String name = LegacyAvdEditDialog.this.mAvdName.getText().trim();
            if (LegacyAvdEditDialog.this.mEditAvdInfo == null || !name.equals(LegacyAvdEditDialog.this.mEditAvdInfo.getName())) {
                Pair<AvdManager.AvdConflict, String> conflict = LegacyAvdEditDialog.this.mAvdManager.isAvdNameConflicting(name);
                if (conflict.getFirst() != AvdManager.AvdConflict.NO_CONFLICT) {
                    if (!LegacyAvdEditDialog.this.mForceCreation.isEnabled()) {
                        LegacyAvdEditDialog.this.mForceCreation.setEnabled(true);
                        LegacyAvdEditDialog.this.mForceCreation.setSelection(false);
                    }
                } else {
                    LegacyAvdEditDialog.this.mForceCreation.setEnabled(false);
                    LegacyAvdEditDialog.this.mForceCreation.setSelection(false);
                }
            } else {
                LegacyAvdEditDialog.this.mForceCreation.setEnabled(false);
                LegacyAvdEditDialog.this.mForceCreation.setSelection(false);
            }
            LegacyAvdEditDialog.this.validatePage();
        }
    }
}

