/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.annotations.NonNull;
import com.android.utils.ILogger;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class MessageBoxLog
implements ILogger {
    final ArrayList<String> logMessages = new ArrayList();
    private final String mMessage;
    private final Display mDisplay;
    private final boolean mLogErrorsOnly;

    public MessageBoxLog(String message, Display display, boolean logErrorsOnly) {
        this.mMessage = message;
        this.mDisplay = display;
        this.mLogErrorsOnly = logErrorsOnly;
    }

    public void error(Throwable throwable, String errorFormat, Object ... arg) {
        if (errorFormat != null) {
            this.logMessages.add(String.format("Error: " + errorFormat, arg));
        }
        if (throwable != null) {
            this.logMessages.add(throwable.getMessage());
        }
    }

    public void warning(@NonNull String warningFormat, Object ... arg) {
        if (!this.mLogErrorsOnly) {
            this.logMessages.add(String.format("Warning: " + warningFormat, arg));
        }
    }

    public void info(@NonNull String msgFormat, Object ... arg) {
        if (!this.mLogErrorsOnly) {
            this.logMessages.add(String.format(msgFormat, arg));
        }
    }

    public void verbose(@NonNull String msgFormat, Object ... arg) {
        if (!this.mLogErrorsOnly) {
            this.logMessages.add(String.format(msgFormat, arg));
        }
    }

    public void displayResult(final boolean success) {
        if (this.logMessages.size() > 0) {
            final StringBuilder sb = new StringBuilder(this.mMessage + "\n\n");
            for (String msg : this.logMessages) {
                int n;
                if (msg.length() <= 0) continue;
                if (msg.charAt(0) != '\n' && (n = sb.length()) > 0 && sb.charAt(n - 1) != '\n') {
                    sb.append('\n');
                }
                sb.append(msg);
            }
            if (this.mDisplay != null && !this.mDisplay.isDisposed()) {
                this.mDisplay.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = null;
                        if (MessageBoxLog.this.mDisplay != null && !MessageBoxLog.this.mDisplay.isDisposed()) {
                            shell = MessageBoxLog.this.mDisplay.getActiveShell();
                        }
                        if (shell == null || shell.isDisposed()) {
                            return;
                        }
                        if (success && !MessageBoxLog.this.mLogErrorsOnly) {
                            MessageDialog.openInformation(shell, "Android Virtual Devices Manager", sb.toString());
                        } else {
                            MessageDialog.openError(shell, "Android Virtual Devices Manager", sb.toString());
                        }
                    }
                });
            }
        }
    }
}

