/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import com.android.ide.eclipse.gltrace.TraceFileInfo;
import com.android.ide.eclipse.gltrace.TraceFileReader;
import com.android.ide.eclipse.gltrace.format.GLAPISpec;
import com.android.ide.eclipse.gltrace.format.GLMessageFormatter;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLFrame;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import com.android.ide.eclipse.gltrace.state.transforms.StateTransformFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TraceFileParserTask
implements IRunnableWithProgress {
    private static final TraceFileReader sReader = new TraceFileReader();
    private static final GLMessageFormatter sGLMessageFormatter = new GLMessageFormatter(GLAPISpec.getSpecs());
    private String mTraceFilePath;
    private RandomAccessFile mFile;
    private List<GLCall> mGLCalls;
    private Set<Integer> mGLContextIds;
    private GLTrace mTrace;

    public TraceFileParserTask(String string) {
        try {
            this.mFile = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        this.mTraceFilePath = string;
        this.mGLCalls = new ArrayList<GLCall>();
        this.mGLContextIds = new TreeSet<Integer>();
    }

    private void addMessage(int n, long l, GLProtoBuf.GLMessage gLMessage, long l2) {
        String string;
        try {
            string = sGLMessageFormatter.formatGLMessage(gLMessage);
        }
        catch (Exception exception) {
            string = String.format("%s()", gLMessage.getFunction().toString());
        }
        GLCall gLCall = new GLCall(n, l2, l, string, gLMessage.getFunction(), gLMessage.hasFb(), gLMessage.getContextId(), gLMessage.getDuration(), gLMessage.getThreadtime());
        this.addProperties(gLCall, gLMessage);
        try {
            gLCall.setStateTransformations(StateTransformFactory.getTransformsFor(gLMessage));
        }
        catch (Exception exception) {
            gLCall.setStateTransformationCreationError(exception.getMessage());
            GlTracePlugin.getDefault().logMessage("Error while creating transformations for " + gLCall.toString() + ":");
            GlTracePlugin.getDefault().logMessage(exception.getMessage());
        }
        this.mGLCalls.add(gLCall);
        this.mGLContextIds.add(gLCall.getContextId());
    }

    private void addProperties(GLCall gLCall, GLProtoBuf.GLMessage gLMessage) {
        switch (gLMessage.getFunction()) {
            case glPushGroupMarkerEXT: {
                gLCall.addProperty(0, gLMessage.getArgs(1).getCharValue(0).toStringUtf8());
                break;
            }
            case glVertexAttribPointerData: {
                gLCall.addProperty(1, gLMessage.getArgs(1).getIntValue(0));
                gLCall.addProperty(2, (Object)GLEnum.valueOf(gLMessage.getArgs(2).getIntValue(0)));
                gLCall.addProperty(3, gLMessage.getArgs(5).getRawBytes(0).toByteArray());
                break;
            }
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        Object object;
        long l;
        try {
            l = this.mFile.length();
        }
        catch (IOException iOException) {
            l = 0L;
        }
        iProgressMonitor.beginTask("Parsing OpenGL Trace File", l > 0L ? 100 : -1);
        List<GLFrame> list = null;
        try {
            try {
                int n;
                object = null;
                int n2 = 0;
                long l2 = this.mFile.getFilePointer();
                int n3 = 0;
                long l3 = Long.MAX_VALUE;
                while ((object = sReader.getMessageAtOffset(this.mFile, -1L)) != null) {
                    if (l3 > ((GLProtoBuf.GLMessage)((Object)object)).getStartTime()) {
                        l3 = ((GLProtoBuf.GLMessage)((Object)object)).getStartTime();
                    }
                    this.addMessage(n2, l2, (GLProtoBuf.GLMessage)((Object)object), ((GLProtoBuf.GLMessage)((Object)object)).getStartTime() - l3);
                    l2 = this.mFile.getFilePointer();
                    ++n2;
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (l <= 0L) continue;
                    n = (int)(l2 * 100L / l);
                    iProgressMonitor.worked(n - n3);
                    n3 = n;
                }
                if (this.mGLContextIds.size() > 1) {
                    Collections.sort(this.mGLCalls, new Comparator<GLCall>(){

                        @Override
                        public int compare(GLCall gLCall, GLCall gLCall2) {
                            long l = gLCall.getStartTime() - gLCall2.getStartTime();
                            if (l == 0L) {
                                return 0;
                            }
                            if (l > 0L) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    n = 0;
                    while (n < this.mGLCalls.size()) {
                        this.mGLCalls.get(n).setIndex(n);
                        ++n;
                    }
                }
                list = this.createFrames(this.mGLCalls);
            }
            catch (Exception exception) {
                throw new InvocationTargetException(exception);
            }
        }
        catch (Throwable throwable) {
            try {
                this.mFile.close();
            }
            catch (IOException iOException) {}
            iProgressMonitor.done();
            throw throwable;
        }
        try {
            this.mFile.close();
        }
        catch (IOException iOException) {}
        iProgressMonitor.done();
        object = new File(this.mTraceFilePath);
        TraceFileInfo traceFileInfo = new TraceFileInfo(this.mTraceFilePath, ((File)object).length(), ((File)object).lastModified());
        this.mTrace = new GLTrace(traceFileInfo, list, this.mGLCalls, new ArrayList<Integer>(this.mGLContextIds));
    }

    private List<GLFrame> createFrames(List<GLCall> list) {
        ArrayList<GLFrame> arrayList = new ArrayList<GLFrame>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            GLCall gLCall = list.get(n3);
            if (gLCall.getFunction() == GLProtoBuf.GLMessage.Function.eglSwapBuffers) {
                arrayList.add(new GLFrame(n2, n, n3 + 1));
                n = n3 + 1;
                ++n2;
            }
            ++n3;
        }
        if (n != this.mGLCalls.size()) {
            arrayList.add(new GLFrame(n2, n, this.mGLCalls.size()));
        }
        return arrayList;
    }

    public GLTrace getTrace() {
        return this.mTrace;
    }
}

