/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLCompositeProperty;
import com.android.ide.eclipse.gltrace.state.GLListProperty;
import com.android.ide.eclipse.gltrace.state.GLSparseArrayProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import java.util.ArrayList;
import java.util.List;

public class GLPropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final List<GLPropertyExtractor> mExtractors;

    private GLPropertyAccessor(int n, List<GLPropertyExtractor> list) {
        this.mContextId = n;
        this.mExtractors = list;
    }

    @Override
    public IGLProperty getProperty(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = ((GLListProperty)iGLProperty).get(this.mContextId);
        for (GLPropertyExtractor gLPropertyExtractor : this.mExtractors) {
            IGLProperty iGLProperty3 = gLPropertyExtractor.getProperty(iGLProperty2);
            if (iGLProperty3 == null) {
                iGLProperty2 = null;
                break;
            }
            iGLProperty2 = iGLProperty3;
        }
        return iGLProperty2;
    }

    public static IGLPropertyAccessor makeAccessor(int n, Object ... objectArray) {
        ArrayList<GLPropertyExtractor> arrayList = new ArrayList<GLPropertyExtractor>();
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray2[n3];
            if (object instanceof GLStateType) {
                arrayList.add(new GLNamePropertyExtractor((GLStateType)((Object)object)));
            } else if (object instanceof Integer) {
                arrayList.add(new GLIndexPropertyExtractor((Integer)object));
            } else {
                throw new IllegalArgumentException("Unknown property (" + object + ") used to access members of IGLProperty");
            }
            ++n3;
        }
        return new GLPropertyAccessor(n, arrayList);
    }

    @Override
    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder(this.mExtractors.size() * 10);
        for (GLPropertyExtractor gLPropertyExtractor : this.mExtractors) {
            if (gLPropertyExtractor instanceof GLNamePropertyExtractor) {
                stringBuilder.append((Object)((GLNamePropertyExtractor)gLPropertyExtractor).mType);
            } else {
                stringBuilder.append(((GLIndexPropertyExtractor)gLPropertyExtractor).mIndex);
            }
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    private static class GLIndexPropertyExtractor
    implements GLPropertyExtractor {
        private final int mIndex;

        public GLIndexPropertyExtractor(int n) {
            this.mIndex = n;
        }

        @Override
        public IGLProperty getProperty(IGLProperty iGLProperty) {
            if (iGLProperty instanceof GLListProperty && this.mIndex >= 0) {
                return ((GLListProperty)iGLProperty).get(this.mIndex);
            }
            if (iGLProperty instanceof GLSparseArrayProperty) {
                return ((GLSparseArrayProperty)iGLProperty).getProperty(this.mIndex);
            }
            return null;
        }
    }

    private static class GLNamePropertyExtractor
    implements GLPropertyExtractor {
        private final GLStateType mType;

        public GLNamePropertyExtractor(GLStateType gLStateType) {
            this.mType = gLStateType;
        }

        @Override
        public IGLProperty getProperty(IGLProperty iGLProperty) {
            if (iGLProperty instanceof GLCompositeProperty) {
                return ((GLCompositeProperty)iGLProperty).getProperty(this.mType);
            }
            return null;
        }
    }

    private static interface GLPropertyExtractor {
        public IGLProperty getProperty(IGLProperty var1);
    }
}

