/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.Client;
import com.android.ddmlib.Log;
import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.NativeStackCallInfo;
import com.android.ddmuilib.Addr2Line;
import com.android.ddmuilib.BaseHeapPanel;
import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.heap.NativeHeapDataImporter;
import com.android.ddmuilib.heap.NativeHeapDiffSnapshot;
import com.android.ddmuilib.heap.NativeHeapLabelProvider;
import com.android.ddmuilib.heap.NativeHeapProviderByAllocations;
import com.android.ddmuilib.heap.NativeHeapProviderByLibrary;
import com.android.ddmuilib.heap.NativeHeapSnapshot;
import com.android.ddmuilib.heap.NativeStackContentProvider;
import com.android.ddmuilib.heap.NativeStackLabelProvider;
import com.android.ddmuilib.heap.NativeSymbolResolverTask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class NativeHeapPanel
extends BaseHeapPanel {
    private static final boolean USE_OLD_RESOLVER;
    private final int MAX_DISPLAYED_ERROR_ITEMS = 5;
    private static final String TOOLTIP_EXPORT_DATA = "Export Heap Data";
    private static final String TOOLTIP_ZYGOTE_ALLOCATIONS = "Show Zygote Allocations";
    private static final String TOOLTIP_DIFFS_ONLY = "Only show new allocations not present in previous snapshot";
    private static final String TOOLTIP_GROUPBY = "Group allocations by library.";
    private static final String EXPORT_DATA_IMAGE = "save.png";
    private static final String ZYGOTE_IMAGE = "zygote.png";
    private static final String DIFFS_ONLY_IMAGE = "diff.png";
    private static final String GROUPBY_IMAGE = "groupby.png";
    private static final String SNAPSHOT_HEAP_BUTTON_TEXT = "Snapshot Current Native Heap Usage";
    private static final String LOAD_HEAP_DATA_BUTTON_TEXT = "Import Heap Data";
    private static final String SYMBOL_SEARCH_PATH_LABEL_TEXT = "Symbol Search Path:";
    private static final String SYMBOL_SEARCH_PATH_TEXT_MESSAGE = "List of colon separated paths to search for symbol debug information. See tooltip for examples.";
    private static final String SYMBOL_SEARCH_PATH_TOOLTIP_TEXT = "Colon separated paths that contain unstripped libraries with debug symbols.\ne.g.: <android-src>/out/target/product/generic/symbols/system/lib:/path/to/my/app/obj/local/armeabi";
    private static final String PREFS_SHOW_DIFFS_ONLY = "nativeheap.show.diffs.only";
    private static final String PREFS_SHOW_ZYGOTE_ALLOCATIONS = "nativeheap.show.zygote";
    private static final String PREFS_GROUP_BY_LIBRARY = "nativeheap.grouby.library";
    private static final String PREFS_SYMBOL_SEARCH_PATH = "nativeheap.search.path";
    private static final String PREFS_SASH_HEIGHT_PERCENT = "nativeheap.sash.percent";
    private static final String PREFS_LAST_IMPORTED_HEAPPATH = "nativeheap.last.import.path";
    private IPreferenceStore mPrefStore;
    private List<NativeHeapSnapshot> mNativeHeapSnapshots;
    private List<NativeHeapSnapshot> mDiffSnapshots;
    private Map<Integer, List<NativeHeapSnapshot>> mImportedSnapshotsPerPid;
    private Button mSnapshotHeapButton;
    private Button mLoadHeapDataButton;
    private Text mSymbolSearchPathText;
    private Combo mSnapshotIndexCombo;
    private Label mMemoryAllocatedText;
    private TreeViewer mDetailsTreeViewer;
    private TreeViewer mStackTraceTreeViewer;
    private NativeHeapProviderByAllocations mContentProviderByAllocations;
    private NativeHeapProviderByLibrary mContentProviderByLibrary;
    private NativeHeapLabelProvider mDetailsTreeLabelProvider;
    private ToolItem mGroupByButton;
    private ToolItem mDiffsOnlyButton;
    private ToolItem mShowZygoteAllocationsButton;
    private ToolItem mExportHeapDataButton;
    private ITableFocusListener mTableFocusListener;

    public NativeHeapPanel(IPreferenceStore prefStore) {
        this.mPrefStore = prefStore;
        this.mPrefStore.setDefault(PREFS_SASH_HEIGHT_PERCENT, 75);
        this.mPrefStore.setDefault(PREFS_SYMBOL_SEARCH_PATH, "");
        this.mPrefStore.setDefault(PREFS_GROUP_BY_LIBRARY, false);
        this.mPrefStore.setDefault(PREFS_SHOW_ZYGOTE_ALLOCATIONS, true);
        this.mPrefStore.setDefault(PREFS_SHOW_DIFFS_ONLY, false);
        this.mNativeHeapSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mDiffSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mImportedSnapshotsPerPid = new HashMap<Integer, List<NativeHeapSnapshot>>();
    }

    @Override
    public void clientChanged(final Client client, int changeMask) {
        if (client != this.getCurrentClient()) {
            return;
        }
        if ((changeMask & 0x80) != 128) {
            return;
        }
        List<NativeAllocationInfo> allocations = client.getClientData().getNativeAllocationList();
        if (allocations.size() == 0) {
            return;
        }
        final List<NativeAllocationInfo> nativeAllocations = this.shallowCloneList(allocations);
        this.addNativeHeapSnapshot(new NativeHeapSnapshot(nativeAllocations));
        this.updateDisplay();
        if (USE_OLD_RESOLVER) {
            Thread t = new Thread(new SymbolResolverTask(nativeAllocations, client.getClientData().getMappedNativeLibraries()));
            t.setName("Address to Symbol Resolver");
            t.start();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    this.resolveSymbols();
                    NativeHeapPanel.this.mDetailsTreeViewer.refresh();
                    NativeHeapPanel.this.mStackTraceTreeViewer.refresh();
                }

                public void resolveSymbols() {
                    Shell shell = Display.getDefault().getActiveShell();
                    ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
                    NativeSymbolResolverTask resolver = new NativeSymbolResolverTask(nativeAllocations, client.getClientData().getMappedNativeLibraries(), NativeHeapPanel.this.mSymbolSearchPathText.getText());
                    try {
                        d.run(true, true, resolver);
                    }
                    catch (InvocationTargetException e) {
                        MessageDialog.openError(shell, "Error Resolving Symbols", e.getCause().getMessage());
                        return;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    MessageDialog.openInformation(shell, "Symbol Resolution Status", NativeHeapPanel.this.getResolutionStatusMessage(resolver));
                }
            });
        }
    }

    private String getResolutionStatusMessage(NativeSymbolResolverTask resolver) {
        Set<Long> unresolvableAddresses;
        Set<String> notFoundLibraries;
        StringBuilder sb = new StringBuilder();
        sb.append("Symbol Resolution Complete.\n\n");
        Set<Long> unmappedAddresses = resolver.getUnmappedAddresses();
        if (unmappedAddresses.size() > 0) {
            sb.append(String.format("Unmapped addresses (%d): ", unmappedAddresses.size()));
            sb.append(this.getSampleForDisplay(unmappedAddresses));
            sb.append('\n');
        }
        if ((notFoundLibraries = resolver.getNotFoundLibraries()).size() > 0) {
            sb.append(String.format("Libraries not found on disk (%d): ", notFoundLibraries.size()));
            sb.append(this.getSampleForDisplay(notFoundLibraries));
            sb.append('\n');
        }
        if ((unresolvableAddresses = resolver.getUnresolvableAddresses()).size() > 0) {
            sb.append(String.format("Unresolved addresses (%d): ", unresolvableAddresses.size()));
            sb.append(this.getSampleForDisplay(unresolvableAddresses));
            sb.append('\n');
        }
        if (resolver.getAddr2LineErrorMessage() != null) {
            sb.append("Error launching addr2line: ");
            sb.append(resolver.getAddr2LineErrorMessage());
        }
        return sb.toString();
    }

    private String getSampleForDisplay(Collection<?> items) {
        StringBuilder sb = new StringBuilder();
        int c = 1;
        Iterator<?> it = items.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof Long) {
                sb.append(String.format("0x%x", item));
            } else {
                sb.append(item);
            }
            if (c == 5 && it.hasNext()) {
                sb.append(", ...");
                break;
            }
            if (it.hasNext()) {
                sb.append(", ");
            }
            ++c;
        }
        return sb.toString();
    }

    private void addNativeHeapSnapshot(NativeHeapSnapshot snapshot) {
        this.mNativeHeapSnapshots.add(snapshot);
        this.mDiffSnapshots.add(null);
    }

    private List<NativeAllocationInfo> shallowCloneList(List<NativeAllocationInfo> allocations) {
        ArrayList<NativeAllocationInfo> clonedList = new ArrayList<NativeAllocationInfo>(allocations.size());
        for (NativeAllocationInfo i : allocations) {
            clonedList.add(i);
        }
        return clonedList;
    }

    @Override
    public void deviceSelected() {
    }

    @Override
    public void clientSelected() {
        Client c = this.getCurrentClient();
        if (c == null) {
            this.mSnapshotHeapButton.setEnabled(false);
            this.mLoadHeapDataButton.setEnabled(false);
            return;
        }
        this.mNativeHeapSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mDiffSnapshots = new ArrayList<NativeHeapSnapshot>();
        this.mSnapshotHeapButton.setEnabled(true);
        this.mLoadHeapDataButton.setEnabled(true);
        List<NativeHeapSnapshot> importedSnapshots = this.mImportedSnapshotsPerPid.get(c.getClientData().getPid());
        if (importedSnapshots != null) {
            for (NativeHeapSnapshot n : importedSnapshots) {
                this.addNativeHeapSnapshot(n);
            }
        }
        List<NativeAllocationInfo> allocations = c.getClientData().getNativeAllocationList();
        if ((allocations = this.shallowCloneList(allocations)).size() > 0) {
            this.addNativeHeapSnapshot(new NativeHeapSnapshot(allocations));
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NativeHeapPanel.this.updateSnapshotIndexCombo();
                NativeHeapPanel.this.updateToolbars();
                int lastSnapshotIndex = NativeHeapPanel.this.mNativeHeapSnapshots.size() - 1;
                NativeHeapPanel.this.displaySnapshot(lastSnapshotIndex);
                NativeHeapPanel.this.displayStackTraceForSelection();
            }
        });
    }

    private void displaySelectedSnapshot() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int idx = NativeHeapPanel.this.mSnapshotIndexCombo.getSelectionIndex();
                NativeHeapPanel.this.displaySnapshot(idx);
            }
        });
    }

    private void displaySnapshot(int index) {
        if (index < 0 || this.mNativeHeapSnapshots.size() == 0) {
            this.mDetailsTreeViewer.setInput(null);
            this.mMemoryAllocatedText.setText("");
            return;
        }
        assert (index < this.mNativeHeapSnapshots.size()) : "Invalid snapshot index";
        NativeHeapSnapshot snapshot = this.mNativeHeapSnapshots.get(index);
        if (this.mDiffsOnlyButton.getSelection() && index > 0) {
            snapshot = this.getDiffSnapshot(index);
        }
        this.mMemoryAllocatedText.setText(snapshot.getFormattedMemorySize());
        this.mMemoryAllocatedText.pack();
        this.mDetailsTreeLabelProvider.setTotalSize(snapshot.getTotalSize());
        this.mDetailsTreeViewer.setInput(snapshot);
        this.mDetailsTreeViewer.refresh();
    }

    private NativeHeapSnapshot getDiffSnapshot(int index) {
        NativeHeapSnapshot diffSnapshot = this.mDiffSnapshots.get(index);
        if (diffSnapshot != null) {
            return diffSnapshot;
        }
        NativeHeapSnapshot cur = this.mNativeHeapSnapshots.get(index);
        NativeHeapSnapshot prev = this.mNativeHeapSnapshots.get(index - 1);
        diffSnapshot = new NativeHeapDiffSnapshot(cur, prev);
        this.mDiffSnapshots.set(index, diffSnapshot);
        return diffSnapshot;
    }

    private void updateDisplayGrouping() {
        boolean groupByLibrary = this.mGroupByButton.getSelection();
        this.mPrefStore.setValue(PREFS_GROUP_BY_LIBRARY, groupByLibrary);
        if (groupByLibrary) {
            this.mDetailsTreeViewer.setContentProvider(this.mContentProviderByLibrary);
        } else {
            this.mDetailsTreeViewer.setContentProvider(this.mContentProviderByAllocations);
        }
    }

    private void updateDisplayForZygotes() {
        boolean displayZygoteMemory = this.mShowZygoteAllocationsButton.getSelection();
        this.mPrefStore.setValue(PREFS_SHOW_ZYGOTE_ALLOCATIONS, displayZygoteMemory);
        this.mContentProviderByLibrary.displayZygoteMemory(displayZygoteMemory);
        this.mContentProviderByAllocations.displayZygoteMemory(displayZygoteMemory);
        this.mDetailsTreeViewer.refresh();
    }

    private void updateSnapshotIndexCombo() {
        ArrayList<String> items = new ArrayList<String>();
        int numSnapshots = this.mNativeHeapSnapshots.size();
        for (int i = 0; i < numSnapshots; ++i) {
            items.add("Snapshot " + (i + 1));
        }
        this.mSnapshotIndexCombo.setItems(items.toArray(new String[items.size()]));
        if (numSnapshots > 0) {
            this.mSnapshotIndexCombo.setEnabled(true);
            this.mSnapshotIndexCombo.select(numSnapshots - 1);
        } else {
            this.mSnapshotIndexCombo.setEnabled(false);
        }
    }

    private void updateToolbars() {
        int numSnapshots = this.mNativeHeapSnapshots.size();
        this.mExportHeapDataButton.setEnabled(numSnapshots > 0);
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(1808));
        this.createControlsSection(c);
        this.createDetailsSection(c);
        this.clientSelected();
        return c;
    }

    private void createControlsSection(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        c.setLayoutData((Object)new GridData(768));
        this.createGetHeapDataSection(c);
        Label l = new Label(c, 514);
        l.setLayoutData((Object)new GridData(1040));
        this.createDisplaySection(c);
    }

    private void createGetHeapDataSection(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        this.createTakeHeapSnapshotButton(c);
        Label l = new Label(c, 258);
        l.setLayoutData((Object)new GridData(768));
        this.createLoadHeapDataButton(c);
    }

    private void createTakeHeapSnapshotButton(Composite parent) {
        this.mSnapshotHeapButton = new Button(parent, 2056);
        this.mSnapshotHeapButton.setText(SNAPSHOT_HEAP_BUTTON_TEXT);
        this.mSnapshotHeapButton.setLayoutData((Object)new GridData());
        this.mSnapshotHeapButton.setEnabled(false);
        this.mSnapshotHeapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                NativeHeapPanel.this.snapshotHeap();
            }
        });
    }

    private void snapshotHeap() {
        Client c = this.getCurrentClient();
        assert (c != null) : "Snapshot Heap could not have been enabled w/o a selected client.";
        c.requestNativeHeapInformation();
    }

    private void createLoadHeapDataButton(Composite parent) {
        this.mLoadHeapDataButton = new Button(parent, 2056);
        this.mLoadHeapDataButton.setText(LOAD_HEAP_DATA_BUTTON_TEXT);
        this.mLoadHeapDataButton.setLayoutData((Object)new GridData());
        this.mLoadHeapDataButton.setEnabled(false);
        this.mLoadHeapDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                NativeHeapPanel.this.loadHeapDataFromFile();
            }
        });
    }

    private void loadHeapDataFromFile() {
        String path = this.getHeapDumpToImport();
        if (path == null) {
            return;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(path);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        Shell shell = Display.getDefault().getActiveShell();
        ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
        NativeHeapDataImporter importer = new NativeHeapDataImporter(reader);
        try {
            d.run(true, true, importer);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError(shell, "Error Importing Heap Data", e.getCause().getMessage());
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        NativeHeapSnapshot snapshot = importer.getImportedSnapshot();
        this.addToImportedSnapshots(snapshot);
        this.addNativeHeapSnapshot(snapshot);
        this.updateDisplay();
    }

    private void addToImportedSnapshots(NativeHeapSnapshot snapshot) {
        Client c = this.getCurrentClient();
        if (c == null) {
            return;
        }
        Integer pid = c.getClientData().getPid();
        List<NativeHeapSnapshot> importedSnapshots = this.mImportedSnapshotsPerPid.get(pid);
        if (importedSnapshots == null) {
            importedSnapshots = new ArrayList<NativeHeapSnapshot>();
        }
        importedSnapshots.add(snapshot);
        this.mImportedSnapshotsPerPid.put(pid, importedSnapshots);
    }

    private String getHeapDumpToImport() {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fileDialog.setText("Import Heap Dump");
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        fileDialog.setFilterPath(this.mPrefStore.getString(PREFS_LAST_IMPORTED_HEAPPATH));
        String selectedFile = fileDialog.open();
        if (selectedFile != null) {
            this.mPrefStore.setValue(PREFS_LAST_IMPORTED_HEAPPATH, new File(selectedFile).getParent());
        }
        return selectedFile;
    }

    private void createDisplaySection(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(768));
        this.createLabel(c, "Display:");
        this.mSnapshotIndexCombo = new Combo(c, 8);
        this.mSnapshotIndexCombo.setItems(new String[]{"No heap snapshots available."});
        this.mSnapshotIndexCombo.setEnabled(false);
        this.mSnapshotIndexCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NativeHeapPanel.this.displaySelectedSnapshot();
            }
        });
        this.createLabel(c, "Memory Allocated:");
        this.mMemoryAllocatedText = new Label(c, 0);
        GridData gd = new GridData();
        gd.widthHint = 100;
        this.mMemoryAllocatedText.setLayoutData((Object)gd);
        this.createLabel(c, SYMBOL_SEARCH_PATH_LABEL_TEXT);
        this.mSymbolSearchPathText = new Text(c, 2048);
        this.mSymbolSearchPathText.setMessage(SYMBOL_SEARCH_PATH_TEXT_MESSAGE);
        this.mSymbolSearchPathText.setToolTipText(SYMBOL_SEARCH_PATH_TOOLTIP_TEXT);
        this.mSymbolSearchPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String path = NativeHeapPanel.this.mSymbolSearchPathText.getText();
                NativeHeapPanel.this.updateSearchPath(path);
                NativeHeapPanel.this.mPrefStore.setValue(NativeHeapPanel.PREFS_SYMBOL_SEARCH_PATH, path);
            }
        });
        this.mSymbolSearchPathText.setText(this.mPrefStore.getString(PREFS_SYMBOL_SEARCH_PATH));
        this.mSymbolSearchPathText.setLayoutData((Object)new GridData(768));
    }

    private void updateSearchPath(String path) {
        Addr2Line.setSearchPath(path);
    }

    private void createLabel(Composite parent, String text) {
        Label l = new Label(parent, 0);
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        l.setLayoutData((Object)gd);
    }

    private void createDetailsSection(Composite parent) {
        final Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FormLayout());
        c.setLayoutData((Object)new GridData(1808));
        ToolBar detailsToolBar = new ToolBar(c, 0x800800);
        this.initializeDetailsToolBar(detailsToolBar);
        Tree detailsTree = new Tree(c, 268437506);
        this.initializeDetailsTree(detailsTree);
        final Sash sash = new Sash(c, 2304);
        Label stackTraceLabel = new Label(c, 0);
        stackTraceLabel.setText("Stack Trace:");
        Tree stackTraceTree = new Tree(c, 2050);
        this.initializeStackTraceTree(stackTraceTree);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        detailsToolBar.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)detailsToolBar, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        detailsTree.setLayoutData((Object)data);
        final FormData sashData = new FormData();
        sashData.top = new FormAttachment(this.mPrefStore.getInt(PREFS_SASH_HEIGHT_PERCENT), 0);
        sashData.left = new FormAttachment(0, 0);
        sashData.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)sashData);
        data = new FormData();
        data.top = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        stackTraceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)stackTraceLabel, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        stackTraceTree.setLayoutData((Object)data);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle sashRect = sash.getBounds();
                Rectangle panelRect = c.getClientArea();
                int sashPercent = sashRect.y * 100 / panelRect.height;
                NativeHeapPanel.this.mPrefStore.setValue(NativeHeapPanel.PREFS_SASH_HEIGHT_PERCENT, sashPercent);
                sashData.top = new FormAttachment(0, e.y);
                c.layout();
            }
        });
    }

    private void initializeDetailsToolBar(ToolBar toolbar) {
        this.mGroupByButton = new ToolItem(toolbar, 32);
        this.mGroupByButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(GROUPBY_IMAGE, toolbar.getDisplay()));
        this.mGroupByButton.setToolTipText(TOOLTIP_GROUPBY);
        this.mGroupByButton.setSelection(this.mPrefStore.getBoolean(PREFS_GROUP_BY_LIBRARY));
        this.mGroupByButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NativeHeapPanel.this.updateDisplayGrouping();
            }
        });
        this.mDiffsOnlyButton = new ToolItem(toolbar, 32);
        this.mDiffsOnlyButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(DIFFS_ONLY_IMAGE, toolbar.getDisplay()));
        this.mDiffsOnlyButton.setToolTipText(TOOLTIP_DIFFS_ONLY);
        this.mDiffsOnlyButton.setSelection(this.mPrefStore.getBoolean(PREFS_SHOW_DIFFS_ONLY));
        this.mDiffsOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = NativeHeapPanel.this.mSnapshotIndexCombo.getSelectionIndex();
                NativeHeapPanel.this.displaySnapshot(idx);
            }
        });
        this.mShowZygoteAllocationsButton = new ToolItem(toolbar, 32);
        this.mShowZygoteAllocationsButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(ZYGOTE_IMAGE, toolbar.getDisplay()));
        this.mShowZygoteAllocationsButton.setToolTipText(TOOLTIP_ZYGOTE_ALLOCATIONS);
        this.mShowZygoteAllocationsButton.setSelection(this.mPrefStore.getBoolean(PREFS_SHOW_ZYGOTE_ALLOCATIONS));
        this.mShowZygoteAllocationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NativeHeapPanel.this.updateDisplayForZygotes();
            }
        });
        this.mExportHeapDataButton = new ToolItem(toolbar, 8);
        this.mExportHeapDataButton.setImage(ImageLoader.getDdmUiLibLoader().loadImage(EXPORT_DATA_IMAGE, toolbar.getDisplay()));
        this.mExportHeapDataButton.setToolTipText(TOOLTIP_EXPORT_DATA);
        this.mExportHeapDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NativeHeapPanel.this.exportSnapshot();
            }
        });
    }

    private void exportSnapshot() {
        int idx = this.mSnapshotIndexCombo.getSelectionIndex();
        String snapshotName = this.mSnapshotIndexCombo.getItem(idx);
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fileDialog.setText("Save " + snapshotName);
        fileDialog.setFileName("allocations.txt");
        final String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        final NativeHeapSnapshot snapshot = this.mNativeHeapSnapshots.get(idx);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PrintWriter out;
                try {
                    out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                }
                catch (IOException e) {
                    this.displayErrorMessage(e.getMessage());
                    return;
                }
                for (NativeAllocationInfo alloc : snapshot.getAllocations()) {
                    out.println(alloc.toString());
                }
                out.close();
            }

            private void displayErrorMessage(final String message) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError(Display.getDefault().getActiveShell(), "Failed to export heap data", message);
                    }
                });
            }
        });
        t.setName("Saving Heap Data to File...");
        t.start();
    }

    private void initializeDetailsTree(Tree tree) {
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        List<String> properties = Arrays.asList("Library", "Total", "Percentage", "Count", "Size", "Method");
        List<String> sampleValues = Arrays.asList("/path/in/device/to/system/library.so", "123456789", " 100%", "123456789", "123456789", "PossiblyLongDemangledMethodName");
        List<Integer> swtFlags = Arrays.asList(16384, 131072, 131072, 131072, 131072, 16384);
        for (int i = 0; i < properties.size(); ++i) {
            String p = properties.get(i);
            String v = sampleValues.get(i);
            int flags = swtFlags.get(i);
            TableHelper.createTreeColumn(tree, p, flags, v, this.getPref("details", p), this.mPrefStore);
        }
        this.mDetailsTreeViewer = new TreeViewer(tree);
        this.mDetailsTreeViewer.setUseHashlookup(true);
        boolean displayZygotes = this.mPrefStore.getBoolean(PREFS_SHOW_ZYGOTE_ALLOCATIONS);
        this.mContentProviderByAllocations = new NativeHeapProviderByAllocations(this.mDetailsTreeViewer, displayZygotes);
        this.mContentProviderByLibrary = new NativeHeapProviderByLibrary(this.mDetailsTreeViewer, displayZygotes);
        if (this.mPrefStore.getBoolean(PREFS_GROUP_BY_LIBRARY)) {
            this.mDetailsTreeViewer.setContentProvider(this.mContentProviderByLibrary);
        } else {
            this.mDetailsTreeViewer.setContentProvider(this.mContentProviderByAllocations);
        }
        this.mDetailsTreeLabelProvider = new NativeHeapLabelProvider();
        this.mDetailsTreeViewer.setLabelProvider(this.mDetailsTreeLabelProvider);
        this.mDetailsTreeViewer.setInput(null);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NativeHeapPanel.this.displayStackTraceForSelection();
            }
        });
    }

    private void initializeStackTraceTree(Tree tree) {
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        List<String> properties = Arrays.asList("Address", "Library", "Method", "File", "Line");
        List<String> sampleValues = Arrays.asList("0x1234_5678", "/path/in/device/to/system/library.so", "PossiblyLongDemangledMethodName", "/android/out/prefix/in/home/directory/to/path/in/device/to/system/library.so", "2000");
        for (int i = 0; i < properties.size(); ++i) {
            String p = properties.get(i);
            String v = sampleValues.get(i);
            TableHelper.createTreeColumn(tree, p, 16384, v, this.getPref("stack", p), this.mPrefStore);
        }
        this.mStackTraceTreeViewer = new TreeViewer(tree);
        this.mStackTraceTreeViewer.setContentProvider(new NativeStackContentProvider());
        this.mStackTraceTreeViewer.setLabelProvider(new NativeStackLabelProvider());
        this.mStackTraceTreeViewer.setInput(null);
    }

    private void displayStackTraceForSelection() {
        TreeItem[] items = this.mDetailsTreeViewer.getTree().getSelection();
        if (items.length == 0) {
            this.mStackTraceTreeViewer.setInput(null);
            return;
        }
        Object data = items[0].getData();
        if (!(data instanceof NativeAllocationInfo)) {
            this.mStackTraceTreeViewer.setInput(null);
            return;
        }
        NativeAllocationInfo info = (NativeAllocationInfo)data;
        if (info.isStackCallResolved()) {
            this.mStackTraceTreeViewer.setInput(info.getResolvedStackCall());
        } else {
            this.mStackTraceTreeViewer.setInput(info.getStackCallAddresses());
        }
    }

    private String getPref(String prefix, String s) {
        return "nativeheap.tree." + prefix + "." + s;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void setTableFocusListener(ITableFocusListener listener) {
        this.mTableFocusListener = listener;
        final Tree heapSitesTree = this.mDetailsTreeViewer.getTree();
        final ITableFocusListener.IFocusedTableActivator heapSitesActivator = new ITableFocusListener.IFocusedTableActivator(){

            @Override
            public void copy(Clipboard clipboard) {
                TreeItem[] items = heapSitesTree.getSelection();
                NativeHeapPanel.this.copyToClipboard(items, clipboard);
            }

            @Override
            public void selectAll() {
                heapSitesTree.selectAll();
            }
        };
        heapSitesTree.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NativeHeapPanel.this.mTableFocusListener.focusLost(heapSitesActivator);
            }

            public void focusGained(FocusEvent arg0) {
                NativeHeapPanel.this.mTableFocusListener.focusGained(heapSitesActivator);
            }
        });
        final Tree stackTraceTree = this.mStackTraceTreeViewer.getTree();
        final ITableFocusListener.IFocusedTableActivator stackTraceActivator = new ITableFocusListener.IFocusedTableActivator(){

            @Override
            public void copy(Clipboard clipboard) {
                TreeItem[] items = stackTraceTree.getSelection();
                NativeHeapPanel.this.copyToClipboard(items, clipboard);
            }

            @Override
            public void selectAll() {
                stackTraceTree.selectAll();
            }
        };
        stackTraceTree.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NativeHeapPanel.this.mTableFocusListener.focusLost(stackTraceActivator);
            }

            public void focusGained(FocusEvent arg0) {
                NativeHeapPanel.this.mTableFocusListener.focusGained(stackTraceActivator);
            }
        });
    }

    private void copyToClipboard(TreeItem[] items, Clipboard clipboard) {
        StringBuilder sb = new StringBuilder();
        for (TreeItem item : items) {
            Object data = item.getData();
            if (data == null) continue;
            sb.append(data.toString());
            sb.append('\n');
        }
        String content = sb.toString();
        if (content.length() > 0) {
            clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    static {
        String useOldResolver = System.getenv("ANDROID_DDMS_OLD_SYMRESOLVER");
        USE_OLD_RESOLVER = useOldResolver != null && useOldResolver.equalsIgnoreCase("true");
    }

    private class SymbolResolverTask
    implements Runnable {
        private List<NativeAllocationInfo> mCallSites;
        private List<NativeLibraryMapInfo> mMappedLibraries;
        private Map<Long, NativeStackCallInfo> mResolvedSymbolCache;

        public SymbolResolverTask(List<NativeAllocationInfo> callSites, List<NativeLibraryMapInfo> mappedLibraries) {
            this.mCallSites = callSites;
            this.mMappedLibraries = mappedLibraries;
            this.mResolvedSymbolCache = new HashMap<Long, NativeStackCallInfo>();
        }

        @Override
        public void run() {
            for (NativeAllocationInfo callSite : this.mCallSites) {
                if (callSite.isStackCallResolved()) continue;
                List<Long> addresses = callSite.getStackCallAddresses();
                ArrayList<NativeStackCallInfo> resolvedStackInfo = new ArrayList<NativeStackCallInfo>(addresses.size());
                for (Long address : addresses) {
                    NativeStackCallInfo info = this.mResolvedSymbolCache.get(address);
                    if (info != null) {
                        resolvedStackInfo.add(info);
                        continue;
                    }
                    info = this.resolveAddress(address);
                    resolvedStackInfo.add(info);
                    this.mResolvedSymbolCache.put(address, info);
                }
                callSite.setResolvedStackCall(resolvedStackInfo);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NativeHeapPanel.this.mDetailsTreeViewer.refresh();
                    NativeHeapPanel.this.mStackTraceTreeViewer.refresh();
                }
            });
        }

        private NativeStackCallInfo resolveAddress(long addr) {
            NativeStackCallInfo info;
            Addr2Line process;
            NativeLibraryMapInfo library = this.getLibraryFor(addr);
            if (library != null && (process = Addr2Line.getProcess(library)) != null && (info = process.getAddress(addr)) != null) {
                return info;
            }
            return new NativeStackCallInfo(addr, library != null ? library.getLibraryName() : null, Long.toHexString(addr), "");
        }

        private NativeLibraryMapInfo getLibraryFor(long addr) {
            for (NativeLibraryMapInfo info : this.mMappedLibraries) {
                if (!info.isWithinLibrary(addr)) continue;
                return info;
            }
            Log.d("ddm-nativeheap", "Failed finding Library for " + Long.toHexString(addr));
            return null;
        }
    }
}

