/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.PatchInfo;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CorruptPatch {
    public static List<Rectangle> findBadPatches(BufferedImage image, PatchInfo patchInfo) {
        ArrayList<Rectangle> corruptedPatches = new ArrayList<Rectangle>();
        for (Rectangle patch : patchInfo.patches) {
            if (!CorruptPatch.corruptPatch(image, patch)) continue;
            corruptedPatches.add(patch);
        }
        for (Rectangle patch : patchInfo.horizontalPatches) {
            if (!CorruptPatch.corruptHorizontalPatch(image, patch)) continue;
            corruptedPatches.add(patch);
        }
        for (Rectangle patch : patchInfo.verticalPatches) {
            if (!CorruptPatch.corruptVerticalPatch(image, patch)) continue;
            corruptedPatches.add(patch);
        }
        return corruptedPatches;
    }

    private static boolean corruptPatch(BufferedImage image, Rectangle patch) {
        int[] pixels = GraphicsUtilities.getPixels(image, patch.x, patch.y, patch.width, patch.height, null);
        if (pixels.length > 0) {
            int reference = pixels[0];
            for (int pixel : pixels) {
                if (pixel == reference) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean corruptHorizontalPatch(BufferedImage image, Rectangle patch) {
        int[] reference = new int[patch.height];
        int[] column = new int[patch.height];
        reference = GraphicsUtilities.getPixels(image, patch.x, patch.y, 1, patch.height, reference);
        for (int i = 1; i < patch.width; ++i) {
            if (Arrays.equals(reference, column = GraphicsUtilities.getPixels(image, patch.x + i, patch.y, 1, patch.height, column))) continue;
            return true;
        }
        return false;
    }

    private static boolean corruptVerticalPatch(BufferedImage image, Rectangle patch) {
        int[] reference = new int[patch.width];
        int[] row = new int[patch.width];
        reference = GraphicsUtilities.getPixels(image, patch.x, patch.y, patch.width, 1, reference);
        for (int i = 1; i < patch.height; ++i) {
            if (Arrays.equals(reference, row = GraphicsUtilities.getPixels(image, patch.x, patch.y + i, patch.width, 1, row))) continue;
            return true;
        }
        return false;
    }
}

