/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public class DependencyGraph {
    private static final boolean DEBUG = false;
    private Set<File> mTargets = Collections.emptySet();
    private Set<File> mPrereqs = this.mTargets;
    private File mFirstPrereq = null;
    private boolean mMissingDepFile = false;
    private long mDepFileLastModified;
    private final List<InputPath> mNewInputs;

    public DependencyGraph(String dependencyFilePath, List<InputPath> newInputPaths) {
        this.mNewInputs = newInputPaths;
        this.parseDependencyFile(dependencyFilePath);
    }

    public boolean dependenciesHaveChanged(boolean printStatus) {
        if (this.mMissingDepFile) {
            System.out.println("No Dependency File Found");
            return true;
        }
        if (this.missingTargetFile()) {
            if (printStatus) {
                System.out.println("Found Deleted Target File");
            }
            return true;
        }
        long oldestTarget = this.getOutputLastModified();
        DependencyStatus status = this.checkInputs(oldestTarget);
        switch (status) {
            case ERROR: {
                throw new BuildException();
            }
            case NEW_FILE: {
                if (printStatus) {
                    System.out.println("Found new input file");
                }
                return true;
            }
            case UPDATED_FILE: {
                if (printStatus) {
                    System.out.println("Found modified input file");
                }
                return true;
            }
        }
        status = this.checkPrereqFiles(oldestTarget);
        switch (status) {
            case ERROR: {
                throw new BuildException();
            }
            case MISSING_FILE: {
                if (printStatus) {
                    System.out.println("Found deleted input file");
                }
                return true;
            }
            case UPDATED_FILE: {
                if (printStatus) {
                    System.out.println("Found modified input file");
                }
                return true;
            }
        }
        return false;
    }

    public Set<File> getTargets() {
        return Collections.unmodifiableSet(this.mTargets);
    }

    public File getFirstPrereq() {
        return this.mFirstPrereq;
    }

    private void parseDependencyFile(String dependencyFilePath) {
        File depFile = new File(dependencyFilePath);
        if (!depFile.isFile()) {
            this.mMissingDepFile = true;
            return;
        }
        this.mDepFileLastModified = depFile.lastModified();
        List<String> content = DependencyGraph.readFile(depFile);
        if (content == null) {
            System.err.println("ERROR: Couldn't read " + dependencyFilePath);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : content) {
            if ((line = line.trim()).endsWith("\\")) {
                line = line.substring(0, line.length() - 1);
            }
            sb.append(line);
        }
        String[] files = sb.toString().split(":");
        String[] targets = files[0].trim().split(" ");
        String[] prereqs = new String[]{};
        if (files.length < 1) {
            System.err.println("Warning! Dependency file does not list any prerequisites after ':' ");
        } else {
            prereqs = files[1].trim().split(" ");
        }
        this.mTargets = new HashSet<File>(targets.length);
        for (String path : targets) {
            if (path.isEmpty()) continue;
            this.mTargets.add(new File(path));
        }
        this.mPrereqs = new HashSet<File>(prereqs.length);
        for (String path : prereqs) {
            if (path.isEmpty()) continue;
            File f = new File(path);
            if (this.mFirstPrereq == null) {
                this.mFirstPrereq = f;
            }
            this.mPrereqs.add(f);
        }
    }

    private DependencyStatus checkInputs(long oldestTarget) {
        if (this.mNewInputs != null) {
            for (InputPath input : this.mNewInputs) {
                DependencyStatus status;
                File file = input.getFile();
                if (!(file.isDirectory() ? (status = this.checkInputFolder(file, input, oldestTarget)) != DependencyStatus.NONE : file.isFile() && (status = this.checkInputFile(file, input, oldestTarget)) != DependencyStatus.NONE)) continue;
                return status;
            }
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkInputFolder(File folder, InputPath inputFolder, long oldestTarget) {
        if (inputFolder.ignores(folder)) {
            return DependencyStatus.NONE;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            System.err.println("ERROR " + folder.toString() + " is not a dir or can't be read");
            return DependencyStatus.ERROR;
        }
        for (File file : files) {
            DependencyStatus status;
            if (!(file.isDirectory() ? (status = this.checkInputFolder(file, inputFolder, oldestTarget)) != DependencyStatus.NONE : file.isFile() && (status = this.checkInputFile(file, inputFolder, oldestTarget)) != DependencyStatus.NONE)) continue;
            return status;
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkInputFile(File file, InputPath inputFolder, long oldestTarget) {
        if (inputFolder.ignores(file)) {
            return DependencyStatus.NONE;
        }
        if (!this.mPrereqs.remove(file)) {
            return DependencyStatus.NEW_FILE;
        }
        if (inputFolder.checksForModification(file) && file.lastModified() > oldestTarget) {
            return DependencyStatus.UPDATED_FILE;
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkPrereqFiles(long oldestTarget) {
        for (File prereq : this.mPrereqs) {
            if (!prereq.exists()) {
                return DependencyStatus.MISSING_FILE;
            }
            if (this.mNewInputs != null) {
                String filePath = prereq.getAbsolutePath();
                for (InputPath input : this.mNewInputs) {
                    File inputFile = input.getFile();
                    if (!(inputFile.isDirectory() ? filePath.startsWith(inputFile.getAbsolutePath()) && input.checksForModification(prereq) && prereq.lastModified() > oldestTarget : prereq.equals(inputFile) && input.checksForModification(prereq) && prereq.lastModified() > oldestTarget)) continue;
                    return DependencyStatus.UPDATED_FILE;
                }
                continue;
            }
            if (prereq.lastModified() <= oldestTarget) continue;
            return DependencyStatus.UPDATED_FILE;
        }
        return DependencyStatus.NONE;
    }

    private boolean missingTargetFile() {
        for (File target : this.mTargets) {
            if (target.exists()) continue;
            return true;
        }
        return false;
    }

    private long getOutputLastModified() {
        long oldestTarget = Long.MAX_VALUE;
        if (this.mTargets.isEmpty()) {
            oldestTarget = this.mDepFileLastModified;
        } else {
            for (File target : this.mTargets) {
                if (target.lastModified() >= oldestTarget) continue;
                oldestTarget = target.lastModified();
            }
        }
        return oldestTarget;
    }

    private static List<String> readFile(File file) {
        try {
            return Files.readLines(file, Charsets.UTF_8);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static enum DependencyStatus {
        NONE,
        NEW_FILE,
        UPDATED_FILE,
        MISSING_FILE,
        ERROR;

    }
}

