/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.data.mergeCommand;
import com.vladium.emma.instr.instrCommand;
import com.vladium.emma.report.reportCommand;
import com.vladium.emma.runCommand;
import com.vladium.util.IConstants;
import com.vladium.util.Property;
import com.vladium.util.Strings;
import com.vladium.util.XProperties;
import com.vladium.util.args.IOptsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public abstract class Command {
    protected final String m_usageToolName;
    protected final String[] m_args;
    protected File m_propertyFile;
    protected Properties m_propertyOverrides;
    protected boolean m_exit;
    protected PrintWriter m_out;
    protected static final String COMMA_DELIMITERS = ", \t\r\n";
    protected static final String PATH_DELIMITERS = ",".concat(File.pathSeparator);
    protected static final String[] USAGE_OPT_NAMES = new String[]{"h", "help"};
    protected static final int STDOUT_WIDTH = 80;
    protected static final int RC_OK = 0;
    protected static final int RC_USAGE = 1;
    protected static final int RC_UNEXPECTED = 2;

    public static Command create(String string, String string2, String[] stringArray) {
        Command command;
        if ("run".equals(string)) {
            command = new runCommand(string2, stringArray);
        } else if ("instr".equals(string)) {
            command = new instrCommand(string2, stringArray);
        } else if ("report".equals(string)) {
            command = new reportCommand(string2, stringArray);
        } else if ("merge".equals(string)) {
            command = new mergeCommand(string2, stringArray);
        } else {
            throw new IllegalArgumentException("unknown command: [" + string + "]");
        }
        ((Command)command).initialize();
        return command;
    }

    public abstract void run();

    protected Command(String string, String[] stringArray) {
        this.m_usageToolName = string;
        this.m_args = stringArray != null ? (String[])stringArray.clone() : IConstants.EMPTY_STRING_ARRAY;
    }

    protected abstract String usageArgsMsg();

    protected void initialize() {
        this.m_exit = false;
        if (this.m_out != null) {
            try {
                this.m_out.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_out = new PrintWriter(System.out, true);
    }

    protected final String getToolName() {
        String string = this.getClass().getName();
        return string.substring(0, string.length() - 7);
    }

    protected final IOptsParser getOptParser(ClassLoader classLoader) {
        return IOptsParser.Factory.create(Command.usageResName(this.getToolName()), classLoader, Command.usageMsgPrefix(this.m_usageToolName), USAGE_OPT_NAMES);
    }

    protected final boolean processOpt(IOptsParser.IOpt iOpt) {
        String string = iOpt.getCanonicalName();
        if ("exit".equals(string)) {
            this.m_exit = Command.getOptionalBooleanOptValue(iOpt);
            return true;
        }
        if ("p".equals(string)) {
            this.m_propertyFile = new File(iOpt.getFirstValue());
            return true;
        }
        if ("verbose".equals(string)) {
            this.setPropertyOverride("verbosity.level", "verbose");
            return true;
        }
        if ("quiet".equals(string)) {
            this.setPropertyOverride("verbosity.level", "warning");
            return true;
        }
        if ("silent".equals(string)) {
            this.setPropertyOverride("verbosity.level", "severe");
            return true;
        }
        if ("debug".equals(string)) {
            if (iOpt.getValueCount() == 0) {
                this.setPropertyOverride("verbosity.level", "trace1");
            } else {
                this.setPropertyOverride("verbosity.level", iOpt.getFirstValue());
            }
            return true;
        }
        if ("debugcls".equals(string)) {
            this.setPropertyOverride("verbosity.filter", Strings.toListForm(Strings.merge(iOpt.getValues(), COMMA_DELIMITERS, true), ','));
            return true;
        }
        return false;
    }

    protected final void processCmdPropertyOverrides(IOptsParser.IOpts iOpts) {
        IOptsParser.IOpt[] iOptArray = iOpts.getOpts("D");
        if (iOptArray != null && iOptArray.length != 0) {
            XProperties xProperties = new XProperties();
            for (int i = 0; i < iOptArray.length; ++i) {
                IOptsParser.IOpt iOpt = iOptArray[i];
                String string = iOpt.getName().substring(iOpt.getPatternPrefix().length());
                xProperties.setProperty(string, iOpt.getFirstValue());
            }
            this.m_propertyOverrides = Property.combine(xProperties, this.m_propertyOverrides);
        }
    }

    protected final boolean processFilePropertyOverrides() {
        if (this.m_propertyFile != null) {
            Properties properties;
            try {
                properties = Property.getPropertiesFromFile(this.m_propertyFile);
            }
            catch (IOException iOException) {
                this.exit(true, "property override file [" + this.m_propertyFile.getAbsolutePath() + "] could not be read", iOException, 1);
                return false;
            }
            this.m_propertyOverrides = Property.combine(this.m_propertyOverrides, properties);
        }
        return true;
    }

    protected final void usageexit(IOptsParser iOptsParser, int n, String string) {
        if (string != null) {
            this.m_out.print(Command.usageMsgPrefix(this.m_usageToolName));
            this.m_out.println(string);
        }
        if (iOptsParser != null) {
            this.m_out.println();
            this.m_out.print(Command.usageMsgPrefix(this.m_usageToolName));
            this.m_out.println(Command.toolNameToCommandName(this.m_usageToolName) + " " + this.usageArgsMsg() + ",");
            this.m_out.println("  where options include:");
            this.m_out.println();
            iOptsParser.usage(this.m_out, n, 80);
        }
        this.m_out.println();
        this.exit(true, null, null, 1);
    }

    protected final void exit(boolean bl, String string, Throwable throwable, int n) throws EMMARuntimeException {
        if (bl) {
            this.m_out.println("[EMMA v0.0, build 0 (unsupported private build)]");
        }
        if (string != null) {
            this.m_out.print(Command.toolNameToCommandName(this.m_usageToolName) + ": ");
            this.m_out.println(string);
        }
        if (n != 0) {
            if (this.m_exit) {
                if (throwable != null) {
                    throwable.printStackTrace(this.m_out);
                }
                System.exit(n);
            } else {
                if (throwable instanceof EMMARuntimeException) {
                    throw (EMMARuntimeException)throwable;
                }
                if (throwable != null) {
                    throw string != null ? new EMMARuntimeException(string, throwable) : new EMMARuntimeException("unexpected failure: ", throwable);
                }
            }
        } else if (this.m_exit) {
            System.exit(0);
        }
    }

    protected static boolean getOptionalBooleanOptValue(IOptsParser.IOpt iOpt) {
        if (iOpt.getValueCount() == 0) {
            return true;
        }
        String string = iOpt.getFirstValue().toLowerCase();
        return Property.toBoolean(string);
    }

    protected static String[] getListOptValue(IOptsParser.IOpt iOpt, String string, boolean bl) throws IOException {
        return Strings.mergeAT(iOpt.getValues(), string, bl);
    }

    protected static String usageMsgPrefix(String string) {
        return Command.toolNameToCommandName(string).concat(" usage: ");
    }

    protected static String usageResName(String string) {
        return string.replace('.', '/').concat("_usage.res");
    }

    protected static String toolNameToCommandName(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(n + 1) : string;
    }

    private void setPropertyOverride(String string, String string2) {
        Properties properties = this.m_propertyOverrides;
        if (properties == null) {
            this.m_propertyOverrides = properties = new XProperties();
        }
        properties.setProperty(string, string2);
    }
}

