/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.ElementList;
import com.vladium.emma.report.html.doc.HTMLDocument;
import com.vladium.emma.report.html.doc.HTMLTable;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.HyperRef;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.emma.report.html.doc.IElement;
import com.vladium.emma.report.html.doc.IElementList;
import com.vladium.emma.report.html.doc.Tag;
import com.vladium.emma.report.html.doc.Text;
import com.vladium.util.Descriptors;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import com.vladium.util.IntObjectMap;
import com.vladium.util.IntVector;
import com.vladium.util.ObjectIntMap;
import com.vladium.util.Property;
import com.vladium.util.asserts.$assert;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private final DecimalFormat m_format = (DecimalFormat)NumberFormat.getPercentInstance();
    private final FieldPosition m_fieldPosition = new FieldPosition(0);
    private LinkedList m_queue;
    private IDGenerator m_reportIDNamespace;
    private IContent m_pageTitle;
    private IContent m_footerBottom;
    private static final boolean USE_LINE_COVERAGE_TOOLTIPS = true;
    private static final String TYPE = "html";
    private static final String REPORT_HEADER_TITLE = "EMMA Coverage Report";
    private static final IContent LEFT_BRACKET;
    private static final IContent RIGHT_BRACKET;
    private static final int MAX_DISPLAY_NAME_LENGTH = 80;
    private static final int SRC_LINE_OFFSET = 4;
    private static final String CSS_HEADER_FOOTER = "hdft";
    private static final String CSS_TITLE = "tl";
    private static final String CSS_NAV = "nv";
    private static final String CSS_COVERAGE_ZERO = "z";
    private static final String CSS_COVERAGE_PARTIAL = "p";
    private static final String CSS_COVERAGE_COMPLETE = "c";
    private static final String DARKER_BACKGROUND = "#F0F0F0";
    private static final String TITLE_BACKGROUND = "#6699CC";
    private static final String NAV_BACKGROUND = "#6633DD";
    private static final String CSS_INVISIBLE_TABLE = "it";
    private static final String CSS_ITEM_NAME = "in";
    private static final String CSS_CLASS_ITEM_SPECIAL = "cis";
    private static final String CSS_SOURCE = "s";
    private static final String CSS_LINENUM = "l";
    private static final String CSS_BOTTOM = "bt";
    private static final String CSS_ODDROW = "o";
    private static final String CSS_BLANK = "b";
    private static final String CSS_DATA = "";
    private static final String CSS_DATA_HIGHLIGHT = "h";
    private static final String CSS_DATA_FIRST = "f";
    private static final String CSS_DATA_HIGHLIGHT_FIRST = "hf";
    private static final String CSS_HEADER = "";
    private static final String CSS_HEADER_FIRST = "f";
    private static final String CSS_CLS_NOLEFT = "cn";
    private static final String CSS = " TABLE,TD,TH {border-style:solid; border-color:black;} TD,TH {background:white;margin:0;line-height:100%;padding-left:0.5em;padding-right:0.5em;} TD {border-width:0 1px 0 0;} TH {border-width:1px 1px 1px 0;} TR TD.h {color:red;} TABLE {border-spacing:0; border-collapse:collapse;border-width:0 0 1px 1px;} P,H1,H2,H3,TH {font-family:verdana,arial,sans-serif;font-size:10pt;} TD {font-family:courier,monospace;font-size:10pt;} TABLE.hdft {border-spacing:0;border-collapse:collapse;border-style:none;} TABLE.hdft TH,TABLE.hdft TD {border-style:none;line-height:normal;} TABLE.hdft TH.tl,TABLE.hdft TD.tl {background:#6699CC;color:white;} TABLE.hdft TD.nv {background:#6633DD;color:white;} .nv A:link {color:white;} .nv A:visited {color:white;} .nv A:active {color:yellow;} TABLE.hdft A:link {color:white;} TABLE.hdft A:visited {color:white;} TABLE.hdft A:active {color:yellow;} .in {color:#356085;} TABLE.s TD {padding-left:0.25em;padding-right:0.25em;} TABLE.s TD.l {padding-left:0.25em;padding-right:0.25em;text-align:right;background:#F0F0F0;} TABLE.s TR.z TD {background:#FF9999;} TABLE.s TR.p TD {background:#FFFF88;} TABLE.s TR.c TD {background:#CCFFCC;} A:link {color:#0000EE;text-decoration:none;} A:visited {color:#0000EE;text-decoration:none;} A:hover {color:#0000EE;text-decoration:underline;} TABLE.cn {border-width:0 0 1px 0;} TABLE.s {border-width:1px 0 1px 1px;} TD.h {color:red;border-width:0 1px 0 0;} TD.f {border-width:0 1px 0 1px;} TD.hf {color:red;border-width:0 1px 0 1px;} TH.f {border-width:1px 1px 1px 1px;} TR.cis TD {background:#F0F0F0;} TR.cis TD {border-width:1px 1px 1px 0;} TR.cis TD.h {color:red;border-width:1px 1px 1px 0;} TR.cis TD.f {border-width:1px 1px 1px 1px;} TR.cis TD.hf {color:red;border-width:1px 1px 1px 1px;} TD.b {border-style:none;background:transparent;line-height:50%;}  TD.bt {border-width:1px 0 0 0;background:transparent;line-height:50%;} TR.o TD {background:#F0F0F0;}TABLE.it {border-style:none;}TABLE.it TD,TABLE.it TH {border-style:none;}";
    private static final String NESTED_ITEMS_PARENT_DIRNAME = "_files";
    private static final File NESTED_ITEMS_PARENT_DIR;
    private static final int[][] NESTING;
    private static final String FILE_EXTENSION = ".html";
    private static final int IO_BUF_SIZE = 32768;
    private static final long[] ATTRIBUTE_SETS;

    public ReportGenerator() {
        this.m_format.setMaximumFractionDigits(0);
    }

    public final String getType() {
        return TYPE;
    }

    public void process(IMetaData iMetaData, ICoverageData iCoverageData, SourcePathCache sourcePathCache, IProperties iProperties) throws EMMARuntimeException {
        this.initialize(iMetaData, iCoverageData, sourcePathCache, iProperties);
        this.m_pageTitle = null;
        this.m_footerBottom = null;
        File file = this.m_settings.getOutDir();
        if (file == null || file.equals(new File(Property.getSystemProperty("user.dir", "")))) {
            file = new File("coverage");
            this.m_settings.setOutDir(file);
        }
        long l = 0L;
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            l = System.currentTimeMillis();
        }
        this.m_queue = new LinkedList();
        this.m_reportIDNamespace = new IDGenerator(iMetaData.size());
        this.m_queue.add(this.m_view.getRoot());
        while (!this.m_queue.isEmpty()) {
            IItem iItem = (IItem)this.m_queue.removeFirst();
            iItem.accept(this, null);
        }
        this.m_reportIDNamespace = null;
        if (bl) {
            long l2 = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (l2 - l) + " ms");
        }
    }

    public void cleanup() {
        this.m_queue = null;
        this.m_reportIDNamespace = null;
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(AllItem allItem, Object object) {
        HTMLWriter hTMLWriter = null;
        try {
            Object object2;
            Object object3;
            File file = this.m_settings.getOutFile();
            if (file == null) {
                file = new File("index".concat(FILE_EXTENSION));
                this.m_settings.setOutFile(file);
            }
            File file2 = Files.newFile(this.m_settings.getOutDir(), file);
            this.m_log.info("writing [" + this.getType() + "] report to [" + file2.getAbsolutePath() + "] ...");
            hTMLWriter = ReportGenerator.openOutFile(file2, this.m_settings.getOutEncoding(), true);
            int[] nArray = this.m_settings.getColumnOrder();
            StringBuffer stringBuffer = new StringBuffer();
            Object object4 = new StringBuffer(REPORT_HEADER_TITLE);
            ((StringBuffer)object4).append(" (generated ");
            ((StringBuffer)object4).append(new Date(EMMAProperties.getTimeStamp()));
            ((StringBuffer)object4).append(')');
            String string = ((StringBuffer)object4).toString();
            object4 = this.createPage(string);
            Object object5 = this.getParentPath(allItem);
            this.addPageHeader((HTMLDocument)object4, allItem, (IItem[])object5);
            this.addPageFooter((HTMLDocument)object4, allItem, (IItem[])object5);
            ((HTMLDocument)object4).addH(1, "OVERALL COVERAGE SUMMARY", null);
            object5 = new HTMLTable("100%", null, null, "0");
            IElement iElement = ((HTMLTable)object5).newTitleRow();
            HTMLTable.IRow iRow = ((HTMLTable)object5).newRow();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                IItemAttribute iItemAttribute = allItem.getAttribute(n, this.m_settings.getUnitsType());
                object3 = iElement.newCell();
                object3.setText(iItemAttribute.getName(), true);
                if (iItemAttribute == null) continue;
                boolean bl = this.m_metrics[n] > 0 && !iItemAttribute.passes(allItem, this.m_metrics[n]);
                stringBuffer.setLength(0);
                iItemAttribute.format(allItem, stringBuffer);
                object2 = iRow.newCell();
                object2.setText(stringBuffer.toString(), true);
                if (!bl) continue;
                object2.setClass(CSS_DATA_HIGHLIGHT);
            }
            ((HTMLDocument)object4).add((IContent)object5);
            ((HTMLDocument)object4).addH(2, "OVERALL STATS SUMMARY", null);
            iElement = new HTMLTable(null, null, null, "0");
            ((HTMLTable)iElement).setClass(CSS_INVISIBLE_TABLE);
            iRow = ((HTMLTable)iElement).newRow();
            iRow.newCell().setText("total packages:", true);
            iRow.newCell().setText("" + allItem.getChildCount(), false);
            if (this.m_srcView && this.m_hasSrcFileInfo) {
                iRow = ((HTMLTable)iElement).newRow();
                iRow.newCell().setText("total executable files:", true);
                iRow.newCell().setText("" + allItem.getAggregate(12), false);
            }
            iRow = ((HTMLTable)iElement).newRow();
            iRow.newCell().setText("total classes:", true);
            iRow.newCell().setText("" + allItem.getAggregate(11), true);
            iRow = ((HTMLTable)iElement).newRow();
            iRow.newCell().setText("total methods:", true);
            iRow.newCell().setText("" + allItem.getAggregate(10), true);
            if (this.m_srcView && this.m_hasSrcFileInfo && this.m_hasLineNumberInfo) {
                iRow = ((HTMLTable)iElement).newRow();
                iRow.newCell().setText("total executable lines:", true);
                iRow.newCell().setText("" + allItem.getAggregate(7), true);
            }
            ((HTMLDocument)object4).add(iElement);
            boolean bl = this.m_settings.getDepth() > allItem.getMetadata().getTypeID();
            ((HTMLDocument)object4).addH(2, "COVERAGE BREAKDOWN BY PACKAGE", null);
            HTMLTable hTMLTable = new HTMLTable("100%", null, null, "0");
            int[] nArray2 = null;
            boolean bl2 = true;
            object3 = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
            Iterator iterator = allItem.getChildren((ItemComparator)object3);
            while (iterator.hasNext()) {
                object2 = (IItem)iterator.next();
                if (nArray2 == null) {
                    nArray2 = this.addHeaderRow((IItem)object2, hTMLTable, nArray);
                }
                String string2 = null;
                if (bl) {
                    string2 = this.getItemHREF(allItem, (IItem)object2);
                }
                this.addItemRow((IItem)object2, bl2, hTMLTable, nArray2, string2, false);
                if (bl) {
                    this.m_queue.addLast(object2);
                }
                bl2 = !bl2;
            }
            ((HTMLDocument)object4).add(hTMLTable);
            ((HTMLDocument)object4).emit(hTMLWriter);
            hTMLWriter.flush();
        }
        finally {
            if (hTMLWriter != null) {
                hTMLWriter.close();
            }
            hTMLWriter = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(PackageItem packageItem, Object object) {
        HTMLWriter hTMLWriter = null;
        try {
            Object object2;
            Object object3;
            if (this.m_verbose) {
                this.m_log.verbose("  report: processing package [" + packageItem.getName() + "] ...");
            }
            File file = ReportGenerator.getItemFile(NESTED_ITEMS_PARENT_DIR, this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(packageItem)));
            hTMLWriter = ReportGenerator.openOutFile(Files.newFile(this.m_settings.getOutDir(), file), this.m_settings.getOutEncoding(), true);
            int[] nArray = this.m_settings.getColumnOrder();
            StringBuffer stringBuffer = new StringBuffer();
            HTMLDocument hTMLDocument = this.createPage(REPORT_HEADER_TITLE);
            Object object4 = this.getParentPath(packageItem);
            this.addPageHeader(hTMLDocument, packageItem, (IItem[])object4);
            this.addPageFooter(hTMLDocument, packageItem, (IItem[])object4);
            object4 = IElement.Factory.create(Tag.SPAN);
            object4.setText(packageItem.getName(), true);
            object4.setClass(CSS_ITEM_NAME);
            IElementList iElementList = new ElementList();
            iElementList.add(new Text("COVERAGE SUMMARY FOR PACKAGE [", true));
            iElementList.add((IContent)object4);
            iElementList.add(new Text("]", true));
            hTMLDocument.addH(1, iElementList, null);
            object4 = new HTMLTable("100%", null, null, "0");
            iElementList = ((HTMLTable)object4).newTitleRow();
            Object object5 = ((HTMLTable)object4).newRow();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                IItemAttribute iItemAttribute = packageItem.getAttribute(n, this.m_settings.getUnitsType());
                object3 = iElementList.newCell();
                object3.setText(iItemAttribute.getName(), true);
                if (iItemAttribute == null) continue;
                boolean bl = this.m_metrics[n] > 0 && !iItemAttribute.passes(packageItem, this.m_metrics[n]);
                stringBuffer.setLength(0);
                iItemAttribute.format(packageItem, stringBuffer);
                object2 = object5.newCell();
                object2.setText(stringBuffer.toString(), true);
                if (!bl) continue;
                object2.setClass(CSS_DATA_HIGHLIGHT);
            }
            hTMLDocument.add((IContent)object4);
            boolean bl = this.m_settings.getDepth() > packageItem.getMetadata().getTypeID();
            object5 = this.m_srcView ? "COVERAGE BREAKDOWN BY SOURCE FILE" : "COVERAGE BREAKDOWN BY CLASS";
            hTMLDocument.addH(2, (String)object5, null);
            HTMLTable hTMLTable = new HTMLTable("100%", null, null, "0");
            int[] nArray2 = null;
            boolean bl2 = true;
            object3 = this.m_typeSortComparators[this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID()];
            Iterator iterator = packageItem.getChildren((ItemComparator)object3);
            while (iterator.hasNext()) {
                object2 = (IItem)iterator.next();
                if (nArray2 == null) {
                    nArray2 = this.addHeaderRow((IItem)object2, hTMLTable, nArray);
                }
                String string = null;
                if (bl) {
                    string = this.getItemHREF(packageItem, (IItem)object2);
                }
                this.addItemRow((IItem)object2, bl2, hTMLTable, nArray2, string, false);
                if (bl) {
                    this.m_queue.addLast(object2);
                }
                bl2 = !bl2;
            }
            hTMLDocument.add(hTMLTable);
            hTMLDocument.emit(hTMLWriter);
            hTMLWriter.flush();
        }
        finally {
            if (hTMLWriter != null) {
                hTMLWriter.close();
            }
            hTMLWriter = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(SrcFileItem srcFileItem, Object object) {
        HTMLWriter hTMLWriter = null;
        try {
            Object object2;
            IElement iElement;
            Object object3;
            boolean bl;
            File file = ReportGenerator.getItemFile(NESTED_ITEMS_PARENT_DIR, this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(srcFileItem)));
            hTMLWriter = ReportGenerator.openOutFile(Files.newFile(this.m_settings.getOutDir(), file), this.m_settings.getOutEncoding(), true);
            int[] nArray = this.m_settings.getColumnOrder();
            StringBuffer stringBuffer = new StringBuffer();
            HTMLDocument hTMLDocument = this.createPage(REPORT_HEADER_TITLE);
            Object object4 = this.getParentPath(srcFileItem);
            this.addPageHeader(hTMLDocument, srcFileItem, (IItem[])object4);
            this.addPageFooter(hTMLDocument, srcFileItem, (IItem[])object4);
            object4 = IElement.Factory.create(Tag.SPAN);
            object4.setText(srcFileItem.getName(), true);
            object4.setClass(CSS_ITEM_NAME);
            IElementList iElementList = new ElementList();
            iElementList.add(new Text("COVERAGE SUMMARY FOR SOURCE FILE [", true));
            iElementList.add((IContent)object4);
            iElementList.add(new Text("]", true));
            hTMLDocument.addH(1, iElementList, null);
            object4 = new HTMLTable("100%", null, null, "0");
            iElementList = ((HTMLTable)object4).newTitleRow();
            HTMLTable.IRow iRow = ((HTMLTable)object4).newRow();
            for (bl = false; bl < nArray.length; bl += 1) {
                int n = nArray[bl];
                object3 = srcFileItem.getAttribute(n, this.m_settings.getUnitsType());
                iElement = iElementList.newCell();
                iElement.setText(object3.getName(), true);
                if (object3 == null) continue;
                boolean bl2 = this.m_metrics[n] > 0 && !object3.passes(srcFileItem, this.m_metrics[n]);
                stringBuffer.setLength(0);
                object3.format(srcFileItem, stringBuffer);
                object2 = iRow.newCell();
                object2.setText(stringBuffer.toString(), true);
                if (!bl2) continue;
                object2.setClass(CSS_DATA_HIGHLIGHT);
            }
            hTMLDocument.add((IContent)object4);
            boolean bl3 = this.m_settings.getDepth() > ClassItem.getTypeMetadata().getTypeID();
            boolean bl4 = bl3 && this.srcFileAvailable(srcFileItem, this.m_cache);
            bl = bl4 && this.m_hasLineNumberInfo;
            IDGenerator iDGenerator = bl ? new IDGenerator() : null;
            hTMLDocument.addH(2, "COVERAGE BREAKDOWN BY CLASS AND METHOD", null);
            object3 = bl4 ? new IntObjectMap() : null;
            iElement = new HTMLTable("100%", null, null, "0");
            ((HTMLTable)iElement).setClass(CSS_CLS_NOLEFT);
            int[] nArray2 = null;
            object2 = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
            int n = 0;
            Iterator iterator = srcFileItem.getChildren((ItemComparator)object2);
            while (iterator.hasNext()) {
                ClassItem classItem = (ClassItem)iterator.next();
                if (nArray2 == null) {
                    nArray2 = this.addHeaderRow(classItem, (HTMLTable)iElement, nArray);
                }
                String string = null;
                if (bl) {
                    String string2 = ReportGenerator.getItemKey(classItem);
                    string = ReportGenerator.addLineAnchorID(classItem.getFirstLine(), iDGenerator.getID(string2), (IntObjectMap)object3);
                }
                this.addClassRow(classItem, n, (HTMLTable)iElement, nArray2, string, bl);
                boolean bl5 = false;
                ItemComparator itemComparator = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
                Iterator iterator2 = classItem.getChildren(itemComparator);
                while (iterator2.hasNext()) {
                    MethodItem methodItem = (MethodItem)iterator2.next();
                    string = null;
                    if (bl) {
                        String string3 = ReportGenerator.getItemKey(methodItem);
                        string = ReportGenerator.addLineAnchorID(methodItem.getFirstLine(), iDGenerator.getID(string3), (IntObjectMap)object3);
                    }
                    this.addClassItemRow(methodItem, bl5, (HTMLTable)iElement, nArray2, string, bl);
                    bl5 = !bl5;
                }
                ++n;
            }
            hTMLDocument.add(iElement);
            if (bl3) {
                hTMLDocument.addEmptyP();
                this.embedSrcFile(srcFileItem, hTMLDocument, (IntObjectMap)object3, this.m_cache);
            }
            hTMLDocument.emit(hTMLWriter);
            hTMLWriter.flush();
        }
        finally {
            if (hTMLWriter != null) {
                hTMLWriter.close();
            }
            hTMLWriter = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ClassItem classItem, Object object) {
        HTMLWriter hTMLWriter = null;
        try {
            Object object2;
            Object object3;
            boolean bl;
            File file = ReportGenerator.getItemFile(NESTED_ITEMS_PARENT_DIR, this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(classItem)));
            hTMLWriter = ReportGenerator.openOutFile(Files.newFile(this.m_settings.getOutDir(), file), this.m_settings.getOutEncoding(), true);
            int[] nArray = this.m_settings.getColumnOrder();
            StringBuffer stringBuffer = new StringBuffer();
            HTMLDocument hTMLDocument = this.createPage(REPORT_HEADER_TITLE);
            Object object4 = this.getParentPath(classItem);
            this.addPageHeader(hTMLDocument, classItem, (IItem[])object4);
            this.addPageFooter(hTMLDocument, classItem, (IItem[])object4);
            object4 = IElement.Factory.create(Tag.SPAN);
            object4.setText(classItem.getName(), true);
            object4.setClass(CSS_ITEM_NAME);
            IElementList iElementList = new ElementList();
            iElementList.add(new Text("COVERAGE SUMMARY FOR CLASS [", true));
            iElementList.add((IContent)object4);
            iElementList.add(new Text("]", true));
            hTMLDocument.addH(1, iElementList, null);
            object4 = new HTMLTable("100%", null, null, "0");
            iElementList = ((HTMLTable)object4).newTitleRow();
            Object object5 = ((HTMLTable)object4).newRow();
            for (bl = false; bl < nArray.length; bl += 1) {
                int n = nArray[bl];
                object3 = classItem.getAttribute(n, this.m_settings.getUnitsType());
                object2 = iElementList.newCell();
                object2.setText(object3.getName(), true);
                if (object3 == null) continue;
                boolean bl2 = this.m_metrics[n] > 0 && !object3.passes(classItem, this.m_metrics[n]);
                stringBuffer.setLength(0);
                object3.format(classItem, stringBuffer);
                HTMLTable.ICell iCell = object5.newCell();
                iCell.setText(stringBuffer.toString(), true);
                if (!bl2) continue;
                iCell.setClass(CSS_DATA_HIGHLIGHT);
            }
            hTMLDocument.add((IContent)object4);
            hTMLDocument.addH(2, "COVERAGE BREAKDOWN BY METHOD", null);
            iElementList = new HTMLTable("100%", null, null, "0");
            object5 = null;
            bl = true;
            ItemComparator itemComparator = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
            object3 = classItem.getChildren(itemComparator);
            while (object3.hasNext()) {
                object2 = (MethodItem)object3.next();
                if (object5 == null) {
                    object5 = this.addHeaderRow((IItem)object2, (HTMLTable)iElementList, nArray);
                }
                this.addItemRow((IItem)object2, bl, (HTMLTable)iElementList, (int[])object5, null, false);
                bl = !bl;
            }
            hTMLDocument.add(iElementList);
            hTMLDocument.emit(hTMLWriter);
            hTMLWriter.flush();
        }
        finally {
            if (hTMLWriter != null) {
                hTMLWriter.close();
            }
            hTMLWriter = null;
        }
        return object;
    }

    private HTMLDocument createPage(String string) {
        HTMLDocument hTMLDocument = new HTMLDocument(string, this.m_settings.getOutEncoding());
        hTMLDocument.addStyle(CSS);
        return hTMLDocument;
    }

    private IElement addPageHeader(HTMLDocument hTMLDocument, IItem iItem, IItem[] iItemArray) {
        HTMLTable hTMLTable = new HTMLTable("100%", null, null, "0");
        hTMLTable.setClass(CSS_HEADER_FOOTER);
        this.addPageHeaderTitleRow(hTMLTable);
        HTMLTable.IRow iRow = hTMLTable.newRow();
        HTMLTable.ICell iCell = iRow.newCell();
        iCell.setClass(CSS_NAV);
        int n = iItemArray.length > 1 ? iItemArray.length - 1 : iItemArray.length;
        for (int i = 0; i < n; ++i) {
            iCell.add(LEFT_BRACKET);
            String string = iItemArray[i].getName();
            String string2 = this.getItemHREF(iItem, iItemArray[i]);
            iCell.add(new HyperRef(string2, string, true));
            iCell.add(RIGHT_BRACKET);
        }
        hTMLDocument.setHeader(hTMLTable);
        return hTMLTable;
    }

    private IElement addPageFooter(HTMLDocument hTMLDocument, IItem iItem, IItem[] iItemArray) {
        HTMLTable hTMLTable = new HTMLTable("100%", null, null, "0");
        hTMLTable.setClass(CSS_HEADER_FOOTER);
        IElementList iElementList = hTMLTable.newRow();
        HTMLTable.ICell iCell = iElementList.newCell();
        iCell.setClass(CSS_NAV);
        int n = iItemArray.length > 1 ? iItemArray.length - 1 : iItemArray.length;
        for (int i = 0; i < n; ++i) {
            iCell.add(LEFT_BRACKET);
            String string = iItemArray[i].getName();
            String string2 = this.getItemHREF(iItem, iItemArray[i]);
            iCell.add(new HyperRef(string2, string, true));
            iCell.add(RIGHT_BRACKET);
        }
        iElementList = hTMLTable.newRow();
        iCell = iElementList.newCell();
        iCell.setClass(CSS_TITLE);
        iCell.add(this.getFooterBottom());
        iElementList = new ElementList();
        ((ElementList)iElementList).add(IElement.Factory.create(Tag.P));
        ((ElementList)iElementList).add(hTMLTable);
        hTMLDocument.setFooter(iElementList);
        return hTMLTable;
    }

    private int[] addHeaderRow(IItem iItem, HTMLTable hTMLTable, int[] nArray) {
        HTMLTable.IRow iRow = hTMLTable.newTitleRow();
        IntVector intVector = new IntVector(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            IItemAttribute iItemAttribute = iItem.getAttribute(n, this.m_settings.getUnitsType());
            if (iItemAttribute == null) continue;
            HTMLTable.ICell iCell = iRow.newCell();
            iCell.setText(iItemAttribute.getName(), true);
            iCell.setClass(ReportGenerator.headerCellStyle(i));
            intVector.add(n);
        }
        return intVector.values();
    }

    private void addItemRow(IItem iItem, boolean bl, HTMLTable hTMLTable, int[] nArray, String string, boolean bl2) {
        HTMLTable.IRow iRow = hTMLTable.newRow();
        if (bl) {
            iRow.setClass(CSS_ODDROW);
        }
        StringBuffer stringBuffer = new StringBuffer(11);
        for (int i = 0; i < nArray.length; ++i) {
            HTMLTable.ICell iCell;
            int n = nArray[i];
            IItemAttribute iItemAttribute = iItem.getAttribute(n, this.m_settings.getUnitsType());
            if (iItemAttribute != null) {
                iCell = iRow.newCell();
                if (string != null && n == 0) {
                    stringBuffer.setLength(0);
                    iItemAttribute.format(iItem, stringBuffer);
                    ReportGenerator.trimForDisplay(stringBuffer);
                    String string2 = bl2 ? "#".concat(string) : string;
                    iCell.add(new HyperRef(string2, stringBuffer.toString(), true));
                    continue;
                }
                boolean bl3 = this.m_metrics[n] > 0 && !iItemAttribute.passes(iItem, this.m_metrics[n]);
                stringBuffer.setLength(0);
                iItemAttribute.format(iItem, stringBuffer);
                ReportGenerator.trimForDisplay(stringBuffer);
                iCell.setText(stringBuffer.toString(), true);
                if (!bl3) continue;
                iCell.setClass(CSS_DATA_HIGHLIGHT);
                continue;
            }
            iCell = iRow.newCell();
            iCell.setText(" ", true);
        }
    }

    private void addClassRow(ClassItem classItem, int n, HTMLTable hTMLTable, int[] nArray, String string, boolean bl) {
        HTMLTable.IRow iRow = hTMLTable.newRow();
        HTMLTable.IRow iRow2 = hTMLTable.newRow();
        iRow2.setClass(CSS_CLASS_ITEM_SPECIAL);
        StringBuffer stringBuffer = new StringBuffer(11);
        for (int i = 0; i < nArray.length; ++i) {
            HTMLTable.ICell iCell;
            int n2 = nArray[i];
            IItemAttribute iItemAttribute = classItem.getAttribute(n2, this.m_settings.getUnitsType());
            if (iItemAttribute != null) {
                stringBuffer.setLength(0);
                iItemAttribute.format(classItem, stringBuffer);
                iCell = iRow.newCell();
                iCell.setClass(n == 0 ? CSS_BLANK : CSS_BOTTOM);
                iCell.setText(" ", true);
                HTMLTable.ICell iCell2 = iRow2.newCell();
                boolean bl2 = false;
                if (n2 == 0) {
                    if (string != null) {
                        String string2 = bl ? "#".concat(string) : string;
                        iCell2.add(new Text("class ", true));
                        iCell2.add(new HyperRef(string2, stringBuffer.toString(), true));
                    } else {
                        iCell2.setText("class " + stringBuffer.toString(), true);
                    }
                } else {
                    bl2 = this.m_metrics[n2] > 0 && !iItemAttribute.passes(classItem, this.m_metrics[n2]);
                    iCell2.setText(stringBuffer.toString(), true);
                }
                iCell2.setClass(ReportGenerator.dataCellStyle(i, bl2));
                continue;
            }
            iCell = iRow2.newCell();
            iCell.setText(" ", true);
            iCell.setClass(ReportGenerator.dataCellStyle(i, false));
        }
    }

    private void addClassItemRow(IItem iItem, boolean bl, HTMLTable hTMLTable, int[] nArray, String string, boolean bl2) {
        HTMLTable.IRow iRow = hTMLTable.newRow();
        if (bl) {
            iRow.setClass(CSS_ODDROW);
        }
        StringBuffer stringBuffer = new StringBuffer(11);
        for (int i = 0; i < nArray.length; ++i) {
            HTMLTable.ICell iCell;
            int n = nArray[i];
            IItemAttribute iItemAttribute = iItem.getAttribute(n, this.m_settings.getUnitsType());
            if (iItemAttribute != null) {
                iCell = iRow.newCell();
                boolean bl3 = false;
                if (string != null && n == 0) {
                    stringBuffer.setLength(0);
                    iItemAttribute.format(iItem, stringBuffer);
                    ReportGenerator.trimForDisplay(stringBuffer);
                    String string2 = bl2 ? "#".concat(string) : string;
                    iCell.add(new HyperRef(string2, stringBuffer.toString(), true));
                } else {
                    bl3 = this.m_metrics[n] > 0 && !iItemAttribute.passes(iItem, this.m_metrics[n]);
                    stringBuffer.setLength(0);
                    iItemAttribute.format(iItem, stringBuffer);
                    ReportGenerator.trimForDisplay(stringBuffer);
                    iCell.setText(stringBuffer.toString(), true);
                }
                iCell.setClass(ReportGenerator.dataCellStyle(i, bl3));
                continue;
            }
            iCell = iRow.newCell();
            iCell.setText(" ", true);
            iCell.setClass(ReportGenerator.dataCellStyle(i, false));
        }
    }

    private boolean srcFileAvailable(SrcFileItem srcFileItem, SourcePathCache sourcePathCache) {
        if (sourcePathCache == null) {
            return false;
        }
        String string = srcFileItem.getName();
        String string2 = ((PackageItem)srcFileItem.getParent()).getVMName();
        return sourcePathCache.find(string2, string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void embedSrcFile(SrcFileItem srcFileItem, HTMLDocument hTMLDocument, IntObjectMap intObjectMap, SourcePathCache sourcePathCache) {
        Object object;
        String string = srcFileItem.getName();
        String string2 = ((PackageItem)srcFileItem.getParent()).getVMName();
        boolean bl = false;
        HTMLTable hTMLTable = new HTMLTable("100%", null, null, "0");
        if (sourcePathCache != null) {
            hTMLTable.setClass(CSS_SOURCE);
            object = sourcePathCache.find(string2, string);
            if (object != null) {
                BufferedReader bufferedReader = null;
                try {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader((File)object), 32768);
                    boolean bl2 = this.m_hasLineNumberInfo;
                    int n = this.m_settings.getUnitsType();
                    IntObjectMap intObjectMap2 = null;
                    StringBuffer stringBuffer = null;
                    if (bl2) {
                        intObjectMap2 = srcFileItem.getLineCoverage();
                        $assert.ASSERT(intObjectMap2 != null, "null: lineCoverageMap");
                        stringBuffer = new StringBuffer(64);
                    }
                    int n2 = 1;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        Object object2;
                        Object object3;
                        HTMLTable.IRow iRow = hTMLTable.newRow();
                        HTMLTable.ICell iCell = iRow.newCell();
                        iCell.setClass(CSS_LINENUM);
                        if (intObjectMap != null) {
                            int n3 = n2 < 4 ? n2 : n2 + 4;
                            object3 = (String)intObjectMap.get(n3);
                            if (object3 != null) {
                                object2 = IElement.Factory.create(Tag.A);
                                object2.getAttributes().set(Attribute.NAME, (String)object3);
                                object2.setText(Integer.toString(n2), true);
                                iCell.add((IContent)object2);
                            } else {
                                iCell.setText(Integer.toString(n2), true);
                            }
                        } else {
                            iCell.setText(Integer.toString(n2), true);
                        }
                        HTMLTable.ICell iCell2 = iRow.newCell();
                        iCell2.setText(string3.length() > 0 ? string3 : " ", true);
                        if (bl2 && (object3 = (SrcFileItem.LineCoverageData)intObjectMap2.get(n2)) != null) {
                            switch (((SrcFileItem.LineCoverageData)object3).m_coverageStatus) {
                                case 0: {
                                    iRow.setClass(CSS_COVERAGE_ZERO);
                                    break;
                                }
                                case 1: {
                                    iRow.setClass(CSS_COVERAGE_PARTIAL);
                                    stringBuffer.setLength(0);
                                    object2 = ((SrcFileItem.LineCoverageData)object3).m_coverageRatio[n];
                                    Object object4 = object2[0];
                                    Object object5 = object2[1];
                                    this.m_format.format((double)object5 / (double)object4, stringBuffer, this.m_fieldPosition);
                                    stringBuffer.append(" line coverage (");
                                    stringBuffer.append((int)object5);
                                    stringBuffer.append(" out of ");
                                    stringBuffer.append((int)object4);
                                    switch (n) {
                                        case 0: {
                                            stringBuffer.append(" basic blocks)");
                                            break;
                                        }
                                        case 1: {
                                            stringBuffer.append(" instructions)");
                                        }
                                    }
                                    iCell.getAttributes().set(Attribute.TITLE, stringBuffer.toString());
                                    iCell2.getAttributes().set(Attribute.TITLE, stringBuffer.toString());
                                    break;
                                }
                                case 2: {
                                    iRow.setClass(CSS_COVERAGE_COMPLETE);
                                    break;
                                }
                                default: {
                                    $assert.ASSERT(false, "invalid line coverage status: " + ((SrcFileItem.LineCoverageData)object3).m_coverageStatus);
                                }
                            }
                        }
                        ++n2;
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                    bl = false;
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    bufferedReader = null;
                }
            }
        }
        if (!bl) {
            hTMLTable.setClass(CSS_INVISIBLE_TABLE);
            object = hTMLTable.newTitleRow();
            object.newCell().setText("[source file '" + Descriptors.combineVMName(string2, string) + "' not found in sourcepath]", false);
        }
        hTMLDocument.add(hTMLTable);
    }

    private static String addLineAnchorID(int n, String string, IntObjectMap intObjectMap) {
        if (n > 0) {
            String string2 = (String)intObjectMap.get(n);
            if (string2 != null) {
                return string2;
            }
            intObjectMap.put(n, string);
            return string;
        }
        return null;
    }

    private IItem[] getParentPath(IItem iItem) {
        LinkedList<IItem> linkedList = new LinkedList<IItem>();
        while (iItem != null) {
            linkedList.add(iItem);
            iItem = iItem.getParent();
        }
        IItem[] iItemArray = new IItem[linkedList.size()];
        int n = iItemArray.length - 1;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iItemArray[n] = (IItem)iterator.next();
            --n;
        }
        return iItemArray;
    }

    private String getItemHREF(IItem iItem, IItem iItem2) {
        int n;
        String string = iItem2 instanceof AllItem ? this.m_settings.getOutFile().getName() : this.m_reportIDNamespace.getID(ReportGenerator.getItemKey(iItem2)).concat(FILE_EXTENSION);
        String string2 = iItem == null ? string : ((n = NESTING[iItem.getMetadata().getTypeID()][iItem2.getMetadata().getTypeID()]) == 1 ? NESTED_ITEMS_PARENT_DIRNAME.concat("/").concat(string) : (n == -1 ? "../".concat(string) : string));
        return string2;
    }

    private IContent getPageTitle() {
        IContent iContent = this.m_pageTitle;
        if (iContent == null) {
            ElementList elementList = new ElementList();
            elementList.add(new HyperRef("this private build is unsupported", "EMMA", true));
            StringBuffer stringBuffer = new StringBuffer(" Coverage Report (generated ");
            stringBuffer.append(new Date(EMMAProperties.getTimeStamp()));
            stringBuffer.append(')');
            elementList.add(new Text(stringBuffer.toString(), true));
            this.m_pageTitle = iContent = elementList;
        }
        return iContent;
    }

    private IContent getFooterBottom() {
        IContent iContent = this.m_footerBottom;
        if (iContent == null) {
            ElementList elementList = new ElementList();
            elementList.add(new HyperRef("this private build is unsupported", "EMMA 0.0.0 (unsupported private build)", true));
            elementList.add(new Text(" (C) Vladimir Roubtsov", true));
            this.m_footerBottom = iContent = elementList;
        }
        return iContent;
    }

    private void addPageHeaderTitleRow(HTMLTable hTMLTable) {
        HTMLTable.IRow iRow = hTMLTable.newTitleRow();
        HTMLTable.ICell iCell = iRow.newCell();
        iCell.setClass(CSS_TITLE);
        iCell.add(this.getPageTitle());
    }

    private static void trimForDisplay(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 80) {
            stringBuffer.setLength(77);
            stringBuffer.append("...");
        }
    }

    private static File getItemFile(File file, String string) {
        if (file == null) {
            return new File(string.concat(FILE_EXTENSION));
        }
        return new File(file, string.concat(FILE_EXTENSION));
    }

    private static String getItemKey(IItem iItem) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iItem != null) {
            stringBuffer.append(iItem.getName());
            stringBuffer.append(':');
            iItem = iItem.getParent();
        }
        return stringBuffer.toString();
    }

    private static HTMLWriter openOutFile(File file, String string, boolean bl) {
        BufferedWriter bufferedWriter = null;
        try {
            File file2;
            if (bl && (file2 = file.getParentFile()) != null) {
                file2.mkdirs();
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string), 32768);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EMMARuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException(iOException);
        }
        return new HTMLWriter(bufferedWriter);
    }

    private static String dataCellStyle(int n, boolean bl) {
        if (n == 0) {
            return bl ? CSS_DATA_HIGHLIGHT_FIRST : "f";
        }
        return bl ? CSS_DATA_HIGHLIGHT : "";
    }

    private static String headerCellStyle(int n) {
        return n == 0 ? "f" : "";
    }

    static {
        int n;
        LEFT_BRACKET = new Text("[", false);
        RIGHT_BRACKET = new Text("]", false);
        NESTED_ITEMS_PARENT_DIR = new File(NESTED_ITEMS_PARENT_DIRNAME);
        IItemMetadata[] iItemMetadataArray = IItemMetadata.Factory.getAllTypes();
        ATTRIBUTE_SETS = new long[iItemMetadataArray.length];
        for (n = 0; n < iItemMetadataArray.length; ++n) {
            ReportGenerator.ATTRIBUTE_SETS[iItemMetadataArray[n].getTypeID()] = iItemMetadataArray[n].getAttributeIDs();
        }
        NESTING = new int[4][4];
        n = AllItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[n][PackageItem.getTypeMetadata().getTypeID()] = 1;
        ReportGenerator.NESTING[n][SrcFileItem.getTypeMetadata().getTypeID()] = 1;
        ReportGenerator.NESTING[n][ClassItem.getTypeMetadata().getTypeID()] = 1;
        n = PackageItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[n][AllItem.getTypeMetadata().getTypeID()] = -1;
        n = SrcFileItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[n][AllItem.getTypeMetadata().getTypeID()] = -1;
        n = ClassItem.getTypeMetadata().getTypeID();
        ReportGenerator.NESTING[n][AllItem.getTypeMetadata().getTypeID()] = -1;
    }

    private static final class IDGenerator {
        private final ObjectIntMap m_namespace;
        private final int[] m_out;

        IDGenerator() {
            this.m_namespace = new ObjectIntMap(101);
            this.m_out = new int[1];
        }

        IDGenerator(int n) {
            this.m_namespace = new ObjectIntMap(n);
            this.m_out = new int[1];
        }

        String getID(String string) {
            int n;
            int[] nArray = this.m_out;
            if (this.m_namespace.get(string, nArray)) {
                n = nArray[0];
            } else {
                n = this.m_namespace.size();
                this.m_namespace.put(string, n);
            }
            return Integer.toHexString(n);
        }
    }
}

