/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.AttributeSet;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IElement;
import com.vladium.emma.report.html.doc.Tag;

public final class HTMLTable
extends IElement.Factory.ElementImpl {
    private IElement m_caption;

    public HTMLTable(String string, String string2, String string3, String string4) {
        super(Tag.TABLE, AttributeSet.create());
        AttributeSet attributeSet = this.getAttributes();
        if (string != null) {
            attributeSet.set(Attribute.WIDTH, string);
        }
        if (string2 != null) {
            attributeSet.set(Attribute.BORDER, string2);
        }
        if (string3 != null) {
            attributeSet.set(Attribute.CELLPADDING, string3);
        }
        if (string4 != null) {
            attributeSet.set(Attribute.CELLSPACING, string4);
        }
    }

    public void setCaption(String string, String string2, boolean bl) {
        this.m_caption = IElement.Factory.create(Tag.CAPTION);
        this.m_caption.getAttributes().set(Attribute.ALIGN, string);
        this.m_caption.setText(string2, bl);
    }

    public IRow newTitleRow() {
        Row row = new Row(true);
        this.add(row);
        return row;
    }

    public IRow newRow() {
        Row row = new Row(false);
        this.add(row);
        return row;
    }

    public void emit(HTMLWriter hTMLWriter) {
        if (this.m_caption != null) {
            this.add(0, this.m_caption);
        }
        super.emit(hTMLWriter);
    }

    private static class Row
    extends IElement.Factory.ElementImpl
    implements IRow {
        private final boolean m_th;

        public ICell newCell() {
            Cell cell = new Cell(this.m_th ? Tag.TH : Tag.TD);
            this.add(cell);
            return cell;
        }

        Row(boolean bl) {
            super(Tag.TR, AttributeSet.create());
            this.m_th = bl;
        }
    }

    private static class Cell
    extends IElement.Factory.ElementImpl
    implements ICell {
        public ICell setColspan(int n) {
            this.getAttributes().set(Attribute.COLSPAN, n);
            return this;
        }

        Cell(Tag tag) {
            super(tag, AttributeSet.create());
        }
    }

    public static interface IRow
    extends IElement {
        public ICell newCell();
    }

    public static interface ICell
    extends IElement {
        public ICell setColspan(int var1);
    }
}

