/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.ide.common.internal.LoggedErrorException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class WaitableExecutor<T> {
    private final CompletionService<T> mCompletionService;
    private final Set<Future<T>> mFutureSet = Sets.newHashSet();

    public WaitableExecutor(int nThreads) {
        this.mCompletionService = nThreads < 1 ? new ExecutorCompletionService<T>(Executors.newCachedThreadPool()) : new ExecutorCompletionService<T>(Executors.newFixedThreadPool(nThreads));
    }

    public WaitableExecutor() {
        this(0);
    }

    public void execute(Callable<T> runnable) {
        this.mFutureSet.add(this.mCompletionService.submit(runnable));
    }

    public List<T> waitForTasksWithQuickFail(boolean cancelRemaining) throws InterruptedException, LoggedErrorException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.mFutureSet.size());
        try {
            while (!this.mFutureSet.isEmpty()) {
                Future<T> future = this.mCompletionService.take();
                assert (this.mFutureSet.contains(future));
                this.mFutureSet.remove(future);
                results.add(future.get());
            }
        }
        catch (ExecutionException e) {
            Throwable cause;
            if (cancelRemaining) {
                this.cancelAllTasks();
            }
            if ((cause = e.getCause()) instanceof LoggedErrorException) {
                throw (LoggedErrorException)cause;
            }
            throw new RuntimeException(cause);
        }
        return results;
    }

    public List<TaskResult<T>> waitForAllTasks() throws InterruptedException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.mFutureSet.size());
        while (!this.mFutureSet.isEmpty()) {
            Future<T> future = this.mCompletionService.take();
            assert (this.mFutureSet.contains(future));
            this.mFutureSet.remove(future);
            try {
                results.add(TaskResult.withValue(future.get()));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof InterruptedException) continue;
                results.add(new TaskResult(cause));
            }
        }
        return results;
    }

    public void cancelAllTasks() {
        for (Future<T> future : this.mFutureSet) {
            future.cancel(true);
        }
    }

    public static final class TaskResult<T> {
        public T value;
        public Throwable exception;

        static <T> TaskResult<T> withValue(T value) {
            TaskResult<T> result = new TaskResult<T>(null);
            result.value = value;
            return result;
        }

        TaskResult(Throwable cause) {
            this.exception = cause;
        }
    }
}

