/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class LocaleDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue STRING_LOCALE = Issue.create("DefaultLocale", "Implied default locale in case conversion", "Finds calls to locale-ambiguous `String` manipulation methods", "Calling `String#toLowerCase()` or `#toUpperCase()` *without specifying an explicit locale* is a common source of bugs. The reason for that is that those methods will use the current locale on the user's device, and even though the code appears to work correctly when you are developing the app, it will fail in some locales. For example, in the Turkish locale, the uppercase replacement for `i` is *not* `I`.\n\nIf you want the methods to just perform ASCII replacement, for example to convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you really want to use the current locale, call `String#toUpperCase(Locale.getDefault())` instead.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(LocaleDetector.class, Scope.CLASS_AND_ALL_RESOURCE_FILES)).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html#default_locale");
    public static final Issue DATE_FORMAT = Issue.create("SimpleDateFormat", "Implied locale in date format", "Using `SimpleDateFormat` directly without an explicit locale", "Almost all callers should use `getDateInstance()`, `getDateTimeInstance()`, or `getTimeInstance()` to get a ready-made instance of SimpleDateFormat suitable for the user's locale. The main reason you'd create an instance this class directly is because you need to format/parse a specific machine-readable format, in which case you almost certainly want to explicitly ask for US to ensure that you get ASCII digits (rather than, say, Arabic digits).\n\nTherefore, you should either use the form of the SimpleDateFormat constructor where you pass in an explicit locale, such as Locale.US, or use one of the get instance methods, or suppress this error if really know what you are doing.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(LocaleDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/java/text/SimpleDateFormat.html");
    static final String DATE_FORMAT_OWNER = "java/text/SimpleDateFormat";
    private static final String STRING_OWNER = "java/lang/String";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    @Nullable
    public List<String> getApplicableCallNames() {
        return Arrays.asList("toLowerCase", "toUpperCase", "format");
    }

    @Override
    @Nullable
    public List<String> getApplicableCallOwners() {
        return Collections.singletonList(DATE_FORMAT_OWNER);
    }

    @Override
    public void checkCall(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode call) {
        String owner = call.owner;
        String desc = call.desc;
        String name = call.name;
        if (owner.equals(DATE_FORMAT_OWNER)) {
            if (!name.equals("<init>")) {
                return;
            }
            if (desc.equals("(Ljava/lang/String;Ljava/text/DateFormatSymbols;)V") || desc.equals("()V") || desc.equals("(Ljava/lang/String;)V")) {
                Location location = context.getLocation((AbstractInsnNode)call);
                String message = "To get local formatting use getDateInstance(), getDateTimeInstance(), or getTimeInstance(), or use new SimpleDateFormat(String template, Locale locale) with for example Locale.US for ASCII dates.";
                context.report(DATE_FORMAT, method, (AbstractInsnNode)call, location, message, null);
            }
            return;
        }
        if (!owner.equals(STRING_OWNER)) {
            return;
        }
        if (name.equals("format")) {
            if (!desc.equals("(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;")) {
                return;
            }
            Analyzer analyzer = new Analyzer(new SourceInterpreter(){

                @Override
                public SourceValue newOperation(AbstractInsnNode insn) {
                    Object cst;
                    if (insn.getOpcode() == 18 && (cst = ((LdcInsnNode)insn).cst) instanceof String) {
                        return new StringValue(1, (String)cst);
                    }
                    return super.newOperation(insn);
                }
            });
            try {
                String format;
                Frame[] frames = analyzer.analyze(classNode.name, method);
                InsnList instructions = method.instructions;
                Frame frame = frames[instructions.indexOf((AbstractInsnNode)call)];
                if (frame.getStackSize() == 0) {
                    return;
                }
                SourceValue stackValue = (SourceValue)frame.getStack(0);
                if (stackValue instanceof StringValue && (format = ((StringValue)stackValue).getString()) != null && StringFormatDetector.isLocaleSpecific(format)) {
                    Location location = context.getLocation((AbstractInsnNode)call);
                    String message = "Implicitly using the default locale is a common source of bugs: Use String.format(Locale, ...) instead";
                    context.report(STRING_LOCALE, method, (AbstractInsnNode)call, location, message, null);
                }
            }
            catch (AnalyzerException e) {
                context.log(e, null, new Object[0]);
            }
        } else if (desc.equals("()Ljava/lang/String;")) {
            Location location = context.getLocation((AbstractInsnNode)call);
            String message = String.format("Implicitly using the default locale is a common source of bugs: Use %1$s(Locale) instead", name);
            context.report(STRING_LOCALE, method, (AbstractInsnNode)call, location, message, null);
        }
    }

    private static class StringValue
    extends SourceValue {
        private final String mString;

        StringValue(int size, String string) {
            super(size);
            this.mString = string;
        }

        String getString() {
            return this.mString;
        }

        @Override
        public int getSize() {
            return 1;
        }
    }
}

