/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothInputStream;
import android.bluetooth.BluetoothOutputStream;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothSocket
implements Closeable {
    private static final String TAG = "BluetoothSocket";
    public static final int MAX_RFCOMM_CHANNEL = 30;
    static final int TYPE_RFCOMM = 1;
    static final int TYPE_SCO = 2;
    static final int TYPE_L2CAP = 3;
    static final int EBADFD = 77;
    static final int EADDRINUSE = 98;
    private final int mType;
    private final BluetoothDevice mDevice;
    private final String mAddress;
    private final boolean mAuth;
    private final boolean mEncrypt;
    private final BluetoothInputStream mInputStream;
    private final BluetoothOutputStream mOutputStream;
    private final SdpHelper mSdp;
    private int mPort;
    private SocketState mSocketState;
    private final ReentrantReadWriteLock mLock;
    private int mSocketData;

    BluetoothSocket(int type, int fd, boolean auth, boolean encrypt, BluetoothDevice device, int port, ParcelUuid uuid) throws IOException {
        if (type == 1 && uuid == null && fd == -1 && (port < 1 || port > 30)) {
            throw new IOException("Invalid RFCOMM channel: " + port);
        }
        if (uuid == null) {
            this.mPort = port;
            this.mSdp = null;
        } else {
            this.mSdp = new SdpHelper(device, uuid);
            this.mPort = -1;
        }
        this.mType = type;
        this.mAuth = auth;
        this.mEncrypt = encrypt;
        this.mDevice = device;
        this.mAddress = device == null ? null : device.getAddress();
        if (fd == -1) {
            this.initSocketNative();
        } else {
            this.initSocketFromFdNative(fd);
        }
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mSocketState = SocketState.INIT;
        this.mLock = new ReentrantReadWriteLock();
    }

    private BluetoothSocket(int type, int fd, boolean auth, boolean encrypt, String address, int port) throws IOException {
        this(type, fd, auth, encrypt, new BluetoothDevice(address), port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            if (this.mSdp != null) {
                this.mPort = this.mSdp.doSdp();
            }
            this.connectNative();
            this.mSocketState = SocketState.CONNECTED;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                return;
            }
            if (this.mSdp != null) {
                this.mSdp.cancel();
            }
            this.abortNative();
        }
        finally {
            this.mLock.readLock().unlock();
        }
        this.mLock.writeLock().lock();
        try {
            this.mSocketState = SocketState.CLOSED;
            this.destroyNative();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public BluetoothDevice getRemoteDevice() {
        return this.mDevice;
    }

    public InputStream getInputStream() throws IOException {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mOutputStream;
    }

    public boolean isConnected() {
        return this.mSocketState == SocketState.CONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int bindListen() {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                int n = 77;
                return n;
            }
            int n = this.bindListenNative();
            return n;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BluetoothSocket accept(int timeout) throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            BluetoothSocket acceptedSocket = this.acceptNative(timeout);
            this.mSocketState = SocketState.CONNECTED;
            BluetoothSocket bluetoothSocket = acceptedSocket;
            return bluetoothSocket;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int available() throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            int n = this.availableNative();
            return n;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] b, int offset, int length) throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            int n = this.readNative(b, offset, length);
            return n;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int write(byte[] b, int offset, int length) throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            int n = this.writeNative(b, offset, length);
            return n;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    private void initSocketNative() throws IOException {
        OverrideMethod.invokeV("android.bluetooth.BluetoothSocket#initSocketNative()V", true, this);
    }

    private void initSocketFromFdNative(int n) throws IOException {
        OverrideMethod.invokeV("android.bluetooth.BluetoothSocket#initSocketFromFdNative(I)V", true, this);
    }

    private void connectNative() throws IOException {
        OverrideMethod.invokeV("android.bluetooth.BluetoothSocket#connectNative()V", true, this);
    }

    private int bindListenNative() {
        return OverrideMethod.invokeI("android.bluetooth.BluetoothSocket#bindListenNative()I", true, this);
    }

    private BluetoothSocket acceptNative(int n) throws IOException {
        return (BluetoothSocket)OverrideMethod.invokeA("android.bluetooth.BluetoothSocket#acceptNative(I)Landroid/bluetooth/BluetoothSocket;", true, this);
    }

    private int availableNative() throws IOException {
        return OverrideMethod.invokeI("android.bluetooth.BluetoothSocket#availableNative()I", true, this);
    }

    private int readNative(byte[] byArray, int n, int n2) throws IOException {
        return OverrideMethod.invokeI("android.bluetooth.BluetoothSocket#readNative([BII)I", true, this);
    }

    private int writeNative(byte[] byArray, int n, int n2) throws IOException {
        return OverrideMethod.invokeI("android.bluetooth.BluetoothSocket#writeNative([BII)I", true, this);
    }

    private void abortNative() throws IOException {
        OverrideMethod.invokeV("android.bluetooth.BluetoothSocket#abortNative()V", true, this);
    }

    private void destroyNative() throws IOException {
        OverrideMethod.invokeV("android.bluetooth.BluetoothSocket#destroyNative()V", true, this);
    }

    void throwErrnoNative(int n) throws IOException {
        OverrideMethod.invokeV("android.bluetooth.BluetoothSocket#throwErrnoNative(I)V", true, this);
    }

    private static class SdpHelper
    extends IBluetoothCallback.Stub {
        private final IBluetooth service = BluetoothDevice.getService();
        private final ParcelUuid uuid;
        private final BluetoothDevice device;
        private int channel;
        private boolean canceled;

        public SdpHelper(BluetoothDevice device, ParcelUuid uuid) {
            this.device = device;
            this.uuid = uuid;
            this.canceled = false;
        }

        public synchronized int doSdp() throws IOException {
            if (this.canceled) {
                throw new IOException("Service discovery canceled");
            }
            this.channel = -1;
            boolean inProgress = false;
            try {
                inProgress = this.service.fetchRemoteUuids(this.device.getAddress(), this.uuid, this);
            }
            catch (RemoteException e) {
                Log.e(BluetoothSocket.TAG, "", e);
            }
            if (!inProgress) {
                throw new IOException("Unable to start Service Discovery");
            }
            try {
                this.wait(12000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.canceled) {
                throw new IOException("Service discovery canceled");
            }
            if (this.channel < 1) {
                throw new IOException("Service discovery failed");
            }
            return this.channel;
        }

        public synchronized void cancel() {
            if (!this.canceled) {
                this.canceled = true;
                this.channel = -1;
                this.notifyAll();
            }
        }

        public synchronized void onRfcommChannelFound(int channel) {
            if (!this.canceled) {
                this.channel = channel;
                this.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SocketState {
        INIT,
        CONNECTED,
        CLOSED;

    }
}

