/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;

public class SQLiteDirectCursorDriver
implements SQLiteCursorDriver {
    private String mEditTable;
    private SQLiteDatabase mDatabase;
    private Cursor mCursor;
    private String mSql;
    private SQLiteQuery mQuery;

    public SQLiteDirectCursorDriver(SQLiteDatabase db, String sql, String editTable) {
        this.mDatabase = db;
        this.mEditTable = editTable;
        this.mSql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor query(SQLiteDatabase.CursorFactory factory, String[] selectionArgs) {
        SQLiteQuery query = null;
        try {
            this.mDatabase.lock(this.mSql);
            this.mDatabase.closePendingStatements();
            query = new SQLiteQuery(this.mDatabase, this.mSql, 0, selectionArgs);
            this.mCursor = factory == null ? new SQLiteCursor(this, this.mEditTable, query) : factory.newCursor(this.mDatabase, this, this.mEditTable, query);
            this.mQuery = query;
            query = null;
            Cursor cursor = this.mCursor;
            return cursor;
        }
        finally {
            if (query != null) {
                query.close();
            }
            this.mDatabase.unlock();
        }
    }

    public void cursorClosed() {
        this.mCursor = null;
    }

    public void setBindArguments(String[] bindArgs) {
        this.mQuery.bindAllArgsAsStrings(bindArgs);
    }

    public void cursorDeactivated() {
    }

    public void cursorRequeried(Cursor cursor) {
    }

    public String toString() {
        return "SQLiteDirectCursorDriver: " + this.mSql;
    }
}

