/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.content.res.TypedArray;
import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GestureOverlayView
extends FrameLayout {
    public static final int GESTURE_STROKE_TYPE_SINGLE = 0;
    public static final int GESTURE_STROKE_TYPE_MULTIPLE = 1;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final int FADE_ANIMATION_RATE = 16;
    private static final boolean GESTURE_RENDERING_ANTIALIAS = true;
    private static final boolean DITHER_FLAG = true;
    private final Paint mGesturePaint = new Paint();
    private long mFadeDuration = 150L;
    private long mFadeOffset = 420L;
    private long mFadingStart;
    private boolean mFadingHasStarted;
    private boolean mFadeEnabled = true;
    private int mCurrentColor;
    private int mCertainGestureColor = -256;
    private int mUncertainGestureColor = 1224736512;
    private float mGestureStrokeWidth = 12.0f;
    private int mInvalidateExtraBorder = 10;
    private int mGestureStrokeType = 0;
    private float mGestureStrokeLengthThreshold = 50.0f;
    private float mGestureStrokeSquarenessTreshold = 0.275f;
    private float mGestureStrokeAngleThreshold = 40.0f;
    private int mOrientation = 1;
    private final Rect mInvalidRect = new Rect();
    private final Path mPath = new Path();
    private boolean mGestureVisible = true;
    private float mX;
    private float mY;
    private float mCurveEndX;
    private float mCurveEndY;
    private float mTotalLength;
    private boolean mIsGesturing = false;
    private boolean mPreviousWasGesturing = false;
    private boolean mInterceptEvents = true;
    private boolean mIsListeningForGestures;
    private boolean mResetGesture;
    private Gesture mCurrentGesture;
    private final ArrayList<GesturePoint> mStrokeBuffer = new ArrayList(100);
    private final ArrayList<OnGestureListener> mOnGestureListeners = new ArrayList();
    private final ArrayList<OnGesturePerformedListener> mOnGesturePerformedListeners = new ArrayList();
    private final ArrayList<OnGesturingListener> mOnGesturingListeners = new ArrayList();
    private boolean mHandleGestureActions;
    private boolean mIsFadingOut = false;
    private float mFadingAlpha = 1.0f;
    private final AccelerateDecelerateInterpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private final FadeOutRunnable mFadingOut = new FadeOutRunnable();

    public GestureOverlayView(Context context) {
        super(context);
        this.init();
    }

    public GestureOverlayView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843703);
    }

    public GestureOverlayView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GestureOverlayView, defStyle, 0);
        this.mGestureStrokeWidth = a.getFloat(1, this.mGestureStrokeWidth);
        this.mInvalidateExtraBorder = Math.max(1, (int)this.mGestureStrokeWidth - 1);
        this.mCertainGestureColor = a.getColor(2, this.mCertainGestureColor);
        this.mUncertainGestureColor = a.getColor(3, this.mUncertainGestureColor);
        this.mFadeDuration = a.getInt(5, (int)this.mFadeDuration);
        this.mFadeOffset = a.getInt(4, (int)this.mFadeOffset);
        this.mGestureStrokeType = a.getInt(6, this.mGestureStrokeType);
        this.mGestureStrokeLengthThreshold = a.getFloat(7, this.mGestureStrokeLengthThreshold);
        this.mGestureStrokeAngleThreshold = a.getFloat(9, this.mGestureStrokeAngleThreshold);
        this.mGestureStrokeSquarenessTreshold = a.getFloat(8, this.mGestureStrokeSquarenessTreshold);
        this.mInterceptEvents = a.getBoolean(10, this.mInterceptEvents);
        this.mFadeEnabled = a.getBoolean(11, this.mFadeEnabled);
        this.mOrientation = a.getInt(0, this.mOrientation);
        a.recycle();
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        Paint gesturePaint = this.mGesturePaint;
        gesturePaint.setAntiAlias(true);
        gesturePaint.setColor(this.mCertainGestureColor);
        gesturePaint.setStyle(Paint.Style.STROKE);
        gesturePaint.setStrokeJoin(Paint.Join.ROUND);
        gesturePaint.setStrokeCap(Paint.Cap.ROUND);
        gesturePaint.setStrokeWidth(this.mGestureStrokeWidth);
        gesturePaint.setDither(true);
        this.mCurrentColor = this.mCertainGestureColor;
        this.setPaintAlpha(255);
    }

    public ArrayList<GesturePoint> getCurrentStroke() {
        return this.mStrokeBuffer;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public void setGestureColor(int color2) {
        this.mCertainGestureColor = color2;
    }

    public void setUncertainGestureColor(int color2) {
        this.mUncertainGestureColor = color2;
    }

    public int getUncertainGestureColor() {
        return this.mUncertainGestureColor;
    }

    public int getGestureColor() {
        return this.mCertainGestureColor;
    }

    public float getGestureStrokeWidth() {
        return this.mGestureStrokeWidth;
    }

    public void setGestureStrokeWidth(float gestureStrokeWidth) {
        this.mGestureStrokeWidth = gestureStrokeWidth;
        this.mInvalidateExtraBorder = Math.max(1, (int)gestureStrokeWidth - 1);
        this.mGesturePaint.setStrokeWidth(gestureStrokeWidth);
    }

    public int getGestureStrokeType() {
        return this.mGestureStrokeType;
    }

    public void setGestureStrokeType(int gestureStrokeType) {
        this.mGestureStrokeType = gestureStrokeType;
    }

    public float getGestureStrokeLengthThreshold() {
        return this.mGestureStrokeLengthThreshold;
    }

    public void setGestureStrokeLengthThreshold(float gestureStrokeLengthThreshold) {
        this.mGestureStrokeLengthThreshold = gestureStrokeLengthThreshold;
    }

    public float getGestureStrokeSquarenessTreshold() {
        return this.mGestureStrokeSquarenessTreshold;
    }

    public void setGestureStrokeSquarenessTreshold(float gestureStrokeSquarenessTreshold) {
        this.mGestureStrokeSquarenessTreshold = gestureStrokeSquarenessTreshold;
    }

    public float getGestureStrokeAngleThreshold() {
        return this.mGestureStrokeAngleThreshold;
    }

    public void setGestureStrokeAngleThreshold(float gestureStrokeAngleThreshold) {
        this.mGestureStrokeAngleThreshold = gestureStrokeAngleThreshold;
    }

    public boolean isEventsInterceptionEnabled() {
        return this.mInterceptEvents;
    }

    public void setEventsInterceptionEnabled(boolean enabled) {
        this.mInterceptEvents = enabled;
    }

    public boolean isFadeEnabled() {
        return this.mFadeEnabled;
    }

    public void setFadeEnabled(boolean fadeEnabled) {
        this.mFadeEnabled = fadeEnabled;
    }

    public Gesture getGesture() {
        return this.mCurrentGesture;
    }

    public void setGesture(Gesture gesture) {
        if (this.mCurrentGesture != null) {
            this.clear(false);
        }
        this.setCurrentColor(this.mCertainGestureColor);
        this.mCurrentGesture = gesture;
        Path path = this.mCurrentGesture.toPath();
        RectF bounds = new RectF();
        path.computeBounds(bounds, true);
        this.mPath.rewind();
        this.mPath.addPath(path, -bounds.left + ((float)this.getWidth() - bounds.width()) / 2.0f, -bounds.top + ((float)this.getHeight() - bounds.height()) / 2.0f);
        this.mResetGesture = true;
        this.invalidate();
    }

    public Path getGesturePath() {
        return this.mPath;
    }

    public Path getGesturePath(Path path) {
        path.set(this.mPath);
        return path;
    }

    public boolean isGestureVisible() {
        return this.mGestureVisible;
    }

    public void setGestureVisible(boolean visible) {
        this.mGestureVisible = visible;
    }

    public long getFadeOffset() {
        return this.mFadeOffset;
    }

    public void setFadeOffset(long fadeOffset) {
        this.mFadeOffset = fadeOffset;
    }

    public void addOnGestureListener(OnGestureListener listener) {
        this.mOnGestureListeners.add(listener);
    }

    public void removeOnGestureListener(OnGestureListener listener) {
        this.mOnGestureListeners.remove(listener);
    }

    public void removeAllOnGestureListeners() {
        this.mOnGestureListeners.clear();
    }

    public void addOnGesturePerformedListener(OnGesturePerformedListener listener) {
        this.mOnGesturePerformedListeners.add(listener);
        if (this.mOnGesturePerformedListeners.size() > 0) {
            this.mHandleGestureActions = true;
        }
    }

    public void removeOnGesturePerformedListener(OnGesturePerformedListener listener) {
        this.mOnGesturePerformedListeners.remove(listener);
        if (this.mOnGesturePerformedListeners.size() <= 0) {
            this.mHandleGestureActions = false;
        }
    }

    public void removeAllOnGesturePerformedListeners() {
        this.mOnGesturePerformedListeners.clear();
        this.mHandleGestureActions = false;
    }

    public void addOnGesturingListener(OnGesturingListener listener) {
        this.mOnGesturingListeners.add(listener);
    }

    public void removeOnGesturingListener(OnGesturingListener listener) {
        this.mOnGesturingListeners.remove(listener);
    }

    public void removeAllOnGesturingListeners() {
        this.mOnGesturingListeners.clear();
    }

    public boolean isGesturing() {
        return this.mIsGesturing;
    }

    private void setCurrentColor(int color2) {
        this.mCurrentColor = color2;
        if (this.mFadingHasStarted) {
            this.setPaintAlpha((int)(255.0f * this.mFadingAlpha));
        } else {
            this.setPaintAlpha(255);
        }
        this.invalidate();
    }

    public Paint getGesturePaint() {
        return this.mGesturePaint;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mCurrentGesture != null && this.mGestureVisible) {
            canvas.drawPath(this.mPath, this.mGesturePaint);
        }
    }

    private void setPaintAlpha(int alpha) {
        alpha += alpha >> 7;
        int baseAlpha = this.mCurrentColor >>> 24;
        int useAlpha = baseAlpha * alpha >> 8;
        this.mGesturePaint.setColor(this.mCurrentColor << 8 >>> 8 | useAlpha << 24);
    }

    public void clear(boolean animated) {
        this.clear(animated, false, true);
    }

    private void clear(boolean animated, boolean fireActionPerformed, boolean immediate) {
        this.setPaintAlpha(255);
        this.removeCallbacks(this.mFadingOut);
        this.mResetGesture = false;
        this.mFadingOut.fireActionPerformed = fireActionPerformed;
        this.mFadingOut.resetMultipleStrokes = false;
        if (animated && this.mCurrentGesture != null) {
            this.mFadingAlpha = 1.0f;
            this.mIsFadingOut = true;
            this.mFadingHasStarted = false;
            this.mFadingStart = AnimationUtils.currentAnimationTimeMillis() + this.mFadeOffset;
            this.postDelayed(this.mFadingOut, this.mFadeOffset);
        } else {
            this.mFadingAlpha = 1.0f;
            this.mIsFadingOut = false;
            this.mFadingHasStarted = false;
            if (immediate) {
                this.mCurrentGesture = null;
                this.mPath.rewind();
                this.invalidate();
            } else if (fireActionPerformed) {
                this.postDelayed(this.mFadingOut, this.mFadeOffset);
            } else if (this.mGestureStrokeType == 1) {
                this.mFadingOut.resetMultipleStrokes = true;
                this.postDelayed(this.mFadingOut, this.mFadeOffset);
            } else {
                this.mCurrentGesture = null;
                this.mPath.rewind();
                this.invalidate();
            }
        }
    }

    public void cancelClearAnimation() {
        this.setPaintAlpha(255);
        this.mIsFadingOut = false;
        this.mFadingHasStarted = false;
        this.removeCallbacks(this.mFadingOut);
        this.mPath.rewind();
        this.mCurrentGesture = null;
    }

    public void cancelGesture() {
        this.mIsListeningForGestures = false;
        this.mCurrentGesture.addStroke(new GestureStroke(this.mStrokeBuffer));
        long now = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
        ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).onGestureCancelled(this, event);
        }
        event.recycle();
        this.clear(false);
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mStrokeBuffer.clear();
        ArrayList<OnGesturingListener> otherListeners = this.mOnGesturingListeners;
        count = otherListeners.size();
        for (int i = 0; i < count; ++i) {
            otherListeners.get(i).onGesturingEnded(this);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.cancelClearAnimation();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            boolean cancelDispatch = (this.mIsGesturing || this.mCurrentGesture != null && this.mCurrentGesture.getStrokesCount() > 0 && this.mPreviousWasGesturing) && this.mInterceptEvents;
            this.processEvent(event);
            if (cancelDispatch) {
                event.setAction(3);
            }
            super.dispatchTouchEvent(event);
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    private boolean processEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchDown(event);
                this.invalidate();
                return true;
            }
            case 2: {
                if (!this.mIsListeningForGestures) break;
                Rect rect = this.touchMove(event);
                if (rect != null) {
                    this.invalidate(rect);
                }
                return true;
            }
            case 1: {
                if (!this.mIsListeningForGestures) break;
                this.touchUp(event, false);
                this.invalidate();
                return true;
            }
            case 3: {
                if (!this.mIsListeningForGestures) break;
                this.touchUp(event, true);
                this.invalidate();
                return true;
            }
        }
        return false;
    }

    private void touchDown(MotionEvent event) {
        this.mIsListeningForGestures = true;
        float x = event.getX();
        float y = event.getY();
        this.mX = x;
        this.mY = y;
        this.mTotalLength = 0.0f;
        this.mIsGesturing = false;
        if (this.mGestureStrokeType == 0 || this.mResetGesture) {
            if (this.mHandleGestureActions) {
                this.setCurrentColor(this.mUncertainGestureColor);
            }
            this.mResetGesture = false;
            this.mCurrentGesture = null;
            this.mPath.rewind();
        } else if ((this.mCurrentGesture == null || this.mCurrentGesture.getStrokesCount() == 0) && this.mHandleGestureActions) {
            this.setCurrentColor(this.mUncertainGestureColor);
        }
        if (this.mFadingHasStarted) {
            this.cancelClearAnimation();
        } else if (this.mIsFadingOut) {
            this.setPaintAlpha(255);
            this.mIsFadingOut = false;
            this.mFadingHasStarted = false;
            this.removeCallbacks(this.mFadingOut);
        }
        if (this.mCurrentGesture == null) {
            this.mCurrentGesture = new Gesture();
        }
        this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
        this.mPath.moveTo(x, y);
        int border = this.mInvalidateExtraBorder;
        this.mInvalidRect.set((int)x - border, (int)y - border, (int)x + border, (int)y + border);
        this.mCurveEndX = x;
        this.mCurveEndY = y;
        ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).onGestureStarted(this, event);
        }
    }

    private Rect touchMove(MotionEvent event) {
        Rect areaToRefresh = null;
        float x = event.getX();
        float y = event.getY();
        float previousX = this.mX;
        float previousY = this.mY;
        float dx = Math.abs(x - previousX);
        float dy = Math.abs(y - previousY);
        if (dx >= 3.0f || dy >= 3.0f) {
            areaToRefresh = this.mInvalidRect;
            int border = this.mInvalidateExtraBorder;
            areaToRefresh.set((int)this.mCurveEndX - border, (int)this.mCurveEndY - border, (int)this.mCurveEndX + border, (int)this.mCurveEndY + border);
            float cX = this.mCurveEndX = (x + previousX) / 2.0f;
            float cY = this.mCurveEndY = (y + previousY) / 2.0f;
            this.mPath.quadTo(previousX, previousY, cX, cY);
            areaToRefresh.union((int)previousX - border, (int)previousY - border, (int)previousX + border, (int)previousY + border);
            areaToRefresh.union((int)cX - border, (int)cY - border, (int)cX + border, (int)cY + border);
            this.mX = x;
            this.mY = y;
            this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
            if (this.mHandleGestureActions && !this.mIsGesturing) {
                this.mTotalLength += (float)Math.sqrt(dx * dx + dy * dy);
                if (this.mTotalLength > this.mGestureStrokeLengthThreshold) {
                    OrientedBoundingBox box = GestureUtils.computeOrientedBoundingBox(this.mStrokeBuffer);
                    float angle = Math.abs(box.orientation);
                    if (angle > 90.0f) {
                        angle = 180.0f - angle;
                    }
                    if (box.squareness > this.mGestureStrokeSquarenessTreshold || (this.mOrientation == 1 ? angle < this.mGestureStrokeAngleThreshold : angle > this.mGestureStrokeAngleThreshold)) {
                        this.mIsGesturing = true;
                        this.setCurrentColor(this.mCertainGestureColor);
                        ArrayList<OnGesturingListener> listeners = this.mOnGesturingListeners;
                        int count = listeners.size();
                        for (int i = 0; i < count; ++i) {
                            listeners.get(i).onGesturingStarted(this);
                        }
                    }
                }
            }
            ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.get(i).onGesture(this, event);
            }
        }
        return areaToRefresh;
    }

    private void touchUp(MotionEvent event, boolean cancel) {
        int i;
        int count;
        ArrayList<Object> listeners;
        this.mIsListeningForGestures = false;
        if (this.mCurrentGesture != null) {
            this.mCurrentGesture.addStroke(new GestureStroke(this.mStrokeBuffer));
            if (!cancel) {
                listeners = this.mOnGestureListeners;
                count = listeners.size();
                for (i = 0; i < count; ++i) {
                    ((OnGestureListener)listeners.get(i)).onGestureEnded(this, event);
                }
                this.clear(this.mHandleGestureActions && this.mFadeEnabled, this.mHandleGestureActions && this.mIsGesturing, false);
            } else {
                this.cancelGesture(event);
            }
        } else {
            this.cancelGesture(event);
        }
        this.mStrokeBuffer.clear();
        this.mPreviousWasGesturing = this.mIsGesturing;
        this.mIsGesturing = false;
        listeners = this.mOnGesturingListeners;
        count = listeners.size();
        for (i = 0; i < count; ++i) {
            ((OnGesturingListener)listeners.get(i)).onGesturingEnded(this);
        }
    }

    private void cancelGesture(MotionEvent event) {
        ArrayList<OnGestureListener> listeners = this.mOnGestureListeners;
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            listeners.get(i).onGestureCancelled(this, event);
        }
        this.clear(false);
    }

    private void fireOnGesturePerformed() {
        ArrayList<OnGesturePerformedListener> actionListeners = this.mOnGesturePerformedListeners;
        int count = actionListeners.size();
        for (int i = 0; i < count; ++i) {
            actionListeners.get(i).onGesturePerformed(this, this.mCurrentGesture);
        }
    }

    public static interface OnGesturePerformedListener {
        public void onGesturePerformed(GestureOverlayView var1, Gesture var2);
    }

    public static interface OnGestureListener {
        public void onGestureStarted(GestureOverlayView var1, MotionEvent var2);

        public void onGesture(GestureOverlayView var1, MotionEvent var2);

        public void onGestureEnded(GestureOverlayView var1, MotionEvent var2);

        public void onGestureCancelled(GestureOverlayView var1, MotionEvent var2);
    }

    public static interface OnGesturingListener {
        public void onGesturingStarted(GestureOverlayView var1);

        public void onGesturingEnded(GestureOverlayView var1);
    }

    private class FadeOutRunnable
    implements Runnable {
        boolean fireActionPerformed;
        boolean resetMultipleStrokes;

        private FadeOutRunnable() {
        }

        public void run() {
            if (GestureOverlayView.this.mIsFadingOut) {
                long now = AnimationUtils.currentAnimationTimeMillis();
                long duration = now - GestureOverlayView.this.mFadingStart;
                if (duration > GestureOverlayView.this.mFadeDuration) {
                    if (this.fireActionPerformed) {
                        GestureOverlayView.this.fireOnGesturePerformed();
                    }
                    GestureOverlayView.this.mPreviousWasGesturing = false;
                    GestureOverlayView.this.mIsFadingOut = false;
                    GestureOverlayView.this.mFadingHasStarted = false;
                    GestureOverlayView.this.mPath.rewind();
                    GestureOverlayView.this.mCurrentGesture = null;
                    GestureOverlayView.this.setPaintAlpha(255);
                } else {
                    GestureOverlayView.this.mFadingHasStarted = true;
                    float interpolatedTime = Math.max(0.0f, Math.min(1.0f, (float)duration / (float)GestureOverlayView.this.mFadeDuration));
                    GestureOverlayView.this.mFadingAlpha = 1.0f - GestureOverlayView.this.mInterpolator.getInterpolation(interpolatedTime);
                    GestureOverlayView.this.setPaintAlpha((int)(255.0f * GestureOverlayView.this.mFadingAlpha));
                    GestureOverlayView.this.postDelayed(this, 16L);
                }
            } else if (this.resetMultipleStrokes) {
                GestureOverlayView.this.mResetGesture = true;
            } else {
                GestureOverlayView.this.fireOnGesturePerformed();
                GestureOverlayView.this.mFadingHasStarted = false;
                GestureOverlayView.this.mPath.rewind();
                GestureOverlayView.this.mCurrentGesture = null;
                GestureOverlayView.this.mPreviousWasGesturing = false;
                GestureOverlayView.this.setPaintAlpha(255);
            }
            GestureOverlayView.this.invalidate();
        }
    }
}

