/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IRemoteControlDisplay;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRemoteControlClient
extends IInterface {
    public void onInformationRequested(int var1, int var2, int var3, int var4) throws RemoteException;

    public void setCurrentClientGenerationId(int var1) throws RemoteException;

    public void plugRemoteControlDisplay(IRemoteControlDisplay var1) throws RemoteException;

    public void unplugRemoteControlDisplay(IRemoteControlDisplay var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteControlClient {
        private static final String DESCRIPTOR = "android.media.IRemoteControlClient";
        static final int TRANSACTION_onInformationRequested = 1;
        static final int TRANSACTION_setCurrentClientGenerationId = 2;
        static final int TRANSACTION_plugRemoteControlDisplay = 3;
        static final int TRANSACTION_unplugRemoteControlDisplay = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRemoteControlClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteControlClient) {
                return (IRemoteControlClient)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.onInformationRequested(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.setCurrentClientGenerationId(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    this.plugRemoteControlDisplay(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    this.unplugRemoteControlDisplay(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IRemoteControlClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onInformationRequested(int generationId, int infoFlags, int artWidth, int artHeight) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(generationId);
                    _data.writeInt(infoFlags);
                    _data.writeInt(artWidth);
                    _data.writeInt(artHeight);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setCurrentClientGenerationId(int clientGeneration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientGeneration);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void plugRemoteControlDisplay(IRemoteControlDisplay rcd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unplugRemoteControlDisplay(IRemoteControlDisplay rcd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

