/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.Metadata;
import android.media.TimedText;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaPlayer {
    public static final boolean METADATA_UPDATE_ONLY = true;
    public static final boolean METADATA_ALL = false;
    public static final boolean APPLY_METADATA_FILTER = true;
    public static final boolean BYPASS_METADATA_FILTER = false;
    private static final String TAG = "MediaPlayer";
    private static final String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private int mNativeContext;
    private int mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private static final int KEY_PARAMETER_TIMED_TEXT_TRACK_INDEX = 1000;
    private static final int KEY_PARAMETER_TIMED_TEXT_ADD_OUT_OF_BAND_SOURCE = 1001;
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private OnPreparedListener mOnPreparedListener;
    private OnCompletionListener mOnCompletionListener;
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnTimedTextListener mOnTimedTextListener;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    private OnErrorListener mOnErrorListener;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    private OnInfoListener mOnInfoListener;

    public MediaPlayer() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<MediaPlayer>(this));
    }

    private void _setVideoSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setVideoSurface(Landroid/view/Surface;)V", true, this);
    }

    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(IMEDIA_PLAYER);
        return parcel;
    }

    public int invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        return retcode;
    }

    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        try {
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(context, uri);
            if (holder != null) {
                mp.setDisplay(holder);
            }
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public static MediaPlayer create(Context context, int resid) {
        try {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resid);
            if (afd == null) {
                return null;
            }
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            if (fd != null) {
                fd.close();
            }
        }
        Log.d(TAG, "Couldn't open file on client side, trying server side");
        this.setDataSource(uri.toString(), headers);
    }

    public void setDataSource(String string2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#setDataSource(Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this._setDataSource(path, keys, values);
    }

    private void _setDataSource(String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_setDataSource(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void prepare() throws IOException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#prepare()V", true, this);
    }

    public void prepareAsync() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#prepareAsync()V", true, this);
    }

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private void _start() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_start()V", true, this);
    }

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private void _stop() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_stop()V", true, this);
    }

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private void _pause() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#_pause()V", true, this);
    }

    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public int getVideoWidth() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoWidth()I", true, this);
    }

    public int getVideoHeight() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getVideoHeight()I", true, this);
    }

    public boolean isPlaying() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isPlaying()Z", true, this) != 0;
    }

    public void seekTo(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#seekTo(I)V", true, this);
    }

    public int getCurrentPosition() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getCurrentPosition()I", true, this);
    }

    public int getDuration() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getDuration()I", true, this);
    }

    public Metadata getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    public int setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnTimedTextListener = null;
        this._release();
    }

    private void _release() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_release()V", true, this);
    }

    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    private void _reset() {
        OverrideMethod.invokeV("android.media.MediaPlayer#_reset()V", true, this);
    }

    public void setAudioStreamType(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAudioStreamType(I)V", true, this);
    }

    public void setLooping(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setLooping(Z)V", true, this);
    }

    public boolean isLooping() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#isLooping()Z", true, this) != 0;
    }

    public void setVolume(float f, float f2) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setVolume(FF)V", true, this);
    }

    public Bitmap getFrameAt(int n) throws IllegalStateException {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaPlayer#getFrameAt(I)Landroid/graphics/Bitmap;", true, this);
    }

    public void setAudioSessionId(int n) throws IllegalArgumentException, IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAudioSessionId(I)V", true, this);
    }

    public int getAudioSessionId() {
        return OverrideMethod.invokeI("android.media.MediaPlayer#getAudioSessionId()I", true, this);
    }

    public void attachAuxEffect(int n) {
        OverrideMethod.invokeV("android.media.MediaPlayer#attachAuxEffect(I)V", true, this);
    }

    public boolean setParameter(int n, Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#setParameter(ILandroid/os/Parcel;)Z", true, this) != 0;
    }

    public boolean setParameter(int key, String value) {
        Parcel p = Parcel.obtain();
        p.writeString(value);
        boolean ret = this.setParameter(key, p);
        p.recycle();
        return ret;
    }

    public boolean setParameter(int key, int value) {
        Parcel p = Parcel.obtain();
        p.writeInt(value);
        boolean ret = this.setParameter(key, p);
        p.recycle();
        return ret;
    }

    private void getParameter(int n, Parcel parcel) {
        OverrideMethod.invokeV("android.media.MediaPlayer#getParameter(ILandroid/os/Parcel;)V", true, this);
    }

    public Parcel getParcelParameter(int key) {
        Parcel p = Parcel.obtain();
        this.getParameter(key, p);
        return p;
    }

    public String getStringParameter(int key) {
        Parcel p = Parcel.obtain();
        this.getParameter(key, p);
        String ret = p.readString();
        p.recycle();
        return ret;
    }

    public int getIntParameter(int key) {
        Parcel p = Parcel.obtain();
        this.getParameter(key, p);
        int ret = p.readInt();
        p.recycle();
        return ret;
    }

    public void setAuxEffectSendLevel(float f) {
        OverrideMethod.invokeV("android.media.MediaPlayer#setAuxEffectSendLevel(F)V", true, this);
    }

    private int native_invoke(Parcel parcel, Parcel parcel2) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_invoke(Landroid/os/Parcel;Landroid/os/Parcel;)I", true, this);
    }

    private boolean native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_getMetadata(ZZLandroid/os/Parcel;)Z", true, this) != 0;
    }

    private int native_setMetadataFilter(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_setMetadataFilter(Landroid/os/Parcel;)I", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_init()V", true, null);
    }

    private void native_setup(Object object) {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_setup(Ljava/lang/Object;)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaPlayer#native_finalize()V", true, this);
    }

    public boolean enableTimedTextTrackIndex(int index) {
        if (index < 0) {
            return false;
        }
        return this.setParameter(1000, index);
    }

    public boolean enableTimedText() {
        return this.enableTimedTextTrackIndex(0);
    }

    public boolean disableTimedText() {
        return this.setParameter(1000, -1);
    }

    public static int native_pullBatteryData(Parcel parcel) {
        return OverrideMethod.invokeI("android.media.MediaPlayer#native_pullBatteryData(Landroid/os/Parcel;)I", true, null);
    }

    protected void finalize() {
        this.native_finalize();
    }

    private static void postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        MediaPlayer mp = (MediaPlayer)((WeakReference)mediaplayer_ref).get();
        if (mp == null) {
            return;
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    public void setOnTimedTextListener(OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    static {
        System.loadLibrary("media_jni");
        MediaPlayer.native_init();
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        public void handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0) {
                Log.w(MediaPlayer.TAG, "mediaplayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    if (MediaPlayer.this.mOnPreparedListener != null) {
                        MediaPlayer.this.mOnPreparedListener.onPrepared(this.mMediaPlayer);
                    }
                    return;
                }
                case 2: {
                    if (MediaPlayer.this.mOnCompletionListener != null) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 3: {
                    if (MediaPlayer.this.mOnBufferingUpdateListener != null) {
                        MediaPlayer.this.mOnBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    if (MediaPlayer.this.mOnSeekCompleteListener != null) {
                        MediaPlayer.this.mOnSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    if (MediaPlayer.this.mOnVideoSizeChangedListener != null) {
                        MediaPlayer.this.mOnVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 100: {
                    Log.e(MediaPlayer.TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    boolean error_was_handled = false;
                    if (MediaPlayer.this.mOnErrorListener != null) {
                        error_was_handled = MediaPlayer.this.mOnErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    if (MediaPlayer.this.mOnCompletionListener != null && !error_was_handled) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: {
                    if (msg.arg1 != 700) {
                        Log.i(MediaPlayer.TAG, "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                    }
                    if (MediaPlayer.this.mOnInfoListener != null) {
                        MediaPlayer.this.mOnInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 99: {
                    if (MediaPlayer.this.mOnTimedTextListener != null) {
                        if (msg.obj == null) {
                            MediaPlayer.this.mOnTimedTextListener.onTimedText(this.mMediaPlayer, null);
                        } else if (msg.obj instanceof byte[]) {
                            TimedText text = new TimedText((byte[])msg.obj);
                            MediaPlayer.this.mOnTimedTextListener.onTimedText(this.mMediaPlayer, text);
                        }
                    }
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    Log.e(MediaPlayer.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }
}

