/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.HandlerThread_Delegate;
import android.os.Looper;
import android.os.Process;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class HandlerThread
extends Thread {
    int mPriority;
    int mTid = -1;
    Looper mLooper;

    public HandlerThread(String name) {
        super(name);
        this.mPriority = 0;
    }

    public HandlerThread(String name, int priority) {
        super(name);
        this.mPriority = priority;
    }

    protected void onLooperPrepared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run_Original() {
        this.mTid = Process.myTid();
        Looper.prepare();
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            this.mLooper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority(this.mPriority);
        this.onLooperPrepared();
        Looper.loop();
        this.mTid = -1;
    }

    @LayoutlibDelegate
    public void run() {
        HandlerThread_Delegate.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        HandlerThread handlerThread = this;
        synchronized (handlerThread) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.mLooper;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public int getThreadId() {
        return this.mTid;
    }
}

