/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class UEventObserver {
    private static final String TAG = UEventObserver.class.getSimpleName();
    private static UEventThread sThread;
    private static boolean sThreadStarted;

    private static void native_setup() {
        OverrideMethod.invokeV("android.os.UEventObserver#native_setup()V", true, null);
    }

    private static int next_event(byte[] byArray) {
        return OverrideMethod.invokeI("android.os.UEventObserver#next_event([B)I", true, null);
    }

    private static synchronized void ensureThreadStarted() {
        if (!sThreadStarted) {
            sThread = new UEventThread();
            sThread.start();
            sThreadStarted = true;
        }
    }

    public synchronized void startObserving(String match) {
        UEventObserver.ensureThreadStarted();
        sThread.addObserver(match, this);
    }

    public synchronized void stopObserving() {
        sThread.removeObserver(this);
    }

    public abstract void onUEvent(UEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.stopObserving();
        }
        finally {
            super.finalize();
        }
    }

    static {
        sThreadStarted = false;
    }

    private static class UEventThread
    extends Thread {
        private ArrayList<Object> mObservers = new ArrayList();

        UEventThread() {
            super("UEventObserver");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UEventObserver.native_setup();
            byte[] buffer = new byte[1024];
            while (true) {
                int len;
                if ((len = UEventObserver.next_event(buffer)) <= 0) {
                    continue;
                }
                String bufferStr = new String(buffer, 0, len);
                ArrayList<Object> arrayList = this.mObservers;
                synchronized (arrayList) {
                    for (int i = 0; i < this.mObservers.size(); i += 2) {
                        if (bufferStr.indexOf((String)this.mObservers.get(i)) == -1) continue;
                        ((UEventObserver)this.mObservers.get(i + 1)).onUEvent(new UEvent(bufferStr));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObserver(String match, UEventObserver observer) {
            ArrayList<Object> arrayList = this.mObservers;
            synchronized (arrayList) {
                this.mObservers.add(match);
                this.mObservers.add(observer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObserver(UEventObserver observer) {
            ArrayList<Object> arrayList = this.mObservers;
            synchronized (arrayList) {
                boolean found = true;
                block3: while (found) {
                    found = false;
                    for (int i = 0; i < this.mObservers.size(); i += 2) {
                        if (this.mObservers.get(i + 1) != observer) continue;
                        this.mObservers.remove(i + 1);
                        this.mObservers.remove(i);
                        found = true;
                        continue block3;
                    }
                }
            }
        }
    }

    public static class UEvent {
        public HashMap<String, String> mMap = new HashMap();

        public UEvent(String message) {
            int offset = 0;
            int length = message.length();
            while (offset < length) {
                int equals = message.indexOf(61, offset);
                int at = message.indexOf(0, offset);
                if (at < 0) break;
                if (equals > offset && equals < at) {
                    this.mMap.put(message.substring(offset, equals), message.substring(equals + 1, at));
                }
                offset = at + 1;
            }
        }

        public String get(String key) {
            return this.mMap.get(key);
        }

        public String get(String key, String defaultValue) {
            String result = this.mMap.get(key);
            return result == null ? defaultValue : result;
        }

        public String toString() {
            return this.mMap.toString();
        }
    }
}

