/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GenericInflater<T, P extends Parent> {
    private final boolean DEBUG = false;
    protected final Context mContext;
    private boolean mFactorySet;
    private Factory<T> mFactory;
    private final Object[] mConstructorArgs = new Object[2];
    private static final Class[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap sConstructorMap = new HashMap();
    private String mDefaultPackage;

    protected GenericInflater(Context context) {
        this.mContext = context;
    }

    protected GenericInflater(GenericInflater<T, P> original, Context newContext) {
        this.mContext = newContext;
        this.mFactory = original.mFactory;
    }

    public abstract GenericInflater cloneInContext(Context var1);

    public void setDefaultPackage(String defaultPackage) {
        this.mDefaultPackage = defaultPackage;
    }

    public String getDefaultPackage() {
        return this.mDefaultPackage;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Factory<T> getFactory() {
        return this.mFactory;
    }

    public void setFactory(Factory<T> factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this inflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        this.mFactory = this.mFactory == null ? factory : new FactoryMerger<T>(factory, this.mFactory);
    }

    public T inflate(int resource, P root) {
        return this.inflate(resource, root, root != null);
    }

    public T inflate(XmlPullParser parser, P root) {
        return this.inflate(parser, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T inflate(int resource, P root, boolean attachToRoot) {
        XmlResourceParser parser = this.getContext().getResources().getXml(resource);
        try {
            T t = this.inflate(parser, root, attachToRoot);
            return t;
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T inflate(XmlPullParser parser, P root, boolean attachToRoot) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (this.mConstructorArgs) {
            AttributeSet attrs = Xml.asAttributeSet(parser);
            this.mConstructorArgs[0] = this.mContext;
            Object result = root;
            try {
                int type;
                do {
                    type = parser.next();
                    if (type == 2) break;
                } while (type != 1);
                if (type != 2) {
                    throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
                }
                T xmlRoot = this.createItemFromTag(parser, parser.getName(), attrs);
                result = this.onMergeRoots(root, attachToRoot, (Parent)xmlRoot);
                this.rInflate(parser, result, attrs);
            }
            catch (InflateException e) {
                throw e;
            }
            catch (XmlPullParserException e) {
                InflateException ex = new InflateException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            catch (IOException e) {
                InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            return (T)result;
        }
    }

    public T createItem(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Constructor<?> constructor = (Constructor<?>)sConstructorMap.get(name);
        try {
            if (null == constructor) {
                Class<?> clazz = this.mContext.getClassLoader().loadClass(prefix != null ? prefix + name : name);
                constructor = clazz.getConstructor(mConstructorSignature);
                sConstructorMap.put(name, constructor);
            }
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + (prefix != null ? prefix + name : name));
            ie.initCause(e);
            throw ie;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + constructor.getClass().getName());
            ie.initCause(e);
            throw ie;
        }
    }

    protected T onCreateItem(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createItem(name, this.mDefaultPackage, attrs);
    }

    private T createItemFromTag(XmlPullParser parser, String name, AttributeSet attrs) {
        try {
            T item;
            T t = item = this.mFactory == null ? null : (T)this.mFactory.onCreateItem(name, this.mContext, attrs);
            if (item == null) {
                item = -1 == name.indexOf(46) ? (T)this.onCreateItem(name, attrs) : (T)this.createItem(name, null, attrs);
            }
            return item;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause(e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause(e);
            throw ie;
        }
    }

    private void rInflate(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth = parser.getDepth();
        while (true) {
            int type = parser.next();
            if (type == 3 && parser.getDepth() <= depth) break;
            if (type == 1) break;
            if (type != 2 || this.onCreateCustomFromTag(parser, parent, attrs)) continue;
            String name = parser.getName();
            T item = this.createItemFromTag(parser, name, attrs);
            ((Parent)parent).addItemFromInflater(item);
            this.rInflate(parser, item, attrs);
        }
    }

    protected boolean onCreateCustomFromTag(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException {
        return false;
    }

    protected P onMergeRoots(P givenRoot, boolean attachToGivenRoot, P xmlRoot) {
        return xmlRoot;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryMerger<T>
    implements Factory<T> {
        private final Factory<T> mF1;
        private final Factory<T> mF2;

        FactoryMerger(Factory<T> f1, Factory<T> f2) {
            this.mF1 = f1;
            this.mF2 = f2;
        }

        @Override
        public T onCreateItem(String name, Context context, AttributeSet attrs) {
            T v = this.mF1.onCreateItem(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF2.onCreateItem(name, context, attrs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<T> {
        public T onCreateItem(String var1, Context var2, AttributeSet var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Parent<T> {
        public void addItemFromInflater(T var1);
    }
}

