/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Interpolator;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.LocaleUtil;
import android.util.Log;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.Property;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.AbsSavedState;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DisplayList;
import android.view.DragEvent;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InputEventConsistencyVerifier;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.Surface;
import android.view.TouchDelegate;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewPropertyAnimator;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.View_Delegate;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityEventSource;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.ScrollBarDrawable;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import com.android.internal.view.menu.MenuBuilder;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements Drawable.Callback,
Drawable.Callback2,
KeyEvent.Callback,
AccessibilityEventSource {
    private static final boolean DBG = false;
    protected static final String VIEW_LOG_TAG = "View";
    public static final int NO_ID = -1;
    private static final int NOT_FOCUSABLE = 0;
    private static final int FOCUSABLE = 1;
    private static final int FOCUSABLE_MASK = 1;
    private static final int FITS_SYSTEM_WINDOWS = 2;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    static final int VISIBILITY_MASK = 12;
    private static final int[] VISIBILITY_FLAGS = new int[]{0, 4, 8};
    static final int ENABLED = 0;
    static final int DISABLED = 32;
    static final int ENABLED_MASK = 32;
    static final int WILL_NOT_DRAW = 128;
    static final int DRAW_MASK = 128;
    static final int SCROLLBARS_NONE = 0;
    static final int SCROLLBARS_HORIZONTAL = 256;
    static final int SCROLLBARS_VERTICAL = 512;
    static final int SCROLLBARS_MASK = 768;
    static final int FILTER_TOUCHES_WHEN_OBSCURED = 1024;
    static final int FADING_EDGE_NONE = 0;
    static final int FADING_EDGE_HORIZONTAL = 4096;
    static final int FADING_EDGE_VERTICAL = 8192;
    static final int FADING_EDGE_MASK = 12288;
    static final int CLICKABLE = 16384;
    static final int DRAWING_CACHE_ENABLED = 32768;
    static final int SAVE_DISABLED = 65536;
    static final int SAVE_DISABLED_MASK = 65536;
    static final int WILL_NOT_CACHE_DRAWING = 131072;
    static final int FOCUSABLE_IN_TOUCH_MODE = 262144;
    public static final int DRAWING_CACHE_QUALITY_LOW = 524288;
    public static final int DRAWING_CACHE_QUALITY_HIGH = 0x100000;
    public static final int DRAWING_CACHE_QUALITY_AUTO = 0;
    private static final int[] DRAWING_CACHE_QUALITY_FLAGS = new int[]{0, 524288, 0x100000};
    static final int DRAWING_CACHE_QUALITY_MASK = 0x180000;
    static final int LONG_CLICKABLE = 0x200000;
    static final int DUPLICATE_PARENT_STATE = 0x400000;
    public static final int SCROLLBARS_INSIDE_OVERLAY = 0;
    public static final int SCROLLBARS_INSIDE_INSET = 0x1000000;
    public static final int SCROLLBARS_OUTSIDE_OVERLAY = 0x2000000;
    public static final int SCROLLBARS_OUTSIDE_INSET = 0x3000000;
    static final int SCROLLBARS_INSET_MASK = 0x1000000;
    static final int SCROLLBARS_OUTSIDE_MASK = 0x2000000;
    static final int SCROLLBARS_STYLE_MASK = 0x3000000;
    public static final int KEEP_SCREEN_ON = 0x4000000;
    public static final int SOUND_EFFECTS_ENABLED = 0x8000000;
    public static final int HAPTIC_FEEDBACK_ENABLED = 0x10000000;
    static final int PARENT_SAVE_DISABLED = 0x20000000;
    static final int PARENT_SAVE_DISABLED_MASK = 0x20000000;
    public static final int LAYOUT_DIRECTION_LTR = 0;
    public static final int LAYOUT_DIRECTION_RTL = 0x40000000;
    public static final int LAYOUT_DIRECTION_INHERIT = Integer.MIN_VALUE;
    public static final int LAYOUT_DIRECTION_LOCALE = -1073741824;
    static final int LAYOUT_DIRECTION_MASK = -1073741824;
    private static final int[] LAYOUT_DIRECTION_FLAGS = new int[]{0, 0x40000000, Integer.MIN_VALUE, -1073741824};
    private static final int LAYOUT_DIRECTION_DEFAULT = Integer.MIN_VALUE;
    public static final int FOCUSABLES_ALL = 0;
    public static final int FOCUSABLES_TOUCH_MODE = 1;
    public static final int FOCUS_BACKWARD = 1;
    public static final int FOCUS_FORWARD = 2;
    public static final int FOCUS_LEFT = 17;
    public static final int FOCUS_UP = 33;
    public static final int FOCUS_RIGHT = 66;
    public static final int FOCUS_DOWN = 130;
    public static final int MEASURED_SIZE_MASK = 0xFFFFFF;
    public static final int MEASURED_STATE_MASK = -16777216;
    public static final int MEASURED_HEIGHT_STATE_SHIFT = 16;
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    protected static final int[] EMPTY_STATE_SET;
    protected static final int[] ENABLED_STATE_SET;
    protected static final int[] FOCUSED_STATE_SET;
    protected static final int[] SELECTED_STATE_SET;
    protected static final int[] PRESSED_STATE_SET;
    protected static final int[] WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_SELECTED_STATE_SET;
    protected static final int[] ENABLED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] FOCUSED_SELECTED_STATE_SET;
    protected static final int[] FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    private static final int[][] VIEW_STATE_SETS;
    static final int VIEW_STATE_WINDOW_FOCUSED = 1;
    static final int VIEW_STATE_SELECTED = 2;
    static final int VIEW_STATE_FOCUSED = 4;
    static final int VIEW_STATE_ENABLED = 8;
    static final int VIEW_STATE_PRESSED = 16;
    static final int VIEW_STATE_ACTIVATED = 32;
    static final int VIEW_STATE_ACCELERATED = 64;
    static final int VIEW_STATE_HOVERED = 128;
    static final int VIEW_STATE_DRAG_CAN_ACCEPT = 256;
    static final int VIEW_STATE_DRAG_HOVERED = 512;
    static final int[] VIEW_STATE_IDS;
    private static final int POPULATING_ACCESSIBILITY_EVENT_TYPES = 8639;
    static final ThreadLocal<Rect> sThreadLocal;
    private SparseArray<Object> mKeyedTags;
    private static int sNextAccessibilityViewId;
    protected Animation mCurrentAnimation = null;
    @ViewDebug.ExportedProperty(category="measurement")
    int mMeasuredWidth;
    @ViewDebug.ExportedProperty(category="measurement")
    int mMeasuredHeight;
    boolean mRecreateDisplayList = false;
    @ViewDebug.ExportedProperty(resolveId=true)
    int mID = -1;
    int mAccessibilityViewId = -1;
    protected Object mTag;
    static final int WANTS_FOCUS = 1;
    static final int FOCUSED = 2;
    static final int SELECTED = 4;
    static final int IS_ROOT_NAMESPACE = 8;
    static final int HAS_BOUNDS = 16;
    static final int DRAWN = 32;
    static final int DRAW_ANIMATION = 64;
    static final int SKIP_DRAW = 128;
    static final int ONLY_DRAWS_BACKGROUND = 256;
    static final int REQUEST_TRANSPARENT_REGIONS = 512;
    static final int DRAWABLE_STATE_DIRTY = 1024;
    static final int MEASURED_DIMENSION_SET = 2048;
    static final int FORCE_LAYOUT = 4096;
    static final int LAYOUT_REQUIRED = 8192;
    private static final int PRESSED = 16384;
    static final int DRAWING_CACHE_VALID = 32768;
    static final int ANIMATION_STARTED = 65536;
    private static final int SAVE_STATE_CALLED = 131072;
    static final int ALPHA_SET = 262144;
    static final int SCROLL_CONTAINER = 524288;
    static final int SCROLL_CONTAINER_ADDED = 0x100000;
    static final int DIRTY = 0x200000;
    static final int DIRTY_OPAQUE = 0x400000;
    static final int DIRTY_MASK = 0x600000;
    static final int OPAQUE_BACKGROUND = 0x800000;
    static final int OPAQUE_SCROLLBARS = 0x1000000;
    static final int OPAQUE_MASK = 0x1800000;
    private static final int PREPRESSED = 0x2000000;
    static final int CANCEL_NEXT_UP_EVENT = 0x4000000;
    private static final int AWAKEN_SCROLL_BARS_ON_ATTACH = 0x8000000;
    private static final int HOVERED = 0x10000000;
    private static final int PIVOT_EXPLICITLY_SET = 0x20000000;
    static final int ACTIVATED = 0x40000000;
    static final int INVALIDATED = Integer.MIN_VALUE;
    static final int DRAG_CAN_ACCEPT = 1;
    static final int DRAG_HOVERED = 2;
    static final int LAYOUT_DIRECTION_RESOLVED_RTL = 4;
    static final int LAYOUT_DIRECTION_RESOLVED = 8;
    static final int DRAG_MASK = 3;
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    public static final int SYSTEM_UI_FLAG_VISIBLE = 0;
    public static final int SYSTEM_UI_FLAG_LOW_PROFILE = 1;
    public static final int SYSTEM_UI_FLAG_HIDE_NAVIGATION = 2;
    public static final int STATUS_BAR_HIDDEN = 1;
    public static final int STATUS_BAR_VISIBLE = 0;
    public static final int STATUS_BAR_DISABLE_EXPAND = 65536;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_ICONS = 131072;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_ALERTS = 262144;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_TICKER = 524288;
    public static final int STATUS_BAR_DISABLE_SYSTEM_INFO = 0x100000;
    public static final int STATUS_BAR_DISABLE_HOME = 0x200000;
    public static final int STATUS_BAR_DISABLE_BACK = 0x400000;
    public static final int STATUS_BAR_DISABLE_CLOCK = 0x800000;
    public static final int STATUS_BAR_DISABLE_RECENT = 0x1000000;
    @Deprecated
    public static final int STATUS_BAR_DISABLE_NAVIGATION = 0x1200000;
    public static final int PUBLIC_STATUS_BAR_VISIBILITY_MASK = 65535;
    public static final int SYSTEM_UI_CLEARABLE_FLAGS = 3;
    public static final int FIND_VIEWS_WITH_TEXT = 1;
    public static final int FIND_VIEWS_WITH_CONTENT_DESCRIPTION = 2;
    private int mOverScrollMode;
    protected ViewParent mParent;
    AttachInfo mAttachInfo;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=4096, equals=4096, name="FORCE_LAYOUT"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="LAYOUT_REQUIRED"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="DRAWING_CACHE_INVALID", outputIf=false), @ViewDebug.FlagToString(mask=32, equals=32, name="DRAWN", outputIf=true), @ViewDebug.FlagToString(mask=32, equals=32, name="NOT_DRAWN", outputIf=false), @ViewDebug.FlagToString(mask=0x600000, equals=0x400000, name="DIRTY_OPAQUE"), @ViewDebug.FlagToString(mask=0x600000, equals=0x200000, name="DIRTY")})
    int mPrivateFlags;
    int mPrivateFlags2;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="SYSTEM_UI_FLAG_LOW_PROFILE", outputIf=true), @ViewDebug.FlagToString(mask=2, equals=2, name="SYSTEM_UI_FLAG_HIDE_NAVIGATION", outputIf=true), @ViewDebug.FlagToString(mask=65535, equals=0, name="SYSTEM_UI_FLAG_VISIBLE", outputIf=true)})
    int mSystemUiVisibility;
    int mWindowAttachCount;
    protected ViewGroup.LayoutParams mLayoutParams;
    @ViewDebug.ExportedProperty
    int mViewFlags;
    TransformationInfo mTransformationInfo;
    private boolean mLastIsOpaque;
    private static final float NONZERO_EPSILON = 0.001f;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mLeft;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mRight;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mTop;
    @ViewDebug.ExportedProperty(category="layout")
    protected int mBottom;
    @ViewDebug.ExportedProperty(category="scrolling")
    protected int mScrollX;
    @ViewDebug.ExportedProperty(category="scrolling")
    protected int mScrollY;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingLeft;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingTop;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mPaddingBottom;
    private CharSequence mContentDescription;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mUserPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mUserPaddingBottom;
    @ViewDebug.ExportedProperty(category="padding")
    protected int mUserPaddingLeft;
    @ViewDebug.ExportedProperty(category="padding")
    boolean mUserPaddingRelative;
    @ViewDebug.ExportedProperty(category="padding")
    int mUserPaddingStart;
    @ViewDebug.ExportedProperty(category="padding")
    int mUserPaddingEnd;
    int mOldWidthMeasureSpec = Integer.MIN_VALUE;
    int mOldHeightMeasureSpec = Integer.MIN_VALUE;
    private Drawable mBGDrawable;
    private int mBackgroundResource;
    private boolean mBackgroundSizeChanged;
    ListenerInfo mListenerInfo;
    protected Context mContext;
    private final Resources mResources;
    private ScrollabilityCache mScrollCache;
    private int[] mDrawableState = null;
    public boolean mCachingFailed;
    private Bitmap mDrawingCache;
    private Bitmap mUnscaledDrawingCache;
    private HardwareLayer mHardwareLayer;
    DisplayList mDisplayList;
    private int mNextFocusLeftId = -1;
    private int mNextFocusRightId = -1;
    private int mNextFocusUpId = -1;
    private int mNextFocusDownId = -1;
    int mNextFocusForwardId = -1;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap = null;
    private PerformClick mPerformClick;
    private SendViewScrolledAccessibilityEvent mSendViewScrolledAccessibilityEvent;
    private UnsetPressedState mUnsetPressedState;
    private boolean mHasPerformedLongPress;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mMinHeight;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mMinWidth;
    private TouchDelegate mTouchDelegate = null;
    private int mDrawingCacheBackgroundColor = 0;
    private ViewTreeObserver mFloatingTreeObserver;
    private int mTouchSlop;
    private ViewPropertyAnimator mAnimator = null;
    public static final int DRAG_FLAG_GLOBAL = 1;
    private float mVerticalScrollFactor;
    private int mVerticalScrollbarPosition;
    public static final int SCROLLBAR_POSITION_DEFAULT = 0;
    public static final int SCROLLBAR_POSITION_LEFT = 1;
    public static final int SCROLLBAR_POSITION_RIGHT = 2;
    public static final int LAYER_TYPE_NONE = 0;
    public static final int LAYER_TYPE_SOFTWARE = 1;
    public static final int LAYER_TYPE_HARDWARE = 2;
    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="SOFTWARE"), @ViewDebug.IntToString(from=2, to="HARDWARE")})
    int mLayerType = 0;
    Paint mLayerPaint;
    Rect mLocalDirtyRect;
    private boolean mSendingHoverAccessibilityEvents;
    AccessibilityDelegate mAccessibilityDelegate;
    public static final int TEXT_DIRECTION_INHERIT = 0;
    public static final int TEXT_DIRECTION_FIRST_STRONG = 1;
    public static final int TEXT_DIRECTION_ANY_RTL = 2;
    public static final int TEXT_DIRECTION_LTR = 3;
    public static final int TEXT_DIRECTION_RTL = 4;
    protected static int DEFAULT_TEXT_DIRECTION;
    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="INHERIT"), @ViewDebug.IntToString(from=1, to="FIRST_STRONG"), @ViewDebug.IntToString(from=2, to="ANY_RTL"), @ViewDebug.IntToString(from=3, to="LTR"), @ViewDebug.IntToString(from=4, to="RTL")})
    private int mTextDirection = DEFAULT_TEXT_DIRECTION;
    @ViewDebug.ExportedProperty(category="text", mapping={@ViewDebug.IntToString(from=0, to="INHERIT"), @ViewDebug.IntToString(from=1, to="FIRST_STRONG"), @ViewDebug.IntToString(from=2, to="ANY_RTL"), @ViewDebug.IntToString(from=3, to="LTR"), @ViewDebug.IntToString(from=4, to="RTL")})
    private int mResolvedTextDirection = 0;
    protected final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
    public static Property<View, Float> ALPHA;
    public static Property<View, Float> TRANSLATION_X;
    public static Property<View, Float> TRANSLATION_Y;
    public static Property<View, Float> X;
    public static Property<View, Float> Y;
    public static Property<View, Float> ROTATION;
    public static Property<View, Float> ROTATION_X;
    public static Property<View, Float> ROTATION_Y;
    public static Property<View, Float> SCALE_X;
    public static Property<View, Float> SCALE_Y;

    public View(Context context) {
        this.mContext = context;
        this.mResources = context != null ? context.getResources() : null;
        this.mViewFlags = -1744830464;
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.setOverScrollMode(1);
        this.mUserPaddingStart = -1;
        this.mUserPaddingEnd = -1;
        this.mUserPaddingRelative = false;
    }

    public View(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public View(Context context, AttributeSet attrs, int defStyle) {
        this(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        Drawable background = null;
        int leftPadding = -1;
        int topPadding = -1;
        int rightPadding = -1;
        int bottomPadding = -1;
        int startPadding = -1;
        int endPadding = -1;
        int padding = -1;
        int viewFlagValues = 0;
        int viewFlagMasks = 0;
        boolean setScrollContainer = false;
        int x = 0;
        int y = 0;
        float tx = 0.0f;
        float ty = 0.0f;
        float rotation = 0.0f;
        float rotationX = 0.0f;
        float rotationY = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        boolean transformSet = false;
        int scrollbarStyle = 0;
        int overScrollMode = this.mOverScrollMode;
        int N = a.getIndexCount();
        block56: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 12: {
                    background = a.getDrawable(attr2);
                    continue block56;
                }
                case 13: {
                    padding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 14: {
                    leftPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 15: {
                    topPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 16: {
                    rightPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 17: {
                    bottomPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 61: {
                    startPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 62: {
                    endPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block56;
                }
                case 10: {
                    x = a.getDimensionPixelOffset(attr2, 0);
                    continue block56;
                }
                case 11: {
                    y = a.getDimensionPixelOffset(attr2, 0);
                    continue block56;
                }
                case 47: {
                    this.setAlpha(a.getFloat(attr2, 1.0f));
                    continue block56;
                }
                case 48: {
                    this.setPivotX(a.getDimensionPixelOffset(attr2, 0));
                    continue block56;
                }
                case 49: {
                    this.setPivotY(a.getDimensionPixelOffset(attr2, 0));
                    continue block56;
                }
                case 50: {
                    tx = a.getDimensionPixelOffset(attr2, 0);
                    transformSet = true;
                    continue block56;
                }
                case 51: {
                    ty = a.getDimensionPixelOffset(attr2, 0);
                    transformSet = true;
                    continue block56;
                }
                case 54: {
                    rotation = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block56;
                }
                case 55: {
                    rotationX = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block56;
                }
                case 56: {
                    rotationY = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block56;
                }
                case 52: {
                    sx = a.getFloat(attr2, 1.0f);
                    transformSet = true;
                    continue block56;
                }
                case 53: {
                    sy = a.getFloat(attr2, 1.0f);
                    transformSet = true;
                    continue block56;
                }
                case 8: {
                    this.mID = a.getResourceId(attr2, -1);
                    continue block56;
                }
                case 9: {
                    this.mTag = a.getText(attr2);
                    continue block56;
                }
                case 21: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 2;
                    viewFlagMasks |= 2;
                    continue block56;
                }
                case 18: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 1;
                    viewFlagMasks |= 1;
                    continue block56;
                }
                case 19: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 0x40001;
                    viewFlagMasks |= 0x40001;
                    continue block56;
                }
                case 29: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 0x4000;
                    viewFlagMasks |= 0x4000;
                    continue block56;
                }
                case 30: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 0x200000;
                    viewFlagMasks |= 0x200000;
                    continue block56;
                }
                case 31: {
                    if (a.getBoolean(attr2, true)) continue block56;
                    viewFlagValues |= 0x10000;
                    viewFlagMasks |= 0x10000;
                    continue block56;
                }
                case 33: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 0x400000;
                    viewFlagMasks |= 0x400000;
                    continue block56;
                }
                case 20: {
                    int visibility = a.getInt(attr2, 0);
                    if (visibility == 0) continue block56;
                    viewFlagValues |= VISIBILITY_FLAGS[visibility];
                    viewFlagMasks |= 0xC;
                    continue block56;
                }
                case 63: {
                    viewFlagValues &= 0x3FFFFFFF;
                    int layoutDirection = a.getInt(attr2, -1);
                    viewFlagValues = layoutDirection != -1 ? (viewFlagValues |= LAYOUT_DIRECTION_FLAGS[layoutDirection]) : (viewFlagValues |= Integer.MIN_VALUE);
                    viewFlagMasks |= 0xC0000000;
                    continue block56;
                }
                case 32: {
                    int cacheQuality = a.getInt(attr2, 0);
                    if (cacheQuality == 0) continue block56;
                    viewFlagValues |= DRAWING_CACHE_QUALITY_FLAGS[cacheQuality];
                    viewFlagMasks |= 0x180000;
                    continue block56;
                }
                case 41: {
                    this.mContentDescription = a.getString(attr2);
                    continue block56;
                }
                case 36: {
                    if (a.getBoolean(attr2, true)) continue block56;
                    viewFlagValues &= 0xF7FFFFFF;
                    viewFlagMasks |= 0x8000000;
                    continue block56;
                }
                case 39: {
                    if (a.getBoolean(attr2, true)) continue block56;
                    viewFlagValues &= 0xEFFFFFFF;
                    viewFlagMasks |= 0x10000000;
                    continue block56;
                }
                case 22: {
                    int scrollbars = a.getInt(attr2, 0);
                    if (scrollbars == 0) continue block56;
                    viewFlagValues |= scrollbars;
                    viewFlagMasks |= 0x300;
                    this.initializeScrollbars(a);
                    continue block56;
                }
                case 23: {
                    if (context.getApplicationInfo().targetSdkVersion >= 14) continue block56;
                }
                case 60: {
                    int fadingEdge = a.getInt(attr2, 0);
                    if (fadingEdge == 0) continue block56;
                    viewFlagValues |= fadingEdge;
                    viewFlagMasks |= 0x3000;
                    this.initializeFadingEdge(a);
                    continue block56;
                }
                case 7: {
                    scrollbarStyle = a.getInt(attr2, 0);
                    if (scrollbarStyle == 0) continue block56;
                    viewFlagValues |= scrollbarStyle & 0x3000000;
                    viewFlagMasks |= 0x3000000;
                    continue block56;
                }
                case 38: {
                    setScrollContainer = true;
                    if (!a.getBoolean(attr2, false)) continue block56;
                    this.setScrollContainer(true);
                    continue block56;
                }
                case 37: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 0x4000000;
                    viewFlagMasks |= 0x4000000;
                    continue block56;
                }
                case 46: {
                    if (!a.getBoolean(attr2, false)) continue block56;
                    viewFlagValues |= 0x400;
                    viewFlagMasks |= 0x400;
                    continue block56;
                }
                case 25: {
                    this.mNextFocusLeftId = a.getResourceId(attr2, -1);
                    continue block56;
                }
                case 26: {
                    this.mNextFocusRightId = a.getResourceId(attr2, -1);
                    continue block56;
                }
                case 27: {
                    this.mNextFocusUpId = a.getResourceId(attr2, -1);
                    continue block56;
                }
                case 28: {
                    this.mNextFocusDownId = a.getResourceId(attr2, -1);
                    continue block56;
                }
                case 58: {
                    this.mNextFocusForwardId = a.getResourceId(attr2, -1);
                    continue block56;
                }
                case 34: {
                    this.mMinWidth = a.getDimensionPixelSize(attr2, 0);
                    continue block56;
                }
                case 35: {
                    this.mMinHeight = a.getDimensionPixelSize(attr2, 0);
                    continue block56;
                }
                case 40: {
                    if (context.isRestricted()) {
                        throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                    }
                    final String handlerName = a.getString(attr2);
                    if (handlerName == null) continue block56;
                    this.setOnClickListener(new OnClickListener(){
                        private Method mHandler;

                        public void onClick(View v) {
                            if (this.mHandler == null) {
                                try {
                                    this.mHandler = View.this.getContext().getClass().getMethod(handlerName, View.class);
                                }
                                catch (NoSuchMethodException e) {
                                    int id2 = View.this.getId();
                                    String idText = id2 == -1 ? "" : " with id '" + View.this.getContext().getResources().getResourceEntryName(id2) + "'";
                                    throw new IllegalStateException("Could not find a method " + handlerName + "(View) in the activity " + View.this.getContext().getClass() + " for onClick handler" + " on view " + View.this.getClass() + idText, e);
                                }
                            }
                            try {
                                this.mHandler.invoke((Object)View.this.getContext(), View.this);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalStateException("Could not execute non public method of the activity", e);
                            }
                            catch (InvocationTargetException e) {
                                throw new IllegalStateException("Could not execute method of the activity", e);
                            }
                        }
                    });
                    continue block56;
                }
                case 45: {
                    overScrollMode = a.getInt(attr2, 1);
                    continue block56;
                }
                case 57: {
                    this.mVerticalScrollbarPosition = a.getInt(attr2, 0);
                    continue block56;
                }
                case 59: {
                    this.setLayerType(a.getInt(attr2, 0), null);
                    continue block56;
                }
                case 64: {
                    this.mTextDirection = a.getInt(attr2, DEFAULT_TEXT_DIRECTION);
                }
            }
        }
        a.recycle();
        this.setOverScrollMode(overScrollMode);
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        this.mUserPaddingRelative = startPadding >= 0 || endPadding >= 0;
        this.mUserPaddingStart = startPadding;
        this.mUserPaddingEnd = endPadding;
        if (padding >= 0) {
            leftPadding = padding;
            topPadding = padding;
            rightPadding = padding;
            bottomPadding = padding;
        }
        this.setPadding(leftPadding >= 0 ? leftPadding : this.mPaddingLeft, topPadding >= 0 ? topPadding : this.mPaddingTop, rightPadding >= 0 ? rightPadding : this.mPaddingRight, bottomPadding >= 0 ? bottomPadding : this.mPaddingBottom);
        if (viewFlagMasks != 0) {
            this.setFlags(viewFlagValues, viewFlagMasks);
        }
        if (scrollbarStyle != 0) {
            this.recomputePadding();
        }
        if (x != 0 || y != 0) {
            this.scrollTo(x, y);
        }
        if (transformSet) {
            this.setTranslationX(tx);
            this.setTranslationY(ty);
            this.setRotation(rotation);
            this.setRotationX(rotationX);
            this.setRotationY(rotationY);
            this.setScaleX(sx);
            this.setScaleY(sy);
        }
        if (!setScrollContainer && (viewFlagValues & 0x200) != 0) {
            this.setScrollContainer(true);
        }
        this.computeOpaqueFlags();
    }

    View() {
        this.mResources = null;
    }

    protected void initializeFadingEdge(TypedArray a) {
        this.initScrollCache();
        this.mScrollCache.fadingEdgeLength = a.getDimensionPixelSize(24, ViewConfiguration.get(this.mContext).getScaledFadingEdgeLength());
    }

    public int getVerticalFadingEdgeLength() {
        ScrollabilityCache cache;
        if (this.isVerticalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public void setFadingEdgeLength(int length) {
        this.initScrollCache();
        this.mScrollCache.fadingEdgeLength = length;
    }

    public int getHorizontalFadingEdgeLength() {
        ScrollabilityCache cache;
        if (this.isHorizontalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public int getVerticalScrollbarWidth() {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBarDrawable scrollBar = cache.scrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(true);
                if (size <= 0) {
                    size = cache.scrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    protected int getHorizontalScrollbarHeight() {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBarDrawable scrollBar = cache.scrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(false);
                if (size <= 0) {
                    size = cache.scrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    protected void initializeScrollbars(TypedArray a) {
        boolean alwaysDraw;
        boolean fadeScrollbars;
        this.initScrollCache();
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        if (scrollabilityCache.scrollBar == null) {
            scrollabilityCache.scrollBar = new ScrollBarDrawable();
        }
        if (!(fadeScrollbars = a.getBoolean(44, true))) {
            scrollabilityCache.state = 1;
        }
        scrollabilityCache.fadeScrollBars = fadeScrollbars;
        scrollabilityCache.scrollBarFadeDuration = a.getInt(42, ViewConfiguration.getScrollBarFadeDuration());
        scrollabilityCache.scrollBarDefaultDelayBeforeFade = a.getInt(43, ViewConfiguration.getScrollDefaultDelay());
        scrollabilityCache.scrollBarSize = a.getDimensionPixelSize(0, ViewConfiguration.get(this.mContext).getScaledScrollBarSize());
        Drawable track = a.getDrawable(3);
        scrollabilityCache.scrollBar.setHorizontalTrackDrawable(track);
        Drawable thumb = a.getDrawable(1);
        if (thumb != null) {
            scrollabilityCache.scrollBar.setHorizontalThumbDrawable(thumb);
        }
        if (alwaysDraw = a.getBoolean(5, false)) {
            scrollabilityCache.scrollBar.setAlwaysDrawHorizontalTrack(true);
        }
        track = a.getDrawable(4);
        scrollabilityCache.scrollBar.setVerticalTrackDrawable(track);
        thumb = a.getDrawable(2);
        if (thumb != null) {
            scrollabilityCache.scrollBar.setVerticalThumbDrawable(thumb);
        }
        if (alwaysDraw = a.getBoolean(6, false)) {
            scrollabilityCache.scrollBar.setAlwaysDrawVerticalTrack(true);
        }
        this.resolvePadding();
    }

    private void initScrollCache() {
        if (this.mScrollCache == null) {
            this.mScrollCache = new ScrollabilityCache(ViewConfiguration.get(this.mContext), this);
        }
    }

    public void setVerticalScrollbarPosition(int position) {
        if (this.mVerticalScrollbarPosition != position) {
            this.mVerticalScrollbarPosition = position;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    public int getVerticalScrollbarPosition() {
        return this.mVerticalScrollbarPosition;
    }

    ListenerInfo getListenerInfo() {
        if (this.mListenerInfo != null) {
            return this.mListenerInfo;
        }
        this.mListenerInfo = new ListenerInfo();
        return this.mListenerInfo;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.getListenerInfo().mOnFocusChangeListener = l;
    }

    public void addOnLayoutChangeListener(OnLayoutChangeListener listener) {
        ListenerInfo li = this.getListenerInfo();
        if (li.mOnLayoutChangeListeners == null) {
            li.mOnLayoutChangeListeners = new ArrayList();
        }
        if (!li.mOnLayoutChangeListeners.contains(listener)) {
            li.mOnLayoutChangeListeners.add(listener);
        }
    }

    public void removeOnLayoutChangeListener(OnLayoutChangeListener listener) {
        ListenerInfo li = this.mListenerInfo;
        if (li == null || li.mOnLayoutChangeListeners == null) {
            return;
        }
        li.mOnLayoutChangeListeners.remove(listener);
    }

    public void addOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
        ListenerInfo li = this.getListenerInfo();
        if (li.mOnAttachStateChangeListeners == null) {
            li.mOnAttachStateChangeListeners = new CopyOnWriteArrayList();
        }
        li.mOnAttachStateChangeListeners.add(listener);
    }

    public void removeOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
        ListenerInfo li = this.mListenerInfo;
        if (li == null || li.mOnAttachStateChangeListeners == null) {
            return;
        }
        li.mOnAttachStateChangeListeners.remove(listener);
    }

    public OnFocusChangeListener getOnFocusChangeListener() {
        ListenerInfo li = this.mListenerInfo;
        return li != null ? li.mOnFocusChangeListener : null;
    }

    public void setOnClickListener(OnClickListener l) {
        if (!this.isClickable()) {
            this.setClickable(true);
        }
        this.getListenerInfo().mOnClickListener = l;
    }

    public boolean hasOnClickListeners() {
        ListenerInfo li = this.mListenerInfo;
        return li != null && li.mOnClickListener != null;
    }

    public void setOnLongClickListener(OnLongClickListener l) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.getListenerInfo().mOnLongClickListener = l;
    }

    public void setOnCreateContextMenuListener(OnCreateContextMenuListener l) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.getListenerInfo().mOnCreateContextMenuListener = l;
    }

    public boolean performClick() {
        this.sendAccessibilityEvent(1);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnClickListener != null) {
            this.playSoundEffect(0);
            li.mOnClickListener.onClick(this);
            return true;
        }
        return false;
    }

    public boolean callOnClick() {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnClickListener != null) {
            li.mOnClickListener.onClick(this);
            return true;
        }
        return false;
    }

    public boolean performLongClick() {
        this.sendAccessibilityEvent(2);
        boolean handled = false;
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnLongClickListener != null) {
            handled = li.mOnLongClickListener.onLongClick(this);
        }
        if (!handled) {
            handled = this.showContextMenu();
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    protected boolean performButtonActionOnTouchDown(MotionEvent event) {
        return (event.getButtonState() & 2) != 0 && this.showContextMenu(event.getX(), event.getY(), event.getMetaState());
    }

    public boolean showContextMenu() {
        return this.getParent().showContextMenuForChild(this);
    }

    public boolean showContextMenu(float x, float y, int metaState) {
        return this.showContextMenu();
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.getParent().startActionModeForChild(this, callback);
    }

    public void setOnKeyListener(OnKeyListener l) {
        this.getListenerInfo().mOnKeyListener = l;
    }

    public void setOnTouchListener(OnTouchListener l) {
        this.getListenerInfo().mOnTouchListener = l;
    }

    public void setOnGenericMotionListener(OnGenericMotionListener l) {
        this.getListenerInfo().mOnGenericMotionListener = l;
    }

    public void setOnHoverListener(OnHoverListener l) {
        this.getListenerInfo().mOnHoverListener = l;
    }

    public void setOnDragListener(OnDragListener l) {
        this.getListenerInfo().mOnDragListener = l;
    }

    void handleFocusGainInternal(int direction, Rect previouslyFocusedRect) {
        if ((this.mPrivateFlags & 2) == 0) {
            this.mPrivateFlags |= 2;
            if (this.mParent != null) {
                this.mParent.requestChildFocus(this, this);
            }
            this.onFocusChanged(true, direction, previouslyFocusedRect);
            this.refreshDrawableState();
        }
    }

    public boolean requestRectangleOnScreen(Rect rectangle) {
        return this.requestRectangleOnScreen(rectangle, false);
    }

    public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
        View child = this;
        ViewParent parent = this.mParent;
        boolean scrolled = false;
        while (parent != null) {
            scrolled |= parent.requestChildRectangleOnScreen(child, rectangle, immediate);
            rectangle.offset(child.getLeft(), child.getTop());
            rectangle.offset(-child.getScrollX(), -child.getScrollY());
            if (!(parent instanceof View)) break;
            child = (View)((Object)parent);
            parent = child.getParent();
        }
        return scrolled;
    }

    public void clearFocus() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            if (this.mParent != null) {
                this.mParent.clearChildFocus(this);
            }
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
        }
    }

    void clearFocusForRemoval() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
        }
    }

    void unFocus() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
        }
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public boolean hasFocusable() {
        return (this.mViewFlags & 0xC) == 0 && this.isFocusable();
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus) {
            this.sendAccessibilityEvent(8);
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (!gainFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            if (imm != null && this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus) {
                imm.focusOut(this);
            }
            this.onFocusLost();
        } else if (imm != null && this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus) {
            imm.focusIn(this);
        }
        this.invalidate(true);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnFocusChangeListener != null) {
            li.mOnFocusChangeListener.onFocusChange(this, gainFocus);
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mKeyDispatchState.reset(this);
        }
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.sendAccessibilityEvent(this, eventType);
        } else {
            this.sendAccessibilityEventInternal(eventType);
        }
    }

    void sendAccessibilityEventInternal(int eventType) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.sendAccessibilityEventUnchecked(AccessibilityEvent.obtain(eventType));
        }
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.sendAccessibilityEventUnchecked(this, event);
        } else {
            this.sendAccessibilityEventUncheckedInternal(event);
        }
    }

    void sendAccessibilityEventUncheckedInternal(AccessibilityEvent event) {
        if (!this.isShown()) {
            return;
        }
        this.onInitializeAccessibilityEvent(event);
        if ((event.getEventType() & 0x21BF) != 0) {
            this.dispatchPopulateAccessibilityEvent(event);
        }
        this.getParent().requestSendAccessibilityEvent(this, event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.dispatchPopulateAccessibilityEvent(this, event);
        }
        return this.dispatchPopulateAccessibilityEventInternal(event);
    }

    boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return false;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.onPopulateAccessibilityEvent(this, event);
        } else {
            this.onPopulateAccessibilityEventInternal(event);
        }
    }

    void onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.onInitializeAccessibilityEvent(this, event);
        } else {
            this.onInitializeAccessibilityEventInternal(event);
        }
    }

    void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        event.setSource(this);
        event.setClassName(this.getClass().getName());
        event.setPackageName(this.getContext().getPackageName());
        event.setEnabled(this.isEnabled());
        event.setContentDescription(this.mContentDescription);
        if (event.getEventType() == 8 && this.mAttachInfo != null) {
            ArrayList<View> focusablesTempList = this.mAttachInfo.mFocusablesTempList;
            this.getRootView().addFocusables(focusablesTempList, 2, 0);
            event.setItemCount(focusablesTempList.size());
            event.setCurrentItemIndex(focusablesTempList.indexOf(this));
            focusablesTempList.clear();
        }
    }

    public AccessibilityNodeInfo createAccessibilityNodeInfo() {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain(this);
        this.onInitializeAccessibilityNodeInfo(info);
        return info;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        if (this.mAccessibilityDelegate != null) {
            this.mAccessibilityDelegate.onInitializeAccessibilityNodeInfo(this, info);
        } else {
            this.onInitializeAccessibilityNodeInfoInternal(info);
        }
    }

    void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        ViewParent parent;
        Rect bounds = this.mAttachInfo.mTmpInvalRect;
        this.getDrawingRect(bounds);
        info.setBoundsInParent(bounds);
        int[] locationOnScreen = this.mAttachInfo.mInvalidateChildLocation;
        this.getLocationOnScreen(locationOnScreen);
        bounds.offsetTo(0, 0);
        bounds.offset(locationOnScreen[0], locationOnScreen[1]);
        info.setBoundsInScreen(bounds);
        if ((this.mPrivateFlags & 8) == 0 && (parent = this.getParent()) instanceof View) {
            View parentView = (View)((Object)parent);
            info.setParent(parentView);
        }
        info.setPackageName(this.mContext.getPackageName());
        info.setClassName(this.getClass().getName());
        info.setContentDescription(this.getContentDescription());
        info.setEnabled(this.isEnabled());
        info.setClickable(this.isClickable());
        info.setFocusable(this.isFocusable());
        info.setFocused(this.isFocused());
        info.setSelected(this.isSelected());
        info.setLongClickable(this.isLongClickable());
        info.addAction(4);
        info.addAction(8);
        if (this.isFocusable()) {
            if (this.isFocused()) {
                info.addAction(2);
            } else {
                info.addAction(1);
            }
        }
    }

    public void setAccessibilityDelegate(AccessibilityDelegate delegate) {
        this.mAccessibilityDelegate = delegate;
    }

    public int getAccessibilityViewId() {
        if (this.mAccessibilityViewId == -1) {
            this.mAccessibilityViewId = sNextAccessibilityViewId++;
        }
        return this.mAccessibilityViewId;
    }

    public int getAccessibilityWindowId() {
        return this.mAttachInfo != null ? this.mAttachInfo.mAccessibilityWindowId : -1;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @RemotableViewMethod
    public void setContentDescription(CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
    }

    protected void onFocusLost() {
        this.resetPressedState();
    }

    private void resetPressedState() {
        if ((this.mViewFlags & 0x20) == 32) {
            return;
        }
        if (this.isPressed()) {
            this.setPressed(false);
            if (!this.mHasPerformedLongPress) {
                this.removeLongPressCallback();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean isFocused() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public View findFocus() {
        return (this.mPrivateFlags & 2) != 0 ? this : null;
    }

    public void setScrollContainer(boolean isScrollContainer) {
        if (isScrollContainer) {
            if (this.mAttachInfo != null && (this.mPrivateFlags & 0x100000) == 0) {
                this.mAttachInfo.mScrollContainers.add(this);
                this.mPrivateFlags |= 0x100000;
            }
            this.mPrivateFlags |= 0x80000;
        } else {
            if ((this.mPrivateFlags & 0x100000) != 0) {
                this.mAttachInfo.mScrollContainers.remove(this);
            }
            this.mPrivateFlags &= 0xFFE7FFFF;
        }
    }

    public int getDrawingCacheQuality() {
        return this.mViewFlags & 0x180000;
    }

    public void setDrawingCacheQuality(int quality) {
        this.setFlags(quality, 0x180000);
    }

    public boolean getKeepScreenOn() {
        return (this.mViewFlags & 0x4000000) != 0;
    }

    public void setKeepScreenOn(boolean keepScreenOn) {
        this.setFlags(keepScreenOn ? 0x4000000 : 0, 0x4000000);
    }

    public int getNextFocusLeftId() {
        return this.mNextFocusLeftId;
    }

    public void setNextFocusLeftId(int nextFocusLeftId) {
        this.mNextFocusLeftId = nextFocusLeftId;
    }

    public int getNextFocusRightId() {
        return this.mNextFocusRightId;
    }

    public void setNextFocusRightId(int nextFocusRightId) {
        this.mNextFocusRightId = nextFocusRightId;
    }

    public int getNextFocusUpId() {
        return this.mNextFocusUpId;
    }

    public void setNextFocusUpId(int nextFocusUpId) {
        this.mNextFocusUpId = nextFocusUpId;
    }

    public int getNextFocusDownId() {
        return this.mNextFocusDownId;
    }

    public void setNextFocusDownId(int nextFocusDownId) {
        this.mNextFocusDownId = nextFocusDownId;
    }

    public int getNextFocusForwardId() {
        return this.mNextFocusForwardId;
    }

    public void setNextFocusForwardId(int nextFocusForwardId) {
        this.mNextFocusForwardId = nextFocusForwardId;
    }

    public boolean isShown() {
        ViewParent parent;
        View current = this;
        do {
            if ((current.mViewFlags & 0xC) != 0) {
                return false;
            }
            parent = current.mParent;
            if (parent == null) {
                return false;
            }
            if (parent instanceof View) continue;
            return true;
        } while ((current = (View)((Object)parent)) != null);
        return false;
    }

    protected boolean fitSystemWindows(Rect insets) {
        if ((this.mViewFlags & 2) == 2) {
            this.mPaddingLeft = insets.left;
            this.mPaddingTop = insets.top;
            this.mPaddingRight = insets.right;
            this.mPaddingBottom = insets.bottom;
            this.requestLayout();
            return true;
        }
        return false;
    }

    public void setFitsSystemWindows(boolean fitSystemWindows) {
        this.setFlags(fitSystemWindows ? 2 : 0, 2);
    }

    public boolean fitsSystemWindows() {
        return (this.mViewFlags & 2) == 2;
    }

    @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=0, to="VISIBLE"), @ViewDebug.IntToString(from=4, to="INVISIBLE"), @ViewDebug.IntToString(from=8, to="GONE")})
    public int getVisibility() {
        return this.mViewFlags & 0xC;
    }

    @RemotableViewMethod
    public void setVisibility(int visibility) {
        this.setFlags(visibility, 12);
        if (this.mBGDrawable != null) {
            this.mBGDrawable.setVisible(visibility == 0, false);
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isEnabled() {
        return (this.mViewFlags & 0x20) == 0;
    }

    @RemotableViewMethod
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.setFlags(enabled ? 0 : 32, 32);
        this.refreshDrawableState();
        this.invalidate(true);
    }

    public void setFocusable(boolean focusable) {
        if (!focusable) {
            this.setFlags(0, 262144);
        }
        this.setFlags(focusable ? 1 : 0, 1);
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        this.setFlags(focusableInTouchMode ? 262144 : 0, 262144);
        if (focusableInTouchMode) {
            this.setFlags(1, 1);
        }
    }

    public void setSoundEffectsEnabled(boolean soundEffectsEnabled) {
        this.setFlags(soundEffectsEnabled ? 0x8000000 : 0, 0x8000000);
    }

    @ViewDebug.ExportedProperty
    public boolean isSoundEffectsEnabled() {
        return 0x8000000 == (this.mViewFlags & 0x8000000);
    }

    public void setHapticFeedbackEnabled(boolean hapticFeedbackEnabled) {
        this.setFlags(hapticFeedbackEnabled ? 0x10000000 : 0, 0x10000000);
    }

    @ViewDebug.ExportedProperty
    public boolean isHapticFeedbackEnabled() {
        return 0x10000000 == (this.mViewFlags & 0x10000000);
    }

    @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=0, to="LTR"), @ViewDebug.IntToString(from=0x40000000, to="RTL"), @ViewDebug.IntToString(from=-2147483648, to="INHERIT"), @ViewDebug.IntToString(from=-1073741824, to="LOCALE")})
    public int getLayoutDirection() {
        return this.mViewFlags & 0xC0000000;
    }

    @RemotableViewMethod
    public void setLayoutDirection(int layoutDirection) {
        if (this.getLayoutDirection() != layoutDirection) {
            this.resetResolvedLayoutDirection();
            this.setFlags(layoutDirection, -1073741824);
        }
    }

    @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=0, to="RESOLVED_DIRECTION_LTR"), @ViewDebug.IntToString(from=0x40000000, to="RESOLVED_DIRECTION_RTL")})
    public int getResolvedLayoutDirection() {
        this.resolveLayoutDirectionIfNeeded();
        return (this.mPrivateFlags2 & 4) == 4 ? 0x40000000 : 0;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public boolean isLayoutRtl() {
        return this.getResolvedLayoutDirection() == 0x40000000;
    }

    public void setWillNotDraw(boolean willNotDraw) {
        this.setFlags(willNotDraw ? 128 : 0, 128);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean willNotDraw() {
        return (this.mViewFlags & 0x80) == 128;
    }

    public void setWillNotCacheDrawing(boolean willNotCacheDrawing) {
        this.setFlags(willNotCacheDrawing ? 131072 : 0, 131072);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean willNotCacheDrawing() {
        return (this.mViewFlags & 0x20000) == 131072;
    }

    @ViewDebug.ExportedProperty
    public boolean isClickable() {
        return (this.mViewFlags & 0x4000) == 16384;
    }

    public void setClickable(boolean clickable) {
        this.setFlags(clickable ? 16384 : 0, 16384);
    }

    public boolean isLongClickable() {
        return (this.mViewFlags & 0x200000) == 0x200000;
    }

    public void setLongClickable(boolean longClickable) {
        this.setFlags(longClickable ? 0x200000 : 0, 0x200000);
    }

    public void setPressed(boolean pressed) {
        this.mPrivateFlags = pressed ? (this.mPrivateFlags |= 0x4000) : (this.mPrivateFlags &= 0xFFFFBFFF);
        this.refreshDrawableState();
        this.dispatchSetPressed(pressed);
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    public boolean isPressed() {
        return (this.mPrivateFlags & 0x4000) == 16384;
    }

    public boolean isSaveEnabled() {
        return (this.mViewFlags & 0x10000) != 65536;
    }

    public void setSaveEnabled(boolean enabled) {
        this.setFlags(enabled ? 0 : 65536, 65536);
    }

    @ViewDebug.ExportedProperty
    public boolean getFilterTouchesWhenObscured() {
        return (this.mViewFlags & 0x400) != 0;
    }

    public void setFilterTouchesWhenObscured(boolean enabled) {
        this.setFlags(enabled ? 0 : 1024, 1024);
    }

    public boolean isSaveFromParentEnabled() {
        return (this.mViewFlags & 0x20000000) != 0x20000000;
    }

    public void setSaveFromParentEnabled(boolean enabled) {
        this.setFlags(enabled ? 0 : 0x20000000, 0x20000000);
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean isFocusable() {
        return 1 == (this.mViewFlags & 1);
    }

    @ViewDebug.ExportedProperty
    public boolean isFocusableInTouchMode() {
        return 262144 == (this.mViewFlags & 0x40000);
    }

    public View focusSearch(int direction) {
        if (this.mParent != null) {
            return this.mParent.focusSearch(this, direction);
        }
        return null;
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        return false;
    }

    View findUserSetNextFocus(View root, int direction) {
        switch (direction) {
            case 17: {
                if (this.mNextFocusLeftId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusLeftId);
            }
            case 66: {
                if (this.mNextFocusRightId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusRightId);
            }
            case 33: {
                if (this.mNextFocusUpId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusUpId);
            }
            case 130: {
                if (this.mNextFocusDownId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusDownId);
            }
            case 2: {
                if (this.mNextFocusForwardId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusForwardId);
            }
            case 1: {
                final int id2 = this.mID;
                return root.findViewByPredicateInsideOut(this, new Predicate<View>(){

                    @Override
                    public boolean apply(View t) {
                        return t.mNextFocusForwardId == id2;
                    }
                });
            }
        }
        return null;
    }

    private View findViewInsideOutShouldExist(View root, final int childViewId) {
        View result = root.findViewByPredicateInsideOut(this, new Predicate<View>(){

            @Override
            public boolean apply(View t) {
                return t.mID == childViewId;
            }
        });
        if (result == null) {
            Log.w(VIEW_LOG_TAG, "couldn't find next focus view specified by user for id " + childViewId);
        }
        return result;
    }

    public ArrayList<View> getFocusables(int direction) {
        ArrayList<View> result = new ArrayList<View>(24);
        this.addFocusables(result, direction);
        return result;
    }

    public void addFocusables(ArrayList<View> views, int direction) {
        this.addFocusables(views, direction, 1);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (!this.isFocusable()) {
            return;
        }
        if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
            return;
        }
        if (views != null) {
            views.add(this);
        }
    }

    public void findViewsWithText(ArrayList<View> outViews, CharSequence searched, int flags) {
        if ((flags & 2) != 0 && !TextUtils.isEmpty(searched) && !TextUtils.isEmpty(this.mContentDescription)) {
            String searchedLowerCase = ((Object)searched).toString().toLowerCase();
            String contentDescriptionLowerCase = ((Object)this.mContentDescription).toString().toLowerCase();
            if (contentDescriptionLowerCase.contains(searchedLowerCase)) {
                outViews.add(this);
            }
        }
    }

    public ArrayList<View> getTouchables() {
        ArrayList<View> result = new ArrayList<View>();
        this.addTouchables(result);
        return result;
    }

    public void addTouchables(ArrayList<View> views) {
        int viewFlags = this.mViewFlags;
        if (((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000) && (viewFlags & 0x20) == 0) {
            views.add(this);
        }
    }

    public boolean requestFocus() {
        return this.requestFocus(130);
    }

    public boolean requestFocus(int direction) {
        return this.requestFocus(direction, null);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if ((this.mViewFlags & 1) != 1 || (this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if (this.isInTouchMode() && 262144 != (this.mViewFlags & 0x40000)) {
            return false;
        }
        if (this.hasAncestorThatBlocksDescendantFocus()) {
            return false;
        }
        this.handleFocusGainInternal(direction, previouslyFocusedRect);
        return true;
    }

    ViewRootImpl getViewRootImpl() {
        View root = this.getRootView();
        return root != null ? (ViewRootImpl)root.getParent() : null;
    }

    public boolean requestFocusFromTouch() {
        ViewRootImpl viewRoot;
        if (this.isInTouchMode() && (viewRoot = this.getViewRootImpl()) != null) {
            viewRoot.ensureTouchMode(false);
        }
        return this.requestFocus(130);
    }

    private boolean hasAncestorThatBlocksDescendantFocus() {
        ViewParent ancestor = this.mParent;
        while (ancestor instanceof ViewGroup) {
            ViewGroup vgAncestor = (ViewGroup)ancestor;
            if (vgAncestor.getDescendantFocusability() == 393216) {
                return true;
            }
            ancestor = vgAncestor.getParent();
        }
        return false;
    }

    public void dispatchStartTemporaryDetach() {
        this.onStartTemporaryDetach();
    }

    public void onStartTemporaryDetach() {
        this.removeUnsetPressCallback();
        this.mPrivateFlags |= 0x4000000;
    }

    public void dispatchFinishTemporaryDetach() {
        this.onFinishTemporaryDetach();
    }

    public void onFinishTemporaryDetach() {
    }

    public KeyEvent.DispatcherState getKeyDispatcherState() {
        return this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null;
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        return this.onKeyPreIme(event.getKeyCode(), event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        ListenerInfo li;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(event, 0);
        }
        if ((li = this.mListenerInfo) != null && li.mOnKeyListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnKeyListener.onKey(this, event.getKeyCode(), event)) {
            return true;
        }
        if (event.dispatch(this, this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null, this)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(event, 0);
        }
        if (this.onFilterTouchEventForSecurity(event)) {
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnTouchListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnTouchListener.onTouch(this, event)) {
                return true;
            }
            if (this.onTouchEvent(event)) {
                return true;
            }
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    public boolean onFilterTouchEventForSecurity(MotionEvent event) {
        return (this.mViewFlags & 0x400) == 0 || (event.getFlags() & 1) == 0;
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(event, 0);
        }
        return this.onTrackballEvent(event);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        int action;
        int source;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onGenericMotionEvent(event, 0);
        }
        if (((source = event.getSource()) & 2) != 0 ? ((action = event.getAction()) == 9 || action == 7 || action == 10 ? this.dispatchHoverEvent(event) : this.dispatchGenericPointerEvent(event)) : this.dispatchGenericFocusedEvent(event)) {
            return true;
        }
        if (this.dispatchGenericMotionEventInternal(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    private boolean dispatchGenericMotionEventInternal(MotionEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnGenericMotionListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnGenericMotionListener.onGenericMotion(this, event)) {
            return true;
        }
        if (this.onGenericMotionEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 0);
        }
        return false;
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnHoverListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnHoverListener.onHover(this, event)) {
            return true;
        }
        return this.onHoverEvent(event);
    }

    protected boolean hasHoveredChild() {
        return false;
    }

    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        return false;
    }

    protected boolean dispatchGenericFocusedEvent(MotionEvent event) {
        return false;
    }

    public boolean dispatchPointerEvent(MotionEvent event) {
        if (event.isTouchEvent()) {
            return this.dispatchTouchEvent(event);
        }
        return this.dispatchGenericMotionEvent(event);
    }

    public void dispatchWindowFocusChanged(boolean hasFocus) {
        this.onWindowFocusChanged(hasFocus);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (!hasWindowFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            if (imm != null && (this.mPrivateFlags & 2) != 0) {
                imm.focusOut(this);
            }
            this.removeLongPressCallback();
            this.removeTapCallback();
            this.onFocusLost();
        } else if (imm != null && (this.mPrivateFlags & 2) != 0) {
            imm.focusIn(this);
        }
        this.refreshDrawableState();
    }

    public boolean hasWindowFocus() {
        return this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus;
    }

    protected void dispatchVisibilityChanged(View changedView, int visibility) {
        this.onVisibilityChanged(changedView, visibility);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (visibility == 0) {
            if (this.mAttachInfo != null) {
                this.initialAwakenScrollBars();
            } else {
                this.mPrivateFlags |= 0x8000000;
            }
        }
    }

    public void dispatchDisplayHint(int hint) {
        this.onDisplayHint(hint);
    }

    protected void onDisplayHint(int hint) {
    }

    public void dispatchWindowVisibilityChanged(int visibility) {
        this.onWindowVisibilityChanged(visibility);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (visibility == 0) {
            this.initialAwakenScrollBars();
        }
    }

    public int getWindowVisibility() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowVisibility : 8;
    }

    public void getWindowVisibleDisplayFrame(Rect outRect) {
        if (this.mAttachInfo != null) {
            try {
                this.mAttachInfo.mSession.getDisplayFrame(this.mAttachInfo.mWindow, outRect);
            }
            catch (RemoteException e) {
                return;
            }
            Rect insets = this.mAttachInfo.mVisibleInsets;
            outRect.left += insets.left;
            outRect.top += insets.top;
            outRect.right -= insets.right;
            outRect.bottom -= insets.bottom;
            return;
        }
        Display d = WindowManagerImpl.getDefault().getDefaultDisplay();
        d.getRectSize(outRect);
    }

    public void dispatchConfigurationChanged(Configuration newConfig) {
        this.onConfigurationChanged(newConfig);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
    }

    void dispatchCollectViewAttributes(int visibility) {
        this.performCollectViewAttributes(visibility);
    }

    void performCollectViewAttributes(int visibility) {
        if ((visibility & 0xC) == 0 && this.mAttachInfo != null) {
            if ((this.mViewFlags & 0x4000000) == 0x4000000) {
                this.mAttachInfo.mKeepScreenOn = true;
            }
            this.mAttachInfo.mSystemUiVisibility |= this.mSystemUiVisibility;
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnSystemUiVisibilityChangeListener != null) {
                this.mAttachInfo.mHasSystemUiListeners = true;
            }
        }
    }

    void needGlobalAttributesUpdate(boolean force) {
        AttachInfo ai = this.mAttachInfo;
        if (ai != null && (force || ai.mKeepScreenOn || ai.mSystemUiVisibility != 0 || ai.mHasSystemUiListeners)) {
            ai.mRecomputeGlobalAttributes = true;
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isInTouchMode() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mInTouchMode;
        }
        return ViewRootImpl.isInTouchMode();
    }

    @ViewDebug.CapturedViewProperty
    public Context getContext() {
        return this.mContext;
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 23: 
            case 66: {
                if ((this.mViewFlags & 0x20) == 32) {
                    return true;
                }
                if ((this.mViewFlags & 0x4000) != 16384 && (this.mViewFlags & 0x200000) != 0x200000 || event.getRepeatCount() != 0) break;
                this.setPressed(true);
                this.checkForLongClick(0);
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 23: 
            case 66: {
                if ((this.mViewFlags & 0x20) == 32) {
                    return true;
                }
                if ((this.mViewFlags & 0x4000) != 16384 || !this.isPressed()) break;
                this.setPressed(false);
                if (this.mHasPerformedLongPress) break;
                this.removeLongPressCallback();
                result = this.performClick();
            }
        }
        return result;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onCheckIsTextEditor() {
        return false;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return null;
    }

    public boolean checkInputConnectionProxy(View view) {
        return false;
    }

    public void createContextMenu(ContextMenu menu2) {
        ContextMenu.ContextMenuInfo menuInfo = this.getContextMenuInfo();
        ((MenuBuilder)((Object)menu2)).setCurrentMenuInfo(menuInfo);
        this.onCreateContextMenu(menu2);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnCreateContextMenuListener != null) {
            li.mOnCreateContextMenuListener.onCreateContextMenu(menu2, this, menuInfo);
        }
        ((MenuBuilder)((Object)menu2)).setCurrentMenuInfo(null);
        if (this.mParent != null) {
            this.mParent.createContextMenu(menu2);
        }
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return null;
    }

    protected void onCreateContextMenu(ContextMenu menu2) {
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public boolean onHoverEvent(MotionEvent event) {
        int action = event.getAction();
        if (!this.mSendingHoverAccessibilityEvents) {
            if ((action == 9 || action == 7) && !this.hasHoveredChild() && this.pointInView(event.getX(), event.getY())) {
                this.mSendingHoverAccessibilityEvents = true;
                this.sendAccessibilityEvent(128);
            }
        } else if (action == 10 || action == 7 && !this.pointInView(event.getX(), event.getY())) {
            this.mSendingHoverAccessibilityEvents = false;
            this.sendAccessibilityEvent(256);
        }
        if (this.isHoverable()) {
            switch (action) {
                case 9: {
                    this.setHovered(true);
                    break;
                }
                case 10: {
                    this.setHovered(false);
                }
            }
            this.dispatchGenericMotionEventInternal(event);
            return true;
        }
        return false;
    }

    private boolean isHoverable() {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x20) == 32) {
            return false;
        }
        return (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000;
    }

    @ViewDebug.ExportedProperty
    public boolean isHovered() {
        return (this.mPrivateFlags & 0x10000000) != 0;
    }

    public void setHovered(boolean hovered) {
        if (hovered) {
            if ((this.mPrivateFlags & 0x10000000) == 0) {
                this.mPrivateFlags |= 0x10000000;
                this.refreshDrawableState();
                this.onHoverChanged(true);
            }
        } else if ((this.mPrivateFlags & 0x10000000) != 0) {
            this.mPrivateFlags &= 0xEFFFFFFF;
            this.refreshDrawableState();
            this.onHoverChanged(false);
        }
    }

    public void onHoverChanged(boolean hovered) {
    }

    public boolean onTouchEvent(MotionEvent event) {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x20) == 32) {
            if (event.getAction() == 1 && (this.mPrivateFlags & 0x4000) != 0) {
                this.mPrivateFlags &= 0xFFFFBFFF;
                this.refreshDrawableState();
            }
            return (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000;
        }
        if (this.mTouchDelegate != null && this.mTouchDelegate.onTouchEvent(event)) {
            return true;
        }
        if ((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000) {
            switch (event.getAction()) {
                case 1: {
                    boolean prepressed;
                    boolean bl = prepressed = (this.mPrivateFlags & 0x2000000) != 0;
                    if ((this.mPrivateFlags & 0x4000) == 0 && !prepressed) break;
                    boolean focusTaken = false;
                    if (this.isFocusable() && this.isFocusableInTouchMode() && !this.isFocused()) {
                        focusTaken = this.requestFocus();
                    }
                    if (prepressed) {
                        this.mPrivateFlags |= 0x4000;
                        this.refreshDrawableState();
                    }
                    if (!this.mHasPerformedLongPress) {
                        this.removeLongPressCallback();
                        if (!focusTaken) {
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            if (!this.post(this.mPerformClick)) {
                                this.performClick();
                            }
                        }
                    }
                    if (this.mUnsetPressedState == null) {
                        this.mUnsetPressedState = new UnsetPressedState();
                    }
                    if (prepressed) {
                        this.postDelayed(this.mUnsetPressedState, ViewConfiguration.getPressedStateDuration());
                    } else if (!this.post(this.mUnsetPressedState)) {
                        this.mUnsetPressedState.run();
                    }
                    this.removeTapCallback();
                    break;
                }
                case 0: {
                    this.mHasPerformedLongPress = false;
                    if (this.performButtonActionOnTouchDown(event)) break;
                    boolean isInScrollingContainer = this.isInScrollingContainer();
                    if (isInScrollingContainer) {
                        this.mPrivateFlags |= 0x2000000;
                        if (this.mPendingCheckForTap == null) {
                            this.mPendingCheckForTap = new CheckForTap();
                        }
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                        break;
                    }
                    this.mPrivateFlags |= 0x4000;
                    this.refreshDrawableState();
                    this.checkForLongClick(0);
                    break;
                }
                case 3: {
                    this.mPrivateFlags &= 0xFFFFBFFF;
                    this.refreshDrawableState();
                    this.removeTapCallback();
                    break;
                }
                case 2: {
                    int x = (int)event.getX();
                    int y = (int)event.getY();
                    if (this.pointInView(x, y, this.mTouchSlop)) break;
                    this.removeTapCallback();
                    if ((this.mPrivateFlags & 0x4000) == 0) break;
                    this.removeLongPressCallback();
                    this.mPrivateFlags &= 0xFFFFBFFF;
                    this.refreshDrawableState();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (!((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    private void removeLongPressCallback() {
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
    }

    private void removePerformClickCallback() {
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
    }

    private void removeUnsetPressCallback() {
        if ((this.mPrivateFlags & 0x4000) != 0 && this.mUnsetPressedState != null) {
            this.setPressed(false);
            this.removeCallbacks(this.mUnsetPressedState);
        }
    }

    private void removeTapCallback() {
        if (this.mPendingCheckForTap != null) {
            this.mPrivateFlags &= 0xFDFFFFFF;
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    public void cancelLongPress() {
        this.removeLongPressCallback();
        this.removeTapCallback();
    }

    private void removeSendViewScrolledAccessibilityEventCallback() {
        if (this.mSendViewScrolledAccessibilityEvent != null) {
            this.removeCallbacks(this.mSendViewScrolledAccessibilityEvent);
        }
    }

    public void setTouchDelegate(TouchDelegate delegate) {
        this.mTouchDelegate = delegate;
    }

    public TouchDelegate getTouchDelegate() {
        return this.mTouchDelegate;
    }

    void setFlags(int flags, int mask) {
        int old = this.mViewFlags;
        this.mViewFlags = this.mViewFlags & ~mask | flags & mask;
        int changed = this.mViewFlags ^ old;
        if (changed == 0) {
            return;
        }
        int privateFlags = this.mPrivateFlags;
        if ((changed & 1) != 0 && (privateFlags & 0x10) != 0) {
            if ((old & 1) == 1 && (privateFlags & 2) != 0) {
                this.clearFocus();
            } else if ((old & 1) == 0 && (privateFlags & 2) == 0 && this.mParent != null) {
                this.mParent.focusableViewAvailable(this);
            }
        }
        if ((flags & 0xC) == 0 && (changed & 0xC) != 0) {
            this.mPrivateFlags |= 0x20;
            this.invalidate(true);
            this.needGlobalAttributesUpdate(true);
            if (this.mParent != null && this.mBottom > this.mTop && this.mRight > this.mLeft) {
                this.mParent.focusableViewAvailable(this);
            }
        }
        if ((changed & 8) != 0) {
            this.needGlobalAttributesUpdate(false);
            this.requestLayout();
            if ((this.mViewFlags & 0xC) == 8) {
                if (this.hasFocus()) {
                    this.clearFocus();
                }
                this.destroyDrawingCache();
                if (this.mParent instanceof View) {
                    ((View)((Object)this.mParent)).invalidate(true);
                }
                this.mPrivateFlags |= 0x20;
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 4) != 0) {
            this.needGlobalAttributesUpdate(false);
            this.mPrivateFlags |= 0x20;
            if ((this.mViewFlags & 0xC) == 4 && this.hasFocus() && this.getRootView() != this) {
                this.clearFocus();
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 0xC) != 0) {
            if (this.mParent instanceof ViewGroup) {
                ((ViewGroup)this.mParent).onChildVisibilityChanged(this, flags & 0xC);
                ((View)((Object)this.mParent)).invalidate(true);
            } else if (this.mParent != null) {
                this.mParent.invalidateChild(this, null);
            }
            this.dispatchVisibilityChanged(this, flags & 0xC);
        }
        if ((changed & 0x20000) != 0) {
            this.destroyDrawingCache();
        }
        if ((changed & 0x8000) != 0) {
            this.destroyDrawingCache();
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.invalidateParentCaches();
        }
        if ((changed & 0x180000) != 0) {
            this.destroyDrawingCache();
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
        if ((changed & 0x80) != 0) {
            if ((this.mViewFlags & 0x80) != 0) {
                if (this.mBGDrawable != null) {
                    this.mPrivateFlags &= 0xFFFFFF7F;
                    this.mPrivateFlags |= 0x100;
                } else {
                    this.mPrivateFlags |= 0x80;
                }
            } else {
                this.mPrivateFlags &= 0xFFFFFF7F;
            }
            this.requestLayout();
            this.invalidate(true);
        }
        if ((changed & 0x4000000) != 0 && this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mParent.recomputeViewAttributes(this);
        }
        if ((changed & 0xC0000000) != 0) {
            this.requestLayout();
        }
    }

    public void bringToFront() {
        if (this.mParent != null) {
            this.mParent.bringChildToFront(this);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.postSendViewScrolledAccessibilityEventCallback();
        }
        this.mBackgroundSizeChanged = true;
        AttachInfo ai = this.mAttachInfo;
        if (ai != null) {
            ai.mViewScrollChanged = true;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    public ViewParent getParent() {
        return this.mParent;
    }

    public void setScrollX(int value) {
        this.scrollTo(value, this.mScrollY);
    }

    public void setScrollY(int value) {
        this.scrollTo(this.mScrollX, value);
    }

    public int getScrollX() {
        return this.mScrollX;
    }

    public int getScrollY() {
        return this.mScrollY;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getWidth() {
        return this.mRight - this.mLeft;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getHeight() {
        return this.mBottom - this.mTop;
    }

    public void getDrawingRect(Rect outRect) {
        outRect.left = this.mScrollX;
        outRect.top = this.mScrollY;
        outRect.right = this.mScrollX + (this.mRight - this.mLeft);
        outRect.bottom = this.mScrollY + (this.mBottom - this.mTop);
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth & 0xFFFFFF;
    }

    public int getMeasuredWidthAndState() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight & 0xFFFFFF;
    }

    public int getMeasuredHeightAndState() {
        return this.mMeasuredHeight;
    }

    public int getMeasuredState() {
        return this.mMeasuredWidth & 0xFF000000 | this.mMeasuredHeight >> 16 & 0xFFFFFF00;
    }

    public Matrix getMatrix() {
        if (this.mTransformationInfo != null) {
            this.updateMatrix();
            return this.mTransformationInfo.mMatrix;
        }
        return Matrix.IDENTITY_MATRIX;
    }

    private static boolean nonzero(float value) {
        return value < -0.001f || value > 0.001f;
    }

    boolean hasIdentityMatrix() {
        if (this.mTransformationInfo != null) {
            this.updateMatrix();
            return this.mTransformationInfo.mMatrixIsIdentity;
        }
        return true;
    }

    void ensureTransformationInfo() {
        if (this.mTransformationInfo == null) {
            this.mTransformationInfo = new TransformationInfo();
        }
    }

    private void updateMatrix() {
        TransformationInfo info = this.mTransformationInfo;
        if (info == null) {
            return;
        }
        if (info.mMatrixDirty) {
            if ((this.mPrivateFlags & 0x20000000) == 0 && (this.mRight - this.mLeft != info.mPrevWidth || this.mBottom - this.mTop != info.mPrevHeight)) {
                info.mPrevWidth = this.mRight - this.mLeft;
                info.mPrevHeight = this.mBottom - this.mTop;
                info.mPivotX = (float)info.mPrevWidth / 2.0f;
                info.mPivotY = (float)info.mPrevHeight / 2.0f;
            }
            info.mMatrix.reset();
            if (!View.nonzero(info.mRotationX) && !View.nonzero(info.mRotationY)) {
                info.mMatrix.setTranslate(info.mTranslationX, info.mTranslationY);
                info.mMatrix.preRotate(info.mRotation, info.mPivotX, info.mPivotY);
                info.mMatrix.preScale(info.mScaleX, info.mScaleY, info.mPivotX, info.mPivotY);
            } else {
                if (info.mCamera == null) {
                    info.mCamera = new Camera();
                    info.matrix3D = new Matrix();
                }
                info.mCamera.save();
                info.mMatrix.preScale(info.mScaleX, info.mScaleY, info.mPivotX, info.mPivotY);
                info.mCamera.rotate(info.mRotationX, info.mRotationY, -info.mRotation);
                info.mCamera.getMatrix(info.matrix3D);
                info.matrix3D.preTranslate(-info.mPivotX, -info.mPivotY);
                info.matrix3D.postTranslate(info.mPivotX + info.mTranslationX, info.mPivotY + info.mTranslationY);
                info.mMatrix.postConcat(info.matrix3D);
                info.mCamera.restore();
            }
            info.mMatrixDirty = false;
            info.mMatrixIsIdentity = info.mMatrix.isIdentity();
            info.mInverseMatrixDirty = true;
        }
    }

    Matrix getInverseMatrix() {
        TransformationInfo info = this.mTransformationInfo;
        if (info != null) {
            this.updateMatrix();
            if (info.mInverseMatrixDirty) {
                if (info.mInverseMatrix == null) {
                    info.mInverseMatrix = new Matrix();
                }
                info.mMatrix.invert(info.mInverseMatrix);
                info.mInverseMatrixDirty = false;
            }
            return info.mInverseMatrix;
        }
        return Matrix.IDENTITY_MATRIX;
    }

    public void setCameraDistance(float distance) {
        this.invalidateParentCaches();
        this.invalidate(false);
        this.ensureTransformationInfo();
        float dpi = this.mResources.getDisplayMetrics().densityDpi;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mCamera == null) {
            info.mCamera = new Camera();
            info.matrix3D = new Matrix();
        }
        info.mCamera.setLocation(0.0f, 0.0f, -Math.abs(distance) / dpi);
        info.mMatrixDirty = true;
        this.invalidate(false);
    }

    public float getRotation() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mRotation : 0.0f;
    }

    public void setRotation(float rotation) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mRotation != rotation) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mRotation = rotation;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getRotationY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mRotationY : 0.0f;
    }

    public void setRotationY(float rotationY) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mRotationY != rotationY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mRotationY = rotationY;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getRotationX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mRotationX : 0.0f;
    }

    public void setRotationX(float rotationX) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mRotationX != rotationX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mRotationX = rotationX;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getScaleX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mScaleX : 1.0f;
    }

    public void setScaleX(float scaleX) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mScaleX != scaleX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mScaleX = scaleX;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getScaleY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mScaleY : 1.0f;
    }

    public void setScaleY(float scaleY) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mScaleY != scaleY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mScaleY = scaleY;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getPivotX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mPivotX : 0.0f;
    }

    public void setPivotX(float pivotX) {
        this.ensureTransformationInfo();
        this.mPrivateFlags |= 0x20000000;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mPivotX != pivotX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mPivotX = pivotX;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getPivotY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mPivotY : 0.0f;
    }

    public void setPivotY(float pivotY) {
        this.ensureTransformationInfo();
        this.mPrivateFlags |= 0x20000000;
        TransformationInfo info = this.mTransformationInfo;
        if (info.mPivotY != pivotY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mPivotY = pivotY;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getAlpha() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mAlpha : 1.0f;
    }

    public void setAlpha(float alpha) {
        this.ensureTransformationInfo();
        this.mTransformationInfo.mAlpha = alpha;
        this.invalidateParentCaches();
        if (this.onSetAlpha((int)(alpha * 255.0f))) {
            this.mPrivateFlags |= 0x40000;
            this.invalidate(true);
        } else {
            this.mPrivateFlags &= 0xFFFBFFFF;
            this.invalidate(false);
        }
    }

    boolean setAlphaNoInvalidation(float alpha) {
        this.ensureTransformationInfo();
        this.mTransformationInfo.mAlpha = alpha;
        boolean subclassHandlesAlpha = this.onSetAlpha((int)(alpha * 255.0f));
        this.mPrivateFlags = subclassHandlesAlpha ? (this.mPrivateFlags |= 0x40000) : (this.mPrivateFlags &= 0xFFFBFFFF);
        return subclassHandlesAlpha;
    }

    @ViewDebug.CapturedViewProperty
    public int getTop() {
        return this.mTop;
    }

    public void setTop(int top) {
        if (top != this.mTop) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int yLoc;
                    int minTop;
                    if (top < this.mTop) {
                        minTop = top;
                        yLoc = top - this.mTop;
                    } else {
                        minTop = this.mTop;
                        yLoc = 0;
                    }
                    this.invalidate(0, yLoc, this.mRight - this.mLeft, this.mBottom - minTop);
                }
            } else {
                this.invalidate(true);
            }
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mTop = top;
            this.onSizeChanged(width, this.mBottom - this.mTop, width, oldHeight);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getBottom() {
        return this.mBottom;
    }

    public boolean isDirty() {
        return (this.mPrivateFlags & 0x600000) != 0;
    }

    public void setBottom(int bottom) {
        if (bottom != this.mBottom) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int maxBottom = bottom < this.mBottom ? this.mBottom : bottom;
                    this.invalidate(0, 0, this.mRight - this.mLeft, maxBottom - this.mTop);
                }
            } else {
                this.invalidate(true);
            }
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mBottom = bottom;
            this.onSizeChanged(width, this.mBottom - this.mTop, width, oldHeight);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getLeft() {
        return this.mLeft;
    }

    public void setLeft(int left) {
        if (left != this.mLeft) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int xLoc;
                    int minLeft;
                    if (left < this.mLeft) {
                        minLeft = left;
                        xLoc = left - this.mLeft;
                    } else {
                        minLeft = this.mLeft;
                        xLoc = 0;
                    }
                    this.invalidate(xLoc, 0, this.mRight - minLeft, this.mBottom - this.mTop);
                }
            } else {
                this.invalidate(true);
            }
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mLeft = left;
            this.onSizeChanged(this.mRight - this.mLeft, height, oldWidth, height);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getRight() {
        return this.mRight;
    }

    public void setRight(int right) {
        if (right != this.mRight) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                if (this.mAttachInfo != null) {
                    int maxRight = right < this.mRight ? this.mRight : right;
                    this.invalidate(0, 0, maxRight - this.mLeft, this.mBottom - this.mTop);
                }
            } else {
                this.invalidate(true);
            }
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mRight = right;
            this.onSizeChanged(this.mRight - this.mLeft, height, oldWidth, height);
            if (!matrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    public float getX() {
        return (float)this.mLeft + (this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationX : 0.0f);
    }

    public void setX(float x) {
        this.setTranslationX(x - (float)this.mLeft);
    }

    public float getY() {
        return (float)this.mTop + (this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationY : 0.0f);
    }

    public void setY(float y) {
        this.setTranslationY(y - (float)this.mTop);
    }

    public float getTranslationX() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationX : 0.0f;
    }

    public void setTranslationX(float translationX) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mTranslationX != translationX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mTranslationX = translationX;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getTranslationY() {
        return this.mTransformationInfo != null ? this.mTransformationInfo.mTranslationY : 0.0f;
    }

    public void setTranslationY(float translationY) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        if (info.mTranslationY != translationY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            info.mTranslationY = translationY;
            info.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public void setFastTranslationX(float x) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mTranslationX = x;
        info.mMatrixDirty = true;
    }

    public void setFastTranslationY(float y) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mTranslationY = y;
        info.mMatrixDirty = true;
    }

    public void setFastX(float x) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mTranslationX = x - (float)this.mLeft;
        info.mMatrixDirty = true;
    }

    public void setFastY(float y) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mTranslationY = y - (float)this.mTop;
        info.mMatrixDirty = true;
    }

    public void setFastScaleX(float x) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mScaleX = x;
        info.mMatrixDirty = true;
    }

    public void setFastScaleY(float y) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mScaleY = y;
        info.mMatrixDirty = true;
    }

    public void setFastAlpha(float alpha) {
        this.ensureTransformationInfo();
        this.mTransformationInfo.mAlpha = alpha;
    }

    public void setFastRotationY(float y) {
        this.ensureTransformationInfo();
        TransformationInfo info = this.mTransformationInfo;
        info.mRotationY = y;
        info.mMatrixDirty = true;
    }

    public void getHitRect(Rect outRect) {
        this.updateMatrix();
        TransformationInfo info = this.mTransformationInfo;
        if (info == null || info.mMatrixIsIdentity || this.mAttachInfo == null) {
            outRect.set(this.mLeft, this.mTop, this.mRight, this.mBottom);
        } else {
            RectF tmpRect = this.mAttachInfo.mTmpTransformRect;
            tmpRect.set(-info.mPivotX, -info.mPivotY, (float)this.getWidth() - info.mPivotX, (float)this.getHeight() - info.mPivotY);
            info.mMatrix.mapRect(tmpRect);
            outRect.set((int)tmpRect.left + this.mLeft, (int)tmpRect.top + this.mTop, (int)tmpRect.right + this.mLeft, (int)tmpRect.bottom + this.mTop);
        }
    }

    boolean pointInView(float localX, float localY) {
        return localX >= 0.0f && localX < (float)(this.mRight - this.mLeft) && localY >= 0.0f && localY < (float)(this.mBottom - this.mTop);
    }

    private boolean pointInView(float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(this.mRight - this.mLeft) + slop && localY < (float)(this.mBottom - this.mTop) + slop;
    }

    public void getFocusedRect(Rect r) {
        this.getDrawingRect(r);
    }

    public boolean getGlobalVisibleRect(Rect r, Point globalOffset) {
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width > 0 && height > 0) {
            r.set(0, 0, width, height);
            if (globalOffset != null) {
                globalOffset.set(-this.mScrollX, -this.mScrollY);
            }
            return this.mParent == null || this.mParent.getChildVisibleRect(this, r, globalOffset);
        }
        return false;
    }

    public boolean getGlobalVisibleRect(Rect r) {
        return this.getGlobalVisibleRect(r, null);
    }

    public boolean getLocalVisibleRect(Rect r) {
        Point offset = new Point();
        if (this.getGlobalVisibleRect(r, offset)) {
            r.offset(-offset.x, -offset.y);
            return true;
        }
        return false;
    }

    public void offsetTopAndBottom(int offset) {
        if (offset != 0) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    int yLoc;
                    int maxBottom;
                    int minTop;
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    if (offset < 0) {
                        minTop = this.mTop + offset;
                        maxBottom = this.mBottom;
                        yLoc = offset;
                    } else {
                        minTop = this.mTop;
                        maxBottom = this.mBottom + offset;
                        yLoc = 0;
                    }
                    r.set(0, yLoc, this.mRight - this.mLeft, maxBottom - minTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(false);
            }
            this.mTop += offset;
            this.mBottom += offset;
            if (!matrixIsIdentity) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(false);
            }
            this.invalidateParentIfNeeded();
        }
    }

    public void offsetLeftAndRight(int offset) {
        if (offset != 0) {
            boolean matrixIsIdentity;
            this.updateMatrix();
            boolean bl = matrixIsIdentity = this.mTransformationInfo == null || this.mTransformationInfo.mMatrixIsIdentity;
            if (matrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    int maxRight;
                    int minLeft;
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    if (offset < 0) {
                        minLeft = this.mLeft + offset;
                        maxRight = this.mRight;
                    } else {
                        minLeft = this.mLeft;
                        maxRight = this.mRight + offset;
                    }
                    r.set(0, 0, maxRight - minLeft, this.mBottom - this.mTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(false);
            }
            this.mLeft += offset;
            this.mRight += offset;
            if (!matrixIsIdentity) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(false);
            }
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.ExportedProperty(deepExport=true, prefix="layout_")
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params == null) {
            throw new NullPointerException("Layout parameters cannot be null");
        }
        this.mLayoutParams = params;
        this.requestLayout();
    }

    public void scrollTo(int x, int y) {
        if (this.mScrollX != x || this.mScrollY != y) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = x;
            this.mScrollY = y;
            this.invalidateParentCaches();
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (!this.awakenScrollBars()) {
                this.invalidate(true);
            }
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo(this.mScrollX + x, this.mScrollY + y);
    }

    protected boolean awakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade, true);
    }

    private boolean initialAwakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade * 4, true);
    }

    protected boolean awakenScrollBars(int startDelay) {
        return this.awakenScrollBars(startDelay, true);
    }

    protected boolean awakenScrollBars(int startDelay, boolean invalidate) {
        ScrollabilityCache scrollCache = this.mScrollCache;
        if (scrollCache == null || !scrollCache.fadeScrollBars) {
            return false;
        }
        if (scrollCache.scrollBar == null) {
            scrollCache.scrollBar = new ScrollBarDrawable();
        }
        if (this.isHorizontalScrollBarEnabled() || this.isVerticalScrollBarEnabled()) {
            long fadeStartTime;
            if (invalidate) {
                this.invalidate(true);
            }
            if (scrollCache.state == 0) {
                int KEY_REPEAT_FIRST_DELAY = 750;
                startDelay = Math.max(750, startDelay);
            }
            scrollCache.fadeStartTime = fadeStartTime = AnimationUtils.currentAnimationTimeMillis() + (long)startDelay;
            scrollCache.state = 1;
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mHandler.removeCallbacks(scrollCache);
                this.mAttachInfo.mHandler.postAtTime(scrollCache, fadeStartTime);
            }
            return true;
        }
        return false;
    }

    private boolean skipInvalidate() {
        return (this.mViewFlags & 0xC) != 0 && this.mCurrentAnimation == null && (!(this.mParent instanceof ViewGroup) || !((ViewGroup)this.mParent).isViewTransitioning(this));
    }

    public void invalidate(Rect dirty) {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            this.mPrivateFlags |= 0x200000;
            ViewParent p = this.mParent;
            AttachInfo ai = this.mAttachInfo;
            if (p != null && ai != null) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                Rect r = ai.mTmpInvalRect;
                r.set(dirty.left - scrollX, dirty.top - scrollY, dirty.right - scrollX, dirty.bottom - scrollY);
                this.mParent.invalidateChild(this, r);
            }
        }
    }

    public void invalidate(int l, int t, int r, int b) {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            this.mPrivateFlags |= 0x200000;
            ViewParent p = this.mParent;
            AttachInfo ai = this.mAttachInfo;
            if (p != null && ai != null && l < r && t < b) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                Rect tmpr = ai.mTmpInvalRect;
                tmpr.set(l - scrollX, t - scrollY, r - scrollX, b - scrollY);
                p.invalidateChild(this, tmpr);
            }
        }
    }

    public void invalidate() {
        this.invalidate(true);
    }

    void invalidate(boolean invalidateCache) {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || invalidateCache && (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE || this.isOpaque() != this.mLastIsOpaque) {
            this.mLastIsOpaque = this.isOpaque();
            this.mPrivateFlags &= 0xFFFFFFDF;
            this.mPrivateFlags |= 0x200000;
            if (invalidateCache) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
                this.mPrivateFlags &= 0xFFFF7FFF;
            }
            AttachInfo ai = this.mAttachInfo;
            ViewParent p = this.mParent;
            if (p != null && ai != null) {
                Rect r = ai.mTmpInvalRect;
                r.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                p.invalidateChild(this, r);
            }
        }
    }

    public void fastInvalidate() {
        if (this.skipInvalidate()) {
            return;
        }
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            if (this.mParent instanceof View) {
                ((View)((Object)this.mParent)).mPrivateFlags |= Integer.MIN_VALUE;
            }
            this.mPrivateFlags &= 0xFFFFFFDF;
            this.mPrivateFlags |= 0x200000;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            this.mPrivateFlags &= 0xFFFF7FFF;
            if (this.mParent != null && this.mAttachInfo != null) {
                if (this.mAttachInfo.mHardwareAccelerated) {
                    this.mParent.invalidateChild(this, null);
                } else {
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    r.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                    this.mParent.invalidateChild(this, r);
                }
            }
        }
    }

    protected void invalidateParentCaches() {
        if (this.mParent instanceof View) {
            ((View)((Object)this.mParent)).mPrivateFlags |= Integer.MIN_VALUE;
        }
    }

    protected void invalidateParentIfNeeded() {
        if (this.isHardwareAccelerated() && this.mParent instanceof View) {
            ((View)((Object)this.mParent)).invalidate(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isOpaque() {
        if ((this.mPrivateFlags & 0x1800000) != 0x1800000) return false;
        float f = this.mTransformationInfo != null ? this.mTransformationInfo.mAlpha : 1.0f;
        if (!(f >= 0.9791667f)) return false;
        return true;
    }

    protected void computeOpaqueFlags() {
        this.mPrivateFlags = this.mBGDrawable != null && this.mBGDrawable.getOpacity() == -1 ? (this.mPrivateFlags |= 0x800000) : (this.mPrivateFlags &= 0xFF7FFFFF);
        int flags = this.mViewFlags;
        this.mPrivateFlags = (flags & 0x200) == 0 && (flags & 0x100) == 0 || (flags & 0x3000000) == 0 ? (this.mPrivateFlags |= 0x1000000) : (this.mPrivateFlags &= 0xFEFFFFFF);
    }

    protected boolean hasOpaqueScrollbars() {
        return (this.mPrivateFlags & 0x1000000) == 0x1000000;
    }

    public Handler getHandler() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mHandler;
        }
        return null;
    }

    public boolean post(Runnable action) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo == null) {
            ViewRootImpl.getRunQueue().post(action);
            return true;
        }
        Handler handler = attachInfo.mHandler;
        return handler.post(action);
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo == null) {
            ViewRootImpl.getRunQueue().postDelayed(action, delayMillis);
            return true;
        }
        Handler handler = attachInfo.mHandler;
        return handler.postDelayed(action, delayMillis);
    }

    public boolean removeCallbacks(Runnable action) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo == null) {
            ViewRootImpl.getRunQueue().removeCallbacks(action);
            return true;
        }
        Handler handler = attachInfo.mHandler;
        handler.removeCallbacks(action);
        return true;
    }

    public void postInvalidate() {
        this.postInvalidateDelayed(0L);
    }

    public void postInvalidate(int left, int top, int right, int bottom) {
        this.postInvalidateDelayed(0L, left, top, right, bottom);
    }

    public void postInvalidateDelayed(long delayMilliseconds) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = this;
            attachInfo.mHandler.sendMessageDelayed(msg, delayMilliseconds);
        }
    }

    public void postInvalidateDelayed(long delayMilliseconds, int left, int top, int right, int bottom) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            AttachInfo.InvalidateInfo info = AttachInfo.InvalidateInfo.acquire();
            info.target = this;
            info.left = left;
            info.top = top;
            info.right = right;
            info.bottom = bottom;
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = info;
            attachInfo.mHandler.sendMessageDelayed(msg, delayMilliseconds);
        }
    }

    private void postSendViewScrolledAccessibilityEventCallback() {
        if (this.mSendViewScrolledAccessibilityEvent == null) {
            this.mSendViewScrolledAccessibilityEvent = new SendViewScrolledAccessibilityEvent();
        }
        if (!this.mSendViewScrolledAccessibilityEvent.mIsPending) {
            this.mSendViewScrolledAccessibilityEvent.mIsPending = true;
            this.postDelayed(this.mSendViewScrolledAccessibilityEvent, ViewConfiguration.getSendRecurringAccessibilityEventsInterval());
        }
    }

    public void computeScroll() {
    }

    public boolean isHorizontalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x1000) == 4096;
    }

    public void setHorizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
        if (this.isHorizontalFadingEdgeEnabled() != horizontalFadingEdgeEnabled) {
            if (horizontalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x1000;
        }
    }

    public boolean isVerticalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x2000) == 8192;
    }

    public void setVerticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
        if (this.isVerticalFadingEdgeEnabled() != verticalFadingEdgeEnabled) {
            if (verticalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x2000;
        }
    }

    protected float getTopFadingEdgeStrength() {
        return this.computeVerticalScrollOffset() > 0 ? 1.0f : 0.0f;
    }

    protected float getBottomFadingEdgeStrength() {
        return this.computeVerticalScrollOffset() + this.computeVerticalScrollExtent() < this.computeVerticalScrollRange() ? 1.0f : 0.0f;
    }

    protected float getLeftFadingEdgeStrength() {
        return this.computeHorizontalScrollOffset() > 0 ? 1.0f : 0.0f;
    }

    protected float getRightFadingEdgeStrength() {
        return this.computeHorizontalScrollOffset() + this.computeHorizontalScrollExtent() < this.computeHorizontalScrollRange() ? 1.0f : 0.0f;
    }

    public boolean isHorizontalScrollBarEnabled() {
        return (this.mViewFlags & 0x100) == 256;
    }

    public void setHorizontalScrollBarEnabled(boolean horizontalScrollBarEnabled) {
        if (this.isHorizontalScrollBarEnabled() != horizontalScrollBarEnabled) {
            this.mViewFlags ^= 0x100;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    public boolean isVerticalScrollBarEnabled() {
        return (this.mViewFlags & 0x200) == 512;
    }

    public void setVerticalScrollBarEnabled(boolean verticalScrollBarEnabled) {
        if (this.isVerticalScrollBarEnabled() != verticalScrollBarEnabled) {
            this.mViewFlags ^= 0x200;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    protected void recomputePadding() {
        this.setPadding(this.mUserPaddingLeft, this.mPaddingTop, this.mUserPaddingRight, this.mUserPaddingBottom);
    }

    public void setScrollbarFadingEnabled(boolean fadeScrollbars) {
        this.initScrollCache();
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        scrollabilityCache.fadeScrollBars = fadeScrollbars;
        scrollabilityCache.state = fadeScrollbars ? 0 : 1;
    }

    public boolean isScrollbarFadingEnabled() {
        return this.mScrollCache != null && this.mScrollCache.fadeScrollBars;
    }

    public void setScrollBarStyle(int style2) {
        if (style2 != (this.mViewFlags & 0x3000000)) {
            this.mViewFlags = this.mViewFlags & 0xFCFFFFFF | style2 & 0x3000000;
            this.computeOpaqueFlags();
            this.resolvePadding();
        }
    }

    @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=0, to="INSIDE_OVERLAY"), @ViewDebug.IntToString(from=0x1000000, to="INSIDE_INSET"), @ViewDebug.IntToString(from=0x2000000, to="OUTSIDE_OVERLAY"), @ViewDebug.IntToString(from=0x3000000, to="OUTSIDE_INSET")})
    public int getScrollBarStyle() {
        return this.mViewFlags & 0x3000000;
    }

    protected int computeHorizontalScrollRange() {
        return this.getWidth();
    }

    protected int computeHorizontalScrollOffset() {
        return this.mScrollX;
    }

    protected int computeHorizontalScrollExtent() {
        return this.getWidth();
    }

    protected int computeVerticalScrollRange() {
        return this.getHeight();
    }

    protected int computeVerticalScrollOffset() {
        return this.mScrollY;
    }

    protected int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    public boolean canScrollHorizontally(int direction) {
        int offset = this.computeHorizontalScrollOffset();
        int range = this.computeHorizontalScrollRange() - this.computeHorizontalScrollExtent();
        if (range == 0) {
            return false;
        }
        if (direction < 0) {
            return offset > 0;
        }
        return offset < range - 1;
    }

    public boolean canScrollVertically(int direction) {
        int offset = this.computeVerticalScrollOffset();
        int range = this.computeVerticalScrollRange() - this.computeVerticalScrollExtent();
        if (range == 0) {
            return false;
        }
        if (direction < 0) {
            return offset > 0;
        }
        return offset < range - 1;
    }

    protected void onDrawScrollBars(Canvas canvas) {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            boolean drawVerticalScrollBar;
            int state = cache.state;
            if (state == 0) {
                return;
            }
            boolean invalidate = false;
            if (state == 2) {
                float[] values;
                if (cache.interpolatorValues == null) {
                    cache.interpolatorValues = new float[1];
                }
                if (cache.scrollBarInterpolator.timeToValues(values = cache.interpolatorValues) == Interpolator.Result.FREEZE_END) {
                    cache.state = 0;
                } else {
                    cache.scrollBar.setAlpha(Math.round(values[0]));
                }
                invalidate = true;
            } else {
                cache.scrollBar.setAlpha(255);
            }
            int viewFlags = this.mViewFlags;
            boolean drawHorizontalScrollBar = (viewFlags & 0x100) == 256;
            boolean bl = drawVerticalScrollBar = (viewFlags & 0x200) == 512 && !this.isVerticalScrollBarHidden();
            if (drawVerticalScrollBar || drawHorizontalScrollBar) {
                int bottom;
                int right;
                int left;
                int top;
                int size;
                int inside;
                int width = this.mRight - this.mLeft;
                int height = this.mBottom - this.mTop;
                ScrollBarDrawable scrollBar = cache.scrollBar;
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                int n = inside = (viewFlags & 0x2000000) == 0 ? -1 : 0;
                if (drawHorizontalScrollBar) {
                    size = scrollBar.getSize(false);
                    if (size <= 0) {
                        size = cache.scrollBarSize;
                    }
                    scrollBar.setParameters(this.computeHorizontalScrollRange(), this.computeHorizontalScrollOffset(), this.computeHorizontalScrollExtent(), false);
                    int verticalScrollBarGap = drawVerticalScrollBar ? this.getVerticalScrollbarWidth() : 0;
                    top = scrollY + height - size - (this.mUserPaddingBottom & inside);
                    left = scrollX + (this.mPaddingLeft & inside);
                    right = scrollX + width - (this.mUserPaddingRight & inside) - verticalScrollBarGap;
                    bottom = top + size;
                    this.onDrawHorizontalScrollBar(canvas, scrollBar, left, top, right, bottom);
                    if (invalidate) {
                        this.invalidate(left, top, right, bottom);
                    }
                }
                if (drawVerticalScrollBar) {
                    size = scrollBar.getSize(true);
                    if (size <= 0) {
                        size = cache.scrollBarSize;
                    }
                    scrollBar.setParameters(this.computeVerticalScrollRange(), this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent(), true);
                    switch (this.mVerticalScrollbarPosition) {
                        default: {
                            left = scrollX + width - size - (this.mUserPaddingRight & inside);
                            break;
                        }
                        case 1: {
                            left = scrollX + (this.mUserPaddingLeft & inside);
                        }
                    }
                    top = scrollY + (this.mPaddingTop & inside);
                    right = left + size;
                    bottom = scrollY + height - (this.mUserPaddingBottom & inside);
                    this.onDrawVerticalScrollBar(canvas, scrollBar, left, top, right, bottom);
                    if (invalidate) {
                        this.invalidate(left, top, right, bottom);
                    }
                }
            }
        }
    }

    protected boolean isVerticalScrollBarHidden() {
        return false;
    }

    protected void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
    }

    void assignParent(ViewParent parent) {
        if (this.mParent == null) {
            this.mParent = parent;
        } else if (parent == null) {
            this.mParent = null;
        } else {
            throw new RuntimeException("view " + this + " being added, but" + " it already has a parent");
        }
    }

    protected void onAttachedToWindow() {
        if ((this.mPrivateFlags & 0x200) != 0) {
            this.mParent.requestTransparentRegion(this);
        }
        if ((this.mPrivateFlags & 0x8000000) != 0) {
            this.initialAwakenScrollBars();
            this.mPrivateFlags &= 0xF7FFFFFF;
        }
        this.jumpDrawablesToCurrentState();
        this.resolveLayoutDirectionIfNeeded();
        this.resolvePadding();
        this.resolveTextDirection();
        if (this.isFocused()) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            imm.focusIn(this);
        }
    }

    private void resolveLayoutDirectionIfNeeded() {
        if ((this.mPrivateFlags2 & 8) == 8) {
            return;
        }
        this.mPrivateFlags2 &= 0xFFFFFFFB;
        this.resetResolvedTextDirection();
        switch (this.getLayoutDirection()) {
            case -2147483648: {
                if (this.mParent == null) {
                    return;
                }
                if (!(this.mParent instanceof ViewGroup)) break;
                ViewGroup viewGroup = (ViewGroup)this.mParent;
                if (!viewGroup.canResolveLayoutDirection()) {
                    return;
                }
                if (viewGroup.getResolvedLayoutDirection() != 0x40000000) break;
                this.mPrivateFlags2 |= 4;
                break;
            }
            case 0x40000000: {
                this.mPrivateFlags2 |= 4;
                break;
            }
            case -1073741824: {
                if (!View.isLayoutDirectionRtl(Locale.getDefault())) break;
                this.mPrivateFlags2 |= 4;
                break;
            }
        }
        this.mPrivateFlags2 |= 8;
    }

    protected void resolvePadding() {
        switch (this.getResolvedLayoutDirection()) {
            case 0x40000000: {
                if (this.mUserPaddingStart >= 0) {
                    this.mUserPaddingRight = this.mUserPaddingStart;
                } else if (this.mUserPaddingRight < 0) {
                    this.mUserPaddingRight = this.mPaddingRight;
                }
                if (this.mUserPaddingEnd >= 0) {
                    this.mUserPaddingLeft = this.mUserPaddingEnd;
                    break;
                }
                if (this.mUserPaddingLeft >= 0) break;
                this.mUserPaddingLeft = this.mPaddingLeft;
                break;
            }
            default: {
                if (this.mUserPaddingStart >= 0) {
                    this.mUserPaddingLeft = this.mUserPaddingStart;
                } else if (this.mUserPaddingLeft < 0) {
                    this.mUserPaddingLeft = this.mPaddingLeft;
                }
                if (this.mUserPaddingEnd >= 0) {
                    this.mUserPaddingRight = this.mUserPaddingEnd;
                    break;
                }
                if (this.mUserPaddingRight >= 0) break;
                this.mUserPaddingRight = this.mPaddingRight;
            }
        }
        this.mUserPaddingBottom = this.mUserPaddingBottom >= 0 ? this.mUserPaddingBottom : this.mPaddingBottom;
        this.recomputePadding();
    }

    protected boolean canResolveLayoutDirection() {
        switch (this.getLayoutDirection()) {
            case -2147483648: {
                return this.mParent != null;
            }
        }
        return true;
    }

    protected void resetResolvedLayoutDirection() {
        this.mPrivateFlags2 &= 0xFFFFFFF7;
    }

    protected static boolean isLayoutDirectionRtl(Locale locale) {
        return 1 == LocaleUtil.getLayoutDirectionFromLocale(locale);
    }

    protected void onDetachedFromWindow() {
        this.mPrivateFlags &= 0xFBFFFFFF;
        this.removeUnsetPressCallback();
        this.removeLongPressCallback();
        this.removePerformClickCallback();
        this.removeSendViewScrolledAccessibilityEventCallback();
        this.destroyDrawingCache();
        this.destroyLayer();
        if (this.mDisplayList != null) {
            this.mDisplayList.invalidate();
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mHandler.removeMessages(1, this);
        }
        this.mCurrentAnimation = null;
        this.resetResolvedLayoutDirection();
        this.resetResolvedTextDirection();
    }

    protected int getWindowAttachCount() {
        return this.mWindowAttachCount;
    }

    public IBinder getWindowToken() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowToken : null;
    }

    public IBinder getApplicationWindowToken() {
        AttachInfo ai = this.mAttachInfo;
        if (ai != null) {
            IBinder appWindowToken = ai.mPanelParentWindowToken;
            if (appWindowToken == null) {
                appWindowToken = ai.mWindowToken;
            }
            return appWindowToken;
        }
        return null;
    }

    IWindowSession getWindowSession() {
        return this.mAttachInfo != null ? this.mAttachInfo.mSession : null;
    }

    void dispatchAttachedToWindow(AttachInfo info, int visibility) {
        int vis;
        CopyOnWriteArrayList listeners;
        this.mAttachInfo = info;
        ++this.mWindowAttachCount;
        this.mPrivateFlags |= 0x400;
        if (this.mFloatingTreeObserver != null) {
            info.mTreeObserver.merge(this.mFloatingTreeObserver);
            this.mFloatingTreeObserver = null;
        }
        if ((this.mPrivateFlags & 0x80000) != 0) {
            this.mAttachInfo.mScrollContainers.add(this);
            this.mPrivateFlags |= 0x100000;
        }
        this.performCollectViewAttributes(visibility);
        this.onAttachedToWindow();
        ListenerInfo li = this.mListenerInfo;
        CopyOnWriteArrayList copyOnWriteArrayList = listeners = li != null ? li.mOnAttachStateChangeListeners : null;
        if (listeners != null && listeners.size() > 0) {
            for (OnAttachStateChangeListener listener : listeners) {
                listener.onViewAttachedToWindow(this);
            }
        }
        if ((vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(vis);
        }
        if ((this.mPrivateFlags & 0x400) != 0) {
            this.refreshDrawableState();
        }
    }

    void dispatchDetachedFromWindow() {
        CopyOnWriteArrayList listeners;
        int vis;
        AttachInfo info = this.mAttachInfo;
        if (info != null && (vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(8);
        }
        this.onDetachedFromWindow();
        ListenerInfo li = this.mListenerInfo;
        CopyOnWriteArrayList copyOnWriteArrayList = listeners = li != null ? li.mOnAttachStateChangeListeners : null;
        if (listeners != null && listeners.size() > 0) {
            for (OnAttachStateChangeListener listener : listeners) {
                listener.onViewDetachedFromWindow(this);
            }
        }
        if ((this.mPrivateFlags & 0x100000) != 0) {
            this.mAttachInfo.mScrollContainers.remove(this);
            this.mPrivateFlags &= 0xFFEFFFFF;
        }
        this.mAttachInfo = null;
    }

    public void saveHierarchyState(SparseArray<Parcelable> container) {
        this.dispatchSaveInstanceState(container);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        if (this.mID != -1 && (this.mViewFlags & 0x10000) == 0) {
            this.mPrivateFlags &= 0xFFFDFFFF;
            Parcelable state = this.onSaveInstanceState();
            if ((this.mPrivateFlags & 0x20000) == 0) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.put(this.mID, state);
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        this.mPrivateFlags |= 0x20000;
        return BaseSavedState.EMPTY_STATE;
    }

    public void restoreHierarchyState(SparseArray<Parcelable> container) {
        this.dispatchRestoreInstanceState(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable state;
        if (this.mID != -1 && (state = container.get(this.mID)) != null) {
            this.mPrivateFlags &= 0xFFFDFFFF;
            this.onRestoreInstanceState(state);
            if ((this.mPrivateFlags & 0x20000) == 0) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        this.mPrivateFlags |= 0x20000;
        if (state != BaseSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class, expecting View State but received " + state.getClass().toString() + " instead. This usually happens " + "when two views of different type have the same id in the same hierarchy. " + "This view's id is " + ViewDebug.resolveId(this.mContext, this.getId()) + ". Make sure " + "other views do not use the same id.");
        }
    }

    public long getDrawingTime() {
        return this.mAttachInfo != null ? this.mAttachInfo.mDrawingTime : 0L;
    }

    public void setDuplicateParentStateEnabled(boolean enabled) {
        this.setFlags(enabled ? 0x400000 : 0, 0x400000);
    }

    public boolean isDuplicateParentStateEnabled() {
        return (this.mViewFlags & 0x400000) == 0x400000;
    }

    public void setLayerType(int layerType, Paint paint) {
        boolean layerDisabled;
        if (layerType < 0 || layerType > 2) {
            throw new IllegalArgumentException("Layer type can only be one of: LAYER_TYPE_NONE, LAYER_TYPE_SOFTWARE or LAYER_TYPE_HARDWARE");
        }
        if (layerType == this.mLayerType) {
            if (layerType != 0 && paint != this.mLayerPaint) {
                this.mLayerPaint = paint == null ? new Paint() : paint;
                this.invalidateParentCaches();
                this.invalidate(true);
            }
            return;
        }
        switch (this.mLayerType) {
            case 2: {
                this.destroyLayer();
            }
            case 1: {
                this.destroyDrawingCache();
                break;
            }
        }
        this.mLayerType = layerType;
        boolean bl = layerDisabled = this.mLayerType == 0;
        this.mLayerPaint = layerDisabled ? null : (paint == null ? new Paint() : paint);
        this.mLocalDirtyRect = layerDisabled ? null : new Rect();
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    boolean hasStaticLayer() {
        return this.mLayerType == 0;
    }

    public int getLayerType() {
        return this.mLayerType;
    }

    public void buildLayer() {
        if (this.mLayerType == 0) {
            return;
        }
        if (this.mAttachInfo == null) {
            throw new IllegalStateException("This view must be attached to a window first");
        }
        switch (this.mLayerType) {
            case 2: {
                if (this.mAttachInfo.mHardwareRenderer == null || !this.mAttachInfo.mHardwareRenderer.isEnabled() || !this.mAttachInfo.mHardwareRenderer.validate()) break;
                this.getHardwareLayer();
                break;
            }
            case 1: {
                this.buildDrawingCache(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HardwareLayer getHardwareLayer() {
        if (this.mAttachInfo == null || this.mAttachInfo.mHardwareRenderer == null || !this.mAttachInfo.mHardwareRenderer.isEnabled()) {
            return null;
        }
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width == 0 || height == 0) {
            return null;
        }
        if ((this.mPrivateFlags & 0x8000) == 0 || this.mHardwareLayer == null) {
            if (this.mHardwareLayer == null) {
                this.mHardwareLayer = this.mAttachInfo.mHardwareRenderer.createHardwareLayer(width, height, this.isOpaque());
                this.mLocalDirtyRect.setEmpty();
            } else if (this.mHardwareLayer.getWidth() != width || this.mHardwareLayer.getHeight() != height) {
                this.mHardwareLayer.resize(width, height);
                this.mLocalDirtyRect.setEmpty();
            }
            if (!this.mHardwareLayer.isValid()) {
                return null;
            }
            HardwareCanvas currentCanvas = this.mAttachInfo.mHardwareCanvas;
            HardwareCanvas canvas = this.mHardwareLayer.start(currentCanvas);
            if (canvas == null) {
                this.mHardwareLayer.end(currentCanvas);
                return null;
            }
            this.mAttachInfo.mHardwareCanvas = canvas;
            try {
                canvas.setViewport(width, height);
                canvas.onPreDraw(this.mLocalDirtyRect);
                this.mLocalDirtyRect.setEmpty();
                int restoreCount = canvas.save();
                this.computeScroll();
                canvas.translate(-this.mScrollX, -this.mScrollY);
                this.mPrivateFlags |= 0x8020;
                if ((this.mPrivateFlags & 0x80) == 128) {
                    this.mPrivateFlags &= 0xFF9FFFFF;
                    this.dispatchDraw(canvas);
                } else {
                    this.draw(canvas);
                }
                canvas.restoreToCount(restoreCount);
            }
            finally {
                canvas.onPostDraw();
                this.mHardwareLayer.end(currentCanvas);
                this.mAttachInfo.mHardwareCanvas = currentCanvas;
            }
        }
        return this.mHardwareLayer;
    }

    boolean destroyLayer() {
        if (this.mHardwareLayer != null) {
            this.mHardwareLayer.destroy();
            this.mHardwareLayer = null;
            this.invalidate(true);
            this.invalidateParentCaches();
            return true;
        }
        return false;
    }

    protected void destroyHardwareResources() {
        this.destroyLayer();
    }

    public void setDrawingCacheEnabled(boolean enabled) {
        this.mCachingFailed = false;
        this.setFlags(enabled ? 32768 : 0, 32768);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isDrawingCacheEnabled() {
        return (this.mViewFlags & 0x8000) == 32768;
    }

    public void outputDirtyFlags(String indent, boolean clear, int clearMask) {
        Log.d(VIEW_LOG_TAG, indent + this + "             DIRTY(" + (this.mPrivateFlags & 0x600000) + ") DRAWN(" + (this.mPrivateFlags & 0x20) + ")" + " CACHE_VALID(" + (this.mPrivateFlags & 0x8000) + ") INVALIDATED(" + (this.mPrivateFlags & Integer.MIN_VALUE) + ")");
        if (clear) {
            this.mPrivateFlags &= clearMask;
        }
        if (this instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)this;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = parent.getChildAt(i);
                child.outputDirtyFlags(indent + "  ", clear, clearMask);
            }
        }
    }

    protected void dispatchGetDisplayList() {
    }

    public boolean canHaveDisplayList() {
        return this.mAttachInfo != null && this.mAttachInfo.mHardwareRenderer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayList getDisplayList() {
        if (!this.canHaveDisplayList()) {
            return null;
        }
        if ((this.mPrivateFlags & 0x8000) == 0 || this.mDisplayList == null || !this.mDisplayList.isValid() || this.mRecreateDisplayList) {
            if (this.mDisplayList != null && this.mDisplayList.isValid() && !this.mRecreateDisplayList) {
                this.mPrivateFlags |= 0x8020;
                this.mPrivateFlags &= 0xFF9FFFFF;
                this.dispatchGetDisplayList();
                return this.mDisplayList;
            }
            this.mRecreateDisplayList = true;
            if (this.mDisplayList == null) {
                this.mDisplayList = this.mAttachInfo.mHardwareRenderer.createDisplayList();
                this.invalidateParentCaches();
            }
            HardwareCanvas canvas = this.mDisplayList.start();
            int restoreCount = 0;
            try {
                int width = this.mRight - this.mLeft;
                int height = this.mBottom - this.mTop;
                canvas.setViewport(width, height);
                canvas.onPreDraw(null);
                this.computeScroll();
                restoreCount = canvas.save();
                canvas.translate(-this.mScrollX, -this.mScrollY);
                this.mPrivateFlags |= 0x8020;
                this.mPrivateFlags &= 0xFF9FFFFF;
                if ((this.mPrivateFlags & 0x80) == 128) {
                    this.dispatchDraw(canvas);
                }
                this.draw(canvas);
            }
            finally {
                canvas.restoreToCount(restoreCount);
                canvas.onPostDraw();
                this.mDisplayList.end();
            }
        } else {
            this.mPrivateFlags |= 0x8020;
            this.mPrivateFlags &= 0xFF9FFFFF;
        }
        return this.mDisplayList;
    }

    public Bitmap getDrawingCache() {
        return this.getDrawingCache(false);
    }

    public Bitmap getDrawingCache(boolean autoScale) {
        if ((this.mViewFlags & 0x20000) == 131072) {
            return null;
        }
        if ((this.mViewFlags & 0x8000) == 32768) {
            this.buildDrawingCache(autoScale);
        }
        return autoScale ? this.mDrawingCache : this.mUnscaledDrawingCache;
    }

    public void destroyDrawingCache() {
        if (this.mDrawingCache != null) {
            this.mDrawingCache.recycle();
            this.mDrawingCache = null;
        }
        if (this.mUnscaledDrawingCache != null) {
            this.mUnscaledDrawingCache.recycle();
            this.mUnscaledDrawingCache = null;
        }
    }

    public void setDrawingCacheBackgroundColor(int color2) {
        if (color2 != this.mDrawingCacheBackgroundColor) {
            this.mDrawingCacheBackgroundColor = color2;
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
    }

    public int getDrawingCacheBackgroundColor() {
        return this.mDrawingCacheBackgroundColor;
    }

    public void buildDrawingCache() {
        this.buildDrawingCache(false);
    }

    public void buildDrawingCache(boolean autoScale) {
        if ((this.mPrivateFlags & 0x8000) == 0 || (autoScale ? this.mDrawingCache == null : this.mUnscaledDrawingCache == null)) {
            Canvas canvas;
            Bitmap bitmap;
            boolean use32BitCache;
            int drawingCacheBackgroundColor;
            boolean scalingRequired;
            this.mCachingFailed = false;
            int width = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            AttachInfo attachInfo = this.mAttachInfo;
            boolean bl = scalingRequired = attachInfo != null && attachInfo.mScalingRequired;
            if (autoScale && scalingRequired) {
                width = (int)((float)width * attachInfo.mApplicationScale + 0.5f);
                height = (int)((float)height * attachInfo.mApplicationScale + 0.5f);
            }
            boolean opaque = (drawingCacheBackgroundColor = this.mDrawingCacheBackgroundColor) != 0 || this.isOpaque();
            boolean bl2 = use32BitCache = attachInfo != null && attachInfo.mUse32BitDrawingCache;
            if (width <= 0 || height <= 0 || width * height * (opaque && !use32BitCache ? 2 : 4) > ViewConfiguration.get(this.mContext).getScaledMaximumDrawingCacheSize()) {
                this.destroyDrawingCache();
                this.mCachingFailed = true;
                return;
            }
            boolean clear = true;
            Bitmap bitmap2 = bitmap = autoScale ? this.mDrawingCache : this.mUnscaledDrawingCache;
            if (bitmap == null || bitmap.getWidth() != width || bitmap.getHeight() != height) {
                Bitmap.Config quality;
                if (!opaque) {
                    switch (this.mViewFlags & 0x180000) {
                        case 0: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        case 524288: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        case 0x100000: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        default: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                    }
                } else {
                    Bitmap.Config config = quality = use32BitCache ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                }
                if (bitmap != null) {
                    bitmap.recycle();
                }
                try {
                    bitmap = Bitmap.createBitmap(width, height, quality);
                    bitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
                    if (autoScale) {
                        this.mDrawingCache = bitmap;
                    } else {
                        this.mUnscaledDrawingCache = bitmap;
                    }
                    if (opaque && use32BitCache) {
                        bitmap.setHasAlpha(false);
                    }
                }
                catch (OutOfMemoryError e) {
                    if (autoScale) {
                        this.mDrawingCache = null;
                    } else {
                        this.mUnscaledDrawingCache = null;
                    }
                    this.mCachingFailed = true;
                    return;
                }
                boolean bl3 = clear = drawingCacheBackgroundColor != 0;
            }
            if (attachInfo != null) {
                canvas = attachInfo.mCanvas;
                if (canvas == null) {
                    canvas = new Canvas();
                }
                canvas.setBitmap(bitmap);
                attachInfo.mCanvas = null;
            } else {
                canvas = new Canvas(bitmap);
            }
            if (clear) {
                bitmap.eraseColor(drawingCacheBackgroundColor);
            }
            this.computeScroll();
            int restoreCount = canvas.save();
            if (autoScale && scalingRequired) {
                float scale = attachInfo.mApplicationScale;
                canvas.scale(scale, scale);
            }
            canvas.translate(-this.mScrollX, -this.mScrollY);
            this.mPrivateFlags |= 0x20;
            if (this.mAttachInfo == null || !this.mAttachInfo.mHardwareAccelerated || this.mLayerType != 0) {
                this.mPrivateFlags |= 0x8000;
            }
            if ((this.mPrivateFlags & 0x80) == 128) {
                this.mPrivateFlags &= 0xFF9FFFFF;
                this.dispatchDraw(canvas);
            } else {
                this.draw(canvas);
            }
            canvas.restoreToCount(restoreCount);
            canvas.setBitmap(null);
            if (attachInfo != null) {
                attachInfo.mCanvas = canvas;
            }
        }
    }

    Bitmap createSnapshot(Bitmap.Config quality, int backgroundColor, boolean skipChildren) {
        Canvas canvas;
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        AttachInfo attachInfo = this.mAttachInfo;
        float scale = attachInfo != null ? attachInfo.mApplicationScale : 1.0f;
        Bitmap bitmap = Bitmap.createBitmap((width = (int)((float)width * scale + 0.5f)) > 0 ? width : 1, (height = (int)((float)height * scale + 0.5f)) > 0 ? height : 1, quality);
        if (bitmap == null) {
            throw new OutOfMemoryError();
        }
        Resources resources = this.getResources();
        if (resources != null) {
            bitmap.setDensity(resources.getDisplayMetrics().densityDpi);
        }
        if (attachInfo != null) {
            canvas = attachInfo.mCanvas;
            if (canvas == null) {
                canvas = new Canvas();
            }
            canvas.setBitmap(bitmap);
            attachInfo.mCanvas = null;
        } else {
            canvas = new Canvas(bitmap);
        }
        if ((backgroundColor & 0xFF000000) != 0) {
            bitmap.eraseColor(backgroundColor);
        }
        this.computeScroll();
        int restoreCount = canvas.save();
        canvas.scale(scale, scale);
        canvas.translate(-this.mScrollX, -this.mScrollY);
        int flags = this.mPrivateFlags;
        this.mPrivateFlags &= 0xFF9FFFFF;
        if ((this.mPrivateFlags & 0x80) == 128) {
            this.dispatchDraw(canvas);
        } else {
            this.draw(canvas);
        }
        this.mPrivateFlags = flags;
        canvas.restoreToCount(restoreCount);
        canvas.setBitmap(null);
        if (attachInfo != null) {
            attachInfo.mCanvas = canvas;
        }
        return bitmap;
    }

    public boolean isInEditMode_Original() {
        return false;
    }

    @LayoutlibDelegate
    public boolean isInEditMode() {
        return View_Delegate.isInEditMode(this);
    }

    protected boolean isPaddingOffsetRequired() {
        return false;
    }

    protected int getLeftPaddingOffset() {
        return 0;
    }

    protected int getRightPaddingOffset() {
        return 0;
    }

    protected int getTopPaddingOffset() {
        return 0;
    }

    protected int getBottomPaddingOffset() {
        return 0;
    }

    protected int getFadeTop(boolean offsetRequired) {
        int top = this.mPaddingTop;
        if (offsetRequired) {
            top += this.getTopPaddingOffset();
        }
        return top;
    }

    protected int getFadeHeight(boolean offsetRequired) {
        int padding = this.mPaddingTop;
        if (offsetRequired) {
            padding += this.getTopPaddingOffset();
        }
        return this.mBottom - this.mTop - this.mPaddingBottom - padding;
    }

    public boolean isHardwareAccelerated() {
        return this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerated;
    }

    public void draw(Canvas canvas) {
        boolean verticalEdges;
        int viewFlags;
        Drawable background;
        int privateFlags = this.mPrivateFlags;
        boolean dirtyOpaque = (privateFlags & 0x600000) == 0x400000 && (this.mAttachInfo == null || !this.mAttachInfo.mIgnoreDirtyState);
        this.mPrivateFlags = privateFlags & 0xFF9FFFFF | 0x20;
        if (!dirtyOpaque && (background = this.mBGDrawable) != null) {
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            if (this.mBackgroundSizeChanged) {
                background.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                this.mBackgroundSizeChanged = false;
            }
            if ((scrollX | scrollY) == 0) {
                background.draw(canvas);
            } else {
                canvas.translate(scrollX, scrollY);
                background.draw(canvas);
                canvas.translate(-scrollX, -scrollY);
            }
        }
        boolean horizontalEdges = ((viewFlags = this.mViewFlags) & 0x1000) != 0;
        boolean bl = verticalEdges = (viewFlags & 0x2000) != 0;
        if (!verticalEdges && !horizontalEdges) {
            if (!dirtyOpaque) {
                this.onDraw(canvas);
            }
            this.dispatchDraw(canvas);
            this.onDrawScrollBars(canvas);
            return;
        }
        boolean drawTop = false;
        boolean drawBottom = false;
        boolean drawLeft = false;
        boolean drawRight = false;
        float topFadeStrength = 0.0f;
        float bottomFadeStrength = 0.0f;
        float leftFadeStrength = 0.0f;
        float rightFadeStrength = 0.0f;
        int paddingLeft = this.mPaddingLeft;
        boolean offsetRequired = this.isPaddingOffsetRequired();
        if (offsetRequired) {
            paddingLeft += this.getLeftPaddingOffset();
        }
        int left = this.mScrollX + paddingLeft;
        int right = left + this.mRight - this.mLeft - this.mPaddingRight - paddingLeft;
        int top = this.mScrollY + this.getFadeTop(offsetRequired);
        int bottom = top + this.getFadeHeight(offsetRequired);
        if (offsetRequired) {
            right += this.getRightPaddingOffset();
            bottom += this.getBottomPaddingOffset();
        }
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        float fadeHeight = scrollabilityCache.fadingEdgeLength;
        int length = (int)fadeHeight;
        if (verticalEdges && top + length > bottom - length) {
            length = (bottom - top) / 2;
        }
        if (horizontalEdges && left + length > right - length) {
            length = (right - left) / 2;
        }
        if (verticalEdges) {
            topFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getTopFadingEdgeStrength()));
            drawTop = topFadeStrength * fadeHeight > 1.0f;
            bottomFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getBottomFadingEdgeStrength()));
            boolean bl2 = drawBottom = bottomFadeStrength * fadeHeight > 1.0f;
        }
        if (horizontalEdges) {
            leftFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getLeftFadingEdgeStrength()));
            drawLeft = leftFadeStrength * fadeHeight > 1.0f;
            rightFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getRightFadingEdgeStrength()));
            drawRight = rightFadeStrength * fadeHeight > 1.0f;
        }
        int saveCount = canvas.getSaveCount();
        int solidColor = this.getSolidColor();
        if (solidColor == 0) {
            int flags = 4;
            if (drawTop) {
                canvas.saveLayer(left, top, right, top + length, null, 4);
            }
            if (drawBottom) {
                canvas.saveLayer(left, bottom - length, right, bottom, null, 4);
            }
            if (drawLeft) {
                canvas.saveLayer(left, top, left + length, bottom, null, 4);
            }
            if (drawRight) {
                canvas.saveLayer(right - length, top, right, bottom, null, 4);
            }
        } else {
            scrollabilityCache.setFadeColor(solidColor);
        }
        if (!dirtyOpaque) {
            this.onDraw(canvas);
        }
        this.dispatchDraw(canvas);
        Paint p = scrollabilityCache.paint;
        Matrix matrix = scrollabilityCache.matrix;
        Shader fade = scrollabilityCache.shader;
        if (drawTop) {
            matrix.setScale(1.0f, fadeHeight * topFadeStrength);
            matrix.postTranslate(left, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, top, right, top + length, p);
        }
        if (drawBottom) {
            matrix.setScale(1.0f, fadeHeight * bottomFadeStrength);
            matrix.postRotate(180.0f);
            matrix.postTranslate(left, bottom);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, bottom - length, right, bottom, p);
        }
        if (drawLeft) {
            matrix.setScale(1.0f, fadeHeight * leftFadeStrength);
            matrix.postRotate(-90.0f);
            matrix.postTranslate(left, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, top, left + length, bottom, p);
        }
        if (drawRight) {
            matrix.setScale(1.0f, fadeHeight * rightFadeStrength);
            matrix.postRotate(90.0f);
            matrix.postTranslate(right, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(right - length, top, right, bottom, p);
        }
        canvas.restoreToCount(saveCount);
        this.onDrawScrollBars(canvas);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public int getSolidColor() {
        return 0;
    }

    private static String printFlags(int flags) {
        String output = "";
        int numFlags = 0;
        if ((flags & 1) == 1) {
            output = output + "TAKES_FOCUS";
            ++numFlags;
        }
        switch (flags & 0xC) {
            case 4: {
                if (numFlags > 0) {
                    output = output + " ";
                }
                output = output + "INVISIBLE";
                break;
            }
            case 8: {
                if (numFlags > 0) {
                    output = output + " ";
                }
                output = output + "GONE";
                break;
            }
        }
        return output;
    }

    private static String printPrivateFlags(int privateFlags) {
        String output = "";
        int numFlags = 0;
        if ((privateFlags & 1) == 1) {
            output = output + "WANTS_FOCUS";
            ++numFlags;
        }
        if ((privateFlags & 2) == 2) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "FOCUSED";
            ++numFlags;
        }
        if ((privateFlags & 4) == 4) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "SELECTED";
            ++numFlags;
        }
        if ((privateFlags & 8) == 8) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "IS_ROOT_NAMESPACE";
            ++numFlags;
        }
        if ((privateFlags & 0x10) == 16) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "HAS_BOUNDS";
            ++numFlags;
        }
        if ((privateFlags & 0x20) == 32) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "DRAWN";
        }
        return output;
    }

    public boolean isLayoutRequested() {
        return (this.mPrivateFlags & 0x1000) == 4096;
    }

    public void layout(int l, int t, int r, int b) {
        int oldL = this.mLeft;
        int oldT = this.mTop;
        int oldB = this.mBottom;
        int oldR = this.mRight;
        boolean changed = this.setFrame(l, t, r, b);
        if (changed || (this.mPrivateFlags & 0x2000) == 8192) {
            this.onLayout(changed, l, t, r, b);
            this.mPrivateFlags &= 0xFFFFDFFF;
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnLayoutChangeListeners != null) {
                ArrayList listenersCopy = (ArrayList)li.mOnLayoutChangeListeners.clone();
                int numListeners = listenersCopy.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((OnLayoutChangeListener)listenersCopy.get(i)).onLayoutChange(this, l, t, r, b, oldL, oldT, oldR, oldB);
                }
            }
        }
        this.mPrivateFlags &= 0xFFFFEFFF;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = false;
        if (this.mLeft != left || this.mRight != right || this.mTop != top || this.mBottom != bottom) {
            changed = true;
            int drawn = this.mPrivateFlags & 0x20;
            int oldWidth = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            int newWidth = right - left;
            int newHeight = bottom - top;
            boolean sizeChanged = newWidth != oldWidth || newHeight != oldHeight;
            this.invalidate(sizeChanged);
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mPrivateFlags |= 0x10;
            if (sizeChanged) {
                if ((this.mPrivateFlags & 0x20000000) == 0 && this.mTransformationInfo != null) {
                    this.mTransformationInfo.mMatrixDirty = true;
                }
                this.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
            }
            if ((this.mViewFlags & 0xC) == 0) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(sizeChanged);
                this.invalidateParentCaches();
            }
            this.mPrivateFlags |= drawn;
            this.mBackgroundSizeChanged = true;
        }
        return changed;
    }

    protected void onFinishInflate() {
    }

    public Resources getResources() {
        return this.mResources;
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.verifyDrawable(who) && what != null) {
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mHandler.postAtTime(what, who, when);
            } else {
                ViewRootImpl.getRunQueue().postDelayed(what, when - SystemClock.uptimeMillis());
            }
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (this.verifyDrawable(who) && what != null) {
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mHandler.removeCallbacks(what, who);
            } else {
                ViewRootImpl.getRunQueue().removeCallbacks(what);
            }
        }
    }

    public void unscheduleDrawable(Drawable who) {
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mHandler.removeCallbacksAndMessages(who);
        }
    }

    @Override
    public int getResolvedLayoutDirection(Drawable who) {
        return who == this.mBGDrawable ? this.getResolvedLayoutDirection() : Integer.MIN_VALUE;
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mBGDrawable;
    }

    protected void drawableStateChanged() {
        Drawable d = this.mBGDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    public void refreshDrawableState() {
        this.mPrivateFlags |= 0x400;
        this.drawableStateChanged();
        ViewParent parent = this.mParent;
        if (parent != null) {
            parent.childDrawableStateChanged(this);
        }
    }

    public int[] getDrawableState() {
        if (this.mDrawableState != null && (this.mPrivateFlags & 0x400) == 0) {
            return this.mDrawableState;
        }
        this.mDrawableState = this.onCreateDrawableState(0);
        this.mPrivateFlags &= 0xFFFFFBFF;
        return this.mDrawableState;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] fullState;
        int privateFlags2;
        if ((this.mViewFlags & 0x400000) == 0x400000 && this.mParent instanceof View) {
            return ((View)((Object)this.mParent)).onCreateDrawableState(extraSpace);
        }
        int privateFlags = this.mPrivateFlags;
        int viewStateIndex = 0;
        if ((privateFlags & 0x4000) != 0) {
            viewStateIndex |= 0x10;
        }
        if ((this.mViewFlags & 0x20) == 0) {
            viewStateIndex |= 8;
        }
        if (this.isFocused()) {
            viewStateIndex |= 4;
        }
        if ((privateFlags & 4) != 0) {
            viewStateIndex |= 2;
        }
        if (this.hasWindowFocus()) {
            viewStateIndex |= 1;
        }
        if ((privateFlags & 0x40000000) != 0) {
            viewStateIndex |= 0x20;
        }
        if (this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerationRequested && HardwareRenderer.isAvailable()) {
            viewStateIndex |= 0x40;
        }
        if ((privateFlags & 0x10000000) != 0) {
            viewStateIndex |= 0x80;
        }
        if (((privateFlags2 = this.mPrivateFlags2) & 1) != 0) {
            viewStateIndex |= 0x100;
        }
        if ((privateFlags2 & 2) != 0) {
            viewStateIndex |= 0x200;
        }
        int[] drawableState = VIEW_STATE_SETS[viewStateIndex];
        if (extraSpace == 0) {
            return drawableState;
        }
        if (drawableState != null) {
            fullState = new int[drawableState.length + extraSpace];
            System.arraycopy(drawableState, 0, fullState, 0, drawableState.length);
        } else {
            fullState = new int[extraSpace];
        }
        return fullState;
    }

    protected static int[] mergeDrawableStates(int[] baseState, int[] additionalState) {
        int i;
        int N = baseState.length;
        for (i = N - 1; i >= 0 && baseState[i] == 0; --i) {
        }
        System.arraycopy(additionalState, 0, baseState, i + 1, additionalState.length);
        return baseState;
    }

    public void jumpDrawablesToCurrentState() {
        if (this.mBGDrawable != null) {
            this.mBGDrawable.jumpToCurrentState();
        }
    }

    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        if (this.mBGDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.mBGDrawable).setColor(color2);
        } else {
            this.setBackgroundDrawable(new ColorDrawable(color2));
        }
    }

    @RemotableViewMethod
    public void setBackgroundResource(int resid) {
        if (resid != 0 && resid == this.mBackgroundResource) {
            return;
        }
        Drawable d = null;
        if (resid != 0) {
            d = this.mResources.getDrawable(resid);
        }
        this.setBackgroundDrawable(d);
        this.mBackgroundResource = resid;
    }

    public void setBackgroundDrawable(Drawable d) {
        if (d == this.mBGDrawable) {
            return;
        }
        boolean requestLayout = false;
        this.mBackgroundResource = 0;
        if (this.mBGDrawable != null) {
            this.mBGDrawable.setCallback(null);
            this.unscheduleDrawable(this.mBGDrawable);
        }
        if (d != null) {
            Rect padding = sThreadLocal.get();
            if (padding == null) {
                padding = new Rect();
                sThreadLocal.set(padding);
            }
            if (d.getPadding(padding)) {
                switch (d.getResolvedLayoutDirectionSelf()) {
                    case 0x40000000: {
                        this.setPadding(padding.right, padding.top, padding.left, padding.bottom);
                        break;
                    }
                    default: {
                        this.setPadding(padding.left, padding.top, padding.right, padding.bottom);
                    }
                }
            }
            if (this.mBGDrawable == null || this.mBGDrawable.getMinimumHeight() != d.getMinimumHeight() || this.mBGDrawable.getMinimumWidth() != d.getMinimumWidth()) {
                requestLayout = true;
            }
            d.setCallback(this);
            if (d.isStateful()) {
                d.setState(this.getDrawableState());
            }
            d.setVisible(this.getVisibility() == 0, false);
            this.mBGDrawable = d;
            if ((this.mPrivateFlags & 0x80) != 0) {
                this.mPrivateFlags &= 0xFFFFFF7F;
                this.mPrivateFlags |= 0x100;
                requestLayout = true;
            }
        } else {
            this.mBGDrawable = null;
            if ((this.mPrivateFlags & 0x100) != 0) {
                this.mPrivateFlags &= 0xFFFFFEFF;
                this.mPrivateFlags |= 0x80;
            }
            requestLayout = true;
        }
        this.computeOpaqueFlags();
        if (requestLayout) {
            this.requestLayout();
        }
        this.mBackgroundSizeChanged = true;
        this.invalidate(true);
    }

    public Drawable getBackground() {
        return this.mBGDrawable;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        boolean changed = false;
        this.mUserPaddingRelative = false;
        this.mUserPaddingLeft = left;
        this.mUserPaddingRight = right;
        this.mUserPaddingBottom = bottom;
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x300) != 0) {
            if ((viewFlags & 0x200) != 0) {
                int offset = (viewFlags & 0x1000000) == 0 ? 0 : this.getVerticalScrollbarWidth();
                switch (this.mVerticalScrollbarPosition) {
                    case 0: {
                        if (this.getResolvedLayoutDirection() == 0x40000000) {
                            left += offset;
                            break;
                        }
                        right += offset;
                        break;
                    }
                    case 2: {
                        right += offset;
                        break;
                    }
                    case 1: {
                        left += offset;
                    }
                }
            }
            if ((viewFlags & 0x100) != 0) {
                bottom += (viewFlags & 0x1000000) == 0 ? 0 : this.getHorizontalScrollbarHeight();
            }
        }
        if (this.mPaddingLeft != left) {
            changed = true;
            this.mPaddingLeft = left;
        }
        if (this.mPaddingTop != top) {
            changed = true;
            this.mPaddingTop = top;
        }
        if (this.mPaddingRight != right) {
            changed = true;
            this.mPaddingRight = right;
        }
        if (this.mPaddingBottom != bottom) {
            changed = true;
            this.mPaddingBottom = bottom;
        }
        if (changed) {
            this.requestLayout();
        }
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        this.mUserPaddingRelative = true;
        this.mUserPaddingStart = start;
        this.mUserPaddingEnd = end;
        switch (this.getResolvedLayoutDirection()) {
            case 0x40000000: {
                this.setPadding(end, top, start, bottom);
                break;
            }
            default: {
                this.setPadding(start, top, end, bottom);
            }
        }
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingStart() {
        return this.getResolvedLayoutDirection() == 0x40000000 ? this.mPaddingRight : this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingEnd() {
        return this.getResolvedLayoutDirection() == 0x40000000 ? this.mPaddingLeft : this.mPaddingRight;
    }

    public boolean isPaddingRelative() {
        return this.mUserPaddingRelative;
    }

    public void setSelected(boolean selected) {
        if ((this.mPrivateFlags & 4) != 0 != selected) {
            this.mPrivateFlags = this.mPrivateFlags & 0xFFFFFFFB | (selected ? 4 : 0);
            if (!selected) {
                this.resetPressedState();
            }
            this.invalidate(true);
            this.refreshDrawableState();
            this.dispatchSetSelected(selected);
        }
    }

    protected void dispatchSetSelected(boolean selected) {
    }

    @ViewDebug.ExportedProperty
    public boolean isSelected() {
        return (this.mPrivateFlags & 4) != 0;
    }

    public void setActivated(boolean activated) {
        if ((this.mPrivateFlags & 0x40000000) != 0 != activated) {
            this.mPrivateFlags = this.mPrivateFlags & 0xBFFFFFFF | (activated ? 0x40000000 : 0);
            this.invalidate(true);
            this.refreshDrawableState();
            this.dispatchSetActivated(activated);
        }
    }

    protected void dispatchSetActivated(boolean activated) {
    }

    @ViewDebug.ExportedProperty
    public boolean isActivated() {
        return (this.mPrivateFlags & 0x40000000) != 0;
    }

    public ViewTreeObserver getViewTreeObserver() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mTreeObserver;
        }
        if (this.mFloatingTreeObserver == null) {
            this.mFloatingTreeObserver = new ViewTreeObserver();
        }
        return this.mFloatingTreeObserver;
    }

    public View getRootView() {
        View v;
        if (this.mAttachInfo != null && (v = this.mAttachInfo.mRootView) != null) {
            return v;
        }
        View parent = this;
        while (parent.mParent != null && parent.mParent instanceof View) {
            parent = (View)((Object)parent.mParent);
        }
        return parent;
    }

    public void getLocationOnScreen(int[] location) {
        this.getLocationInWindow(location);
        AttachInfo info = this.mAttachInfo;
        if (info != null) {
            location[0] = location[0] + info.mWindowLeft;
            location[1] = location[1] + info.mWindowTop;
        }
    }

    public void getLocationInWindow(int[] location) {
        if (this.mAttachInfo == null) {
            return;
        }
        if (location == null || location.length < 2) {
            throw new IllegalArgumentException("location must be an array of two integers");
        }
        float[] position = this.mAttachInfo.mTmpTransformLocation;
        position[1] = 0.0f;
        position[0] = 0.0f;
        if (!this.hasIdentityMatrix()) {
            this.getMatrix().mapPoints(position);
        }
        position[0] = position[0] + (float)this.mLeft;
        position[1] = position[1] + (float)this.mTop;
        ViewParent viewParent = this.mParent;
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            position[0] = position[0] - (float)view.mScrollX;
            position[1] = position[1] - (float)view.mScrollY;
            if (!view.hasIdentityMatrix()) {
                view.getMatrix().mapPoints(position);
            }
            position[0] = position[0] + (float)view.mLeft;
            position[1] = position[1] + (float)view.mTop;
            viewParent = view.mParent;
        }
        if (viewParent instanceof ViewRootImpl) {
            ViewRootImpl vr = (ViewRootImpl)viewParent;
            position[1] = position[1] - (float)vr.mCurScrollY;
        }
        location[0] = (int)(position[0] + 0.5f);
        location[1] = (int)(position[1] + 0.5f);
    }

    protected View findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return this;
        }
        return null;
    }

    protected View findViewWithTagTraversal(Object tag) {
        if (tag != null && tag.equals(this.mTag)) {
            return this;
        }
        return null;
    }

    protected View findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        if (predicate.apply(this)) {
            return this;
        }
        return null;
    }

    public View findViewById(int id2) {
        if (id2 < 0) {
            return null;
        }
        return this.findViewTraversal(id2);
    }

    View findViewByAccessibilityId(int accessibilityId) {
        if (accessibilityId < 0) {
            return null;
        }
        return this.findViewByAccessibilityIdTraversal(accessibilityId);
    }

    View findViewByAccessibilityIdTraversal(int accessibilityId) {
        if (this.getAccessibilityViewId() == accessibilityId) {
            return this;
        }
        return null;
    }

    public View findViewWithTag(Object tag) {
        if (tag == null) {
            return null;
        }
        return this.findViewWithTagTraversal(tag);
    }

    public View findViewByPredicate(Predicate<View> predicate) {
        return this.findViewByPredicateTraversal(predicate, null);
    }

    public View findViewByPredicateInsideOut(View start, Predicate<View> predicate) {
        View childToSkip = null;
        View view;
        while ((view = start.findViewByPredicateTraversal(predicate, childToSkip)) == null && start != this) {
            ViewParent parent = start.getParent();
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            childToSkip = start;
            start = (View)((Object)parent);
        }
        return view;
    }

    public void setId(int id2) {
        this.mID = id2;
    }

    public void setIsRootNamespace(boolean isRoot) {
        this.mPrivateFlags = isRoot ? (this.mPrivateFlags |= 8) : (this.mPrivateFlags &= 0xFFFFFFF7);
    }

    public boolean isRootNamespace() {
        return (this.mPrivateFlags & 8) != 0;
    }

    @ViewDebug.CapturedViewProperty
    public int getId() {
        return this.mID;
    }

    @ViewDebug.ExportedProperty
    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public Object getTag(int key) {
        if (this.mKeyedTags != null) {
            return this.mKeyedTags.get(key);
        }
        return null;
    }

    public void setTag(int key, Object tag) {
        if (key >>> 24 < 2) {
            throw new IllegalArgumentException("The key must be an application-specific resource id.");
        }
        this.setKeyedTag(key, tag);
    }

    public void setTagInternal(int key, Object tag) {
        if (key >>> 24 != 1) {
            throw new IllegalArgumentException("The key must be a framework-specific resource id.");
        }
        this.setKeyedTag(key, tag);
    }

    private void setKeyedTag(int key, Object tag) {
        if (this.mKeyedTags == null) {
            this.mKeyedTags = new SparseArray();
        }
        this.mKeyedTags.put(key, tag);
    }

    protected boolean dispatchConsistencyCheck(int consistency) {
        return this.onConsistencyCheck(consistency);
    }

    protected boolean onConsistencyCheck(int consistency) {
        boolean checkDrawing;
        boolean result = true;
        boolean checkLayout = (consistency & 1) != 0;
        boolean bl = checkDrawing = (consistency & 2) != 0;
        if (checkLayout) {
            if (this.getParent() == null) {
                result = false;
                Log.d("ViewConsistency", "View " + this + " does not have a parent.");
            }
            if (this.mAttachInfo == null) {
                result = false;
                Log.d("ViewConsistency", "View " + this + " is not attached to a window.");
            }
        }
        if (checkDrawing && (this.mPrivateFlags & 0x20) != 32 && (this.mPrivateFlags & 0x8000) == 32768) {
            result = false;
            Log.d("ViewConsistency", "View " + this + " was invalidated but its drawing cache is valid.");
        }
        return result;
    }

    public void debug() {
        this.debug(0);
    }

    protected void debug(int depth) {
        Object tag;
        String output = View.debugIndent(depth - 1);
        output = output + "+ " + this;
        int id2 = this.getId();
        if (id2 != -1) {
            output = output + " (id=" + id2 + ")";
        }
        if ((tag = this.getTag()) != null) {
            output = output + " (tag=" + tag + ")";
        }
        Log.d(VIEW_LOG_TAG, output);
        if ((this.mPrivateFlags & 2) != 0) {
            output = View.debugIndent(depth) + " FOCUSED";
            Log.d(VIEW_LOG_TAG, output);
        }
        output = View.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        Log.d(VIEW_LOG_TAG, output);
        if (this.mPaddingLeft != 0 || this.mPaddingTop != 0 || this.mPaddingRight != 0 || this.mPaddingBottom != 0) {
            output = View.debugIndent(depth);
            output = output + "padding={" + this.mPaddingLeft + ", " + this.mPaddingTop + ", " + this.mPaddingRight + ", " + this.mPaddingBottom + "}";
            Log.d(VIEW_LOG_TAG, output);
        }
        output = View.debugIndent(depth);
        output = output + "mMeasureWidth=" + this.mMeasuredWidth + " mMeasureHeight=" + this.mMeasuredHeight;
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = this.mLayoutParams == null ? output + "BAD! no layout params" : this.mLayoutParams.debug(output);
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = output + "flags={";
        output = output + View.printFlags(this.mViewFlags);
        output = output + "}";
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = output + "privateFlags={";
        output = output + View.printPrivateFlags(this.mPrivateFlags);
        output = output + "}";
        Log.d(VIEW_LOG_TAG, output);
    }

    protected static String debugIndent(int depth) {
        StringBuilder spaces = new StringBuilder((depth * 2 + 3) * 2);
        for (int i = 0; i < depth * 2 + 3; ++i) {
            spaces.append(' ').append(' ');
        }
        return spaces.toString();
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getBaseline() {
        return -1;
    }

    public void requestLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (this.mParent != null) {
            if (this.mLayoutParams != null) {
                this.mLayoutParams.resolveWithDirection(this.getResolvedLayoutDirection());
            }
            if (!this.mParent.isLayoutRequested()) {
                this.mParent.requestLayout();
            }
        }
    }

    public void forceLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
    }

    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        if ((this.mPrivateFlags & 0x1000) == 4096 || widthMeasureSpec != this.mOldWidthMeasureSpec || heightMeasureSpec != this.mOldHeightMeasureSpec) {
            this.mPrivateFlags &= 0xFFFFF7FF;
            this.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if ((this.mPrivateFlags & 0x800) != 2048) {
                throw new IllegalStateException("onMeasure() did not set the measured dimension by calling setMeasuredDimension()");
            }
            this.mPrivateFlags |= 0x2000;
        }
        this.mOldWidthMeasureSpec = widthMeasureSpec;
        this.mOldHeightMeasureSpec = heightMeasureSpec;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.getDefaultSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), View.getDefaultSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    protected void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.mMeasuredWidth = measuredWidth;
        this.mMeasuredHeight = measuredHeight;
        this.mPrivateFlags |= 0x800;
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    public static int resolveSize(int size, int measureSpec) {
        return View.resolveSizeAndState(size, measureSpec, 0) & 0xFFFFFF;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    public static int getDefaultSize(int size, int measureSpec) {
        int result = size;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: 
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    protected int getSuggestedMinimumHeight() {
        int bgMinHeight;
        int suggestedMinHeight = this.mMinHeight;
        if (this.mBGDrawable != null && suggestedMinHeight < (bgMinHeight = this.mBGDrawable.getMinimumHeight())) {
            suggestedMinHeight = bgMinHeight;
        }
        return suggestedMinHeight;
    }

    protected int getSuggestedMinimumWidth() {
        int bgMinWidth;
        int suggestedMinWidth = this.mMinWidth;
        if (this.mBGDrawable != null && suggestedMinWidth < (bgMinWidth = this.mBGDrawable.getMinimumWidth())) {
            suggestedMinWidth = bgMinWidth;
        }
        return suggestedMinWidth;
    }

    public void setMinimumHeight(int minHeight) {
        this.mMinHeight = minHeight;
    }

    public void setMinimumWidth(int minWidth) {
        this.mMinWidth = minWidth;
    }

    public Animation getAnimation() {
        return this.mCurrentAnimation;
    }

    public void startAnimation(Animation animation) {
        animation.setStartTime(-1L);
        this.setAnimation(animation);
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    public void clearAnimation() {
        if (this.mCurrentAnimation != null) {
            this.mCurrentAnimation.detach();
        }
        this.mCurrentAnimation = null;
        this.invalidateParentIfNeeded();
    }

    public void setAnimation(Animation animation) {
        this.mCurrentAnimation = animation;
        if (animation != null) {
            animation.reset();
        }
    }

    protected void onAnimationStart() {
        this.mPrivateFlags |= 0x10000;
    }

    protected void onAnimationEnd() {
        this.mPrivateFlags &= 0xFFFEFFFF;
    }

    protected boolean onSetAlpha(int alpha) {
        return false;
    }

    public boolean gatherTransparentRegion(Region region) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (region != null && attachInfo != null) {
            int pflags = this.mPrivateFlags;
            if ((pflags & 0x80) == 0) {
                int[] location = attachInfo.mTransparentLocation;
                this.getLocationInWindow(location);
                region.op(location[0], location[1], location[0] + this.mRight - this.mLeft, location[1] + this.mBottom - this.mTop, Region.Op.DIFFERENCE);
            } else if ((pflags & 0x100) != 0 && this.mBGDrawable != null) {
                this.applyDrawableToTransparentRegion(this.mBGDrawable, region);
            }
        }
        return true;
    }

    public void playSoundEffect(int soundConstant) {
        if (this.mAttachInfo == null || this.mAttachInfo.mRootCallbacks == null || !this.isSoundEffectsEnabled()) {
            return;
        }
        this.mAttachInfo.mRootCallbacks.playSoundEffect(soundConstant);
    }

    public boolean performHapticFeedback(int feedbackConstant) {
        return this.performHapticFeedback(feedbackConstant, 0);
    }

    public boolean performHapticFeedback(int feedbackConstant, int flags) {
        if (this.mAttachInfo == null) {
            return false;
        }
        if ((flags & 1) == 0 && !this.isHapticFeedbackEnabled()) {
            return false;
        }
        return this.mAttachInfo.mRootCallbacks.performHapticFeedback(feedbackConstant, (flags & 2) != 0);
    }

    public void setSystemUiVisibility(int visibility) {
        if (visibility != this.mSystemUiVisibility) {
            this.mSystemUiVisibility = visibility;
            if (this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
                this.mParent.recomputeViewAttributes(this);
            }
        }
    }

    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    public void setOnSystemUiVisibilityChangeListener(OnSystemUiVisibilityChangeListener l) {
        this.getListenerInfo().mOnSystemUiVisibilityChangeListener = l;
        if (this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mParent.recomputeViewAttributes(this);
        }
    }

    public void dispatchSystemUiVisibilityChanged(int visibility) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnSystemUiVisibilityChangeListener != null) {
            li.mOnSystemUiVisibilityChangeListener.onSystemUiVisibilityChange(visibility & 0xFFFF);
        }
    }

    void updateLocalSystemUiVisibility(int localValue, int localChanges) {
        int val = this.mSystemUiVisibility & ~localChanges | localValue & localChanges;
        if (val != this.mSystemUiVisibility) {
            this.setSystemUiVisibility(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDrag(ClipData data, DragShadowBuilder shadowBuilder, Object myLocalState, int flags) {
        boolean okay;
        block6: {
            okay = false;
            Point shadowSize = new Point();
            Point shadowTouchPoint = new Point();
            shadowBuilder.onProvideShadowMetrics(shadowSize, shadowTouchPoint);
            if (shadowSize.x < 0 || shadowSize.y < 0 || shadowTouchPoint.x < 0 || shadowTouchPoint.y < 0) {
                throw new IllegalStateException("Drag shadow dimensions must not be negative");
            }
            Surface surface = new Surface();
            try {
                IBinder token = this.mAttachInfo.mSession.prepareDrag(this.mAttachInfo.mWindow, flags, shadowSize.x, shadowSize.y, surface);
                if (token == null) break block6;
                Canvas canvas = surface.lockCanvas(null);
                try {
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    shadowBuilder.onDrawShadow(canvas);
                }
                finally {
                    surface.unlockCanvasAndPost(canvas);
                }
                ViewRootImpl root = this.getViewRootImpl();
                root.setLocalDragState(myLocalState);
                root.getLastTouchPoint(shadowSize);
                okay = this.mAttachInfo.mSession.performDrag(this.mAttachInfo.mWindow, token, shadowSize.x, shadowSize.y, shadowTouchPoint.x, shadowTouchPoint.y, data);
                surface.release();
            }
            catch (Exception e) {
                Log.e(VIEW_LOG_TAG, "Unable to initiate drag", e);
                surface.destroy();
            }
        }
        return okay;
    }

    public boolean onDragEvent(DragEvent event) {
        return false;
    }

    public boolean dispatchDragEvent(DragEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnDragListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnDragListener.onDrag(this, event)) {
            return true;
        }
        return this.onDragEvent(event);
    }

    boolean canAcceptDrag() {
        return (this.mPrivateFlags2 & 1) != 0;
    }

    public void onCloseSystemDialogs(String reason) {
    }

    public void applyDrawableToTransparentRegion(Drawable dr, Region region) {
        Region r = dr.getTransparentRegion();
        Rect db = dr.getBounds();
        AttachInfo attachInfo = this.mAttachInfo;
        if (r != null && attachInfo != null) {
            int w = this.getRight() - this.getLeft();
            int h = this.getBottom() - this.getTop();
            if (db.left > 0) {
                r.op(0, 0, db.left, h, Region.Op.UNION);
            }
            if (db.right < w) {
                r.op(db.right, 0, w, h, Region.Op.UNION);
            }
            if (db.top > 0) {
                r.op(0, 0, w, db.top, Region.Op.UNION);
            }
            if (db.bottom < h) {
                r.op(0, db.bottom, w, h, Region.Op.UNION);
            }
            int[] location = attachInfo.mTransparentLocation;
            this.getLocationInWindow(location);
            r.translate(location[0], location[1]);
            region.op(r, Region.Op.INTERSECT);
        } else {
            region.op(db, Region.Op.DIFFERENCE);
        }
    }

    private void checkForLongClick(int delayOffset) {
        if ((this.mViewFlags & 0x200000) == 0x200000) {
            this.mHasPerformedLongPress = false;
            if (this.mPendingCheckForLongPress == null) {
                this.mPendingCheckForLongPress = new CheckForLongPress();
            }
            this.mPendingCheckForLongPress.rememberWindowAttachCount();
            this.postDelayed(this.mPendingCheckForLongPress, ViewConfiguration.getLongPressTimeout() - delayOffset);
        }
    }

    public static View inflate(Context context, int resource, ViewGroup root) {
        LayoutInflater factory = LayoutInflater.from(context);
        return factory.inflate(resource, root);
    }

    protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        int overScrollMode = this.mOverScrollMode;
        boolean canScrollHorizontal = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean canScrollVertical = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        boolean overScrollHorizontal = overScrollMode == 0 || overScrollMode == 1 && canScrollHorizontal;
        boolean overScrollVertical = overScrollMode == 0 || overScrollMode == 1 && canScrollVertical;
        int newScrollX = scrollX + deltaX;
        if (!overScrollHorizontal) {
            maxOverScrollX = 0;
        }
        int newScrollY = scrollY + deltaY;
        if (!overScrollVertical) {
            maxOverScrollY = 0;
        }
        int left = -maxOverScrollX;
        int right = maxOverScrollX + scrollRangeX;
        int top = -maxOverScrollY;
        int bottom = maxOverScrollY + scrollRangeY;
        boolean clampedX = false;
        if (newScrollX > right) {
            newScrollX = right;
            clampedX = true;
        } else if (newScrollX < left) {
            newScrollX = left;
            clampedX = true;
        }
        boolean clampedY = false;
        if (newScrollY > bottom) {
            newScrollY = bottom;
            clampedY = true;
        } else if (newScrollY < top) {
            newScrollY = top;
            clampedY = true;
        }
        this.onOverScrolled(newScrollX, newScrollY, clampedX, clampedY);
        return clampedX || clampedY;
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
    }

    public int getOverScrollMode() {
        return this.mOverScrollMode;
    }

    public void setOverScrollMode(int overScrollMode) {
        if (overScrollMode != 0 && overScrollMode != 1 && overScrollMode != 2) {
            throw new IllegalArgumentException("Invalid overscroll mode " + overScrollMode);
        }
        this.mOverScrollMode = overScrollMode;
    }

    protected float getVerticalScrollFactor() {
        if (this.mVerticalScrollFactor == 0.0f) {
            TypedValue outValue = new TypedValue();
            if (!this.mContext.getTheme().resolveAttribute(16842829, outValue, true)) {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
            this.mVerticalScrollFactor = outValue.getDimension(this.mContext.getResources().getDisplayMetrics());
        }
        return this.mVerticalScrollFactor;
    }

    protected float getHorizontalScrollFactor() {
        return this.getVerticalScrollFactor();
    }

    public int getTextDirection() {
        return this.mTextDirection;
    }

    public void setTextDirection(int textDirection) {
        if (textDirection != this.mTextDirection) {
            this.mTextDirection = textDirection;
            this.resetResolvedTextDirection();
            this.requestLayout();
        }
    }

    public int getResolvedTextDirection() {
        if (this.mResolvedTextDirection == 0) {
            this.resolveTextDirection();
        }
        return this.mResolvedTextDirection;
    }

    protected void resolveTextDirection() {
        if (this.mTextDirection != 0) {
            this.mResolvedTextDirection = this.mTextDirection;
            return;
        }
        if (this.mParent != null && this.mParent instanceof ViewGroup) {
            this.mResolvedTextDirection = ((ViewGroup)this.mParent).getResolvedTextDirection();
            return;
        }
        this.mResolvedTextDirection = 1;
    }

    protected void resetResolvedTextDirection() {
        this.mResolvedTextDirection = 0;
    }

    public void hackTurnOffWindowResizeAnim(boolean off) {
        this.mAttachInfo.mTurnOffWindowResizeAnim = off;
    }

    public ViewPropertyAnimator animate() {
        if (this.mAnimator == null) {
            this.mAnimator = new ViewPropertyAnimator(this);
        }
        return this.mAnimator;
    }

    static {
        VIEW_STATE_IDS = new int[]{16842909, 1, 0x10100A1, 2, 16842908, 4, 16842910, 8, 16842919, 16, 16843518, 32, 16843547, 64, 16843623, 128, 16843624, 256, 16843625, 512};
        if (VIEW_STATE_IDS.length / 2 != R.styleable.ViewDrawableStates.length) {
            throw new IllegalStateException("VIEW_STATE_IDs array length does not match ViewDrawableStates style array");
        }
        int[] orderedIds = new int[VIEW_STATE_IDS.length];
        for (int i = 0; i < R.styleable.ViewDrawableStates.length; ++i) {
            int viewState = R.styleable.ViewDrawableStates[i];
            for (int j = 0; j < VIEW_STATE_IDS.length; j += 2) {
                if (VIEW_STATE_IDS[j] != viewState) continue;
                orderedIds[i * 2] = viewState;
                orderedIds[i * 2 + 1] = VIEW_STATE_IDS[j + 1];
            }
        }
        int NUM_BITS = VIEW_STATE_IDS.length / 2;
        VIEW_STATE_SETS = new int[1 << NUM_BITS][];
        for (int i = 0; i < VIEW_STATE_SETS.length; ++i) {
            int numBits = Integer.bitCount(i);
            int[] set = new int[numBits];
            int pos = 0;
            for (int j = 0; j < orderedIds.length; j += 2) {
                if ((i & orderedIds[j + 1]) == 0) continue;
                set[pos++] = orderedIds[j];
            }
            View.VIEW_STATE_SETS[i] = set;
        }
        EMPTY_STATE_SET = VIEW_STATE_SETS[0];
        WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[1];
        SELECTED_STATE_SET = VIEW_STATE_SETS[2];
        SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[3];
        FOCUSED_STATE_SET = VIEW_STATE_SETS[4];
        FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[5];
        FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[6];
        FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[7];
        ENABLED_STATE_SET = VIEW_STATE_SETS[8];
        ENABLED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[9];
        ENABLED_SELECTED_STATE_SET = VIEW_STATE_SETS[10];
        ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[11];
        ENABLED_FOCUSED_STATE_SET = VIEW_STATE_SETS[12];
        ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[13];
        ENABLED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[14];
        ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[15];
        PRESSED_STATE_SET = VIEW_STATE_SETS[16];
        PRESSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[17];
        PRESSED_SELECTED_STATE_SET = VIEW_STATE_SETS[18];
        PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[19];
        PRESSED_FOCUSED_STATE_SET = VIEW_STATE_SETS[20];
        PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[21];
        PRESSED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[22];
        PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[23];
        PRESSED_ENABLED_STATE_SET = VIEW_STATE_SETS[24];
        PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[25];
        PRESSED_ENABLED_SELECTED_STATE_SET = VIEW_STATE_SETS[26];
        PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[27];
        PRESSED_ENABLED_FOCUSED_STATE_SET = VIEW_STATE_SETS[28];
        PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[29];
        PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[30];
        PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[31];
        sThreadLocal = new ThreadLocal();
        DEFAULT_TEXT_DIRECTION = 0;
        ALPHA = new FloatProperty<View>("alpha"){

            @Override
            public void setValue(View object, float value) {
                object.setAlpha(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getAlpha());
            }
        };
        TRANSLATION_X = new FloatProperty<View>("translationX"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationX());
            }
        };
        TRANSLATION_Y = new FloatProperty<View>("translationY"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationY());
            }
        };
        X = new FloatProperty<View>("x"){

            @Override
            public void setValue(View object, float value) {
                object.setX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getX());
            }
        };
        Y = new FloatProperty<View>("y"){

            @Override
            public void setValue(View object, float value) {
                object.setY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getY());
            }
        };
        ROTATION = new FloatProperty<View>("rotation"){

            @Override
            public void setValue(View object, float value) {
                object.setRotation(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotation());
            }
        };
        ROTATION_X = new FloatProperty<View>("rotationX"){

            @Override
            public void setValue(View object, float value) {
                object.setRotationX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotationX());
            }
        };
        ROTATION_Y = new FloatProperty<View>("rotationY"){

            @Override
            public void setValue(View object, float value) {
                object.setRotationY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotationY());
            }
        };
        SCALE_X = new FloatProperty<View>("scaleX"){

            @Override
            public void setValue(View object, float value) {
                object.setScaleX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getScaleX());
            }
        };
        SCALE_Y = new FloatProperty<View>("scaleY"){

            @Override
            public void setValue(View object, float value) {
                object.setScaleY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getScaleY());
            }
        };
    }

    public static class AccessibilityDelegate {
        public void sendAccessibilityEvent(View host, int eventType) {
            host.sendAccessibilityEventInternal(eventType);
        }

        public void sendAccessibilityEventUnchecked(View host, AccessibilityEvent event) {
            host.sendAccessibilityEventUncheckedInternal(event);
        }

        public boolean dispatchPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            return host.dispatchPopulateAccessibilityEventInternal(event);
        }

        public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            host.onPopulateAccessibilityEventInternal(event);
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            host.onInitializeAccessibilityEventInternal(event);
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            host.onInitializeAccessibilityNodeInfoInternal(info);
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            return host.onRequestSendAccessibilityEventInternal(child, event);
        }
    }

    private class SendViewScrolledAccessibilityEvent
    implements Runnable {
        public volatile boolean mIsPending;

        private SendViewScrolledAccessibilityEvent() {
        }

        public void run() {
            View.this.sendAccessibilityEvent(4096);
            this.mIsPending = false;
        }
    }

    private static class ScrollabilityCache
    implements Runnable {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FADING = 2;
        public boolean fadeScrollBars;
        public int fadingEdgeLength;
        public int scrollBarDefaultDelayBeforeFade;
        public int scrollBarFadeDuration;
        public int scrollBarSize;
        public ScrollBarDrawable scrollBar;
        public float[] interpolatorValues;
        public View host;
        public final Paint paint;
        public final Matrix matrix;
        public Shader shader;
        public final Interpolator scrollBarInterpolator = new Interpolator(1, 2);
        private static final float[] OPAQUE = new float[]{255.0f};
        private static final float[] TRANSPARENT = new float[]{0.0f};
        public long fadeStartTime;
        public int state = 0;
        private int mLastColor;

        public ScrollabilityCache(ViewConfiguration configuration, View host) {
            this.fadingEdgeLength = configuration.getScaledFadingEdgeLength();
            this.scrollBarSize = configuration.getScaledScrollBarSize();
            this.scrollBarDefaultDelayBeforeFade = ViewConfiguration.getScrollDefaultDelay();
            this.scrollBarFadeDuration = ViewConfiguration.getScrollBarFadeDuration();
            this.paint = new Paint();
            this.matrix = new Matrix();
            this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, -16777216, 0, Shader.TileMode.CLAMP);
            this.paint.setShader(this.shader);
            this.paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.host = host;
        }

        public void setFadeColor(int color2) {
            if (color2 != 0 && color2 != this.mLastColor) {
                this.mLastColor = color2;
                this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, (color2 |= 0xFF000000) | 0xFF000000, color2 & 0xFFFFFF, Shader.TileMode.CLAMP);
                this.paint.setShader(this.shader);
                this.paint.setXfermode(null);
            }
        }

        public void run() {
            long now = AnimationUtils.currentAnimationTimeMillis();
            if (now >= this.fadeStartTime) {
                int nextFrame = (int)now;
                int framesCount = 0;
                Interpolator interpolator2 = this.scrollBarInterpolator;
                interpolator2.setKeyFrame(framesCount++, nextFrame, OPAQUE);
                interpolator2.setKeyFrame(framesCount, nextFrame += this.scrollBarFadeDuration, TRANSPARENT);
                this.state = 2;
                this.host.invalidate(true);
            }
        }
    }

    static class AttachInfo {
        final IWindowSession mSession;
        final IWindow mWindow;
        final IBinder mWindowToken;
        final Callbacks mRootCallbacks;
        HardwareCanvas mHardwareCanvas;
        View mRootView;
        IBinder mPanelParentWindowToken;
        Surface mSurface;
        boolean mHardwareAccelerated;
        boolean mHardwareAccelerationRequested;
        HardwareRenderer mHardwareRenderer;
        float mApplicationScale;
        boolean mScalingRequired;
        boolean mTurnOffWindowResizeAnim;
        int mWindowLeft;
        int mWindowTop;
        boolean mUse32BitDrawingCache;
        final Rect mContentInsets = new Rect();
        final Rect mVisibleInsets = new Rect();
        final ViewTreeObserver.InternalInsetsInfo mGivenInternalInsets = new ViewTreeObserver.InternalInsetsInfo();
        final ArrayList<View> mScrollContainers = new ArrayList();
        final KeyEvent.DispatcherState mKeyDispatchState = new KeyEvent.DispatcherState();
        boolean mHasWindowFocus;
        int mWindowVisibility;
        long mDrawingTime;
        boolean mIgnoreDirtyState;
        boolean mSetIgnoreDirtyState = false;
        boolean mInTouchMode;
        boolean mRecomputeGlobalAttributes;
        boolean mForceReportNewAttributes;
        boolean mKeepScreenOn;
        int mSystemUiVisibility;
        boolean mHasSystemUiListeners;
        boolean mViewVisibilityChanged;
        boolean mViewScrollChanged;
        final int[] mTransparentLocation = new int[2];
        final int[] mInvalidateChildLocation = new int[2];
        final float[] mTmpTransformLocation = new float[2];
        final ViewTreeObserver mTreeObserver = new ViewTreeObserver();
        Canvas mCanvas;
        final Handler mHandler;
        static final int INVALIDATE_MSG = 1;
        static final int INVALIDATE_RECT_MSG = 2;
        final Rect mTmpInvalRect = new Rect();
        final RectF mTmpTransformRect = new RectF();
        final ArrayList<View> mFocusablesTempList = new ArrayList(24);
        int mAccessibilityWindowId = -1;

        AttachInfo(IWindowSession session, IWindow window, Handler handler, Callbacks effectPlayer) {
            this.mSession = session;
            this.mWindow = window;
            this.mWindowToken = window.asBinder();
            this.mHandler = handler;
            this.mRootCallbacks = effectPlayer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class InvalidateInfo
        implements Poolable<InvalidateInfo> {
            private static final int POOL_LIMIT = 10;
            private static final Pool<InvalidateInfo> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<InvalidateInfo>(){

                @Override
                public InvalidateInfo newInstance() {
                    return new InvalidateInfo();
                }

                @Override
                public void onAcquired(InvalidateInfo element) {
                }

                @Override
                public void onReleased(InvalidateInfo element) {
                    element.target = null;
                }
            }, 10));
            private InvalidateInfo mNext;
            private boolean mIsPooled;
            View target;
            int left;
            int top;
            int right;
            int bottom;

            InvalidateInfo() {
            }

            @Override
            public void setNextPoolable(InvalidateInfo element) {
                this.mNext = element;
            }

            @Override
            public InvalidateInfo getNextPoolable() {
                return this.mNext;
            }

            static InvalidateInfo acquire() {
                return sPool.acquire();
            }

            void release() {
                sPool.release(this);
            }

            @Override
            public boolean isPooled() {
                return this.mIsPooled;
            }

            @Override
            public void setPooled(boolean isPooled) {
                this.mIsPooled = isPooled;
            }
        }

        static interface Callbacks {
            public void playSoundEffect(int var1);

            public boolean performHapticFeedback(int var1, boolean var2);
        }
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            @Override
            public BaseSavedState createFromParcel(Parcel in) {
                return new BaseSavedState(in);
            }

            public BaseSavedState[] newArray(int size) {
                return new BaseSavedState[size];
            }
        };

        public BaseSavedState(Parcel source) {
            super(source);
        }

        public BaseSavedState(Parcelable superState) {
            super(superState);
        }
    }

    private class UnsetPressedState
    implements Runnable {
        private UnsetPressedState() {
        }

        public void run() {
            View.this.setPressed(false);
        }
    }

    public static interface OnAttachStateChangeListener {
        public void onViewAttachedToWindow(View var1);

        public void onViewDetachedFromWindow(View var1);
    }

    public static interface OnSystemUiVisibilityChangeListener {
        public void onSystemUiVisibilityChange(int var1);
    }

    public static interface OnCreateContextMenuListener {
        public void onCreateContextMenu(ContextMenu var1, View var2, ContextMenu.ContextMenuInfo var3);
    }

    public static interface OnClickListener {
        public void onClick(View var1);
    }

    public static interface OnFocusChangeListener {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface OnDragListener {
        public boolean onDrag(View var1, DragEvent var2);
    }

    public static interface OnLongClickListener {
        public boolean onLongClick(View var1);
    }

    public static interface OnGenericMotionListener {
        public boolean onGenericMotion(View var1, MotionEvent var2);
    }

    public static interface OnHoverListener {
        public boolean onHover(View var1, MotionEvent var2);
    }

    public static interface OnTouchListener {
        public boolean onTouch(View var1, MotionEvent var2);
    }

    public static interface OnKeyListener {
        public boolean onKey(View var1, int var2, KeyEvent var3);
    }

    private class PerformClick
    implements Runnable {
        private PerformClick() {
        }

        public void run() {
            View.this.performClick();
        }
    }

    private class CheckForTap
    implements Runnable {
        private CheckForTap() {
        }

        public void run() {
            View.this.mPrivateFlags &= 0xFDFFFFFF;
            View.this.mPrivateFlags |= 0x4000;
            View.this.refreshDrawableState();
            View.this.checkForLongClick(ViewConfiguration.getTapTimeout());
        }
    }

    class CheckForLongPress
    implements Runnable {
        private int mOriginalWindowAttachCount;

        CheckForLongPress() {
        }

        public void run() {
            if (View.this.isPressed() && View.this.mParent != null && this.mOriginalWindowAttachCount == View.this.mWindowAttachCount && View.this.performLongClick()) {
                View.this.mHasPerformedLongPress = true;
            }
        }

        public void rememberWindowAttachCount() {
            this.mOriginalWindowAttachCount = View.this.mWindowAttachCount;
        }
    }

    public static class MeasureSpec {
        private static final int MODE_SHIFT = 30;
        private static final int MODE_MASK = -1073741824;
        public static final int UNSPECIFIED = 0;
        public static final int EXACTLY = 0x40000000;
        public static final int AT_MOST = Integer.MIN_VALUE;

        public static int makeMeasureSpec(int size, int mode) {
            return size + mode;
        }

        public static int getMode(int measureSpec) {
            return measureSpec & 0xC0000000;
        }

        public static int getSize(int measureSpec) {
            return measureSpec & 0x3FFFFFFF;
        }

        public static String toString(int measureSpec) {
            int mode = MeasureSpec.getMode(measureSpec);
            int size = MeasureSpec.getSize(measureSpec);
            StringBuilder sb = new StringBuilder("MeasureSpec: ");
            if (mode == 0) {
                sb.append("UNSPECIFIED ");
            } else if (mode == 0x40000000) {
                sb.append("EXACTLY ");
            } else if (mode == Integer.MIN_VALUE) {
                sb.append("AT_MOST ");
            } else {
                sb.append(mode).append(" ");
            }
            sb.append(size);
            return sb.toString();
        }
    }

    public static class DragShadowBuilder {
        private final WeakReference<View> mView;

        public DragShadowBuilder(View view) {
            this.mView = new WeakReference<View>(view);
        }

        public DragShadowBuilder() {
            this.mView = new WeakReference<Object>(null);
        }

        public View getView() {
            return (View)this.mView.get();
        }

        public void onProvideShadowMetrics(Point shadowSize, Point shadowTouchPoint) {
            View view = (View)this.mView.get();
            if (view != null) {
                shadowSize.set(view.getWidth(), view.getHeight());
                shadowTouchPoint.set(shadowSize.x / 2, shadowSize.y / 2);
            } else {
                Log.e(View.VIEW_LOG_TAG, "Asked for drag thumb metrics but no view");
            }
        }

        public void onDrawShadow(Canvas canvas) {
            View view = (View)this.mView.get();
            if (view != null) {
                view.draw(canvas);
            } else {
                Log.e(View.VIEW_LOG_TAG, "Asked to draw drag shadow but no view");
            }
        }
    }

    public static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }

    static class ListenerInfo {
        protected OnFocusChangeListener mOnFocusChangeListener;
        private ArrayList<OnLayoutChangeListener> mOnLayoutChangeListeners;
        private CopyOnWriteArrayList<OnAttachStateChangeListener> mOnAttachStateChangeListeners;
        public OnClickListener mOnClickListener;
        protected OnLongClickListener mOnLongClickListener;
        protected OnCreateContextMenuListener mOnCreateContextMenuListener;
        private OnKeyListener mOnKeyListener;
        private OnTouchListener mOnTouchListener;
        private OnHoverListener mOnHoverListener;
        private OnGenericMotionListener mOnGenericMotionListener;
        private OnDragListener mOnDragListener;
        private OnSystemUiVisibilityChangeListener mOnSystemUiVisibilityChangeListener;

        ListenerInfo() {
        }
    }

    static class TransformationInfo {
        private final Matrix mMatrix = new Matrix();
        private Matrix mInverseMatrix;
        boolean mMatrixDirty = false;
        private boolean mInverseMatrixDirty = true;
        private boolean mMatrixIsIdentity = true;
        private Camera mCamera = null;
        private Matrix matrix3D = null;
        private int mPrevWidth = -1;
        private int mPrevHeight = -1;
        @ViewDebug.ExportedProperty
        float mRotationY = 0.0f;
        @ViewDebug.ExportedProperty
        float mRotationX = 0.0f;
        @ViewDebug.ExportedProperty
        float mRotation = 0.0f;
        @ViewDebug.ExportedProperty
        float mTranslationX = 0.0f;
        @ViewDebug.ExportedProperty
        float mTranslationY = 0.0f;
        @ViewDebug.ExportedProperty
        float mScaleX = 1.0f;
        @ViewDebug.ExportedProperty
        float mScaleY = 1.0f;
        @ViewDebug.ExportedProperty
        float mPivotX = 0.0f;
        @ViewDebug.ExportedProperty
        float mPivotY = 0.0f;
        @ViewDebug.ExportedProperty
        float mAlpha = 1.0f;

        TransformationInfo() {
        }
    }
}

